/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.jts.util;

import java.io.Serializable;
import org.locationtech.geomesa.spark.jts.util.Bounds;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class GeoHash$ {
    public static final GeoHash$ MODULE$ = new GeoHash$();
    private static double latRange;
    private static double lonRange;
    private static Map<Object, Object> powersOf2Map;
    private static Map<Object, Object> latDeltaMap;
    private static Map<Object, Object> lonDeltaMap;
    private static GeometryFactory latLonGeoFactory;
    private static final int MAX_PRECISION;
    private static final Bounds latBounds;
    private static final Bounds lonBounds;
    private static final double lonMax;
    private static final double latMax;
    private static final int[] bits;
    private static final String base32;
    private static final Map<Object, scala.collection.BitSet> characterMap;
    private static volatile byte bitmap$0;

    static {
        MAX_PRECISION = 63;
        latBounds = new Bounds(-90.0, 90.0);
        lonBounds = new Bounds(-180.0, 180.0);
        lonMax = (double)360 - package$.MODULE$.pow(0.5, 32.0);
        latMax = (double)180 - package$.MODULE$.pow(0.5, 32.0);
        bits = new int[]{16, 8, 4, 2, 1};
        base32 = "0123456789bcdefghjkmnpqrstuvwxyz";
        characterMap = ((IterableOnceOps)((IndexedSeqOps)Predef$.MODULE$.wrapString(MODULE$.base32()).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                char c = tuple2._1$mcC$sp();
                int i = tuple2._2$mcI$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)c)), (Object)MODULE$.bitSetFromBase32Character(i));
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public int MAX_PRECISION() {
        return MAX_PRECISION;
    }

    private Bounds latBounds() {
        return latBounds;
    }

    private Bounds lonBounds() {
        return lonBounds;
    }

    private double latRange$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                latRange = this.latBounds().high() - this.latBounds().low();
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return latRange;
    }

    private double latRange() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.latRange$lzycompute();
        }
        return latRange;
    }

    private double lonRange$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                lonRange = this.lonBounds().high() - this.lonBounds().low();
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return lonRange;
    }

    private double lonRange() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.lonRange$lzycompute();
        }
        return lonRange;
    }

    private Map<Object, Object> powersOf2Map$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                powersOf2Map = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.MAX_PRECISION()).map((Function1 & Serializable)i -> GeoHash$.$anonfun$powersOf2Map$1(BoxesRunTime.unboxToInt((Object)i))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return powersOf2Map;
    }

    private Map<Object, Object> powersOf2Map() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.powersOf2Map$lzycompute();
        }
        return powersOf2Map;
    }

    private Map<Object, Object> latDeltaMap$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                latDeltaMap = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.MAX_PRECISION()).map((Function1 & Serializable)i -> GeoHash$.$anonfun$latDeltaMap$1(BoxesRunTime.unboxToInt((Object)i))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return latDeltaMap;
    }

    private Map<Object, Object> latDeltaMap() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.latDeltaMap$lzycompute();
        }
        return latDeltaMap;
    }

    private Map<Object, Object> lonDeltaMap$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(bitmap$0 & 0x10) == 0) {
                lonDeltaMap = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), this.MAX_PRECISION()).map((Function1 & Serializable)i -> GeoHash$.$anonfun$lonDeltaMap$1(BoxesRunTime.unboxToInt((Object)i))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                bitmap$0 = (byte)(bitmap$0 | 0x10);
            }
        }
        return lonDeltaMap;
    }

    private Map<Object, Object> lonDeltaMap() {
        if ((byte)(bitmap$0 & 0x10) == 0) {
            return this.lonDeltaMap$lzycompute();
        }
        return lonDeltaMap;
    }

    public double latitudeDeltaForPrecision(int prec) {
        this.checkPrecision(prec);
        return BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
    }

    public double longitudeDeltaForPrecision(int prec) {
        this.checkPrecision(prec);
        return BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
    }

    private double lonMax() {
        return lonMax;
    }

    private double latMax() {
        return latMax;
    }

    private int[] bits() {
        return bits;
    }

    public String base32() {
        return base32;
    }

    private Map<Object, scala.collection.BitSet> characterMap() {
        return characterMap;
    }

    private GeometryFactory latLonGeoFactory$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(bitmap$0 & 0x20) == 0) {
                latLonGeoFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326);
                bitmap$0 = (byte)(bitmap$0 | 0x20);
            }
        }
        return latLonGeoFactory;
    }

    public GeometryFactory latLonGeoFactory() {
        if ((byte)(bitmap$0 & 0x20) == 0) {
            return this.latLonGeoFactory$lzycompute();
        }
        return latLonGeoFactory;
    }

    private Envelope envFromIndiciesDeltas(long lonIndex, long latIndex, double lonDelta, double latDelta) {
        return new Envelope(this.lonBounds().low() + lonDelta * (double)lonIndex, this.lonBounds().low() + lonDelta * (double)(lonIndex + 1L), this.latBounds().low() + latDelta * (double)latIndex, this.latBounds().low() + latDelta * (double)(latIndex + 1L));
    }

    private long interleaveReverseBits(long first, long second, int numBits) {
        Tuple2.mcJJ.sp sp2;
        boolean even = (numBits & 1) == 0;
        Tuple2.mcJJ.sp sp3 = sp2 = even ? new Tuple2.mcJJ.sp(second, first) : new Tuple2.mcJJ.sp(first, second);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        long actualFirst = sp2._1$mcJ$sp();
        long actualSecond = sp2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(actualFirst, actualSecond);
        long actualFirst2 = sp4._1$mcJ$sp();
        long actualSecond2 = sp4._2$mcJ$sp();
        int numPairs = numBits >> 1;
        LongRef result = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPairs).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)pairNum -> {
            result$1.elem = result$1.elem << 1 | actualFirst2 >> pairNum & 1L;
            result$1.elem = result$1.elem << 1 | actualSecond2 >> pairNum & 1L;
        });
        if (!even) {
            return result.elem << 1 | actualFirst2 >> numPairs & 1L;
        }
        return result.elem;
    }

    private Tuple2<Object, Object> extractReverseBits(long value, int numBits) {
        int numPairs = numBits >> 1;
        LongRef first = LongRef.create((long)0L);
        LongRef second = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPairs).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)pairNum -> {
            first$1.elem = first$1.elem << 1 | value >> pairNum * 2 & 1L;
            second$1.elem = second$1.elem << 1 | value >> pairNum * 2 + 1 & 1L;
        });
        return new Tuple2.mcJJ.sp((numBits & 1) == 1 ? first.elem << 1 | value >> numBits - 1 & 1L : first.elem, second.elem);
    }

    private scala.collection.BitSet shift(int n, scala.collection.BitSet bs) {
        return bs.map((Function1)(JFunction1.mcII.sp & Serializable)x$2 -> x$2 + n);
    }

    private scala.collection.BitSet bitSetFromBase32Character(long charIndex) {
        return (scala.collection.BitSet)scala.collection.BitSet$.MODULE$.apply((Seq)((IndexedSeqOps)((IterableOps)Predef$.MODULE$.wrapString(this.toPaddedBinaryString(charIndex, 5)).zipWithIndex()).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)GeoHash$.$anonfun$bitSetFromBase32Character$1(x0$1)))).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._2$mcI$sp())));
    }

    private String toPaddedBinaryString(long i, int length) {
        return String.format(new StringBuilder(2).append("%").append(length).append("s").toString(), RichLong$.MODULE$.toBinaryString$extension(Predef$.MODULE$.longWrapper(i))).replace(' ', '0');
    }

    private String toBase32(scala.collection.BitSet bitset, int prec) {
        int n;
        int numLeftoverBits;
        int n2 = numLeftoverBits = prec % 5;
        switch (n2) {
            case 0: {
                n = 0;
                break;
            }
            default: {
                n = 5 - numLeftoverBits;
                break;
            }
        }
        int precision = prec + n;
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), precision).grouped(5).map((Function1 & Serializable)i -> BoxesRunTime.boxToCharacter((char)GeoHash$.MODULE$.ch((IndexedSeq<Object>)i, bitset))).mkString();
    }

    private char ch(IndexedSeq<Object> v, scala.collection.BitSet bitset) {
        return StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.base32()), BoxesRunTime.unboxToInt((Object)v.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(cur, i) -> cur + (bitset.apply((Object)BoxesRunTime.boxToInteger((int)i)) ? MODULE$.bits()[i % MODULE$.bits().length] : 0))));
    }

    public void checkPrecision(int precision) {
        Predef$.MODULE$.require(precision <= this.MAX_PRECISION(), (Function0 & Serializable)() -> new StringBuilder(72).append("GeoHash precision of ").append(precision).append(" requested, but precisions above ").append(MODULE$.MAX_PRECISION()).append(" are not supported").toString());
    }

    public String encode(double lon, double lat, int prec) {
        Predef$.MODULE$.require(lon >= -180.0 && lon <= 180.0);
        Predef$.MODULE$.require(lat >= -90.0 && lat <= 90.0);
        this.checkPrecision(prec);
        double lonDelta = BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
        double latDelta = BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
        long lonIndex = lon == 180.0 ? (long)(this.lonMax() / lonDelta) : (long)((lon - this.lonBounds().low()) / lonDelta);
        long latIndex = lat == 90.0 ? (long)(this.latMax() / latDelta) : (long)((lat - this.latBounds().low()) / latDelta);
        BitSet bitSet = BitSet$.MODULE$.fromBitMaskNoCopy(new long[]{this.interleaveReverseBits(lonIndex, latIndex, prec)});
        return this.toBase32((scala.collection.BitSet)bitSet, prec);
    }

    public int encode$default$3() {
        return 25;
    }

    public Geometry decode(String string, Option<Object> precisionOption) {
        scala.collection.BitSet bitSet;
        int prec = BoxesRunTime.unboxToInt((Object)precisionOption.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 5 * string.length()));
        this.checkPrecision(prec);
        IndexedSeq bitsets = (IndexedSeq)((IndexedSeqOps)Predef$.MODULE$.wrapString(string).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                char c = tuple2._1$mcC$sp();
                int i = tuple2._2$mcI$sp();
                if (true) {
                    char c2 = c;
                    if (true) {
                        int n = i;
                        return MODULE$.shift(n * 5, (scala.collection.BitSet)MODULE$.characterMap().apply((Object)BoxesRunTime.boxToCharacter((char)c2)));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        int n = bitsets.size();
        switch (n) {
            case 0: {
                bitSet = (scala.collection.BitSet)scala.collection.BitSet$.MODULE$.apply((Seq)Nil$.MODULE$);
                break;
            }
            case 1: {
                bitSet = (scala.collection.BitSet)bitsets.apply(0);
                break;
            }
            default: {
                bitSet = (scala.collection.BitSet)bitsets.reduce((Function2 & Serializable)(x$4, x$5) -> (scala.collection.BitSet)x$4.$bar((Set)x$5));
                break;
            }
        }
        scala.collection.BitSet finalBitset = bitSet;
        Tuple2<Object, Object> tuple2 = this.extractReverseBits(BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.longArrayOps(finalBitset.toBitMask()))), prec);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long lonIndex = tuple2._1$mcJ$sp();
        long latIndex = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(lonIndex, latIndex);
        long lonIndex2 = sp2._1$mcJ$sp();
        long latIndex2 = sp2._2$mcJ$sp();
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec))), BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec))));
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        double lonDelta = sp3._1$mcD$sp();
        double latDelta = sp3._2$mcD$sp();
        Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(lonDelta, latDelta);
        double lonDelta2 = sp4._1$mcD$sp();
        double latDelta2 = sp4._2$mcD$sp();
        Envelope envelope = this.envFromIndiciesDeltas(lonIndex2, latIndex2, lonDelta2, latDelta2);
        return this.latLonGeoFactory().toGeometry(envelope);
    }

    public Option<Object> decode$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ Tuple2 $anonfun$powersOf2Map$1(int i) {
        return new Tuple2.mcIJ.sp(i, 1L << i);
    }

    public static final /* synthetic */ Tuple2 $anonfun$latDeltaMap$1(int i) {
        return new Tuple2.mcID.sp(i, MODULE$.latRange() / (double)BoxesRunTime.unboxToLong((Object)MODULE$.powersOf2Map().apply((Object)BoxesRunTime.boxToInteger((int)(i / 2)))));
    }

    public static final /* synthetic */ Tuple2 $anonfun$lonDeltaMap$1(int i) {
        return new Tuple2.mcID.sp(i, MODULE$.lonRange() / (double)BoxesRunTime.unboxToLong((Object)MODULE$.powersOf2Map().apply((Object)BoxesRunTime.boxToInteger((int)(i / 2 + i % 2)))));
    }

    public static final /* synthetic */ boolean $anonfun$bitSetFromBase32Character$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            char c = tuple2._1$mcC$sp();
            return c == '1';
        }
        throw new MatchError((Object)tuple2);
    }

    private GeoHash$() {
    }
}

