/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.features.ScalaSimpleFeature$;
import org.locationtech.geomesa.spark.GeoMesaSparkKryoRegistrator;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.interop.WKTUtils;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

public final class SparkSQLTestUtils$ {
    public static final SparkSQLTestUtils$ MODULE$;
    private final Random random;
    private final String ChiSpec;
    private final SimpleFeatureType ChicagoSpec;

    static {
        new SparkSQLTestUtils$();
    }

    public SparkSession createSparkSession() {
        return SparkSession$.MODULE$.builder().appName("testSpark").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.kryo.registrator", GeoMesaSparkKryoRegistrator.class.getName()).config("spark.sql.crossJoin.enabled", "true").master("local[*]").getOrCreate();
    }

    public Random random() {
        return this.random;
    }

    public String ChiSpec() {
        return this.ChiSpec;
    }

    public SimpleFeatureType ChicagoSpec() {
        return this.ChicagoSpec;
    }

    public void ingestChicago(DataStore ds) {
        SimpleFeatureType sft = this.ChicagoSpec();
        ds.createSchema((FeatureType)sft);
        SimpleFeatureStore fs = (SimpleFeatureStore)ds.getFeatureSource("chicago");
        Serializable createPoint = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Point apply(Coordinate x$1) {
                return JTSFactoryFinder.getGeometryFactory().createPoint(x$1);
            }
        };
        List f = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ScalaSimpleFeature[]{ScalaSimpleFeature$.MODULE$.create(sft, "1", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"true", "1", "2016-01-01T00:00:00.000Z", createPoint.apply((Object)new Coordinate(-76.5, 38.5))})), ScalaSimpleFeature$.MODULE$.create(sft, "2", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"true", "2", "2016-01-02T00:00:00.000Z", createPoint.apply((Object)new Coordinate(-77.0, 38.0))})), ScalaSimpleFeature$.MODULE$.create(sft, "3", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"true", "3", "2016-01-03T00:00:00.000Z", createPoint.apply((Object)new Coordinate(-78.0, 39.0))}))}));
        f.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(ScalaSimpleFeature x$2) {
                return x$2.getUserData().put(Hints.USE_PROVIDED_FID, Boolean.TRUE);
            }
        });
        fs.addFeatures((FeatureCollection)DataUtilities.collection((java.util.List)JavaConversions$.MODULE$.seqAsJavaList((Seq)f)));
    }

    public void ingestPoints(DataStore ds, String name, Map<String, String> points) {
        SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(name, "name:String,*geom:Point:srid=4326");
        ds.createSchema((FeatureType)sft);
        SimpleFeatureCollection features = DataUtilities.collection((java.util.List)JavaConversions$.MODULE$.seqAsJavaList((Seq)((TraversableOnce)points.map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final ScalaSimpleFeature apply(Tuple2<String, String> x) {
                return new ScalaSimpleFeature(this.sft$1, (String)x._1(), new Object[]{x._1(), (Point)WKTUtils.read((String)((String)x._2()))}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
            }
            {
                this.sft$1 = sft$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList()));
        SimpleFeatureStore fs = (SimpleFeatureStore)ds.getFeatureSource(name);
        fs.addFeatures((FeatureCollection)features);
    }

    public void ingestGeometries(DataStore ds, String name, Map<String, String> geoms) {
        SimpleFeatureType sft = SimpleFeatureTypes$.MODULE$.createType(name, "name:String,*geom:Geometry:srid=4326");
        ds.createSchema((FeatureType)sft);
        SimpleFeatureCollection features = DataUtilities.collection((java.util.List)JavaConversions$.MODULE$.seqAsJavaList((Seq)((TraversableOnce)geoms.map((Function1)new Serializable(sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$2;

            public final ScalaSimpleFeature apply(Tuple2<String, String> x) {
                return new ScalaSimpleFeature(this.sft$2, (String)x._1(), new Object[]{x._1(), WKTUtils.read((String)((String)x._2()))}, ScalaSimpleFeature$.MODULE$.$lessinit$greater$default$4());
            }
            {
                this.sft$2 = sft$2;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList()));
        SimpleFeatureStore fs = (SimpleFeatureStore)ds.getFeatureSource(name);
        fs.addFeatures((FeatureCollection)features);
    }

    public Map<String, String> generatePoints(GeometryFactory gf, int numPoints) {
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), numPoints).map((Function1)new Serializable(gf){
            public static final long serialVersionUID = 0L;
            private final GeometryFactory gf$1;

            public final Tuple2<String, String> apply(int i) {
                double x = (double)-180 + (double)360 * SparkSQLTestUtils$.MODULE$.random().nextDouble();
                double y = (double)-90 + (double)180 * SparkSQLTestUtils$.MODULE$.random().nextDouble();
                return new Tuple2((Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString(), (Object)this.gf$1.createPoint(new Coordinate(x, y)).toText());
            }
            {
                this.gf$1 = gf$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, String> generatePolys(GeometryFactory gf, int numPoints) {
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), numPoints).map((Function1)new Serializable(gf){
            public static final long serialVersionUID = 0L;
            private final GeometryFactory gf$2;

            public final Tuple2<String, String> apply(int i) {
                double x = (double)-180 + (double)360 * SparkSQLTestUtils$.MODULE$.random().nextDouble();
                double y = (double)-90 + (double)180 * SparkSQLTestUtils$.MODULE$.random().nextDouble();
                double width = (double)3 * SparkSQLTestUtils$.MODULE$.random().nextDouble() / 2.0;
                double height = 1.0 * SparkSQLTestUtils$.MODULE$.random().nextDouble() / 2.0;
                Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)(x - width)), (Object)BoxesRunTime.boxToDouble((double)(x + width)), (Object)BoxesRunTime.boxToDouble((double)(y - height)), (Object)BoxesRunTime.boxToDouble((double)(y + height)));
                if (tuple4 != null) {
                    Tuple4 tuple42;
                    double minX = BoxesRunTime.unboxToDouble((Object)tuple4._1());
                    double maxX = BoxesRunTime.unboxToDouble((Object)tuple4._2());
                    double minY = BoxesRunTime.unboxToDouble((Object)tuple4._3());
                    double maxY = BoxesRunTime.unboxToDouble((Object)tuple4._4());
                    Tuple4 tuple43 = tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)minX), (Object)BoxesRunTime.boxToDouble((double)maxX), (Object)BoxesRunTime.boxToDouble((double)minY), (Object)BoxesRunTime.boxToDouble((double)maxY));
                    double minX2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
                    double maxX2 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
                    double minY2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
                    double maxY2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
                    Coordinate[] coords = (Coordinate[])((Object[])new Coordinate[]{new Coordinate(minX2, minY2), new Coordinate(minX2, maxY2), new Coordinate(maxX2, minY2), new Coordinate(maxX2, maxY2), new Coordinate(minX2, minY2)});
                    return new Tuple2((Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString(), (Object)this.gf$2.createPolygon(coords).toText());
                }
                throw new MatchError((Object)tuple4);
            }
            {
                this.gf$2 = gf$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private SparkSQLTestUtils$() {
        MODULE$ = this;
        this.random = new Random();
        this.random().setSeed(0L);
        this.ChiSpec = "arrest:String,case_number:Int:index=full:cardinality=high,dtg:Date,*geom:Point:srid=4326";
        this.ChicagoSpec = SimpleFeatureTypes$.MODULE$.createType("chicago", this.ChiSpec());
    }
}

