/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.ingest;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.jobs.JobUtils$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat$;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.ingest.AbstractIngest;
import org.locationtech.geomesa.tools.ingest.IngestMapper;
import org.locationtech.geomesa.utils.classpath.ClassPathUtils$;
import org.opengis.feature.simple.SimpleFeature;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00055d!B\u0001\u0003\u0003\u0003i!!E!cgR\u0014\u0018m\u0019;J]\u001e,7\u000f\u001e&pE*\u00111\u0001B\u0001\u0007S:<Wm\u001d;\u000b\u0005\u00151\u0011!\u0002;p_2\u001c(BA\u0004\t\u0003\u001d9Wm\\7fg\u0006T!!\u0003\u0006\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011\u0015)\u0002\u0001\"\u0001\u0017\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0019\u00015\t!\u0001C\u0003\u001b\u0001\u0019\u00051$\u0001\tj]B,HOR8s[\u0006$8\t\\1tgV\tA\u0004\r\u0002\u001eMA\u0019a$\t\u0013\u000f\u0005=y\u0012B\u0001\u0011\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011!e\t\u0002\u0006\u00072\f7o\u001d\u0006\u0003AA\u0001\"!\n\u0014\r\u0001\u0011Iq%GA\u0001\u0002\u0003\u0015\t\u0001\u000b\u0002\u0004?\u0012\n\u0014CA\u0015-!\ty!&\u0003\u0002,!\t9aj\u001c;iS:<\u0007GA\u0017=!\u0011q\u0013hO\"\u000e\u0003=R!\u0001M\u0019\u0002\u000b%t\u0007/\u001e;\u000b\u0005I\u001a\u0014a\u00017jE*\u0011A'N\u0001\n[\u0006\u0004(/\u001a3vG\u0016T!AN\u001c\u0002\r!\fGm\\8q\u0015\tA$\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003u=\u0012qBR5mK&s\u0007/\u001e;G_Jl\u0017\r\u001e\t\u0003Kq\"\u0011\"\u0010 \u0002\u0002\u0003\u0005)\u0011A \u0003\u0007}##\u0007B\u0005(3\u0005\u0005\u0019\u0011!B\u0001QE\u0011\u0011\u0006\u0011\t\u0003\u001f\u0005K!A\u0011\t\u0003\u0007\u0005s\u0017\u0010\u0005\u0002E\u00176\tQI\u0003\u0002G\u000f\u000611/[7qY\u0016T!\u0001S%\u0002\u000f\u0019,\u0017\r^;sK*\u0011!JC\u0001\b_B,gnZ5t\u0013\taUIA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\u0005\u0006\u001d\u00021\taT\u0001\rG>tg-[4ve\u0016TuN\u0019\u000b\u0003!N\u0003\"aD)\n\u0005I\u0003\"\u0001B+oSRDQ\u0001V'A\u0002U\u000b1A[8c!\t1v+D\u00014\u0013\tA6GA\u0002K_\nDQA\u0017\u0001\u0007\u0002m\u000bqa\u001e:jiR,g\u000e\u0006\u0002]?B\u0011q\"X\u0005\u0003=B\u0011A\u0001T8oO\")A+\u0017a\u0001+\")\u0011\r\u0001D\u0001E\u00061a-Y5mK\u0012$\"\u0001X2\t\u000bQ\u0003\u0007\u0019A+\t\u000b\u0015\u0004A\u0011\u00014\u0002\u0007I,h\u000e\u0006\u0006hUJ$\u0018QAA\u0005\u0003W\u0001Ba\u00045]9&\u0011\u0011\u000e\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u000b-$\u0007\u0019\u00017\u0002\u0011\u0011\u001c\b+\u0019:b[N\u0004BAH7p_&\u0011an\t\u0002\u0004\u001b\u0006\u0004\bC\u0001\u0010q\u0013\t\t8E\u0001\u0004TiJLgn\u001a\u0005\u0006g\u0012\u0004\ra\\\u0001\tif\u0004XMT1nK\")Q\u000f\u001aa\u0001m\u0006)\u0001/\u0019;igB\u0019qo`8\u000f\u0005alhBA=}\u001b\u0005Q(BA>\r\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002\u007f!\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0001\u0003\u0007\u00111aU3r\u0015\tq\b\u0003\u0003\u0004\u0002\b\u0011\u0004\ra\\\u0001\fY&\u0014'.\u0019:t\r&dW\rC\u0004\u0002\f\u0011\u0004\r!!\u0004\u0002\u00191L'M[1sgB\u000bG\u000f[:\u0011\u000b]\fy!a\u0005\n\t\u0005E\u00111\u0001\u0002\t\u0013R,'/\u0019;peB)q\"!\u0006\u0002\u001a%\u0019\u0011q\u0003\t\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\u0003B<\u0000\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#\u0001\u0002j_*\u0011\u0011QE\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002*\u0005}!\u0001\u0002$jY\u0016Dq!!\fe\u0001\u0004\ty#\u0001\bti\u0006$Xo]\"bY2\u0014\u0017mY6\u0011\t\u0005E\u00121\n\b\u0005\u0003g\t9E\u0004\u0003\u00026\u0005\u0015c\u0002BA\u001c\u0003\u0007rA!!\u000f\u0002B9!\u00111HA \u001d\rI\u0018QH\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011bAA%\u0005\u0005q\u0011IY:ue\u0006\u001cG/\u00138hKN$\u0018\u0002BA'\u0003\u001f\u0012ab\u0015;biV\u001c8)\u00197mE\u0006\u001c7NC\u0002\u0002J\tAq!a\u0015\u0001\t#\t)&A\u0006sK\u0006$G*\u001b2KCJ\u001cH\u0003BA,\u0003G\u0002R!!\u0017\u0002`=l!!a\u0017\u000b\t\u0005u\u00131E\u0001\u0005kRLG.\u0003\u0003\u0002b\u0005m#\u0001\u0002'jgRDq!!\u001a\u0002R\u0001\u0007q.\u0001\u0003gS2,\u0007bBA5\u0001\u0011E\u00111N\u0001\u0012I\u00164\u0017-\u001e7u'\u0016\f'o\u00195QCRDWCAA\u0007\u0001")
public abstract class AbstractIngestJob {
    public abstract Class<? extends FileInputFormat<?, SimpleFeature>> inputFormatClass();

    public abstract void configureJob(Job var1);

    public abstract long written(Job var1);

    public abstract long failed(Job var1);

    /*
     * WARNING - void declaration
     */
    public Tuple2<Object, Object> run(Map<String, String> dsParams, String typeName, Seq<String> paths, String libjarsFile, Iterator<Function0<Seq<File>>> libjarsPaths, AbstractIngest.StatusCallback statusCallback) {
        Job job = Job.getInstance((Configuration)new Configuration(), (String)"GeoMesa Tools Ingest");
        JobUtils$.MODULE$.setLibJars(job.getConfiguration(), (Seq)JavaConversions$.MODULE$.asScalaBuffer(this.readLibJars(libjarsFile)), this.defaultSearchPath().$plus$plus((Function0)new Serializable(this, libjarsPaths){
            public static final long serialVersionUID = 0L;
            private final Iterator libjarsPaths$1;

            public final Iterator<Function0<Seq<File>>> apply() {
                return this.libjarsPaths$1;
            }
            {
                this.libjarsPaths$1 = libjarsPaths$1;
            }
        }));
        job.setJarByClass(this.getClass());
        job.setMapperClass(IngestMapper.class);
        job.setInputFormatClass(this.inputFormatClass());
        job.setOutputFormatClass(GeoMesaOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setOutputValueClass(ScalaSimpleFeature.class);
        job.setNumReduceTasks(0);
        job.getConfiguration().set("mapred.reduce.tasks.speculative.execution", "false");
        job.getConfiguration().set("mapreduce.job.user.classpath.first", "true");
        FileInputFormat.setInputPaths((Job)job, (String)paths.mkString(","));
        this.configureJob(job);
        GeoMesaConfigurator$.MODULE$.setFeatureTypeOut(job.getConfiguration(), typeName);
        GeoMesaOutputFormat$.MODULE$.configureDataStore(job, dsParams);
        Command$.MODULE$.user().info("Submitting job - please wait...");
        job.submit();
        Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tracking available at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{job.getStatus().getTrackingUrl()})));
        while (true) {
            void var7_7;
            if (job.isComplete()) {
                statusCallback.apply("", job.mapProgress(), (Seq<Tuple2<String, Object>>)this.counters$1(job), true);
                if (!job.isSuccessful()) {
                    Command$.MODULE$.user().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Job failed with state ", " due to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{job.getStatus().getState(), job.getStatus().getFailureInfo()})));
                }
                return new Tuple2.mcJJ.sp(this.written(job), this.failed(job));
            }
            JobStatus.State state = var7_7.getStatus().getState();
            JobStatus.State state2 = JobStatus.State.PREP;
            if (state == null ? state2 != null : !state.equals(state2)) {
                statusCallback.apply("", var7_7.mapProgress(), (Seq<Tuple2<String, Object>>)this.counters$1((Job)var7_7), false);
            }
            Thread.sleep(1000L);
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<String> readLibJars(String file) {
        List list;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(file);
        try {
            list = IOUtils.readLines((InputStream)is);
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                throw new Exception("Error reading ingest libjars", e);
            }
            catch (Throwable throwable3) {
                void var2_2;
                IOUtils.closeQuietly((InputStream)var2_2);
                throw throwable3;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return list;
    }

    public Iterator<Function0<Seq<File>>> defaultSearchPath() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIngestJob $outer;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromClasspath(this.$outer.getClass());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getFilesFromSystemProperty("geomesa.convert.scripts.path");
            }
        }}));
    }

    private final Seq counters$1(Job job$1) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"ingested", (Object)BoxesRunTime.boxToLong((long)this.written(job$1))), new Tuple2((Object)"failed", (Object)BoxesRunTime.boxToLong((long)this.failed(job$1)))}));
    }
}

