/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.ingest;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.locationtech.geomesa.jobs.mapreduce.ConverterInputFormat;
import org.locationtech.geomesa.jobs.mapreduce.ConverterInputFormat$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.tools.ingest.AbstractIngestJob;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u00015\u0011!cQ8om\u0016\u0014H/\u001a:J]\u001e,7\u000f\u001e&pE*\u00111\u0001B\u0001\u0007S:<Wm\u001d;\u000b\u0005\u00151\u0011!\u0002;p_2\u001c(BA\u0004\t\u0003\u001d9Wm\\7fg\u0006T!!\u0003\u0006\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!!E!cgR\u0014\u0018m\u0019;J]\u001e,7\u000f\u001e&pE\"A1\u0003\u0001B\u0001B\u0003%A#A\u0002tMR\u0004\"!\u0006\u000f\u000e\u0003YQ!a\u0006\r\u0002\rMLW\u000e\u001d7f\u0015\tI\"$A\u0004gK\u0006$XO]3\u000b\u0005mQ\u0011aB8qK:<\u0017n]\u0005\u0003;Y\u0011\u0011cU5na2,g)Z1ukJ,G+\u001f9f\u0011!y\u0002A!A!\u0002\u0013\u0001\u0013aD2p]Z,'\u000f^3s\u0007>tg-[4\u0011\u0005\u0005BS\"\u0001\u0012\u000b\u0005\r\"\u0013AB2p]\u001aLwM\u0003\u0002&M\u0005AA/\u001f9fg\u00064WMC\u0001(\u0003\r\u0019w.\\\u0005\u0003S\t\u0012aaQ8oM&<\u0007\"B\u0016\u0001\t\u0003a\u0013A\u0002\u001fj]&$h\bF\u0002.]=\u0002\"a\u0004\u0001\t\u000bMQ\u0003\u0019\u0001\u000b\t\u000b}Q\u0003\u0019\u0001\u0011\t\u000fE\u0002!\u0019!C\u0001e\u0005aa-Y5m\u0007>,h\u000e^3sgV\t1\u0007E\u00025smj\u0011!\u000e\u0006\u0003m]\n!bY8mY\u0016\u001cG/[8o\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e6\u0005\r\u0019V-\u001d\t\u0005yuzt(D\u00018\u0013\tqtG\u0001\u0004UkBdWM\r\t\u0003\u0001\u0016k\u0011!\u0011\u0006\u0003\u0005\u000e\u000bA\u0001\\1oO*\tA)\u0001\u0003kCZ\f\u0017B\u0001$B\u0005\u0019\u0019FO]5oO\"1\u0001\n\u0001Q\u0001\nM\nQBZ1jY\u000e{WO\u001c;feN\u0004\u0003b\u0002&\u0001\u0005\u0004%\teS\u0001\u0011S:\u0004X\u000f\u001e$pe6\fGo\u00117bgN,\u0012\u0001\u0014\u0019\u0003\u001bZ\u00032AT)U\u001d\tat*\u0003\u0002Qo\u00051\u0001K]3eK\u001aL!AU*\u0003\u000b\rc\u0017m]:\u000b\u0005A;\u0004CA+W\u0019\u0001!\u0011b\u0016-\u0002\u0002\u0003\u0005)\u0011\u00010\u0003\u0007}#c\u0007\u0003\u0004Z\u0001\u0001\u0006IAW\u0001\u0012S:\u0004X\u000f\u001e$pe6\fGo\u00117bgN\u0004\u0003GA.^!\rq\u0015\u000b\u0018\t\u0003+v#\u0011b\u0016-\u0002\u0002\u0003\u0005)\u0011\u00010\u0012\u0005}\u0013\u0007C\u0001\u001fa\u0013\t\twGA\u0004O_RD\u0017N\\41\u0005\r\u0014\b\u0003\u00023pcfl\u0011!\u001a\u0006\u0003M\u001e\fQ!\u001b8qkRT!\u0001[5\u0002\u00071L'M\u0003\u0002kW\u0006IQ.\u00199sK\u0012,8-\u001a\u0006\u0003Y6\fa\u0001[1e_>\u0004(B\u00018\u000b\u0003\u0019\t\u0007/Y2iK&\u0011\u0001/\u001a\u0002\u0010\r&dW-\u00138qkR4uN]7biB\u0011QK\u001d\u0003\ngR\f\t\u0011!A\u0003\u0002U\u00141a\u0018\u00138\t%9\u0006,!A\u0002\u0002\u000b\u0005a,\u0005\u0002`mB\u0011Ah^\u0005\u0003q^\u00121!\u00118z!\t)\"0\u0003\u0002|-\ti1+[7qY\u00164U-\u0019;ve\u0016DQ! \u0001\u0005By\fAbY8oM&<WO]3K_\n$2a`A\u0003!\ra\u0014\u0011A\u0005\u0004\u0003\u00079$\u0001B+oSRDq!a\u0002}\u0001\u0004\tI!A\u0002k_\n\u0004B!a\u0003\u0002\u000e5\t\u0011.C\u0002\u0002\u0010%\u00141AS8c\u0011\u001d\t\u0019\u0002\u0001C!\u0003+\tqa\u001e:jiR,g\u000e\u0006\u0003\u0002\u0018\u0005u\u0001c\u0001\u001f\u0002\u001a%\u0019\u00111D\u001c\u0003\t1{gn\u001a\u0005\t\u0003\u000f\t\t\u00021\u0001\u0002\n!9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0012A\u00024bS2,G\r\u0006\u0003\u0002\u0018\u0005\u0015\u0002\u0002CA\u0004\u0003?\u0001\r!!\u0003")
public class ConverterIngestJob
extends AbstractIngestJob {
    private final SimpleFeatureType sft;
    private final Config converterConfig;
    private final Seq<Tuple2<String, String>> failCounters;
    private final Class<? extends FileInputFormat<?, SimpleFeature>> inputFormatClass;

    public Seq<Tuple2<String, String>> failCounters() {
        return this.failCounters;
    }

    @Override
    public Class<? extends FileInputFormat<?, SimpleFeature>> inputFormatClass() {
        return this.inputFormatClass;
    }

    @Override
    public void configureJob(Job job) {
        ConverterInputFormat$.MODULE$.setConverterConfig(job, this.converterConfig.root().render(ConfigRenderOptions.concise()));
        ConverterInputFormat$.MODULE$.setSft(job, this.sft);
    }

    @Override
    public long written(Job job) {
        return job.getCounters().findCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), GeoMesaOutputFormat.Counters$.MODULE$.Written()).getValue();
    }

    @Override
    public long failed(Job job) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.failCounters().map((Function1)new Serializable(this, job){
            public static final long serialVersionUID = 0L;
            private final Job job$1;

            public final long apply(Tuple2<String, String> c) {
                return this.job$1.getCounters().findCounter((String)c._1(), (String)c._2()).getValue();
            }
            {
                this.job$1 = job$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public ConverterIngestJob(SimpleFeatureType sft, Config converterConfig) {
        this.sft = sft;
        this.converterConfig = converterConfig;
        this.failCounters = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)ConverterInputFormat.Counters$.MODULE$.Group(), (Object)ConverterInputFormat.Counters$.MODULE$.Failed()), new Tuple2((Object)GeoMesaOutputFormat.Counters$.MODULE$.Group(), (Object)GeoMesaOutputFormat.Counters$.MODULE$.Failed())}));
        this.inputFormatClass = ConverterInputFormat.class;
    }
}

