/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.DelimitedExporter$;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.utils.DataFormats$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001=\u0011\u0011\u0003R3mS6LG/\u001a3FqB|'\u000f^3s\u0015\t\u0019A!A\u0004g_Jl\u0017\r^:\u000b\u0005\u00151\u0011AB3ya>\u0014HO\u0003\u0002\b\u0011\u0005)Ao\\8mg*\u0011\u0011BC\u0001\bO\u0016|W.Z:b\u0015\tYA\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001\u0003\u0007\u000f\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012\u0001\u00027b]\u001eT\u0011!F\u0001\u0005U\u00064\u0018-\u0003\u0002\u0018%\t1qJ\u00196fGR\u0004\"!\u0007\u000e\u000e\u0003\tI!a\u0007\u0002\u0003\u001f\u0019+\u0017\r^;sK\u0016C\bo\u001c:uKJ\u0004\"!\b\u0013\u000e\u0003yQ!a\b\u0011\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0005\u0012\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\r\n1aY8n\u0013\t)cDA\u0006MCjLHj\\4hS:<\u0007\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\r]\u0014\u0018\u000e^3s!\tIC&D\u0001+\u0015\tYC#\u0001\u0002j_&\u0011QF\u000b\u0002\u0007/JLG/\u001a:\t\u0011=\u0002!\u0011!Q\u0001\nA\naAZ8s[\u0006$\bCA\u0019D\u001d\t\u0011\u0004I\u0004\u00024}9\u0011A'\u0010\b\u0003kqr!AN\u001e\u000f\u0005]RT\"\u0001\u001d\u000b\u0005er\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u007f\u0019\tQ!\u001e;jYNL!!\u0011\"\u0002\u0017\u0011\u000bG/\u0019$pe6\fGo\u001d\u0006\u0003\u007f\u0019I!\u0001R#\u0003\u0015\u0011\u000bG/\u0019$pe6\fGO\u0003\u0002B\u0005\"Aq\t\u0001B\u0001B\u0003%\u0001*\u0001\u0006biR\u0014\u0018NY;uKN\u00042!\u0013'O\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%AB(qi&|g\u000e\u0005\u0002P):\u0011\u0001K\u0015\b\u0003gEK!!\u0002\u0004\n\u0005M#\u0011!D#ya>\u0014HoQ8n[\u0006tG-\u0003\u0002V-\n\u0001R\t\u001f9peR\fE\u000f\u001e:jEV$Xm\u001d\u0006\u0003'\u0012A\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!W\u0001\u000bo&$\b\u000eS3bI\u0016\u0014\bCA%[\u0013\tY&JA\u0004C_>dW-\u00198\t\u000bu\u0003A\u0011\u00010\u0002\rqJg.\u001b;?)\u0015y\u0006-\u00192d!\tI\u0002\u0001C\u0003(9\u0002\u0007\u0001\u0006C\u000309\u0002\u0007\u0001\u0007C\u0003H9\u0002\u0007\u0001\nC\u0003Y9\u0002\u0007\u0011\fC\u0004f\u0001\t\u0007I\u0011\u00024\u0002\u000fA\u0014\u0018N\u001c;feV\tq\r\u0005\u0002i_6\t\u0011N\u0003\u0002kW\u0006\u00191m\u001d<\u000b\u00051l\u0017aB2p[6|gn\u001d\u0006\u0003]2\ta!\u00199bG\",\u0017B\u00019j\u0005)\u00195K\u0016)sS:$XM\u001d\u0005\u0007e\u0002\u0001\u000b\u0011B4\u0002\u0011A\u0014\u0018N\u001c;fe\u0002Bq\u0001\u001e\u0001C\u0002\u0013%Q/\u0001\u0004xSRD\u0017\nZ\u000b\u00023\"1q\u000f\u0001Q\u0001\ne\u000bqa^5uQ&#\u0007\u0005C\u0005z\u0001\u0001\u0007\t\u0019!C\u0005u\u0006)a.Y7fgV\t1\u0010E\u0003}\u0003\u0007\tIA\u0004\u0002~\u007f:\u0011qG`\u0005\u0002\u0017&\u0019\u0011\u0011\u0001&\u0002\u000fA\f7m[1hK&!\u0011QAA\u0004\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u0003Q\u0005\u0003BA\u0006\u0003#q1!SA\u0007\u0013\r\tyAS\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0011Q\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=!\nC\u0006\u0002\u001a\u0001\u0001\r\u00111A\u0005\n\u0005m\u0011!\u00038b[\u0016\u001cx\fJ3r)\u0011\ti\"a\t\u0011\u0007%\u000by\"C\u0002\u0002\")\u0013A!\u00168ji\"I\u0011QEA\f\u0003\u0003\u0005\ra_\u0001\u0004q\u0012\n\u0004bBA\u0015\u0001\u0001\u0006Ka_\u0001\u0007]\u0006lWm\u001d\u0011\t\u000f\u00055\u0002\u0001\"\u0011\u00020\u0005)1\u000f^1siR!\u0011QDA\u0019\u0011!\t\u0019$a\u000bA\u0002\u0005U\u0012aA:giB!\u0011qGA#\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012AB:j[BdWM\u0003\u0003\u0002@\u0005\u0005\u0013a\u00024fCR,(/\u001a\u0006\u0004\u0003\u0007b\u0011aB8qK:<\u0017n]\u0005\u0005\u0003\u000f\nIDA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016Da!\u0002\u0001\u0005B\u0005-C\u0003BA'\u0003+\u0002B!\u0013'\u0002PA\u0019\u0011*!\u0015\n\u0007\u0005M#J\u0001\u0003M_:<\u0007\u0002CA,\u0003\u0013\u0002\r!!\u0017\u0002\u0011\u0019,\u0017\r^;sKN\u0004R\u0001`A.\u0003?JA!!\u0018\u0002\b\tA\u0011\n^3sCR|'\u000f\u0005\u0003\u00028\u0005\u0005\u0014\u0002BA2\u0003s\u0011QbU5na2,g)Z1ukJ,\u0007bBA4\u0001\u0011\u0005\u0013\u0011N\u0001\u0006G2|7/\u001a\u000b\u0003\u0003;Aq!!\u001c\u0001\t\u0013\ty'A\u0005tiJLgnZ5gsR!\u0011\u0011BA9\u0011!\t\u0019(a\u001bA\u0002\u0005U\u0014!A8\u0011\u0007%\u000b9(C\u0002\u0002z)\u00131!\u00118z\u0001")
public class DelimitedExporter
implements FeatureExporter,
LazyLogging {
    private final Option<ExportCommand.ExportAttributes> attributes;
    private final boolean withHeader;
    private final CSVPrinter org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer;
    private final boolean org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$withId;
    private Seq<String> org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$names;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        DelimitedExporter delimitedExporter = this;
        synchronized (delimitedExporter) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public CSVPrinter org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer() {
        return this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer;
    }

    public boolean org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$withId() {
        return this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$withId;
    }

    public Seq<String> org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$names() {
        return this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$names;
    }

    private void org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$names_$eq(Seq<String> x$1) {
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$names = x$1;
    }

    @Override
    public void start(SimpleFeatureType sft) {
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$names_$eq((Seq<String>)((Seq)this.attributes.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(ExportCommand.ExportAttributes x$2) {
                return x$2.names();
            }
        }).getOrElse((Function0)new Serializable(this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final Seq<String> apply() {
                return (Seq)JavaConversions$.MODULE$.asScalaBuffer(this.sft$1.getAttributeDescriptors()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(AttributeDescriptor x$3) {
                        return x$3.getLocalName();
                    }
                }, Buffer$.MODULE$.canBuildFrom());
            }
            {
                this.sft$1 = sft$1;
            }
        })));
        if (this.withHeader) {
            if (this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$withId()) {
                this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().print((Object)"id");
            }
            this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$names().foreach((Function1)new Serializable(this, sft){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedExporter $outer;
                private final SimpleFeatureType sft$1;

                public final void apply(String name) {
                    this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().print((Object)SimpleFeatureTypes$.MODULE$.encodeDescriptor(this.sft$1, this.sft$1.getDescriptor(name)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sft$1 = sft$1;
                }
            });
            this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().println();
            this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().flush();
        }
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        BoxedUnit boxedUnit;
        LongRef count = LongRef.create((long)0L);
        features.foreach((Function1)new Serializable(this, count){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelimitedExporter $outer;
            private final LongRef count$1;

            public final void apply(SimpleFeature sf) {
                if (this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$withId()) {
                    this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().print((Object)sf.getID());
                }
                this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$names().foreach((Function1)new Serializable(this, sf){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$export$1 $outer;
                    private final SimpleFeature sf$1;

                    public final void apply(String name) {
                        this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$anonfun$$$outer().org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().print((Object)this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$anonfun$$$outer().org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(this.sf$1.getAttribute(name)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.sf$1 = sf$1;
                    }
                });
                this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().println();
                ++this.count$1.elem;
                if (this.count$1.elem % 10000L == 0L) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("wrote {} features", new Object[]{BoxesRunTime.boxToLong((long)this.count$1.elem)});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }

            public /* synthetic */ DelimitedExporter org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.count$1 = count$1;
            }
        });
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().flush();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Exported {} features", new Object[]{BoxesRunTime.boxToLong((long)count.elem)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)count.elem));
    }

    @Override
    public void close() {
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().close();
    }

    public String org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(Object o) {
        String string;
        Object object = o;
        if (object == null) {
            string = "";
        } else if (object instanceof Geometry) {
            Geometry geometry = (Geometry)object;
            string = WKTUtils$.MODULE$.write(geometry);
        } else if (object instanceof Date) {
            Date date = (Date)object;
            string = package$.MODULE$.GeoToolsDateFormat().format(Instant.ofEpochMilli(date.getTime()).atZone(ZoneOffset.UTC));
        } else if (object instanceof List) {
            List list = (List)object;
            string = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(list).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedExporter $outer;

                public final String apply(Object o) {
                    return this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(o);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(",");
        } else if (object instanceof Map) {
            Map map = (Map)object;
            string = ((TraversableOnce)JavaConversions$.MODULE$.mapAsScalaMap(map).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedExporter $outer;

                public final String apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "->", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(k), this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(v)}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
        } else {
            string = o.toString();
        }
        return string;
    }

    public DelimitedExporter(Writer writer, Enumeration.Value format, Option<ExportCommand.ExportAttributes> attributes, boolean withHeader) {
        Enumeration.Value value;
        block4: {
            CSVPrinter cSVPrinter;
            block3: {
                block2: {
                    this.attributes = attributes;
                    this.withHeader = withHeader;
                    LazyLogging.class.$init$((LazyLogging)this);
                    value = format;
                    Enumeration.Value value2 = DataFormats$.MODULE$.Csv();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    cSVPrinter = CSVFormat.DEFAULT.withQuoteMode(QuoteMode.MINIMAL).print((Appendable)writer);
                    break block3;
                }
                Enumeration.Value value4 = DataFormats$.MODULE$.Tsv();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                cSVPrinter = CSVFormat.TDF.withQuoteMode(QuoteMode.MINIMAL).print((Appendable)writer);
            }
            this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer = cSVPrinter;
            this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$withId = attributes.forall((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(ExportCommand.ExportAttributes x$1) {
                    return x$1.fid();
                }
            });
            return;
        }
        throw new MatchError((Object)value);
    }
}

