/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import java.io.OutputStream;
import java.util.Arrays;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.factory.Hints;
import org.locationtech.geomesa.arrow.io.SimpleFeatureArrowIO$;
import org.locationtech.geomesa.arrow.io.records.RecordBatchUnloader;
import org.locationtech.geomesa.arrow.package$;
import org.locationtech.geomesa.arrow.vector.ArrowDictionary;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector;
import org.locationtech.geomesa.arrow.vector.SimpleFeatureVector$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.tools.export.formats.ArrowExporter$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.collection.SelfClosingIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureOrdering$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

public final class ArrowExporter$ {
    public static final ArrowExporter$ MODULE$;

    static {
        new ArrowExporter$();
    }

    public Map<String, Object[]> queryDictionaries(DataStore ds, Query query) {
        Map map;
        Hints hints = query.getHints();
        Map provided = QueryHints$.MODULE$.RichHints(hints).getArrowDictionaryEncodedValues(ds.getSchema(query.getTypeName()));
        Seq dictionaryFields = (Seq)QueryHints$.MODULE$.RichHints(hints).getArrowDictionaryFields().filterNot((Function1)new Serializable(provided){
            public static final long serialVersionUID = 0L;
            private final Map provided$1;

            public final boolean apply(String key) {
                return this.provided$1.contains((Object)key);
            }
            {
                this.provided$1 = provided$1;
            }
        });
        if (dictionaryFields.isEmpty()) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            Query dictionaryQuery = new Query(query.getTypeName(), query.getFilter());
            dictionaryQuery.setPropertyNames(JavaConversions$.MODULE$.seqAsJavaList(dictionaryFields));
            Map map2 = ((TraversableOnce)dictionaryFields.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, HashSet<Object>> apply(String f) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f), (Object)HashSet$.MODULE$.empty());
                }
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            SelfClosingIterator$.MODULE$.apply(ds.getFeatureReader(dictionaryQuery, Transaction.AUTO_COMMIT)).foreach((Function1)new Serializable(map2){
                public static final long serialVersionUID = 0L;
                private final Map map$1;

                public final void apply(SimpleFeature sf) {
                    this.map$1.foreach((Function1)new Serializable(this, sf){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeature sf$1;

                        public final void apply(Tuple2<String, HashSet<Object>> x0$2) {
                            Tuple2<String, HashSet<Object>> tuple2 = x0$2;
                            if (tuple2 != null) {
                                String k = (String)tuple2._1();
                                HashSet values = (HashSet)tuple2._2();
                                Option$.MODULE$.apply(this.sf$1.getAttribute(k)).foreach((Function1)new Serializable(this, values){
                                    public static final long serialVersionUID = 0L;
                                    private final HashSet values$1;

                                    public final boolean apply(Object elem) {
                                        return this.values$1.add(elem);
                                    }
                                    {
                                        this.values$1 = values$1;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.sf$1 = sf$1;
                        }
                    });
                }
                {
                    this.map$1 = map$1;
                }
            });
            map = (Map)map2.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Object[]> apply(Tuple2<String, HashSet<Object>> x0$3) {
                    Tuple2<String, HashSet<Object>> tuple2 = x0$3;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        HashSet values = (HashSet)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)k, values.toArray(ClassTag$.MODULE$.AnyRef()));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Map$.MODULE$.canBuildFrom());
        }
        return map;
    }

    public long writeSortedBatches(SimpleFeatureType sft, SimpleFeatureVector.SimpleFeatureEncoding encoding, Tuple2<String, Object> sort, Map<String, ArrowDictionary> dictionaries, int batchSize, Iterator<SimpleFeature> features, OutputStream out) {
        Tuple2<String, Object> tuple2 = sort;
        if (tuple2 != null) {
            Tuple2 tuple22;
            String sortField = (String)tuple2._1();
            boolean reverse = tuple2._2$mcZ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)sortField, (Object)BoxesRunTime.boxToBoolean((boolean)reverse));
            String sortField2 = (String)tuple23._1();
            boolean reverse2 = tuple23._2$mcZ$sp();
            SimpleFeatureVector vector = SimpleFeatureVector$.MODULE$.create(sft, dictionaries, encoding, SimpleFeatureVector$.MODULE$.create$default$4(), package$.MODULE$.allocator());
            RecordBatchUnloader batchWriter = new RecordBatchUnloader(vector);
            Ordering ordering = SimpleFeatureOrdering$.MODULE$.apply(sft.indexOf(sortField2));
            ArrayBuffer batches = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            SimpleFeature[] batch = (SimpleFeature[])Array$.MODULE$.ofDim(batchSize, ClassTag$.MODULE$.apply(SimpleFeature.class));
            IntRef index = IntRef.create((int)0);
            LongRef count = LongRef.create((long)0L);
            features.foreach((Function1)new Serializable(batchSize, reverse2, vector, batchWriter, ordering, batches, batch, index, count){
                public static final long serialVersionUID = 0L;
                private final int batchSize$4;
                private final boolean reverse$1;
                private final SimpleFeatureVector vector$1;
                private final RecordBatchUnloader batchWriter$1;
                private final Ordering ordering$1;
                private final ArrayBuffer batches$1;
                private final SimpleFeature[] batch$1;
                private final IntRef index$1;
                private final LongRef count$3;

                public final void apply(SimpleFeature feature) {
                    this.batch$1[this.index$1.elem] = feature;
                    ++this.index$1.elem;
                    if (this.index$1.elem % this.batchSize$4 == 0) {
                        ArrowExporter$.MODULE$.org$locationtech$geomesa$tools$export$formats$ArrowExporter$$sortAndUnloadBatch$1(this.reverse$1, this.vector$1, this.batchWriter$1, this.ordering$1, this.batches$1, this.batch$1, this.index$1, this.count$3);
                    }
                }
                {
                    this.batchSize$4 = batchSize$4;
                    this.reverse$1 = reverse$1;
                    this.vector$1 = vector$1;
                    this.batchWriter$1 = batchWriter$1;
                    this.ordering$1 = ordering$1;
                    this.batches$1 = batches$1;
                    this.batch$1 = batch$1;
                    this.index$1 = index$1;
                    this.count$3 = count$3;
                }
            });
            if (index.elem > 0) {
                this.org$locationtech$geomesa$tools$export$formats$ArrowExporter$$sortAndUnloadBatch$1(reverse2, vector, batchWriter, ordering, batches, batch, index, count);
            }
            WithClose$.MODULE$.apply((Object)SimpleFeatureArrowIO$.MODULE$.sortBatches(sft, dictionaries, encoding, sortField2, reverse2, batchSize, CloseableIterator$.MODULE$.iteratorToCloseable(batches.iterator()), package$.MODULE$.allocator()), (Function1)new Serializable(out){
                public static final long serialVersionUID = 0L;
                public final OutputStream out$1;

                public final void apply(CloseableIterator<byte[]> sorted) {
                    sorted.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.writeSortedBatches.2 $outer;

                        public final void apply(byte[] x$1) {
                            this.$outer.out$1.write(x$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.out$1 = out$1;
                }
            });
            return count.elem;
        }
        throw new MatchError(tuple2);
    }

    public final void org$locationtech$geomesa$tools$export$formats$ArrowExporter$$sortAndUnloadBatch$1(boolean reverse$1, SimpleFeatureVector vector$1, RecordBatchUnloader batchWriter$1, Ordering ordering$1, ArrayBuffer batches$1, SimpleFeature[] batch$1, IntRef index$1, LongRef count$3) {
        Arrays.sort((Object[])batch$1, 0, index$1.elem, reverse$1 ? ordering$1.reverse() : ordering$1);
        vector$1.clear();
        for (int i = 0; i < index$1.elem; ++i) {
            vector$1.writer().set(i, batch$1[i]);
        }
        batches$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{batchWriter$1.unload(index$1.elem)}));
        count$3.elem += (long)index$1.elem;
        index$1.elem = 0;
    }

    private ArrowExporter$() {
        MODULE$ = this;
    }
}

