/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import java.io.File;
import java.io.InputStream;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.LeafletMapExporter;
import org.locationtech.geomesa.tools.export.formats.LeafletMapExporter$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class LeafletMapExporter$ {
    public static final LeafletMapExporter$ MODULE$;
    private String[] Template;
    private String IndexHead;
    private String IndexTail;
    private final int MaxFeatures;
    private volatile byte bitmap$0;

    static {
        new LeafletMapExporter$();
    }

    private String[] Template$lzycompute() {
        LeafletMapExporter$ leafletMapExporter$ = this;
        synchronized (leafletMapExporter$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.Template = (String[])WithClose$.MODULE$.apply((Object)this.getClass().getClassLoader().getResourceAsStream("leaflet/index.html"), (Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    /*
                     * WARNING - void declaration
                     */
                    public final String[] apply(InputStream is) {
                        void var2_2;
                        String[] indexArray = Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString().split("\\|codegen\\|");
                        Predef$.MODULE$.require(indexArray.length == 2, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Malformed index.html, unable to render map";
                            }
                        });
                        return var2_2;
                    }
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.Template;
        }
    }

    private String IndexHead$lzycompute() {
        LeafletMapExporter$ leafletMapExporter$ = this;
        synchronized (leafletMapExporter$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.IndexHead = (String)Predef$.MODULE$.refArrayOps((Object[])this.Template()).head();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.IndexHead;
        }
    }

    private String IndexTail$lzycompute() {
        LeafletMapExporter$ leafletMapExporter$ = this;
        synchronized (leafletMapExporter$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.IndexTail = (String)Predef$.MODULE$.refArrayOps((Object[])this.Template()).last();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.IndexTail;
        }
    }

    private String[] Template() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.Template$lzycompute() : this.Template;
    }

    public String IndexHead() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.IndexHead$lzycompute() : this.IndexHead;
    }

    public String IndexTail() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.IndexTail$lzycompute() : this.IndexTail;
    }

    public int MaxFeatures() {
        return this.MaxFeatures;
    }

    public void setDestination(ExportCommand.ExportParams params) {
        Object object;
        File destination;
        File file2 = new File((String)Option$.MODULE$.apply((Object)params.file()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return (String)package$.MODULE$.props().apply((Object)"user.dir");
            }
        }));
        File file3 = destination = file2.isDirectory() || !file2.exists() && file2.getName().indexOf(".") == -1 ? new File(file2, "index.html") : file2;
        if (destination.exists()) {
            object = BoxedUnit.UNIT;
        } else {
            Option$.MODULE$.apply((Object)destination.getParentFile()).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(File x$1) {
                    return x$1.mkdirs();
                }
            });
            object = BoxesRunTime.boxToBoolean((boolean)destination.createNewFile());
        }
        params.file_$eq(destination.getAbsolutePath());
    }

    public String getFeatureInfo(SimpleFeatureType sft) {
        Option option;
        block4: {
            StringBuilder str;
            block3: {
                String string;
                block2: {
                    str = new StringBuilder();
                    str.append("    function onEachFeature(feature, layer) {\n");
                    option = Option$.MODULE$.apply((Object)sft);
                    if (!None$.MODULE$.equals(option)) break block2;
                    string = str.append("\n    };\n\n").toString();
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                str.append("        layer.bindPopup(\"ID: \" + feature.id + \"<br>\" + ");
                str.append("\"GEOM: \" + feature.geometry.type + \"[\" + feature.geometry.coordinates + \"]<br>\" + ");
                string = str.append(((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(AttributeDescriptor x$2) {
                        String string = x$2.getLocalName();
                        String string2 = "geom";
                        return string != null ? !string.equals(string2) : string2 != null;
                    }
                })).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(AttributeDescriptor attr) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", ": \" + feature.properties.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attr.getLocalName(), attr.getLocalName()}));
                    }
                }, Buffer$.MODULE$.canBuildFrom())).mkString(" + \"<br>\" + "));
            }
            str.append(");\n    }\n\n");
            return str.toString();
        }
        throw new MatchError((Object)option);
    }

    public void storeFeature(SimpleFeature feature, Map<LeafletMapExporter.SimpleCoordinate, Object> coords) {
        Geometry geom = (Geometry)feature.getDefaultGeometry();
        if (geom != null) {
            Predef$.MODULE$.refArrayOps((Object[])geom.getCoordinates()).foreach((Function1)new Serializable(coords){
                public static final long serialVersionUID = 0L;
                public final Map coords$1;

                public final void apply(Coordinate c) {
                    LeafletMapExporter.SimpleCoordinate simple = new LeafletMapExporter.SimpleCoordinate(c.x, c.y);
                    this.coords$1.put((Object)simple, (Object)BoxesRunTime.boxToInteger((int)1)).foreach((Function1)new Serializable(this, simple){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.storeFeature.1 $outer;
                        private final LeafletMapExporter.SimpleCoordinate simple$1;

                        public final Option<Object> apply(int count) {
                            return this.$outer.coords$1.put((Object)this.simple$1, (Object)BoxesRunTime.boxToInteger((int)(count + 1)));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.simple$1 = simple$1;
                        }
                    });
                }
                {
                    this.coords$1 = coords$1;
                }
            });
        }
    }

    public scala.collection.immutable.Map<LeafletMapExporter.SimpleCoordinate, Object> normalizeValues(Map<LeafletMapExporter.SimpleCoordinate, Object> coords) {
        scala.collection.immutable.Map map;
        if (coords.nonEmpty()) {
            float max = ((Tuple2)coords.maxBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<LeafletMapExporter.SimpleCoordinate, Object> x$3) {
                    return x$3._2$mcI$sp();
                }
            }, (Ordering)Ordering.Int$.MODULE$))._2$mcI$sp();
            map = ((TraversableOnce)coords.map((Function1)new Serializable(max){
                public static final long serialVersionUID = 0L;
                private final float max$1;

                public final Tuple2<LeafletMapExporter.SimpleCoordinate, Object> apply(Tuple2<LeafletMapExporter.SimpleCoordinate, Object> c) {
                    return new Tuple2(c._1(), (Object)BoxesRunTime.boxToFloat((float)((float)c._2$mcI$sp() / this.max$1)));
                }
                {
                    this.max$1 = max$1;
                }
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    private LeafletMapExporter$() {
        MODULE$ = this;
        this.MaxFeatures = 10000;
    }
}

