/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import com.typesafe.scalalogging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.orc.OrcFileSystemWriter;
import org.locationtech.geomesa.fs.storage.orc.OrcFileSystemWriter$;
import org.locationtech.geomesa.parquet.ParquetFileSystemStorage;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.export.formats.FileSystemExporter$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005=e!B\u0001\u0003\u0003\u0003y!A\u0005$jY\u0016\u001c\u0016p\u001d;f[\u0016C\bo\u001c:uKJT!a\u0001\u0003\u0002\u000f\u0019|'/\\1ug*\u0011QAB\u0001\u0007Kb\u0004xN\u001d;\u000b\u0005\u001dA\u0011!\u0002;p_2\u001c(BA\u0005\u000b\u0003\u001d9Wm\\7fg\u0006T!a\u0003\u0007\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0019!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003mC:<'\"A\u000b\u0002\t)\fg/Y\u0005\u0003/I\u0011aa\u00142kK\u000e$\bCA\r\u001b\u001b\u0005\u0011\u0011BA\u000e\u0003\u0005=1U-\u0019;ve\u0016,\u0005\u0010]8si\u0016\u0014\b\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\tA\fG\u000f\u001b\t\u0003?\u0015r!\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\na\u0001\u0015:fI\u00164\u0017B\u0001\u0014(\u0005\u0019\u0019FO]5oO*\u0011A%\t\u0005\u0006S\u0001!\tAK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005-b\u0003CA\r\u0001\u0011\u0015i\u0002\u00061\u0001\u001f\u0011!q\u0003\u0001#b\u0001\n\u0013y\u0013A\u00025b]\u0012dW-F\u00011!\t\t\u0014J\u0004\u00023\r:\u00111g\u0011\b\u0003i\u0001s!!\u000e \u000f\u0005YjdBA\u001c=\u001d\tA4(D\u0001:\u0015\tQd\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0010\u0005\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0005\u0013\u0015AA5p\u0015\ty\u0004\"\u0003\u0002E\u000b\u0006\u0011am\u001d\u0006\u0003\u0003\nK!a\u0012%\u0002%\u0019KG.Z*zgR,W\u000eR3mK\u001e\fG/\u001a\u0006\u0003\t\u0016K!AS&\u0003\u0015\u0019KG.\u001a%b]\u0012dWM\u0003\u0002H\u0011\"AQ\n\u0001E\u0001B\u0003&\u0001'A\u0004iC:$G.\u001a\u0011\t\u0013=\u0003\u0001\u0019!a\u0001\n\u0013\u0001\u0016AB<sSR,'/F\u0001R!\t\u0011\u0006M\u0004\u0002T;:\u0011AK\u0017\b\u0003+^s!!\u000e,\n\u0005\u0011C\u0011B\u0001-Z\u0003\u001d\u0019Ho\u001c:bO\u0016T!\u0001\u0012\u0005\n\u0005mc\u0016aA1qS*\u0011\u0001,W\u0005\u0003=~\u000b\u0011CR5mKNK8\u000f^3n'R|'/Y4f\u0015\tYF,\u0003\u0002bE\n\u0001b)\u001b7f'f\u001cH/Z7Xe&$XM\u001d\u0006\u0003=~C\u0011\u0002\u001a\u0001A\u0002\u0003\u0007I\u0011B3\u0002\u0015]\u0014\u0018\u000e^3s?\u0012*\u0017\u000f\u0006\u0002gSB\u0011\u0001eZ\u0005\u0003Q\u0006\u0012A!\u00168ji\"9!nYA\u0001\u0002\u0004\t\u0016a\u0001=%c!1A\u000e\u0001Q!\nE\u000bqa\u001e:ji\u0016\u0014\b\u0005C\u0003o\u0001\u0019Eq.\u0001\u0007de\u0016\fG/Z,sSR,'\u000f\u0006\u0002Ra\")\u0011/\u001ca\u0001e\u0006\u00191O\u001a;\u0011\u0005MTX\"\u0001;\u000b\u0005U4\u0018AB:j[BdWM\u0003\u0002xq\u00069a-Z1ukJ,'BA=\r\u0003\u001dy\u0007/\u001a8hSNL!a\u001f;\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X\rC\u0003~\u0001\u0011\u0005c0A\u0003ti\u0006\u0014H\u000f\u0006\u0002g\u007f\")\u0011\u000f a\u0001e\"1Q\u0001\u0001C!\u0003\u0007!B!!\u0002\u0002\u0012A)\u0001%a\u0002\u0002\f%\u0019\u0011\u0011B\u0011\u0003\r=\u0003H/[8o!\r\u0001\u0013QB\u0005\u0004\u0003\u001f\t#\u0001\u0002'p]\u001eD\u0001\"a\u0005\u0002\u0002\u0001\u0007\u0011QC\u0001\tM\u0016\fG/\u001e:fgB1\u0011qCA\u0011\u0003OqA!!\u0007\u0002\u001e9\u0019\u0001(a\u0007\n\u0003\tJ1!a\b\"\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\t\u0002&\tA\u0011\n^3sCR|'OC\u0002\u0002 \u0005\u00022a]A\u0015\u0013\r\tY\u0003\u001e\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\t\u000f\u0005=\u0002\u0001\"\u0011\u00022\u0005)!-\u001f;fgV\u0011\u00111\u0002\u0005\b\u0003k\u0001A\u0011IA\u001c\u0003\u0015\u0019Gn\\:f)\u00051waBA\u001e\u0005!\u0005\u0011QH\u0001\u0013\r&dWmU=ti\u0016lW\t\u001f9peR,'\u000fE\u0002\u001a\u0003\u007f1a!\u0001\u0002\t\u0002\u0005\u00053CBA \u0003\u0007\nI\u0005E\u0002!\u0003\u000bJ1!a\u0012\"\u0005\u0019\te.\u001f*fMB!\u00111JA-\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013\u0001D:dC2\fGn\\4hS:<'\u0002BA*\u0003+\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0003/\n1aY8n\u0013\u0011\tY&!\u0014\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\bS\u0005}B\u0011AA0)\t\tiDB\u0004\u0002d\u0005}\u0002!!\u001a\u00033A\u000b'/];fi\u001aKG.Z*zgR,W.\u0012=q_J$XM]\n\u0004\u0003CZ\u0003\"C\u000f\u0002b\t\u0005\t\u0015!\u0003\u001f\u0011\u001dI\u0013\u0011\rC\u0001\u0003W\"B!!\u001c\u0002rA!\u0011qNA1\u001b\t\ty\u0004\u0003\u0004\u001e\u0003S\u0002\rA\b\u0005\b]\u0006\u0005D\u0011KA;)\r\t\u0016q\u000f\u0005\u0007c\u0006M\u0004\u0019\u0001:\u0007\u000f\u0005m\u0014q\b\u0001\u0002~\t)rJ]2GS2,7+_:uK6,\u0005\u0010]8si\u0016\u00148cAA=W!IQ$!\u001f\u0003\u0002\u0003\u0006IA\b\u0005\bS\u0005eD\u0011AAB)\u0011\t))a\"\u0011\t\u0005=\u0014\u0011\u0010\u0005\u0007;\u0005\u0005\u0005\u0019\u0001\u0010\t\u000f9\fI\b\"\u0015\u0002\fR\u0019\u0011+!$\t\rE\fI\t1\u0001s\u0001")
public abstract class FileSystemExporter
implements FeatureExporter {
    private final String path;
    private FileSystemDelegate.FileHandle handle;
    private FileSystemStorage.FileSystemWriter org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer;
    private volatile boolean bitmap$0;

    public static Logger logger() {
        return FileSystemExporter$.MODULE$.logger();
    }

    private FileSystemDelegate.FileHandle handle$lzycompute() {
        FileSystemExporter fileSystemExporter = this;
        synchronized (fileSystemExporter) {
            if (!this.bitmap$0) {
                this.handle = PathUtils$.MODULE$.getHandle(this.path);
                this.bitmap$0 = true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            this.path = null;
            return this.handle;
        }
    }

    private FileSystemDelegate.FileHandle handle() {
        return this.bitmap$0 ? this.handle : this.handle$lzycompute();
    }

    public FileSystemStorage.FileSystemWriter org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer() {
        return this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer;
    }

    private void org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer_$eq(FileSystemStorage.FileSystemWriter x$1) {
        this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer = x$1;
    }

    public abstract FileSystemStorage.FileSystemWriter createWriter(SimpleFeatureType var1);

    @Override
    public void start(SimpleFeatureType sft) {
        if (this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer() != null) {
            this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer().close();
        }
        this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer_$eq(this.createWriter(sft));
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        Predef$.MODULE$.require(this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Must call 'start' before 'export'";
            }
        });
        LongRef i = LongRef.create((long)0L);
        features.foreach((Function1)new Serializable(this, i){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystemExporter $outer;
            private final LongRef i$1;

            public final void apply(SimpleFeature f) {
                this.$outer.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer().write(f);
                ++this.i$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.i$1 = i$1;
            }
        });
        return new Some((Object)BoxesRunTime.boxToLong((long)i.elem));
    }

    @Override
    public long bytes() {
        return this.handle().length();
    }

    @Override
    public void close() {
        if (this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer() != null) {
            this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer().close();
        }
    }

    public FileSystemExporter(String path) {
        this.path = path;
    }

    public static class OrcFileSystemExporter
    extends FileSystemExporter {
        private final String path;

        @Override
        public FileSystemStorage.FileSystemWriter createWriter(SimpleFeatureType sft) {
            return new OrcFileSystemWriter(sft, new Configuration(), new Path(PathUtils$.MODULE$.getUrl(this.path).toURI()), OrcFileSystemWriter$.MODULE$.$lessinit$greater$default$4());
        }

        public OrcFileSystemExporter(String path) {
            this.path = path;
            super(path);
        }
    }

    public static class ParquetFileSystemExporter
    extends FileSystemExporter {
        private final String path;

        @Override
        public FileSystemStorage.FileSystemWriter createWriter(SimpleFeatureType sft) {
            BoxedUnit boxedUnit;
            Configuration conf = new Configuration();
            StorageConfiguration$.MODULE$.setSft(conf, sft);
            try {
                boxedUnit = Class.forName("org.xerial.snappy.Snappy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                BoxedUnit boxedUnit2;
                if (FileSystemExporter$.MODULE$.logger().underlying().isWarnEnabled()) {
                    FileSystemExporter$.MODULE$.logger().underlying().warn("SNAPPY compression is not available on the classpath - falling back to GZIP");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                conf.set("parquet.compression", "GZIP");
                boxedUnit = BoxedUnit.UNIT;
            }
            return new ParquetFileSystemStorage.ParquetFileSystemWriter(sft, new Path(PathUtils$.MODULE$.getUrl(this.path).toURI()), conf, ParquetFileSystemStorage.ParquetFileSystemWriter$.MODULE$.$lessinit$greater$default$4());
        }

        public ParquetFileSystemExporter(String path) {
            this.path = path;
            super(path);
        }
    }
}

