/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.locationtech.geomesa.tools.Command;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.CommandWithSubCommands;
import org.locationtech.geomesa.tools.Runner;
import org.locationtech.geomesa.tools.Runner$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.control.NonFatal$;

public abstract class Runner$class {
    public static Option environmentErrorInfo(Runner $this) {
        return None$.MODULE$;
    }

    public static void main(Runner $this, String[] args) {
        try {
            $this.parseCommand(args).execute();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoClassDefFoundError;
            if (bl) {
                BoxedUnit boxedUnit;
                String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Warning: Missing dependency for command execution: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable2.getMessage()}));
                if ($this.logger().underlying().isErrorEnabled()) {
                    $this.logger().underlying().error(msg, throwable2);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Command$.MODULE$.user().error(msg);
                $this.environmentErrorInfo().foreach((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(String x$1) {
                        Command$.MODULE$.user().error(x$1);
                    }
                });
                throw package$.MODULE$.exit(-1);
            }
            if (throwable2 instanceof ParameterException) {
                ParameterException parameterException = (ParameterException)throwable2;
                Command$.MODULE$.user().error(parameterException.getMessage());
                throw package$.MODULE$.exit(-1);
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Command$.MODULE$.user().error(e.getMessage(), e);
            throw package$.MODULE$.exit(-1);
        }
        throw package$.MODULE$.exit(0);
    }

    /*
     * WARNING - void declaration
     */
    public static Command parseCommand(Runner $this, String[] args) {
        JCommander jc = new JCommander();
        jc.setProgramName($this.name());
        Runner$.MODULE$.addConverterFactories(jc);
        Seq<Command> commands = $this.createCommands(jc);
        commands.foreach((Function1)new Serializable($this, jc){
            public static final long serialVersionUID = 0L;
            private final JCommander jc$1;

            public final void apply(Command x0$1) {
                Command command = x0$1;
                if (command instanceof CommandWithSubCommands) {
                    CommandWithSubCommands commandWithSubCommands = (CommandWithSubCommands)command;
                    this.jc$1.addCommand(commandWithSubCommands.name(), commandWithSubCommands.params());
                    JCommander registered = (JCommander)this.jc$1.getCommands().get(commandWithSubCommands.name());
                    commandWithSubCommands.subCommands().foreach((Function1)new Serializable(this, registered){
                        public static final long serialVersionUID = 0L;
                        private final JCommander registered$1;

                        public final void apply(Command sub) {
                            this.registered$1.addCommand(sub.name(), sub.params());
                        }
                        {
                            this.registered$1 = registered$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.jc$1.addCommand(command.name(), command.params());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.jc$1 = jc$1;
            }
        });
        try {
            jc.parse(args);
        }
        catch (ParameterException parameterException) {
            void var2_2;
            Command$.MODULE$.user().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error parsing arguments: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parameterException.getMessage()})));
            Command$.MODULE$.user().info($this.usage((JCommander)var2_2, var2_2.getParsedCommand()));
            throw parameterException;
        }
        Command parsed = (Command)commands.find((Function1)new Serializable($this, jc){
            public static final long serialVersionUID = 0L;
            private final JCommander jc$1;

            public final boolean apply(Command x$1) {
                String string = x$1.name();
                String string2 = this.jc$1.getParsedCommand();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.jc$1 = jc$1;
            }
        }).getOrElse((Function0)new Serializable($this, jc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Runner $outer;
            private final JCommander jc$1;

            public final Runner.DefaultCommand apply() {
                return new Runner.DefaultCommand(this.$outer, this.jc$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.jc$1 = jc$1;
            }
        });
        $this.resolveEnvironment(parsed);
        return parsed;
    }

    public static String usage(Runner $this, JCommander jc) {
        StringBuilder out = new StringBuilder();
        out.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Usage: ", " [command] [command options]\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.name()})));
        Seq commands = ((TraversableOnce)JavaConversions$.MODULE$.mapAsScalaMap(jc.getCommands()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, JCommander> x$2) {
                return (String)x$2._1();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        out.append("  Commands:\n");
        int maxLen = BoxesRunTime.unboxToInt((Object)((TraversableOnce)commands.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$3) {
                return x$3.length();
            }
        }, Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$)) + 4;
        ((IterableLike)commands.sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1)new Serializable($this, out, maxLen, jc){
            public static final long serialVersionUID = 0L;
            private final StringBuilder out$1;
            private final int maxLen$1;
            private final JCommander jc$2;

            public final StringBuilder apply(String command) {
                String spaces = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(this.maxLen$1 - command.length());
                return this.out$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"    ", "", "", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command, spaces, this.jc$2.getCommandDescription(command)})));
            }
            {
                this.out$1 = out$1;
                this.maxLen$1 = maxLen$1;
                this.jc$2 = jc$2;
            }
        });
        return out.toString();
    }

    public static String usage(Runner $this, JCommander jc, String name) {
        Option option;
        block4: {
            String string;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)name).flatMap((Function1)new Serializable($this, jc){
                        public static final long serialVersionUID = 0L;
                        private final JCommander jc$3;

                        public final Option<JCommander> apply(String n) {
                            return Option$.MODULE$.apply(this.jc$3.getCommands().get(n));
                        }
                        {
                            this.jc$3 = jc$3;
                        }
                    });
                    if (!None$.MODULE$.equals(option)) break block2;
                    string = $this.usage(jc);
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                JCommander command = (JCommander)some.x();
                java.lang.StringBuilder out = new java.lang.StringBuilder();
                command.usage(out);
                string = out.toString();
            }
            return string;
        }
        throw new MatchError((Object)option);
    }

    public static void autocompleteUsage(Runner $this, JCommander jc, Runner.AutocompleteInfo autocompleteInfo) {
        File file = new File(autocompleteInfo.path());
        Seq commands = ((TraversableOnce)JavaConversions$.MODULE$.mapAsScalaMap(jc.getCommands()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, JCommander> x$4) {
                return (String)x$4._1();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        StringBuilder out = new StringBuilder();
        out.append(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_", "(){\n         |  local cur prev;\n         |  COMPREPLY=();\n         |  cur=\"${COMP_WORDS[COMP_CWORD]}\";\n         |  prev=\"${COMP_WORDS[COMP_CWORD-1]}\";\n         |\n         |  if [[ \"${COMP_WORDS[1]}\" == \"help\" ]]; then\n         |    COMPREPLY=( $(compgen -W \"", "\" ${cur}));\n         |    return 0;\n         |  fi;\n         |\n         |  case ${COMP_CWORD} in\n         |    1)\n         |      COMPREPLY=( $(compgen -W \"", "\" ${cur}));\n         |      ;;\n         |    [2-9] | [1-9][0-9])\n         |      if [[ \"${cur}\" =~ ^-[a-zA-Z-]?+$ ]]; then\n         |        case ${COMP_WORDS[1]} in\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{autocompleteInfo.commandName(), commands.mkString(" "), commands.mkString(" ")})))).stripMargin());
        commands.foreach((Function1)new Serializable($this, out, jc){
            public static final long serialVersionUID = 0L;
            private final StringBuilder out$2;
            private final JCommander jc$4;

            public final StringBuilder apply(String command) {
                Buffer params = (Buffer)((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(((JCommander)this.jc$4.getCommands().get(command)).getParameters()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ParameterDescription x$5) {
                        return !x$5.getParameter().hidden();
                    }
                })).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<String> apply(ParameterDescription x$6) {
                        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])x$6.getParameter().names()).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$7) {
                                return x$7.length() != 2;
                            }
                        }));
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                return this.out$2.append(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"            ", ")\n         |              COMPREPLY=( $(compgen -W \"", "\" -- ${cur}));\n         |              return 0;\n         |              ;;\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command, params.mkString(" ").replaceAll("[,\\s]+", " ")})))).stripMargin());
            }
            {
                this.out$2 = out$2;
                this.jc$4 = jc$4;
            }
        });
        out.append(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"        esac;\n         |      else\n         |        compopt -o filenames -o nospace;\n         |        COMPREPLY=( $(compgen -f \"$2\") );\n         |      fi;\n         |      return 0;\n         |      ;;\n         |    *)\n         |      COMPREPLY=();\n         |      ;;\n         |  esac;\n         |};\n         |complete -F _", " ", ";\n         |complete -F _", " bin/", ";\n         |\n         |\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{autocompleteInfo.commandName(), autocompleteInfo.commandName(), autocompleteInfo.commandName(), autocompleteInfo.commandName()})))).stripMargin());
        FileUtils.writeStringToFile((File)file, (String)out.toString(), (Charset)StandardCharsets.UTF_8);
    }

    public static void resolveEnvironment(Runner $this, Command command) {
    }

    public static void $init$(Runner $this) {
    }
}

