/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.OutputStream;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.locationtech.geomesa.tools.export.formats.DelimitedExporter$;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001=\u0011\u0011\u0003R3mS6LG/\u001a3FqB|'\u000f^3s\u0015\t\u0019A!A\u0004g_Jl\u0017\r^:\u000b\u0005\u00151\u0011AB3ya>\u0014HO\u0003\u0002\b\u0011\u0005)Ao\\8mg*\u0011\u0011BC\u0001\bO\u0016|W.Z:b\u0015\tYA\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001C\n\t\u0003#\rr!AE\u0011\u000f\u0005M\u0001cB\u0001\u000b \u001d\t)bD\u0004\u0002\u0017;9\u0011q\u0003\b\b\u00031mi\u0011!\u0007\u0006\u000359\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u0003E\t\tqBR3biV\u0014X-\u0012=q_J$XM]\u0005\u0003I\u0015\u00121CQ=uK\u000e{WO\u001c;fe\u0016C\bo\u001c:uKJT!A\t\u0002\u0011\u0005\u001drS\"\u0001\u0015\u000b\u0005%R\u0013\u0001D:dC2\fGn\\4hS:<'BA\u0016-\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0017\u0002\u0007\r|W.\u0003\u00020Q\tYA*\u0019>z\u0019><w-\u001b8h\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014a\u00029sS:$XM\u001d\t\u0003gij\u0011\u0001\u000e\u0006\u0003kY\n1aY:w\u0015\t9\u0004(A\u0004d_6lwN\\:\u000b\u0005eb\u0011AB1qC\u000eDW-\u0003\u0002<i\tQ1i\u0015,Qe&tG/\u001a:\t\u0011u\u0002!\u0011!Q\u0001\ny\nqaY8v]R,'\u000f\u0005\u0002\u0012\u007f%\u0011\u0001)\n\u0002\f\u0005f$XmQ8v]R,'\u000f\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0003)9\u0018\u000e\u001e5IK\u0006$WM\u001d\t\u0003\t\u001ek\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\b\u0005>|G.Z1o\u0011!Q\u0005A!A!\u0002\u0013\u0019\u0015AC5oG2,H-Z%eg\")A\n\u0001C\u0001\u001b\u00061A(\u001b8jiz\"RA\u0014)R%N\u0003\"a\u0014\u0001\u000e\u0003\tAQ!M&A\u0002IBQ!P&A\u0002yBQAQ&A\u0002\rCQAS&A\u0002\rCQ!\u0016\u0001\u0005BY\u000bQa\u001d;beR$\"a\u0016.\u0011\u0005\u0011C\u0016BA-F\u0005\u0011)f.\u001b;\t\u000bm#\u0006\u0019\u0001/\u0002\u0007M4G\u000f\u0005\u0002^I6\taL\u0003\u0002`A\u000611/[7qY\u0016T!!\u00192\u0002\u000f\u0019,\u0017\r^;sK*\u00111\rD\u0001\b_B,gnZ5t\u0013\t)gLA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016DQ!\u0002\u0001\u0005B\u001d$\"\u0001\u001b8\u0011\u0007\u0011K7.\u0003\u0002k\u000b\n1q\n\u001d;j_:\u0004\"\u0001\u00127\n\u00055,%\u0001\u0002'p]\u001eDQa\u001c4A\u0002A\f\u0001BZ3biV\u0014Xm\u001d\t\u0004cZLhB\u0001:u\u001d\tA2/C\u0001G\u0013\t)X)A\u0004qC\u000e\\\u0017mZ3\n\u0005]D(\u0001C%uKJ\fGo\u001c:\u000b\u0005U,\u0005CA/{\u0013\tYhLA\u0007TS6\u0004H.\u001a$fCR,(/\u001a\u0005\u0006{\u0002!\tE`\u0001\u0006G2|7/\u001a\u000b\u0002/\"9\u0011\u0011\u0001\u0001\u0005\n\u0005\r\u0011!C:ue&tw-\u001b4z)\u0011\t)!a\u0005\u0011\t\u0005\u001d\u0011Q\u0002\b\u0004\t\u0006%\u0011bAA\u0006\u000b\u00061\u0001K]3eK\u001aLA!a\u0004\u0002\u0012\t11\u000b\u001e:j]\u001eT1!a\u0003F\u0011\u001d\t)b a\u0001\u0003/\t1a\u001c2k!\r!\u0015\u0011D\u0005\u0004\u00037)%aA!os\u001e9\u0011q\u0004\u0002\t\u0002\u0005\u0005\u0012!\u0005#fY&l\u0017\u000e^3e\u000bb\u0004xN\u001d;feB\u0019q*a\t\u0007\r\u0005\u0011\u0001\u0012AA\u0013'\u0011\t\u0019#a\n\u0011\u0007\u0011\u000bI#C\u0002\u0002,\u0015\u0013a!\u00118z%\u00164\u0007b\u0002'\u0002$\u0011\u0005\u0011q\u0006\u000b\u0003\u0003CAq!NA\u0012\t\u0003\t\u0019\u0004F\u0005O\u0003k\tI%a\u0013\u0002N!A\u0011qGA\u0019\u0001\u0004\tI$\u0001\u0002pgB!\u00111HA#\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013AA5p\u0015\t\t\u0019%\u0001\u0003kCZ\f\u0017\u0002BA$\u0003{\u0011AbT;uaV$8\u000b\u001e:fC6Da!PA\u0019\u0001\u0004q\u0004B\u0002\"\u00022\u0001\u00071\t\u0003\u0005K\u0003c\u0001\n\u00111\u0001D\u0011!\t\t&a\t\u0005\u0002\u0005M\u0013a\u0001;tmRIa*!\u0016\u0002X\u0005e\u00131\f\u0005\t\u0003o\ty\u00051\u0001\u0002:!1Q(a\u0014A\u0002yBaAQA(\u0001\u0004\u0019\u0005\u0002\u0003&\u0002PA\u0005\t\u0019A\"\t\u0011\u0005}\u00131\u0005C\u0001\u0003C\nQ!\u00199qYf$2BTA2\u0003K\n9'!\u001d\u0002t!A\u0011qGA/\u0001\u0004\tI\u0004\u0003\u0004>\u0003;\u0002\rA\u0010\u0005\t\u0003S\ni\u00061\u0001\u0002l\u00051am\u001c:nCR\u00042aMA7\u0013\r\ty\u0007\u000e\u0002\n\u0007N3fi\u001c:nCRDaAQA/\u0001\u0004\u0019\u0005\u0002\u0003&\u0002^A\u0005\t\u0019A\"\t\u0015\u0005]\u00141EI\u0001\n\u0003\tI(A\u0007dgZ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003wR3aQA?W\t\ty\b\u0005\u0003\u0002\u0002\u0006-UBAAB\u0015\u0011\t))a\"\u0002\u0013Ut7\r[3dW\u0016$'bAAE\u000b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00151\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007BCAI\u0003G\t\n\u0011\"\u0001\u0002z\u0005iAo\u001d<%I\u00164\u0017-\u001e7uIQB!\"!&\u0002$E\u0005I\u0011AA=\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012*\u0004")
public class DelimitedExporter
extends FeatureExporter.ByteCounterExporter
implements LazyLogging {
    public final CSVPrinter org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer;
    private final boolean withHeader;
    public final boolean org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$includeIds;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static boolean apply$default$5() {
        return DelimitedExporter$.MODULE$.apply$default$5();
    }

    public static boolean tsv$default$4() {
        return DelimitedExporter$.MODULE$.tsv$default$4();
    }

    public static boolean csv$default$4() {
        return DelimitedExporter$.MODULE$.csv$default$4();
    }

    public static DelimitedExporter apply(OutputStream outputStream, FeatureExporter.ByteCounter byteCounter, CSVFormat cSVFormat, boolean bl, boolean bl2) {
        return DelimitedExporter$.MODULE$.apply(outputStream, byteCounter, cSVFormat, bl, bl2);
    }

    public static DelimitedExporter tsv(OutputStream outputStream, FeatureExporter.ByteCounter byteCounter, boolean bl, boolean bl2) {
        return DelimitedExporter$.MODULE$.tsv(outputStream, byteCounter, bl, bl2);
    }

    public static DelimitedExporter csv(OutputStream outputStream, FeatureExporter.ByteCounter byteCounter, boolean bl, boolean bl2) {
        return DelimitedExporter$.MODULE$.csv(outputStream, byteCounter, bl, bl2);
    }

    private Logger logger$lzycompute() {
        DelimitedExporter delimitedExporter = this;
        synchronized (delimitedExporter) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public void start(SimpleFeatureType sft) {
        if (this.withHeader) {
            if (this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$includeIds) {
                this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.print((Object)"id");
            }
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).foreach((Function1)new Serializable(this, sft){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedExporter $outer;
                private final SimpleFeatureType sft$1;

                public final void apply(AttributeDescriptor descriptor) {
                    this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.print((Object)SimpleFeatureTypes$.MODULE$.encodeDescriptor(this.sft$1, descriptor));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sft$1 = sft$1;
                }
            });
            this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.println();
            this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.flush();
        }
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        BoxedUnit boxedUnit;
        LongRef count2 = LongRef.create((long)0L);
        features.foreach((Function1)new Serializable(this, count2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelimitedExporter $outer;
            private final LongRef count$1;

            public final void apply(SimpleFeature sf) {
                if (this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$includeIds) {
                    this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.print((Object)sf.getID());
                }
                for (int i = 0; i < sf.getAttributeCount(); ++i) {
                    this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.print((Object)this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(sf.getAttribute(i)));
                }
                this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.println();
                ++this.count$1.elem;
                if (this.count$1.elem % 10000L == 0L) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("wrote {} features", new Object[]{BoxesRunTime.boxToLong((long)this.count$1.elem)});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.count$1 = count$1;
            }
        });
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.flush();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Exported {} features", new Object[]{BoxesRunTime.boxToLong((long)count2.elem)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)count2.elem));
    }

    @Override
    public void close() {
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer.close();
    }

    public String org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(Object obj) {
        String string;
        Object object = obj;
        if (object == null) {
            string = "";
        } else if (object instanceof Geometry) {
            Geometry geometry = (Geometry)object;
            string = WKTUtils$.MODULE$.write(geometry);
        } else if (object instanceof Date) {
            Date date = (Date)object;
            string = package$.MODULE$.GeoToolsDateFormat().format(Instant.ofEpochMilli(date.getTime()).atZone(ZoneOffset.UTC));
        } else if (object instanceof List) {
            List list = (List)object;
            string = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedExporter $outer;

                public final String apply(Object obj) {
                    return this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(obj);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(",");
        } else if (object instanceof Map) {
            Map map2 = (Map)object;
            string = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map2).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedExporter $outer;

                public final String apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "->", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(k), this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(v)}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
        } else {
            string = obj.toString();
        }
        return string;
    }

    public DelimitedExporter(CSVPrinter printer, FeatureExporter.ByteCounter counter, boolean withHeader, boolean includeIds) {
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer = printer;
        this.withHeader = withHeader;
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$includeIds = includeIds;
        super(counter);
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

