/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.data;

import com.beust.jcommander.ParameterException;
import java.io.IOException;
import org.geotools.data.DataStore;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geomesa.tools.data.UpdateSchemaCommand;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.locationtech.geomesa.utils.conf.IndexId;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpec;
import org.locationtech.geomesa.utils.geotools.sft.SimpleFeatureSpecParser$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

public abstract class UpdateSchemaCommand$class {
    public static void execute(UpdateSchemaCommand $this) {
        $this.withDataStore(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UpdateSchemaCommand $outer;

            public final void apply(DS ds) {
                this.$outer.update(ds);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void update(UpdateSchemaCommand $this, DataStore ds) {
        Object x$6;
        List<String> x$5;
        String x$4;
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        SimpleFeatureType sft;
        SimpleFeatureType simpleFeatureType;
        $this.params().validate().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(ParameterException e) {
                throw e;
            }
        });
        try {
            simpleFeatureType = ds.getSchema($this.params().featureName());
        }
        catch (IOException iOException) {
            simpleFeatureType = sft = null;
        }
        if (sft == null) {
            throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' does not exist in the data store"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.params().featureName()})));
        }
        IntRef n = IntRef.create((int)0);
        StringBuilder prompts = new StringBuilder();
        BooleanRef canRenameTables = BooleanRef.create((boolean)false);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(sft);
        Option$.MODULE$.apply((Object)$this.params().rename()).foreach((Function1)new Serializable($this, n, prompts, canRenameTables, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UpdateSchemaCommand $outer;
            private final IntRef n$1;
            private final StringBuilder prompts$1;
            private final BooleanRef canRenameTables$1;
            private final SimpleFeatureTypeBuilder builder$1;

            public final void apply(String rename) {
                int n = rename.indexOf(58);
                switch (n) {
                    default: {
                        this.builder$1.setNamespaceURI(rename.substring(0, n));
                        this.builder$1.setName(rename.substring(n + 1));
                        break;
                    }
                    case -1: {
                        this.builder$1.setName(rename);
                    }
                }
                this.prompts$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  ", ": Renaming schema to '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)UpdateSchemaCommand$class.number$1(this.$outer, this.n$1)), rename})));
                this.canRenameTables$1.elem = true;
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.n$1 = n$1;
                this.prompts$1 = var3_3;
                this.canRenameTables$1 = var4_4;
                this.builder$1 = var5_5;
            }
        });
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.params().renameAttributes()).asScala()).grouped(2).foreach((Function1)new Serializable($this, sft, n, prompts, canRenameTables, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UpdateSchemaCommand $outer;
            private final SimpleFeatureType sft$1;
            private final IntRef n$1;
            private final StringBuilder prompts$1;
            private final BooleanRef canRenameTables$1;
            private final SimpleFeatureTypeBuilder builder$1;

            public final void apply(Buffer<String> x0$1) {
                Buffer<String> buffer = x0$1;
                Some some = Seq$.MODULE$.unapplySeq(buffer);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    String from = (String)((SeqLike)some.get()).apply(0);
                    String to = (String)((SeqLike)some.get()).apply(1);
                    int i = this.sft$1.indexOf(from);
                    if (i == -1) {
                        throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute '", "' does not exist in the schema"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{from})));
                    }
                    AttributeTypeBuilder attribute = new AttributeTypeBuilder();
                    attribute.init(this.sft$1.getDescriptor(i));
                    this.builder$1.set(i, attribute.buildDescriptor(to));
                    String string = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1));
                    String string2 = from;
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.builder$1.setDefaultGeometry(to);
                    }
                    this.prompts$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  ", ": Renaming attribute '", "' to '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)UpdateSchemaCommand$class.number$1(this.$outer, this.n$1)), from, to})));
                    this.canRenameTables$1.elem = this.canRenameTables$1.elem || RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getIndices$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1)).exists((Function1)new Serializable(this, from){
                        public static final long serialVersionUID = 0L;
                        private final String from$1;

                        public final boolean apply(IndexId x$1) {
                            return x$1.attributes().contains((Object)this.from$1);
                        }
                        {
                            this.from$1 = from$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(buffer);
            }
            {
                void var6_6;
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$1 = sft$1;
                this.n$1 = var3_3;
                this.prompts$1 = var4_4;
                this.canRenameTables$1 = var5_5;
                this.builder$1 = var6_6;
            }
        });
        Object object = canRenameTables.elem && $this.params().renameTables() ? prompts.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  ", ": Renaming index tables (WARNING may be expensive)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)UpdateSchemaCommand$class.number$1($this, n))}))) : BoxedUnit.UNIT;
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.params().attributes()).asScala()).foreach((Function1)new Serializable($this, n, prompts, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UpdateSchemaCommand $outer;
            private final IntRef n$1;
            private final StringBuilder prompts$1;
            private final SimpleFeatureTypeBuilder builder$1;

            public final StringBuilder apply(String attribute) {
                SimpleFeatureSpec.AttributeSpec spec;
                try {
                    spec = SimpleFeatureSpecParser$.MODULE$.parseAttribute(attribute, SimpleFeatureSpecParser$.MODULE$.parseAttribute$default$2());
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid attribute spec: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{attribute})), e);
                }
                this.builder$1.add(spec.toDescriptor());
                return this.prompts$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  ", ": Adding attribute '", "' of type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)UpdateSchemaCommand$class.number$1(this.$outer, this.n$1)), spec.name(), spec.clazz().getName()})));
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.n$1 = n$1;
                this.prompts$1 = var3_3;
                this.builder$1 = var4_4;
            }
        });
        SimpleFeatureType updated = builder.buildFeatureType();
        updated.getUserData().putAll(sft.getUserData());
        if ($this.params().plusKeywords().isEmpty()) {
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            Buffer keywords = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter($this.params().plusKeywords()).asScala();
            RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.addKeywords$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(updated), keywords.toSet());
            boxedUnit2 = prompts.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  ", ": Adding keywords: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)UpdateSchemaCommand$class.number$1($this, n)), keywords.mkString("', '")})));
        }
        if ($this.params().minusKeywords().isEmpty()) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            Buffer keywords = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter($this.params().minusKeywords()).asScala();
            RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.removeKeywords$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(updated), keywords.toSet());
            boxedUnit = prompts.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  ", ": Removing keywords: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)UpdateSchemaCommand$class.number$1($this, n)), keywords.mkString("', '")})));
        }
        if (!$this.params().userData().isEmpty()) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter($this.params().userData()).asScala()).foreach((Function1)new Serializable($this, n, prompts, updated){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ UpdateSchemaCommand $outer;
                private final IntRef n$1;
                private final StringBuilder prompts$1;
                private final SimpleFeatureType updated$1;

                public final StringBuilder apply(String ud) {
                    String[] stringArray = ud.split(":", 2);
                    Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                        String k = (String)((SeqLike)option.get()).apply(0);
                        String v = (String)((SeqLike)option.get()).apply(1);
                        String string = this.updated$1.getUserData().put(k, v);
                        StringBuilder stringBuilder = string == null ? this.prompts$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  ", ": Adding user data: '", "=", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)UpdateSchemaCommand$class.number$1(this.$outer, this.n$1)), k, v}))) : this.prompts$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  ", ": Updating user data: '", "=", "' (was '", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)UpdateSchemaCommand$class.number$1(this.$outer, this.n$1)), k, v, string})));
                        StringBuilder stringBuilder2 = stringBuilder;
                        return stringBuilder2;
                    }
                    throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid user data entry - expected 'key:value': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ud})));
                }
                {
                    void var4_4;
                    void var3_3;
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.n$1 = n$1;
                    this.prompts$1 = var3_3;
                    this.updated$1 = var4_4;
                }
            });
        }
        Option$.MODULE$.apply((Object)$this.params().enableStats()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$2) {
                return x$2;
            }
        }).foreach((Function1)new Serializable($this, sft, n, prompts){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UpdateSchemaCommand $outer;
            private final SimpleFeatureType sft$1;
            private final IntRef n$1;
            private final StringBuilder prompts$1;

            public final StringBuilder apply(boolean enable) {
                RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.setStatsEnabled$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1), enable);
                return this.prompts$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  ", ": ", "abling stats"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)UpdateSchemaCommand$class.number$1(this.$outer, this.n$1)), enable ? "En" : "Dis"})));
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$1 = sft$1;
                this.n$1 = var3_3;
                this.prompts$1 = var4_4;
            }
        });
        Object object2 = $this.params().renameTables() ? updated.getUserData().put(SimpleFeatureTypes.Configs$.MODULE$.UpdateRenameTables(), Boolean.TRUE) : BoxedUnit.UNIT;
        Object object3 = $this.params().noBackup() ? updated.getUserData().put(SimpleFeatureTypes.Configs$.MODULE$.UpdateBackupMetadata(), Boolean.FALSE) : BoxedUnit.UNIT;
        package$Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Preparing to update schema '", "':", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName(), prompts})));
        if ($this.params().force() || Prompt$.MODULE$.confirm(x$4 = "Continue (y/n)? ", x$5 = Prompt$.MODULE$.confirm$default$2(), x$6 = Prompt$.MODULE$.confirm$default$3(x$4, x$5))) {
            package$Command$.MODULE$.user().info("Updating, please wait...");
            ds.updateSchema(sft.getTypeName(), updated);
            package$Command$.MODULE$.user().info("Update complete");
        }
    }

    public static final int number$1(UpdateSchemaCommand $this, IntRef n$1) {
        ++n$1.elem;
        return n$1.elem;
    }

    public static void $init$(UpdateSchemaCommand $this) {
        $this.org$locationtech$geomesa$tools$data$UpdateSchemaCommand$_setter_$name_$eq("update-schema");
    }
}

