/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.ingest;

import com.beust.jcommander.ParameterException;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collections;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.locationtech.geomesa.convert.ConverterConfigLoader$;
import org.locationtech.geomesa.convert.all.TypeAwareInference$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter$;
import org.locationtech.geomesa.tools.ConverterConfigParam;
import org.locationtech.geomesa.tools.FeatureSpecParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalInputFormatParam;
import org.locationtech.geomesa.tools.TypeNameParam;
import org.locationtech.geomesa.tools.ingest.IngestCommand$;
import org.locationtech.geomesa.tools.ingest.IngestCommand$$anonfun$25$$anonfun$apply$4$;
import org.locationtech.geomesa.tools.ingest.IngestCommand$$anonfun$org$locationtech$geomesa$tools$ingest$IngestCommand$;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.tools.utils.CLArgResolver$;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits$;
import org.locationtech.geomesa.utils.geotools.ConfigSftParsing$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class IngestCommand$
implements LazyLogging {
    public static final IngestCommand$ MODULE$;
    private final GeoMesaSystemProperties.SystemProperty LocalBatchSize;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new IngestCommand$();
    }

    private Logger logger$lzycompute() {
        IngestCommand$ ingestCommand$ = this;
        synchronized (ingestCommand$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public GeoMesaSystemProperties.SystemProperty LocalBatchSize() {
        return this.LocalBatchSize;
    }

    public Option<String> getDataFormat(OptionalInputFormatParam params, Seq<String> files) {
        Iterator exts;
        Some raw = params.inputFormat() == null ? ((exts = files.iterator().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<FileSystemDelegate.FileHandle> apply(String path) {
                return PathUtils$.MODULE$.interpretPath(path);
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(FileSystemDelegate.FileHandle x$4) {
                return x$4.format();
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$5) {
                return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
            }
        })).hasNext() ? new Some(exts.next()) : None$.MODULE$) : new Some((Object)params.inputFormat());
        return raw.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x0$2) {
                String string = x0$2;
                String string2 = string.equalsIgnoreCase("gml") ? "xml" : (string.equalsIgnoreCase("geojson") ? "json" : string.toLowerCase(Locale.US));
                return string2;
            }
        });
    }

    public Try<Option<Tuple2<SimpleFeatureType, Config>>> getSftAndConverter(TypeNameParam params, Seq<String> inputs, Option<String> format, Option<package.DataStoreCommand<? extends DataStore>> command) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Try try_;
            Object object = new Object();
            try {
                try_ = Try$.MODULE$.apply((Function0)new Serializable(params, inputs, format, command, object){
                    public static final long serialVersionUID = 0L;
                    private final TypeNameParam params$1;
                    private final Seq inputs$1;
                    private final Option format$1;
                    public final Option command$1;
                    private final Object nonLocalReturnKey1$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Some<Tuple2<SimpleFeatureType, Config>> apply() {
                        ListBuffer opened;
                        ObjectRef sft = ObjectRef.create((Object)((SimpleFeatureType)IngestCommand$.MODULE$.org$locationtech$geomesa$tools$ingest$IngestCommand$$loadSft(this.params$1, (Option<package.DataStoreCommand<? extends DataStore>>)this.command$1).orNull(Predef$.MODULE$.$conforms())));
                        Config converter = (Config)Option$.MODULE$.apply((Object)((ConverterConfigParam)((Object)this.params$1)).config()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Config apply(String configArg) {
                                return CLArgResolver$.MODULE$.getConfig(configArg);
                            }
                        }).orNull(Predef$.MODULE$.$conforms());
                        if (converter == null && this.inputs$1.nonEmpty()) {
                            Tuple2 tuple2;
                            Option option;
                            package$Command$.MODULE$.user().info("No converter defined - will attempt to detect schema from input files");
                            FileSystemDelegate.FileHandle file = (FileSystemDelegate.FileHandle)ScalaImplicits.RichIterator$.MODULE$.headOption$extension(ScalaImplicits$.MODULE$.RichIterator(this.inputs$1.iterator().flatMap((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Seq<FileSystemDelegate.FileHandle> apply(String path) {
                                    return PathUtils$.MODULE$.interpretPath(path);
                                }
                            }))).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Nothing$ apply() {
                                    throw new ParameterException("Parameter <files> did not evaluate to anything that could be read");
                                }
                            });
                            opened = (ListBuffer)ListBuffer$.MODULE$.empty();
                            Option option2 = this.format$1;
                            if (None$.MODULE$.equals(option2)) {
                                option = SimpleFeatureConverter$.MODULE$.infer((Function0)new Serializable(this, file, opened){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.getSftAndConverter.1 $outer;
                                    private final FileSystemDelegate.FileHandle file$1;
                                    private final ListBuffer opened$1;

                                    public final InputStream apply() {
                                        return this.$outer.org$locationtech$geomesa$tools$ingest$IngestCommand$$anonfun$$open$1(this.file$1, this.opened$1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.file$1 = file$1;
                                        this.opened$1 = opened$1;
                                    }
                                }, Option$.MODULE$.apply((Object)((SimpleFeatureType)sft.elem)), Option$.MODULE$.apply((Object)file.path()));
                            } else {
                                if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                                Some some = (Some)option2;
                                String fmt = (String)some.x();
                                option = TypeAwareInference$.MODULE$.infer(fmt, (Function0)new Serializable(this, file, opened){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.getSftAndConverter.1 $outer;
                                    private final FileSystemDelegate.FileHandle file$1;
                                    private final ListBuffer opened$1;

                                    public final InputStream apply() {
                                        return this.$outer.org$locationtech$geomesa$tools$ingest$IngestCommand$$anonfun$$open$1(this.file$1, this.opened$1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.file$1 = file$1;
                                        this.opened$1 = opened$1;
                                    }
                                }, Option$.MODULE$.apply((Object)((SimpleFeatureType)sft.elem)), Option$.MODULE$.apply((Object)file.path()));
                            }
                            Option opt = option;
                            Tuple2 tuple22 = (Tuple2)opt.getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Nothing$ apply() {
                                    throw new ParameterException("Could not determine converter from inputs - please specify a converter");
                                }
                            });
                            if (tuple22 == null) throw new MatchError((Object)tuple22);
                            SimpleFeatureType inferredSft = (SimpleFeatureType)tuple22._1();
                            Config inferredConverter = (Config)tuple22._2();
                            Tuple2 tuple23 = tuple2 = new Tuple2((Object)inferredSft, (Object)inferredConverter);
                            SimpleFeatureType inferredSft2 = (SimpleFeatureType)tuple23._1();
                            Config inferredConverter2 = (Config)tuple23._2();
                            ConfigRenderOptions renderOptions = ConfigRenderOptions.concise().setFormatted(true);
                            ObjectRef inferredSftString = ObjectRef.create((Object)None$.MODULE$);
                            if ((SimpleFeatureType)sft.elem == null) {
                                String typeName = (String)Option$.MODULE$.apply((Object)this.params$1.featureName()).getOrElse((Function0)new Serializable(this, file){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.getSftAndConverter.1 $outer;
                                    private final FileSystemDelegate.FileHandle file$1;

                                    public final String apply() {
                                        String base;
                                        Set existing = (Set)Option$.MODULE$.option2Iterable(this.$outer.command$1).toSet().flatMap((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final ArrayOps<String> apply(package.DataStoreCommand<? extends DataStore> x$8) {
                                                return Predef$.MODULE$.refArrayOps((Object[])x$8.withDataStore(new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String[] apply(DataStore x$9) {
                                                        return x$9.getTypeNames();
                                                    }
                                                }));
                                            }
                                        }, Set$.MODULE$.canBuildFrom());
                                        Option fileName = Option$.MODULE$.apply((Object)FilenameUtils.getBaseName((String)this.file$1.path()));
                                        String name2 = base = (String)fileName.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(String x$10) {
                                                return x$10.trim().replaceAll("[^A-Za-z0-9]+", "_");
                                            }
                                        }).filterNot((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final boolean apply(String x$11) {
                                                return x$11.isEmpty();
                                            }
                                        }).getOrElse((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply() {
                                                return "geomesa";
                                            }
                                        });
                                        int i = 0;
                                        while (existing.contains((Object)name2)) {
                                            name2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{base, BoxesRunTime.boxToInteger((int)i)}));
                                            ++i;
                                        }
                                        return name2;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.file$1 = file$1;
                                    }
                                });
                                sft.elem = SimpleFeatureTypes$.MODULE$.renameSft(inferredSft2, typeName);
                                SimpleFeatureType x$19 = (SimpleFeatureType)sft.elem;
                                boolean x$20 = false;
                                boolean x$21 = SimpleFeatureTypes$.MODULE$.toConfig$default$2();
                                inferredSftString.elem = new Some((Object)SimpleFeatureTypes$.MODULE$.toConfig(x$19, x$21, x$20).root().render(renderOptions));
                                if (!((OptionalForceParam)((Object)this.params$1)).force()) {
                                    package$Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inferred schema: ", " identified ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeName, SimpleFeatureTypes$.MODULE$.encodeType((SimpleFeatureType)sft.elem)})));
                                }
                            }
                            converter = inferredConverter2;
                            if (!((OptionalForceParam)((Object)this.params$1)).force()) {
                                String converterString = inferredConverter2.root().render(renderOptions);
                                package$Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inferred converter:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{converterString})));
                                String x$25 = "Use inferred converter (y/n)? ";
                                List<String> x$26 = Prompt$.MODULE$.confirm$default$2();
                                Object x$27 = Prompt$.MODULE$.confirm$default$3(x$25, x$26);
                                if (Prompt$.MODULE$.confirm(x$25, x$26, x$27)) {
                                    this.persist$1(sft, inferredSftString, converterString);
                                } else {
                                    package$Command$.MODULE$.user().info("Please re-run with a valid converter");
                                    this.persist$1(sft, inferredSftString, converterString);
                                    throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Success((Object)None$.MODULE$));
                                }
                            }
                        }
                        if ((SimpleFeatureType)sft.elem == null) {
                            throw new ParameterException("SimpleFeatureType name and/or specification argument is required");
                        }
                        if (converter == null) {
                            throw new ParameterException("Converter config argument is required");
                        }
                        if (((ConverterConfigParam)((Object)this.params$1)).errorMode() == null) return new Some((Object)new Tuple2((Object)((SimpleFeatureType)sft.elem), (Object)converter));
                        ConfigObject opts = ConfigValueFactory.fromMap(Collections.singletonMap("error-mode", ((ConverterConfigParam)((Object)this.params$1)).errorMode().toString()));
                        converter = ConfigFactory.empty().withValue("options", (ConfigValue)opts).withFallback((ConfigMergeable)converter);
                        return new Some((Object)new Tuple2((Object)((SimpleFeatureType)sft.elem), (Object)converter));
                        finally {
                            package.CloseWithLogging$.MODULE$.apply((Object)opened, (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable());
                        }
                    }

                    public final InputStream org$locationtech$geomesa$tools$ingest$IngestCommand$$anonfun$$open$1(FileSystemDelegate.FileHandle file$1, ListBuffer opened$1) {
                        CloseableIterator streams = file$1.open().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final InputStream apply(Tuple2<Option<String>, InputStream> x$6) {
                                return (InputStream)x$6._2();
                            }
                        });
                        opened$1.$plus$eq((Object)streams);
                        if (streams.hasNext()) {
                            return (InputStream)streams.next();
                        }
                        throw new ParameterException("Parameter <files> did not evaluate to anything that could be read");
                    }

                    private final void persist$1(ObjectRef sft$2, ObjectRef inferredSftString$1, String converterString$1) {
                        Object x$24;
                        String x$22 = "Persist this converter for future use (y/n)? ";
                        List<String> x$23 = Prompt$.MODULE$.confirm$default$2();
                        if (Prompt$.MODULE$.confirm(x$22, x$23, x$24 = Prompt$.MODULE$.confirm$default$3(x$22, x$23))) {
                            IngestCommand$.MODULE$.org$locationtech$geomesa$tools$ingest$IngestCommand$$writeInferredConverter(((SimpleFeatureType)sft$2.elem).getTypeName(), converterString$1, (Option<String>)((Option)inferredSftString$1.elem));
                        }
                    }
                    {
                        this.params$1 = params$1;
                        this.inputs$1 = inputs$1;
                        this.format$1 = format$1;
                        this.command$1 = command$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                try_ = (Try)nonLocalReturnControl2.value();
            }
            return try_;
        }
        throw nonLocalReturnControl2;
    }

    public String getStatInfo(long successes, long failures, String action, String input) {
        String failureString = failures == 0L ? "with no failures" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and failed to ingest ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getPlural(failures, "feature")}));
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, TextTools$.MODULE$.getPlural(successes, "feature"), failureString, TextTools$.MODULE$.prefixSpace(input)}));
    }

    public String getStatInfo$default$3() {
        return "Ingested";
    }

    public String getStatInfo$default$4() {
        return "";
    }

    public Option<SimpleFeatureType> org$locationtech$geomesa$tools$ingest$IngestCommand$$loadSft(TypeNameParam params, Option<package.DataStoreCommand<? extends DataStore>> command) {
        ObjectRef fromEnv$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        Option fromStore = command.flatMap((Function1)new Serializable(params){
            public static final long serialVersionUID = 0L;
            private final TypeNameParam params$2;

            public final Option<SimpleFeatureType> apply(package.DataStoreCommand<? extends DataStore> cmd) {
                return Option$.MODULE$.apply((Object)this.params$2.featureName()).flatMap((Function1)new Serializable(this, cmd){
                    public static final long serialVersionUID = 0L;
                    private final package.DataStoreCommand cmd$1;

                    public final Option<SimpleFeatureType> apply(String name2) {
                        return ((Option)this.cmd$1.withDataStore(new Serializable(this, name2){
                            public static final long serialVersionUID = 0L;
                            public final String name$1;

                            public final Option<SimpleFeatureType> apply(DataStore ds) {
                                return Try$.MODULE$.apply((Function0)new Serializable(this, ds){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$25$$anonfun$apply$4$$anonfun$apply$5 $outer;
                                    private final DataStore ds$2;

                                    public final SimpleFeatureType apply() {
                                        return this.ds$2.getSchema(this.$outer.name$1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.ds$2 = ds$2;
                                    }
                                }).filter((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(SimpleFeatureType x$12) {
                                        return x$12 != null;
                                    }
                                }).toOption();
                            }
                            {
                                this.name$1 = name$1;
                            }
                        })).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final SimpleFeatureType apply(SimpleFeatureType sft) {
                                return sft;
                            }
                        });
                    }
                    {
                        this.cmd$1 = cmd$1;
                    }
                });
            }
            {
                this.params$2 = params$2;
            }
        });
        if (this.logger().underlying().isWarnEnabled()) {
            fromStore.foreach((Function1)new Serializable(params, fromEnv$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final TypeNameParam params$2;
                private final ObjectRef fromEnv$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final void apply(SimpleFeatureType fs) {
                    IngestCommand$.MODULE$.org$locationtech$geomesa$tools$ingest$IngestCommand$$fromEnv$1(this.params$2, this.fromEnv$lzy$1, this.bitmap$0$1).foreach((Function1)new Serializable(this, fs){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType fs$1;

                        public final void apply(SimpleFeatureType fe) {
                            String string = this.fs$1.getTypeName();
                            String string2 = fe.getTypeName();
                            if ((string != null ? !string.equals(string2) : string2 != null) || SimpleFeatureTypes$.MODULE$.compare(this.fs$1, fe) != 0) {
                                BoxedUnit boxedUnit;
                                if (IngestCommand$.MODULE$.logger().underlying().isWarnEnabled()) {
                                    IngestCommand$.MODULE$.logger().underlying().warn(new StringBuilder().append((Object)"Schema from data store does not match schema from environment.").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  From data store:  ", " identified ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fs$1.getTypeName(), DataUtilities.encodeType((SimpleFeatureType)this.fs$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  From environment: ", " identified ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fe.getTypeName(), DataUtilities.encodeType((SimpleFeatureType)fe)}))).toString());
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                            }
                        }
                        {
                            this.fs$1 = fs$1;
                        }
                    });
                }
                {
                    this.params$2 = params$2;
                    this.fromEnv$lzy$1 = fromEnv$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
        }
        return fromStore.orElse((Function0)new Serializable(params, fromEnv$lzy, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final TypeNameParam params$2;
            private final ObjectRef fromEnv$lzy$1;
            private final VolatileByteRef bitmap$0$1;

            public final Option<SimpleFeatureType> apply() {
                return IngestCommand$.MODULE$.org$locationtech$geomesa$tools$ingest$IngestCommand$$fromEnv$1(this.params$2, this.fromEnv$lzy$1, this.bitmap$0$1);
            }
            {
                this.params$2 = params$2;
                this.fromEnv$lzy$1 = fromEnv$lzy$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        });
    }

    public void org$locationtech$geomesa$tools$ingest$IngestCommand$$writeInferredConverter(String typeName, String converterString, Option<String> schemaString) {
        block9: {
            try {
                Option conf;
                Option option = conf = ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(this.getClass().getClassLoader().getResources("reference.conf")).asScala()).find((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(URL u) {
                        return "file".equalsIgnoreCase(u.getProtocol()) && u.getPath().endsWith("/conf/reference.conf");
                    }
                });
                if (None$.MODULE$.equals(option)) {
                    package$Command$.MODULE$.user().error("Could not persist converter: could not find 'conf/reference.conf'");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block9;
                }
                if (option instanceof Some) {
                    Tuple2 tuple2;
                    Some some = (Some)option;
                    URL r = (URL)some.x();
                    File reference = new File(r.toURI());
                    File folder = reference.getParentFile();
                    String baseName = typeName.replaceAll("[^A-Za-z0-9_]+", "_");
                    ObjectRef convert2 = ObjectRef.create((Object)new File(folder, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseName}))));
                    int i = 1;
                    while (((File)convert2.elem).exists()) {
                        convert2.elem = new File(folder, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ".conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseName, BoxesRunTime.boxToInteger((int)i)})));
                        ++i;
                    }
                    package.WithClose$.MODULE$.apply((Object)new PrintWriter(new FileWriter((File)convert2.elem)), (Function1)new Serializable(converterString, schemaString, baseName){
                        public static final long serialVersionUID = 0L;
                        private final String converterString$2;
                        private final Option schemaString$1;
                        public final String baseName$1;

                        public final void apply(PrintWriter writer) {
                            writer.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", " : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ConverterConfigLoader$.MODULE$.path(), this.baseName$1, this.converterString$2})));
                            this.schemaString$1.foreach((Function1)new Serializable(this, writer){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$org$locationtech$geomesa$tools$ingest$IngestCommand$$writeInferredConverter$1 $outer;
                                private final PrintWriter writer$1;

                                public final void apply(String s) {
                                    this.writer$1.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", " : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ConfigSftParsing$.MODULE$.path(), this.$outer.baseName$1, s})));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.writer$1 = writer$1;
                                }
                            });
                        }
                        {
                            this.converterString$2 = converterString$2;
                            this.schemaString$1 = schemaString$1;
                            this.baseName$1 = baseName$1;
                        }
                    }, IsCloseable$.MODULE$.closeableIsCloseable());
                    package.WithClose$.MODULE$.apply((Object)new PrintWriter(new FileWriter(reference, true)), (Function1)new Serializable(convert2){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef convert$1;

                        public final void apply(PrintWriter writer) {
                            writer.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include \"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((File)this.convert$1.elem).getName()})));
                        }
                        {
                            this.convert$1 = convert$1;
                        }
                    }, IsCloseable$.MODULE$.closeableIsCloseable());
                    Tuple2 tuple22 = tuple2 = schemaString.isDefined() ? new Tuple2((Object)"schema and converter", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'--spec ", "' and '--converter ", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseName, baseName}))) : new Tuple2((Object)"converter", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'--converter ", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseName})));
                    if (tuple2 != null) {
                        Tuple2 tuple23;
                        String names = (String)tuple2._1();
                        String refs = (String)tuple2._2();
                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)names, (Object)refs);
                        String names2 = (String)tuple24._1();
                        String refs2 = (String)tuple24._2();
                        package$Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Added import in reference.conf and saved inferred ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{names2, ((File)convert2.elem).getAbsolutePath()})));
                        package$Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In future commands, the ", " may be invoked with ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{names2, refs2})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block9;
                    }
                    throw new MatchError((Object)tuple2);
                }
                throw new MatchError((Object)option);
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit;
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Error trying to persist inferred schema", e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                package$Command$.MODULE$.user().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error trying to persist inferred schema: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e})));
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            }
        }
    }

    private final Option fromEnv$lzycompute$1(TypeNameParam params$2, ObjectRef fromEnv$lzy$1, VolatileByteRef bitmap$0$1) {
        IngestCommand$ ingestCommand$ = this;
        synchronized (ingestCommand$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                fromEnv$lzy$1.elem = Option$.MODULE$.apply((Object)((FeatureSpecParam)((Object)params$2)).spec()).map((Function1)new Serializable(params$2){
                    public static final long serialVersionUID = 0L;
                    private final TypeNameParam params$2;

                    public final SimpleFeatureType apply(String x$13) {
                        return CLArgResolver$.MODULE$.getSft(x$13, this.params$2.featureName());
                    }
                    {
                        this.params$2 = params$2;
                    }
                }).orElse((Function0)new Serializable(params$2){
                    public static final long serialVersionUID = 0L;
                    private final TypeNameParam params$2;

                    public final Option<SimpleFeatureType> apply() {
                        return Option$.MODULE$.apply((Object)this.params$2.featureName()).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Option<SimpleFeatureType> apply(String name2) {
                                return Try$.MODULE$.apply((Function0)new Serializable(this, name2){
                                    public static final long serialVersionUID = 0L;
                                    private final String name$2;

                                    public final SimpleFeatureType apply() {
                                        return CLArgResolver$.MODULE$.getSft(this.name$2, CLArgResolver$.MODULE$.getSft$default$2());
                                    }
                                    {
                                        this.name$2 = name$2;
                                    }
                                }).toOption();
                            }
                        });
                    }
                    {
                        this.params$2 = params$2;
                    }
                });
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (Option)fromEnv$lzy$1.elem;
        }
    }

    public final Option org$locationtech$geomesa$tools$ingest$IngestCommand$$fromEnv$1(TypeNameParam params$2, ObjectRef fromEnv$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.fromEnv$lzycompute$1(params$2, fromEnv$lzy$1, bitmap$0$1) : (Option)fromEnv$lzy$1.elem;
    }

    private IngestCommand$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.LocalBatchSize = new GeoMesaSystemProperties.SystemProperty("geomesa.ingest.local.batch.size", "20000");
    }
}

