/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.utils;

import com.beust.jcommander.IValueValidator;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.BaseConverter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.convert.Modes;
import org.locationtech.geomesa.tools.export.formats.ExportFormat;
import org.locationtech.geomesa.tools.export.formats.ExportFormat$;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.geomesa.utils.text.DurationParsing$;
import org.locationtech.geomesa.utils.text.Suffixes;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00055w!B\u0001\u0003\u0011\u0003i\u0011a\u0005)be\u0006lW\r^3s\u0007>tg/\u001a:uKJ\u001c(BA\u0002\u0005\u0003\u0015)H/\u001b7t\u0015\t)a!A\u0003u_>d7O\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u0001\u0001C\u0001\b\u0010\u001b\u0005\u0011a!\u0002\t\u0003\u0011\u0003\t\"a\u0005)be\u0006lW\r^3s\u0007>tg/\u001a:uKJ\u001c8CA\b\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\")\u0011d\u0004C\u00015\u00051A(\u001b8jiz\"\u0012!\u0004\u0004\u00059=\u0001QDA\u0007IS:$8i\u001c8wKJ$XM]\n\u00037y\u00012a\b\u0015+\u001b\u0005\u0001#BA\u0011#\u0003)\u0019wN\u001c<feR,'o\u001d\u0006\u0003G\u0011\n!B[2p[6\fg\u000eZ3s\u0015\t)c%A\u0003cKV\u001cHOC\u0001(\u0003\r\u0019w.\\\u0005\u0003S\u0001\u0012QBQ1tK\u000e{gN^3si\u0016\u0014\b\u0003B\u00161eIj\u0011\u0001\f\u0006\u0003[9\nA!\u001e;jY*\tq&\u0001\u0003kCZ\f\u0017BA\u0019-\u0005\ri\u0015\r\u001d\t\u0003gYr!a\u0005\u001b\n\u0005U\"\u0012A\u0002)sK\u0012,g-\u0003\u00028q\t11\u000b\u001e:j]\u001eT!!\u000e\u000b\t\u0011iZ\"\u0011!Q\u0001\nI\nAA\\1nK\")\u0011d\u0007C\u0001yQ\u0011Qh\u0010\t\u0003}mi\u0011a\u0004\u0005\u0006um\u0002\rA\r\u0005\u0006\u0003n!\tEQ\u0001\bG>tg/\u001a:u)\tQ3\tC\u0003E\u0001\u0002\u0007!'A\u0003wC2,XM\u0002\u0003G\u001f\u00019%!\u0005#ve\u0006$\u0018n\u001c8D_:4XM\u001d;feN\u0011Q\t\u0013\t\u0004?!J\u0005C\u0001&P\u001b\u0005Y%B\u0001'N\u0003!!WO]1uS>t'B\u0001(\u0015\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003!.\u0013\u0001\u0002R;sCRLwN\u001c\u0005\tu\u0015\u0013\t\u0011)A\u0005e!)\u0011$\u0012C\u0001'R\u0011A+\u0016\t\u0003}\u0015CQA\u000f*A\u0002IBQ!Q#\u0005B]#\"!\u0013-\t\u000b\u00113\u0006\u0019\u0001\u001a\u0007\ti{\u0001a\u0017\u0002\u0010\r&dG/\u001a:D_:4XM\u001d;feN\u0011\u0011\f\u0018\t\u0004?!j\u0006C\u00010d\u001b\u0005y&B\u00011b\u0003\u00191\u0017\u000e\u001c;fe*\u0011!MC\u0001\b_B,gnZ5t\u0013\t!wL\u0001\u0004GS2$XM\u001d\u0005\tue\u0013\t\u0011)A\u0005e!)\u0011$\u0017C\u0001OR\u0011\u0001.\u001b\t\u0003}eCQA\u000f4A\u0002IBQ!Q-\u0005B-$\"!\u00187\t\u000b\u0011S\u0007\u0019\u0001\u001a\u0007\t9|\u0001a\u001c\u0002\u0016\u000bb\u0004xN\u001d;G_Jl\u0017\r^\"p]Z,'\u000f^3s'\ti\u0007\u000fE\u0002 QE\u0004\"A]<\u000e\u0003MT!\u0001^;\u0002\u000f\u0019|'/\\1ug*\u0011a\u000fB\u0001\u0007Kb\u0004xN\u001d;\n\u0005a\u001c(\u0001D#ya>\u0014HOR8s[\u0006$\b\u0002\u0003\u001en\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u000beiG\u0011A>\u0015\u0005ql\bC\u0001 n\u0011\u0015Q$\u00101\u00013\u0011\u0015\tU\u000e\"\u0011\u0000)\r\t\u0018\u0011\u0001\u0005\u0006\tz\u0004\rA\r\u0004\u0007\u0003\u000by\u0001!a\u0002\u0003#-+\u0017PV1mk\u0016\u001cuN\u001c<feR,'o\u0005\u0003\u0002\u0004\u0005%\u0001\u0003B\u0010)\u0003\u0017\u0001RaEA\u0007eIJ1!a\u0004\u0015\u0005\u0019!V\u000f\u001d7fe!I!(a\u0001\u0003\u0002\u0003\u0006IA\r\u0005\b3\u0005\rA\u0011AA\u000b)\u0011\t9\"!\u0007\u0011\u0007y\n\u0019\u0001\u0003\u0004;\u0003'\u0001\rA\r\u0005\b\u0003\u0006\rA\u0011IA\u000f)\u0011\tY!a\b\t\r\u0011\u000bY\u00021\u00013\r\u0019\t\u0019c\u0004\u0001\u0002&\t\t\u0012J\u001c;feZ\fGnQ8om\u0016\u0014H/\u001a:\u0014\t\u0005\u0005\u0012q\u0005\t\u0005?!\nI\u0003E\u0004\u0014\u0003\u001b\tY#a\u000b\u0011\u0007-\ni#C\u0002\u000201\u0012A\u0001R1uK\"I!(!\t\u0003\u0002\u0003\u0006IA\r\u0005\b3\u0005\u0005B\u0011AA\u001b)\u0011\t9$!\u000f\u0011\u0007y\n\t\u0003\u0003\u0004;\u0003g\u0001\rA\r\u0005\b\u0003\u0006\u0005B\u0011IA\u001f)\u0011\tI#a\u0010\t\r\u0011\u000bY\u00041\u00013\r\u0019\t\u0019e\u0004\u0001\u0002F\t\u0011RI\u001d:pe6{G-Z\"p]Z,'\u000f^3s'\u0011\t\t%a\u0012\u0011\t}A\u0013\u0011\n\t\u0005\u0003\u0017\nIG\u0004\u0003\u0002N\u0005\rd\u0002BA(\u0003CrA!!\u0015\u0002`9!\u00111KA/\u001d\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00053\u0011\u0002BA3\u0003O\nQ!T8eKNT!!\u0011\u0004\n\t\u0005-\u0014Q\u000e\u0002\n\u000bJ\u0014xN]'pI\u0016TA!!\u001a\u0002h!I!(!\u0011\u0003\u0002\u0003\u0006IA\r\u0005\b3\u0005\u0005C\u0011AA:)\u0011\t)(a\u001e\u0011\u0007y\n\t\u0005\u0003\u0004;\u0003c\u0002\rA\r\u0005\b\u0003\u0006\u0005C\u0011IA>)\u0011\tI%! \t\r\u0011\u000bI\b1\u00013\r\u0019\t\ti\u0004\u0001\u0002\u0004\nq!)\u001f;fg\u000e{gN^3si\u0016\u00148\u0003BA@\u0003\u000b\u0003Ba\b\u0015\u0002\bB!\u0011\u0011RAH\u001b\t\tYIC\u0002\u0002\u000e:\nA\u0001\\1oO&!\u0011\u0011SAF\u0005\u0011auN\\4\t\u0013i\nyH!A!\u0002\u0013\u0011\u0004bB\r\u0002\u0000\u0011\u0005\u0011q\u0013\u000b\u0005\u00033\u000bY\nE\u0002?\u0003\u007fBaAOAK\u0001\u0004\u0011\u0004bB!\u0002\u0000\u0011\u0005\u0013q\u0014\u000b\u0005\u0003\u000f\u000b\t\u000b\u0003\u0004E\u0003;\u0003\rA\r\u0004\u0007\u0003K{\u0001!a*\u0003\u001d\tKH/Z:WC2LG-\u0019;peN1\u00111UAU\u0003_\u0003B!!#\u0002,&!\u0011QVAF\u0005\u0019y%M[3diB)\u0011\u0011WAZe5\t!%C\u0002\u00026\n\u0012q\"\u0013,bYV,g+\u00197jI\u0006$xN\u001d\u0005\b3\u0005\rF\u0011AA])\t\tY\fE\u0002?\u0003GC\u0001\"a0\u0002$\u0012\u0005\u0013\u0011Y\u0001\tm\u0006d\u0017\u000eZ1uKR1\u00111YAe\u0003\u0017\u00042aEAc\u0013\r\t9\r\u0006\u0002\u0005+:LG\u000f\u0003\u0004;\u0003{\u0003\rA\r\u0005\u0007\t\u0006u\u0006\u0019\u0001\u001a")
public final class ParameterConverters {

    public static class HintConverter
    extends BaseConverter<Map<String, String>> {
        public Map<String, String> convert(String value) {
            try {
                HashMap<String, String> map2 = new HashMap<String, String>();
                Predef$.MODULE$.refArrayOps((Object[])value.split(";")).foreach((Function1)new Serializable(this, map2){
                    public static final long serialVersionUID = 0L;
                    private final HashMap map$1;

                    public final String apply(String part) {
                        String[] stringArray = part.split("=");
                        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                            Tuple2 tuple2;
                            String k = (String)((SeqLike)option.get()).apply(0);
                            String v = (String)((SeqLike)option.get()).apply(1);
                            Tuple2 tuple22 = tuple2 = new Tuple2((Object)k, (Object)v);
                            String k2 = (String)tuple22._1();
                            String v2 = (String)tuple22._2();
                            return this.map$1.put(k2.trim(), v2.trim());
                        }
                        throw new MatchError((Object)stringArray);
                    }
                    {
                        this.map$1 = map$1;
                    }
                });
                return map2;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                throw new ParameterException(this.getErrorString(value, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hint map: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e}))));
            }
        }

        public HintConverter(String name2) {
            super(name2);
        }
    }

    public static class BytesConverter
    extends BaseConverter<Long> {
        public Long convert(String value) {
            Try try_ = Suffixes.Memory$.MODULE$.bytes(value);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                long b = BoxesRunTime.unboxToLong((Object)success.value());
                Long l = Predef$.MODULE$.long2Long(b);
                return l;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid byte string '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})), e);
            }
            throw new MatchError((Object)try_);
        }

        public BytesConverter(String name2) {
            super(name2);
        }
    }

    public static class BytesValidator
    implements IValueValidator<String> {
        public void validate(String name2, String value) {
            Suffixes.Memory$.MODULE$.bytes(value).failed().foreach((Function1)new Serializable(this, value){
                public static final long serialVersionUID = 0L;
                private final String value$3;

                public final Nothing$ apply(Throwable e) {
                    throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid byte string '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$3})), e);
                }
                {
                    this.value$3 = value$3;
                }
            });
        }
    }

    public static class FilterConverter
    extends BaseConverter<Filter> {
        public Filter convert(String value) {
            try {
                return ECQL.toFilter((String)value);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                throw new ParameterException(this.getErrorString(value, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"filter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e}))));
            }
        }

        public FilterConverter(String name2) {
            super(name2);
        }
    }

    public static class DurationConverter
    extends BaseConverter<Duration> {
        public Duration convert(String value) {
            try {
                return DurationParsing$.MODULE$.caseInsensitive(value);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                throw new ParameterException(this.getErrorString(value, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"duration: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e}))));
            }
        }

        public DurationConverter(String name2) {
            super(name2);
        }
    }

    public static class KeyValueConverter
    extends BaseConverter<Tuple2<String, String>> {
        public Tuple2<String, String> convert(String value) {
            try {
                int i = value.indexOf(61);
                if (i == -1 || value.indexOf(61, i + 1) != -1) {
                    throw new IllegalArgumentException("key-value pairs must be separated by a single '='");
                }
                return new Tuple2((Object)value.substring(0, i), (Object)value.substring(i + 1));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                throw new ParameterException(this.getErrorString(value, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"format: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e}))));
            }
        }

        public KeyValueConverter(String name2) {
            super(name2);
        }
    }

    public static class IntervalConverter
    extends BaseConverter<Tuple2<Date, Date>> {
        public Tuple2<Date, Date> convert(String value) {
            try {
                int i = value.indexOf(47);
                if (i == -1 || value.indexOf(47, i + 1) != -1) {
                    throw new IllegalArgumentException("Interval from/to must be separated by a single '/'");
                }
                Date start2 = (Date)FastConverter$.MODULE$.convert((Object)value.substring(0, i), Date.class);
                Date end = (Date)FastConverter$.MODULE$.convert((Object)value.substring(i + 1), Date.class);
                if (start2 == null || end == null) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not convert ", " to date interval"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})));
                }
                return new Tuple2((Object)start2, (Object)end);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                throw new ParameterException(this.getErrorString(value, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"format: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e}))));
            }
        }

        public IntervalConverter(String name2) {
            super(name2);
        }
    }

    public static class ErrorModeConverter
    extends BaseConverter<Enumeration.Value> {
        public Enumeration.Value convert(String value) {
            return (Enumeration.Value)Modes.ErrorMode$.MODULE$.values().find((Function1)new Serializable(this, value){
                public static final long serialVersionUID = 0L;
                private final String value$2;

                public final boolean apply(Enumeration.Value x$3) {
                    return x$3.toString().equalsIgnoreCase(this.value$2);
                }
                {
                    this.value$2 = value$2;
                }
            }).getOrElse((Function0)new Serializable(this, value){
                public static final long serialVersionUID = 0L;
                private final String value$2;

                public final Nothing$ apply() {
                    throw new ParameterException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid error mode '", "'. Valid values are "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$2}))).append((Object)((TraversableOnce)Modes.ErrorMode$.MODULE$.values().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Enumeration.Value x$4) {
                            return x$4.toString();
                        }
                    }, SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$))).mkString("'", "', '", "'")).toString());
                }
                {
                    this.value$2 = value$2;
                }
            });
        }

        public ErrorModeConverter(String name2) {
            super(name2);
        }
    }

    public static class ExportFormatConverter
    extends BaseConverter<ExportFormat> {
        public ExportFormat convert(String value) {
            try {
                return (ExportFormat)ExportFormat$.MODULE$.apply(value).getOrElse((Function0)new Serializable(this, value){
                    public static final long serialVersionUID = 0L;
                    private final String value$1;

                    public final Nothing$ apply() {
                        throw new ParameterException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid format '", "'. Valid values are "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.value$1}))).append((Object)((TraversableOnce)((SeqLike)ExportFormat$.MODULE$.Formats().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final IndexedSeq<Object> apply(ExportFormat f) {
                                Seq<String> seq = f.extensions();
                                return (IndexedSeq)new StringOps(Predef$.MODULE$.augmentString(f.name())).$plus$colon(seq, Predef$.MODULE$.fallbackStringCanBuildFrom());
                            }
                        }, Seq$.MODULE$.canBuildFrom())).distinct()).mkString("'", "', '", "'")).toString());
                    }
                    {
                        this.value$1 = value$1;
                    }
                });
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                throw new ParameterException(this.getErrorString(value, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"format: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e}))));
            }
        }

        public ExportFormatConverter(String name2) {
            super(name2);
        }
    }
}

