/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import com.typesafe.scalalogging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.orc.OrcFileSystemWriter;
import org.locationtech.geomesa.fs.storage.orc.OrcFileSystemWriter$;
import org.locationtech.geomesa.parquet.ParquetFileSystemStorage;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.export.formats.FileSystemExporter$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005}d!B\u0001\u0003\u0003\u0003y!A\u0005$jY\u0016\u001c\u0016p\u001d;f[\u0016C\bo\u001c:uKJT!a\u0001\u0003\u0002\u000f\u0019|'/\\1ug*\u0011QAB\u0001\u0007Kb\u0004xN\u001d;\u000b\u0005\u001dA\u0011!\u0002;p_2\u001c(BA\u0005\u000b\u0003\u001d9Wm\\7fg\u0006T!a\u0003\u0007\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0010\r\u0016\fG/\u001e:f\u000bb\u0004xN\u001d;fe\"A1\u0004\u0001B\u0001B\u0003%A$\u0001\u0003qCRD\u0007CA\u000f!\u001d\t\tb$\u0003\u0002 %\u00051\u0001K]3eK\u001aL!!\t\u0012\u0003\rM#(/\u001b8h\u0015\ty\"\u0003C\u0003%\u0001\u0011\u0005Q%\u0001\u0004=S:LGO\u0010\u000b\u0003M\u001d\u0002\"a\u0006\u0001\t\u000bm\u0019\u0003\u0019\u0001\u000f\t\u0011%\u0002\u0001R1A\u0005\n)\na\u0001[1oI2,W#A\u0016\u0011\u00051\"eBA\u0017B\u001d\tqcH\u0004\u00020w9\u0011\u0001'\u000f\b\u0003car!AM\u001c\u000f\u0005M2T\"\u0001\u001b\u000b\u0005Ur\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011!\bC\u0001\u0006kRLGn]\u0005\u0003yu\n!![8\u000b\u0005iB\u0011BA A\u0003\t17O\u0003\u0002={%\u0011!iQ\u0001\u0013\r&dWmU=ti\u0016lG)\u001a7fO\u0006$XM\u0003\u0002@\u0001&\u0011QI\u0012\u0002\u000b\r&dW\rS1oI2,'B\u0001\"D\u0011!A\u0005\u0001#A!B\u0013Y\u0013a\u00025b]\u0012dW\r\t\u0005\n\u0015\u0002\u0001\r\u00111A\u0005\n-\u000baa\u001e:ji\u0016\u0014X#\u0001'\u0011\u00055[fB\u0001(Y\u001d\tyUK\u0004\u0002Q%:\u0011\u0001'U\u0005\u0003\u007f!I!a\u0015+\u0002\u000fM$xN]1hK*\u0011q\bC\u0005\u0003-^\u000b1!\u00199j\u0015\t\u0019F+\u0003\u0002Z5\u0006\tb)\u001b7f'f\u001cH/Z7Ti>\u0014\u0018mZ3\u000b\u0005Y;\u0016B\u0001/^\u0005A1\u0015\u000e\\3TsN$X-\\,sSR,'O\u0003\u0002Z5\"Iq\f\u0001a\u0001\u0002\u0004%I\u0001Y\u0001\u000boJLG/\u001a:`I\u0015\fHCA1e!\t\t\"-\u0003\u0002d%\t!QK\\5u\u0011\u001d)g,!AA\u00021\u000b1\u0001\u001f\u00132\u0011\u00199\u0007\u0001)Q\u0005\u0019\u00069qO]5uKJ\u0004\u0003\"B5\u0001\r#Q\u0017\u0001D2sK\u0006$Xm\u0016:ji\u0016\u0014HC\u0001'l\u0011\u0015a\u0007\u000e1\u0001n\u0003\r\u0019h\r\u001e\t\u0003]Vl\u0011a\u001c\u0006\u0003aF\faa]5na2,'B\u0001:t\u0003\u001d1W-\u0019;ve\u0016T!\u0001\u001e\u0007\u0002\u000f=\u0004XM\\4jg&\u0011ao\u001c\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007\"\u0002=\u0001\t\u0003J\u0018!B:uCJ$HCA1{\u0011\u0015aw\u000f1\u0001n\u0011\u0015)\u0001\u0001\"\u0011})\ri\u0018q\u0001\t\u0005#y\f\t!\u0003\u0002\u0000%\t1q\n\u001d;j_:\u00042!EA\u0002\u0013\r\t)A\u0005\u0002\u0005\u0019>tw\rC\u0004\u0002\nm\u0004\r!a\u0003\u0002\u0011\u0019,\u0017\r^;sKN\u0004b!!\u0004\u0002\u0018\u0005ua\u0002BA\b\u0003'q1aMA\t\u0013\u0005\u0019\u0012bAA\u000b%\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\r\u00037\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003+\u0011\u0002c\u00018\u0002 %\u0019\u0011\u0011E8\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0011\u001d\t)\u0003\u0001C!\u0003O\tQAY=uKN,\"!!\u0001\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.\u0005)1\r\\8tKR\t\u0011mB\u0004\u00022\tA\t!a\r\u0002%\u0019KG.Z*zgR,W.\u0012=q_J$XM\u001d\t\u0004/\u0005UbAB\u0001\u0003\u0011\u0003\t9dE\u0003\u00026A\tI\u0004\u0005\u0003\u0002<\u0005%SBAA\u001f\u0015\u0011\ty$!\u0011\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\u0005\r\u0013QI\u0001\tif\u0004Xm]1gK*\u0011\u0011qI\u0001\u0004G>l\u0017\u0002BA&\u0003{\u00111\u0002T1{s2{wmZ5oO\"9A%!\u000e\u0005\u0002\u0005=CCAA\u001a\r\u001d\t\u0019&!\u000e\u0001\u0003+\u0012\u0011\u0004U1scV,GOR5mKNK8\u000f^3n\u000bb\u0004xN\u001d;feN\u0019\u0011\u0011\u000b\u0014\t\u0013m\t\tF!A!\u0002\u0013a\u0002b\u0002\u0013\u0002R\u0011\u0005\u00111\f\u000b\u0005\u0003;\n\t\u0007\u0005\u0003\u0002`\u0005ESBAA\u001b\u0011\u0019Y\u0012\u0011\fa\u00019!9\u0011.!\u0015\u0005R\u0005\u0015Dc\u0001'\u0002h!1A.a\u0019A\u000254q!a\u001b\u00026\u0001\tiGA\u000bPe\u000e4\u0015\u000e\\3TsN$X-\\#ya>\u0014H/\u001a:\u0014\u0007\u0005%d\u0005C\u0005\u001c\u0003S\u0012\t\u0011)A\u00059!9A%!\u001b\u0005\u0002\u0005MD\u0003BA;\u0003o\u0002B!a\u0018\u0002j!11$!\u001dA\u0002qAq![A5\t#\nY\bF\u0002M\u0003{Ba\u0001\\A=\u0001\u0004i\u0007")
public abstract class FileSystemExporter
implements FeatureExporter {
    private final String path;
    private FileSystemDelegate.FileHandle handle;
    private FileSystemStorage.FileSystemWriter org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer;
    private volatile boolean bitmap$0;

    public static Logger logger() {
        return FileSystemExporter$.MODULE$.logger();
    }

    private FileSystemDelegate.FileHandle handle$lzycompute() {
        FileSystemExporter fileSystemExporter = this;
        synchronized (fileSystemExporter) {
            if (!this.bitmap$0) {
                this.handle = PathUtils$.MODULE$.getHandle(this.path);
                this.bitmap$0 = true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
            this.path = null;
            return this.handle;
        }
    }

    private FileSystemDelegate.FileHandle handle() {
        return this.bitmap$0 ? this.handle : this.handle$lzycompute();
    }

    public FileSystemStorage.FileSystemWriter org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer() {
        return this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer;
    }

    private void org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer_$eq(FileSystemStorage.FileSystemWriter x$1) {
        this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer = x$1;
    }

    public abstract FileSystemStorage.FileSystemWriter createWriter(SimpleFeatureType var1);

    @Override
    public void start(SimpleFeatureType sft) {
        if (this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer() != null) {
            this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer().close();
        }
        this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer_$eq(this.createWriter(sft));
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        Predef$.MODULE$.require(this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Must call 'start' before 'export'";
            }
        });
        LongRef i = LongRef.create((long)0L);
        features.foreach((Function1)new Serializable(this, i){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystemExporter $outer;
            private final LongRef i$1;

            public final void apply(SimpleFeature f) {
                this.$outer.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer().write(f);
                ++this.i$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.i$1 = i$1;
            }
        });
        return new Some((Object)BoxesRunTime.boxToLong((long)i.elem));
    }

    @Override
    public long bytes() {
        return this.handle().length();
    }

    @Override
    public void close() {
        if (this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer() != null) {
            this.org$locationtech$geomesa$tools$export$formats$FileSystemExporter$$writer().close();
        }
    }

    public FileSystemExporter(String path) {
        this.path = path;
    }

    public static class OrcFileSystemExporter
    extends FileSystemExporter {
        private final String path;

        @Override
        public FileSystemStorage.FileSystemWriter createWriter(SimpleFeatureType sft) {
            return new OrcFileSystemWriter(sft, new Configuration(), new Path(PathUtils$.MODULE$.getUrl(this.path).toURI()), OrcFileSystemWriter$.MODULE$.$lessinit$greater$default$4());
        }

        public OrcFileSystemExporter(String path) {
            this.path = path;
            super(path);
        }
    }

    public static class ParquetFileSystemExporter
    extends FileSystemExporter {
        private final String path;

        @Override
        public FileSystemStorage.FileSystemWriter createWriter(SimpleFeatureType sft) {
            BoxedUnit boxedUnit;
            Configuration conf = new Configuration();
            StorageConfiguration$.MODULE$.setSft(conf, sft);
            try {
                boxedUnit = Class.forName("org.xerial.snappy.Snappy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                BoxedUnit boxedUnit2;
                if (FileSystemExporter$.MODULE$.logger().underlying().isWarnEnabled()) {
                    FileSystemExporter$.MODULE$.logger().underlying().warn("SNAPPY compression is not available on the classpath - falling back to GZIP");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                conf.set("parquet.compression", "GZIP");
                boxedUnit = BoxedUnit.UNIT;
            }
            return new ParquetFileSystemStorage.ParquetFileSystemWriter(sft, new Path(PathUtils$.MODULE$.getUrl(this.path).toURI()), conf, ParquetFileSystemStorage.ParquetFileSystemWriter$.MODULE$.$lessinit$greater$default$4());
        }

        public ParquetFileSystemExporter(String path) {
            this.path = path;
            super(path);
        }
    }
}

