/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.data;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.partition.TablePartition;
import org.locationtech.geomesa.index.conf.partition.TimePartition;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.tools.data.ManagePartitionsCommand;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.date.DateUtils$;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public abstract class ManagePartitionsCommand$AdoptPartitionCommand$class {
    public static void execute(ManagePartitionsCommand.AdoptPartitionCommand $this, GeoMesaDataStore ds, SimpleFeatureType sft, TablePartition partition) {
        TimePartition time = (TimePartition)Option$.MODULE$.apply((Object)partition).collect((PartialFunction)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends TablePartition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TimePartition) {
                    TimePartition timePartition = (TimePartition)A1;
                    object = timePartition;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(TablePartition x1) {
                TablePartition tablePartition = x1;
                boolean bl = tablePartition instanceof TimePartition;
                return bl;
            }
        }).getOrElse((Function0)new Serializable($this, partition){
            public static final long serialVersionUID = 0L;
            private final TablePartition partition$3;

            public final Nothing$ apply() {
                throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported partition implementation: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partition$3.getClass().getName()})));
            }
            {
                this.partition$3 = partition$3;
            }
        });
        Tuple2<Date, Date> tuple2 = new ParameterConverters.IntervalConverter("value").convert($this.params().value());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Date s = (Date)tuple2._1();
            Date e = (Date)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)s, (Object)e);
            Date s2 = (Date)tuple23._1();
            Date e2 = (Date)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)ZonedDateTime.ofInstant(DateUtils$.MODULE$.toInstant(s2), ZoneOffset.UTC), (Object)ZonedDateTime.ofInstant(DateUtils$.MODULE$.toInstant(e2), ZoneOffset.UTC));
            if (tuple24 != null) {
                Tuple2 tuple25;
                ZonedDateTime start2 = (ZonedDateTime)tuple24._1();
                ZonedDateTime end = (ZonedDateTime)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)start2, (Object)end);
                ZonedDateTime start3 = (ZonedDateTime)tuple26._1();
                ZonedDateTime end2 = (ZonedDateTime)tuple26._2();
                Buffer tables = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter($this.params().tables()).asScala();
                package$Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adopting tables ", " as partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tables.mkString(", "), $this.params().partition()})));
                Seq indices = ds.manager().indices(sft, ds.manager().indices$default$2());
                if (indices.lengthCompare(tables.length()) != 0) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected an index table for each index: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)indices.map((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(GeoMesaFeatureIndex<?, ?> x$4) {
                            return x$4.name();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
                }
                Seq indexNames = (Seq)indices.map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple4<GeoMesaFeatureIndex<Object, Object>, String, String, String> apply(GeoMesaFeatureIndex<?, ?> index) {
                        String name2 = StringSerialization$.MODULE$.alphaNumericSafeString(index.name());
                        String attributes = ((TraversableOnce)index.attributes().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String input) {
                                return StringSerialization$.MODULE$.alphaNumericSafeString(input);
                            }
                        }, Seq$.MODULE$.canBuildFrom())).mkString("_");
                        String version = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index.version())}));
                        return new Tuple4(index, (Object)name2, (Object)attributes, (Object)version);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Map tableToIndexName = (Map)((LinearSeqOptimized)indexNames.toList().sortWith((Function2)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple4<GeoMesaFeatureIndex<Object, Object>, String, String, String> x$5, Tuple4<GeoMesaFeatureIndex<Object, Object>, String, String, String> x$6) {
                        return ((String)x$5._3()).length() > ((String)x$6._3()).length();
                    }
                })).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2)new Serializable($this, tables){
                    public static final long serialVersionUID = 0L;
                    private final Buffer tables$1;

                    public final Map<String, Tuple4<GeoMesaFeatureIndex<?, ?>, String, String, String>> apply(Map<String, Tuple4<GeoMesaFeatureIndex<?, ?>, String, String, String>> mappedTables, Tuple4<GeoMesaFeatureIndex<Object, Object>, String, String, String> indexName) {
                        Buffer fullMatches = (Buffer)this.tables$1.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final Map mappedTables$1;
                            private final Tuple4 indexName$1;

                            public final boolean apply(String table) {
                                return !this.mappedTables$1.contains((Object)table) && table.contains((CharSequence)this.indexName$1._2()) && table.contains((CharSequence)this.indexName$1._3()) && table.contains((CharSequence)this.indexName$1._4());
                            }
                            {
                                this.mappedTables$1 = mappedTables$1;
                                this.indexName$1 = indexName$1;
                            }
                        });
                        if (fullMatches.lengthCompare(1) >= 0) {
                            return mappedTables.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(fullMatches.head()), indexName));
                        }
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not match a table to an index of '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{indexName._3()})));
                    }
                    {
                        this.tables$1 = tables$1;
                    }
                });
                tableToIndexName.foreach((Function1)new Serializable($this, ds, sft){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ManagePartitionsCommand.AdoptPartitionCommand $outer;
                    private final GeoMesaDataStore ds$3;
                    private final SimpleFeatureType sft$3;

                    public final void apply(Tuple2<String, Tuple4<GeoMesaFeatureIndex<?, ?>, String, String, String>> x0$1) {
                        Tuple2<String, Tuple4<GeoMesaFeatureIndex<?, ?>, String, String, String>> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String table = (String)tuple2._1();
                            Tuple4 indexName = (Tuple4)tuple2._2();
                            this.ds$3.metadata().insert(this.sft$3.getTypeName(), ((GeoMesaFeatureIndex)indexName._1()).tableNameKey((Option)new Some((Object)this.$outer.params().partition())), (Object)table);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        void var3_3;
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.ds$3 = ds$3;
                        this.sft$3 = var3_3;
                    }
                });
                time.register($this.params().partition(), start3, end2);
                package$Command$.MODULE$.user().info("Done");
                return;
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError(tuple2);
    }

    public static void $init$(ManagePartitionsCommand.AdoptPartitionCommand $this) {
        $this.org$locationtech$geomesa$tools$data$ManagePartitionsCommand$AdoptPartitionCommand$_setter_$name_$eq("adopt");
    }
}

