/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.ingest;

import com.beust.jcommander.ParameterException;
import com.typesafe.config.Config;
import java.util.Map;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.locationtech.geomesa.jobs.mapreduce.ConverterCombineInputFormat;
import org.locationtech.geomesa.jobs.package;
import org.locationtech.geomesa.tools.DistributedRunParam$RunModes$;
import org.locationtech.geomesa.tools.ingest.ConverterIngestJob;
import org.locationtech.geomesa.tools.ingest.IngestCommand;
import org.locationtech.geomesa.tools.ingest.IngestCommand$;
import org.locationtech.geomesa.tools.ingest.IngestCommand$IngestCounters$;
import org.locationtech.geomesa.tools.ingest.LocalConverterIngest;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.tools.utils.TerminalCallback$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.LocalDelegate;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.Try$;

public abstract class IngestCommand$class {
    public static Seq libjarsFiles(IngestCommand $this) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org/locationtech/geomesa/tools/ingest-libjars.list"}));
    }

    public static void execute(IngestCommand $this) {
        block17: {
            Enumeration.Value mode2;
            Option<String> format;
            IngestCommand.Inputs inputs;
            block16: {
                block15: {
                    Enumeration.Value value;
                    if ($this.params().files().isEmpty() && !LocalDelegate.StdInHandle$.MODULE$.isAvailable()) {
                        throw new ParameterException("Missing option: <files>... is required, or use `-` to ingest from standard in");
                    }
                    IngestCommand.Inputs files = new IngestCommand.Inputs((Seq<String>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter($this.params().files()).asScala()));
                    inputs = $this.params().srcList() ? files.asSourceList() : files;
                    format = IngestCommand$.MODULE$.getDataFormat($this.params(), inputs.paths());
                    boolean remote = inputs.paths().exists((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String path) {
                            return PathUtils$.MODULE$.isRemote(path);
                        }
                    });
                    if (remote) {
                        String prefix = ((String)inputs.paths().head()).split("/")[0].toLowerCase();
                        if (!((IterableLike)inputs.paths().drop(1)).forall((Function1)new Serializable($this, prefix){
                            public static final long serialVersionUID = 0L;
                            private final String prefix$1;

                            public final boolean apply(String x$1) {
                                return x$1.toLowerCase().startsWith(this.prefix$1);
                            }
                            {
                                this.prefix$1 = prefix$1;
                            }
                        })) {
                            throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files must all be on the same file system: (", ") or all be local"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix})));
                        }
                    }
                    if (format.contains((Object)"shp")) {
                        if ($this.params().mode().exists((Function1)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Enumeration.Value x$2) {
                                Enumeration.Value value = x$2;
                                Enumeration.Value value2 = DistributedRunParam$RunModes$.MODULE$.Local();
                                return value != null ? !value.equals(value2) : value2 != null;
                            }
                        })) {
                            package$Command$.MODULE$.user().warn("Forcing run mode to local for shapefile ingestion");
                        }
                        value = DistributedRunParam$RunModes$.MODULE$.Local();
                    } else if (remote) {
                        value = (Enumeration.Value)$this.params().mode().getOrElse((Function0)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final Enumeration.Value apply() {
                                return DistributedRunParam$RunModes$.MODULE$.Distributed();
                            }
                        });
                    } else {
                        if ($this.params().mode().exists((Function1)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Enumeration.Value x$3) {
                                Enumeration.Value value = x$3;
                                Enumeration.Value value2 = DistributedRunParam$RunModes$.MODULE$.Local();
                                return value != null ? !value.equals(value2) : value2 != null;
                            }
                        })) {
                            throw new ParameterException("Input files must be in a distributed file system to run in distributed mode");
                        }
                        value = DistributedRunParam$RunModes$.MODULE$.Local();
                    }
                    Enumeration.Value value2 = mode2 = value;
                    Enumeration.Value value3 = DistributedRunParam$RunModes$.MODULE$.Local();
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block15;
                    if (!$this.params().waitForCompletion()) {
                        throw new ParameterException("Tracking must be enabled when running in local mode");
                    }
                    break block16;
                }
                if (!BoxesRunTime.equalsNumObject((Number)$this.params().threads(), (Object)BoxesRunTime.boxToInteger((int)1))) break block17;
            }
            if ($this.params().maxSplitSize() == null || $this.params().combineInputs()) {
                ((Option)IngestCommand$.MODULE$.getSftAndConverter($this.params(), inputs.paths(), format, (Option<package.DataStoreCommand<? extends DataStore>>)new Some((Object)$this)).get()).foreach((Function1)new Serializable($this, inputs, mode2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ IngestCommand $outer;
                    private final IngestCommand.Inputs inputs$2;
                    private final Enumeration.Value mode$1;

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(Tuple2<SimpleFeatureType, Config> x0$1) {
                        BoxedUnit boxedUnit;
                        DataStore ds;
                        block8: {
                            Tuple2<SimpleFeatureType, Config> tuple2 = x0$1;
                            if (tuple2 == null) throw new MatchError(tuple2);
                            SimpleFeatureType sft = (SimpleFeatureType)tuple2._1();
                            Config converter = (Config)tuple2._2();
                            long start2 = System.currentTimeMillis();
                            ds = DataStoreFinder.getDataStore((Map)((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.$outer.connection()).asJava()));
                            if (ds == null) {
                                throw new ParameterException("Could not create data store from parameters");
                            }
                            try {
                                SimpleFeatureType existing = (SimpleFeatureType)Try$.MODULE$.apply((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final SimpleFeatureType sft$1;
                                    private final DataStore ds$1;

                                    public final SimpleFeatureType apply() {
                                        return this.ds$1.getSchema(this.sft$1.getTypeName());
                                    }
                                    {
                                        this.sft$1 = sft$1;
                                        this.ds$1 = ds$1;
                                    }
                                }).getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Null$ apply() {
                                        return null;
                                    }
                                });
                                if (existing == null) {
                                    package$Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating schema '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()})));
                                    this.$outer.setBackendSpecificOptions(sft);
                                    ds.createSchema((FeatureType)sft);
                                } else {
                                    package$Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()})));
                                    if (DataUtilities.compare((SimpleFeatureType)sft, (SimpleFeatureType)existing) != 0) {
                                        throw new ParameterException(new StringBuilder().append((Object)"Existing simple feature type does not match expected type").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  existing: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SimpleFeatureTypes$.MODULE$.encodeType(existing)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n  expected: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SimpleFeatureTypes$.MODULE$.encodeType(sft)}))).toString());
                                    }
                                }
                                package.Awaitable result = this.$outer.startIngest(this.mode$1, ds, sft, converter, this.inputs$2);
                                if (this.$outer.params().waitForCompletion()) {
                                    package.JobResult jobResult = result.await(TerminalCallback$.MODULE$.apply(TerminalCallback$.MODULE$.apply$default$1()));
                                    if (jobResult instanceof package.JobResult$.JobSuccess) {
                                        package.JobResult$.JobSuccess jobSuccess = (package.JobResult$.JobSuccess)jobResult;
                                        String message = jobSuccess.message();
                                        scala.collection.immutable.Map counts = jobSuccess.counts();
                                        package$Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ingestion complete in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getTime(start2)})));
                                        long count2 = BoxesRunTime.unboxToLong((Object)counts.getOrElse((Object)IngestCommand$IngestCounters$.MODULE$.Persisted(), (Function0)new Serializable(this, counts){
                                            public static final long serialVersionUID = 0L;
                                            private final scala.collection.immutable.Map counts$1;

                                            public final long apply() {
                                                return this.apply$mcJ$sp();
                                            }

                                            public long apply$mcJ$sp() {
                                                return BoxesRunTime.unboxToLong((Object)this.counts$1.getOrElse((Object)IngestCommand$IngestCounters$.MODULE$.Ingested(), (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final long apply() {
                                                        return this.apply$mcJ$sp();
                                                    }

                                                    public long apply$mcJ$sp() {
                                                        return 0L;
                                                    }
                                                }));
                                            }
                                            {
                                                this.counts$1 = counts$1;
                                            }
                                        }));
                                        long failed = BoxesRunTime.unboxToLong((Object)counts.getOrElse((Object)IngestCommand$IngestCounters$.MODULE$.Failed(), (Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final long apply() {
                                                return this.apply$mcJ$sp();
                                            }

                                            public long apply$mcJ$sp() {
                                                return 0L;
                                            }
                                        }));
                                        long x$15 = count2;
                                        long x$16 = failed;
                                        String x$17 = message;
                                        String x$18 = IngestCommand$.MODULE$.getStatInfo$default$3();
                                        package$Command$.MODULE$.user().info(IngestCommand$.MODULE$.getStatInfo(x$15, x$16, x$18, x$17));
                                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                        boxedUnit = BoxedUnit.UNIT;
                                        break block8;
                                    }
                                    if (!(jobResult instanceof package.JobResult$.JobFailure)) throw new MatchError((Object)jobResult);
                                    package.JobResult$.JobFailure jobFailure = (package.JobResult$.JobFailure)jobResult;
                                    String message = jobFailure.message();
                                    package$Command$.MODULE$.user().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ingestion failed in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getTime(start2)})));
                                    throw new package.Command.CommandException(message);
                                }
                                package$Command$.MODULE$.user().info("Job submitted, check tracking for progress and result");
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            catch (Throwable throwable) {
                                void var8_6;
                                package.CloseWithLogging$.MODULE$.apply((Object)var8_6, (IsCloseable)IsCloseable$.MODULE$.dataStoreIsCloseable());
                                throw throwable;
                            }
                        }
                        package.CloseWithLogging$.MODULE$.apply((Object)ds, (IsCloseable)IsCloseable$.MODULE$.dataStoreIsCloseable());
                        BoxedUnit boxedUnit3 = boxedUnit;
                    }
                    {
                        void var3_3;
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.inputs$2 = inputs$2;
                        this.mode$1 = var3_3;
                    }
                });
                return;
            }
            throw new ParameterException("--split-max-size can only be used with --combine-inputs");
        }
        throw new ParameterException("Threads can only be specified in local mode");
    }

    public static package.Awaitable startIngest(IngestCommand $this, Enumeration.Value mode2, DataStore ds, SimpleFeatureType sft, Config converter, IngestCommand.Inputs inputs) {
        block4: {
            Object object;
            block3: {
                Enumeration.Value value;
                block2: {
                    value = mode2;
                    Enumeration.Value value2 = DistributedRunParam$RunModes$.MODULE$.Local();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    package$Command$.MODULE$.user().info("Running ingestion in local mode");
                    object = new LocalConverterIngest(ds, sft, converter, inputs, Predef$.MODULE$.Integer2int($this.params().threads()));
                    break block3;
                }
                Enumeration.Value value4 = DistributedRunParam$RunModes$.MODULE$.Distributed();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                package$Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running ingestion in distributed ", "mode"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.params().combineInputs() ? "combine " : ""})));
                object = new ConverterIngestJob($this, sft, converter, inputs){
                    private final /* synthetic */ IngestCommand $outer;

                    public void configureJob(Job job) {
                        super.configureJob(job);
                        if (this.$outer.params().combineInputs()) {
                            job.setInputFormatClass(ConverterCombineInputFormat.class);
                            Option$.MODULE$.apply((Object)this.$outer.params().maxSplitSize()).foreach((Function1)new Serializable(this, job){
                                public static final long serialVersionUID = 0L;
                                private final Job job$1;

                                public final void apply(Integer s) {
                                    FileInputFormat.setMaxInputSplitSize((Job)this.job$1, (long)Predef$.MODULE$.Integer2int(s));
                                }
                                {
                                    this.job$1 = job$1;
                                }
                            });
                        }
                    }
                    {
                        void var4_4;
                        void var3_3;
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super($outer.connection(), (SimpleFeatureType)sft$3, (Config)var3_3, var4_4.paths(), $outer.libjarsFiles(), $outer.libjarsPaths());
                    }
                };
            }
            return object;
        }
        throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing implementation for mode ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mode2})));
    }

    public static void $init$(IngestCommand $this) {
        $this.org$locationtech$geomesa$tools$ingest$IngestCommand$_setter_$name_$eq("ingest");
    }
}

