/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools;

import com.beust.jcommander.IStringConverterFactory;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.facebook.nailgun.NGContext;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.locationtech.geomesa.tools.Runner;
import org.locationtech.geomesa.tools.Runner$;
import org.locationtech.geomesa.tools.Runner$CommandResult$;
import org.locationtech.geomesa.tools.export.ConvertCommand;
import org.locationtech.geomesa.tools.export.GenerateAvroSchemaCommand;
import org.locationtech.geomesa.tools.help.ClasspathCommand;
import org.locationtech.geomesa.tools.help.HelpCommand;
import org.locationtech.geomesa.tools.help.NailgunCommand;
import org.locationtech.geomesa.tools.help.ScalaConsoleCommand;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.tools.status.ConfigureCommand;
import org.locationtech.geomesa.tools.status.EnvironmentCommand;
import org.locationtech.geomesa.tools.status.VersionCommand;
import org.locationtech.geomesa.tools.utils.GeoMesaIStringConverterFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public abstract class Runner$class {
    public static Option environmentErrorInfo(Runner $this) {
        return None$.MODULE$;
    }

    public static void main(Runner $this, String[] args) {
        Runner$class.execute($this, new Runner.MainExecutor($this, args));
    }

    public static void nailMain(Runner $this, NGContext context) {
        Runner$class.execute($this, new Runner.NailgunExecutor($this, context));
    }

    private static void execute(Runner $this, Runner.Executor executor) {
        Runner.CommandResult commandResult;
        try {
            executor.execute();
            commandResult = new Runner.CommandResult(0, Runner$CommandResult$.MODULE$.apply$default$2());
        }
        catch (Throwable throwable) {
            Runner.CommandResult commandResult2;
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ClassNotFoundException ? true : throwable2 instanceof NoClassDefFoundError;
            if (bl) {
                BoxedUnit boxedUnit;
                String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Warning: Missing dependency for command execution: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable2.getMessage()}));
                if ($this.logger().underlying().isErrorEnabled()) {
                    $this.logger().underlying().error(msg, throwable2);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                commandResult2 = new Runner.CommandResult(1, (Seq<Either<String, Throwable>>)((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Left[]{package$.MODULE$.Left().apply((Object)msg)}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable($this.environmentErrorInfo().map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Left<String, Nothing$> apply(String a) {
                        return package$.MODULE$.Left().apply((Object)a);
                    }
                })), Seq$.MODULE$.canBuildFrom())));
            } else if (throwable2 instanceof ParameterException) {
                ParameterException parameterException = (ParameterException)throwable2;
                commandResult2 = new Runner.CommandResult(1, (Seq<Either<String, Throwable>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Left[]{package$.MODULE$.Left().apply((Object)parameterException.getMessage())}))));
            } else if (throwable2 instanceof package.Command.CommandException) {
                package.Command.CommandException commandException = (package.Command.CommandException)throwable2;
                commandResult2 = new Runner.CommandResult(1, (Seq<Either<String, Throwable>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Left[]{package$.MODULE$.Left().apply((Object)commandException.getMessage())}))));
            } else {
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                commandResult2 = new Runner.CommandResult(1, (Seq<Either<String, Throwable>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Right[]{package$.MODULE$.Right().apply((Object)e)}))));
            }
            commandResult = commandResult2;
        }
        Runner.CommandResult result = commandResult;
        result.errors().foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(Either<String, Throwable> x0$1) {
                Either<String, Throwable> either;
                block4: {
                    block3: {
                        block2: {
                            either = x0$1;
                            if (!(either instanceof Left)) break block2;
                            Left left = (Left)either;
                            String msg = (String)left.a();
                            package$Command$.MODULE$.user().error(msg);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(either instanceof Right)) break block4;
                        Right right = (Right)either;
                        Throwable e = (Throwable)right.b();
                        package$Command$.MODULE$.user().error(e.getMessage(), e);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(either);
            }
        });
        throw scala.sys.package$.MODULE$.exit(result.code());
    }

    public static package.Command parseCommand(Runner $this, String[] args) {
        package.Command command;
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        JCommander jc = JCommander.newBuilder().programName($this.name()).addConverterFactory((IStringConverterFactory)new GeoMesaIStringConverterFactory()).build();
        Seq commands = (Seq)$this.commands().$colon$plus((Object)new HelpCommand($this, jc), Seq$.MODULE$.canBuildFrom());
        commands.foreach((Function1)new Serializable($this, jc){
            public static final long serialVersionUID = 0L;
            public final JCommander jc$1;

            public final void apply(package.Command command) {
                this.jc$1.addCommand(command.name(), command.params());
                command.subCommands().foreach((Function1)new Serializable(this, command){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Runner$.anonfun.parseCommand.1 $outer;
                    private final package.Command command$1;

                    public final void apply(package.Command sub) {
                        ((JCommander)this.$outer.jc$1.getCommands().get(this.command$1.name())).addCommand(sub.name(), sub.params());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.command$1 = command$1;
                    }
                });
            }
            {
                this.jc$1 = jc$1;
            }
        });
        try {
            jc.parse(args);
        }
        catch (ParameterException parameterException) {
            Runner$class.logAndThrowError$1($this, parameterException, jc);
        }
        package.Command parsed = (package.Command)commands.find((Function1)new Serializable($this, jc){
            public static final long serialVersionUID = 0L;
            private final JCommander jc$1;

            public final boolean apply(package.Command x$1) {
                String string = x$1.name();
                String string2 = this.jc$1.getParsedCommand();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.jc$1 = jc$1;
            }
        }).getOrElse((Function0)new Serializable($this, jc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Runner $outer;
            private final JCommander jc$1;

            public final Runner.DefaultCommand apply() {
                return new Runner.DefaultCommand(this.$outer, this.jc$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.jc$1 = jc$1;
            }
        });
        $this.resolveEnvironment(parsed);
        if (parsed.subCommands().isEmpty()) {
            command = parsed;
        } else {
            ObjectRef available$lzy = ObjectRef.zero();
            String sub = (String)Option$.MODULE$.apply((Object)((JCommander)jc.getCommands().get(parsed.name())).getParsedCommand()).getOrElse((Function0)new Serializable($this, parsed, available$lzy, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Runner $outer;
                private final package.Command parsed$1;
                private final ObjectRef available$lzy$1;
                private final VolatileByteRef bitmap$0$1;

                public final Nothing$ apply() {
                    throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No sub-command specified. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Runner$class.available$1(this.$outer, this.parsed$1, this.available$lzy$1, this.bitmap$0$1)})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parsed$1 = parsed$1;
                    this.available$lzy$1 = available$lzy$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
            command = (package.Command)parsed.subCommands().find((Function1)new Serializable($this, sub){
                public static final long serialVersionUID = 0L;
                private final String sub$1;

                public final boolean apply(package.Command x$3) {
                    String string = x$3.name();
                    String string2 = this.sub$1;
                    return !(string != null ? !string.equals(string2) : string2 != null);
                }
                {
                    this.sub$1 = sub$1;
                }
            }).getOrElse((Function0)new Serializable($this, parsed, available$lzy, sub, bitmap$0){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Runner $outer;
                private final package.Command parsed$1;
                private final ObjectRef available$lzy$1;
                private final String sub$1;
                private final VolatileByteRef bitmap$0$1;

                public final Nothing$ apply() {
                    throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sub-command '", "' not found. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sub$1, Runner$class.available$1(this.$outer, this.parsed$1, this.available$lzy$1, this.bitmap$0$1)})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.parsed$1 = parsed$1;
                    this.available$lzy$1 = available$lzy$1;
                    this.sub$1 = sub$1;
                    this.bitmap$0$1 = bitmap$0$1;
                }
            });
        }
        package.Command command2 = command;
        command2.validate().foreach((Function1)new Serializable($this, jc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Runner $outer;
            private final JCommander jc$1;

            public final void apply(ParameterException e) {
                Runner$class.logAndThrowError$1(this.$outer, e, this.jc$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.jc$1 = jc$1;
            }
        });
        return command2;
    }

    public static String usage(Runner $this, JCommander jc) {
        StringBuilder out = new StringBuilder();
        out.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Usage: ", " [command] [command options]\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.name()})));
        Seq commands = (Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(jc.getCommands()).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, JCommander> x$4) {
                return (String)x$4._1();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
        out.append("  Commands:\n");
        int maxLen = BoxesRunTime.unboxToInt((Object)((TraversableOnce)commands.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$5) {
                return x$5.length();
            }
        }, Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$)) + 4;
        commands.foreach((Function1)new Serializable($this, out, maxLen, jc){
            public static final long serialVersionUID = 0L;
            private final StringBuilder out$1;
            private final int maxLen$1;
            private final JCommander jc$2;

            public final StringBuilder apply(String name2) {
                String spaces = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(this.maxLen$1 - name2.length());
                return this.out$1.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"    ", "", "", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2, spaces, this.jc$2.getUsageFormatter().getCommandDescription(name2)})));
            }
            {
                this.out$1 = out$1;
                this.maxLen$1 = maxLen$1;
                this.jc$2 = jc$2;
            }
        });
        return out.toString();
    }

    public static String usage(Runner $this, JCommander jc, String name2) {
        Option option;
        block4: {
            String string;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)name2).flatMap((Function1)new Serializable($this, jc){
                        public static final long serialVersionUID = 0L;
                        private final JCommander jc$3;

                        public final Option<JCommander> apply(String n) {
                            return Option$.MODULE$.apply(this.jc$3.getCommands().get(n));
                        }
                        {
                            this.jc$3 = jc$3;
                        }
                    });
                    if (!None$.MODULE$.equals(option)) break block2;
                    string = $this.usage(jc);
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                JCommander command = (JCommander)some.x();
                java.lang.StringBuilder out = new java.lang.StringBuilder();
                command.getUsageFormatter().usage(out);
                string = out.toString();
            }
            return string;
        }
        throw new MatchError((Object)option);
    }

    public static void autocompleteUsage(Runner $this, JCommander jc, Runner.AutocompleteInfo autocompleteInfo) {
        File file = new File(autocompleteInfo.path());
        Seq commands = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(jc.getCommands()).asScala()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, JCommander> x$6) {
                return (String)x$6._1();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        StringBuilder out = new StringBuilder();
        out.append(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_", "(){\n         |  local cur prev;\n         |  COMPREPLY=();\n         |  cur=\"${COMP_WORDS[COMP_CWORD]}\";\n         |  prev=\"${COMP_WORDS[COMP_CWORD-1]}\";\n         |\n         |  if [[ \"${COMP_WORDS[1]}\" == \"help\" ]]; then\n         |    COMPREPLY=( $(compgen -W \"", "\" ${cur}));\n         |    return 0;\n         |  fi;\n         |\n         |  case ${COMP_CWORD} in\n         |    1)\n         |      COMPREPLY=( $(compgen -W \"", "\" ${cur}));\n         |      ;;\n         |    [2-9] | [1-9][0-9])\n         |      if [[ \"${cur}\" =~ ^-[a-zA-Z-]?+$ ]]; then\n         |        case ${COMP_WORDS[1]} in\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{autocompleteInfo.commandName(), commands.mkString(" "), commands.mkString(" ")})))).stripMargin());
        commands.foreach((Function1)new Serializable($this, out, jc){
            public static final long serialVersionUID = 0L;
            private final StringBuilder out$2;
            private final JCommander jc$4;

            public final StringBuilder apply(String command) {
                Buffer params = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((JCommander)this.jc$4.getCommands().get(command)).getParameters()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(ParameterDescription x$7) {
                        return !x$7.getParameter().hidden();
                    }
                })).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<String> apply(ParameterDescription x$8) {
                        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])x$8.getParameter().names()).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$9) {
                                return x$9.length() != 2;
                            }
                        }));
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                return this.out$2.append(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"            ", ")\n         |              COMPREPLY=( $(compgen -W \"", "\" -- ${cur}));\n         |              return 0;\n         |              ;;\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{command, params.mkString(" ").replaceAll("[,\\s]+", " ")})))).stripMargin());
            }
            {
                this.out$2 = out$2;
                this.jc$4 = jc$4;
            }
        });
        out.append(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"        esac;\n         |      else\n         |        compopt -o filenames -o nospace;\n         |        COMPREPLY=( $(compgen -f \"$2\") );\n         |      fi;\n         |      return 0;\n         |      ;;\n         |    *)\n         |      COMPREPLY=();\n         |      ;;\n         |  esac;\n         |};\n         |complete -F _", " ", ";\n         |complete -F _", " bin/", ";\n         |\n         |\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{autocompleteInfo.commandName(), autocompleteInfo.commandName(), autocompleteInfo.commandName(), autocompleteInfo.commandName()})))).stripMargin());
        FileUtils.writeStringToFile((File)file, (String)out.toString(), (Charset)StandardCharsets.UTF_8);
    }

    public static Seq commands(Runner $this) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new package.Command[]{new ConvertCommand(), new ConfigureCommand(), new ClasspathCommand(), new EnvironmentCommand(), new GenerateAvroSchemaCommand(), new NailgunCommand(), new ScalaConsoleCommand(), new VersionCommand()}));
    }

    public static void resolveEnvironment(Runner $this, package.Command command) {
    }

    public static final void logAndThrowError$1(Runner $this, ParameterException e, JCommander jc$1) {
        package$Command$.MODULE$.user().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error parsing arguments: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()})));
        package$Command$.MODULE$.user().info($this.usage(jc$1, jc$1.getParsedCommand()));
        throw e;
    }

    private static final String available$lzycompute$1(Runner $this, package.Command parsed$1, ObjectRef available$lzy$1, VolatileByteRef bitmap$0$1) {
        Runner runner = $this;
        synchronized (runner) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                available$lzy$1.elem = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Use '", " <sub-command>', where sub-command is one of: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{parsed$1.name()}))).append((Object)((TraversableOnce)parsed$1.subCommands().map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(package.Command x$2) {
                        return x$2.name();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ")).toString();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (String)available$lzy$1.elem;
        }
    }

    public static final String available$1(Runner $this, package.Command parsed$1, ObjectRef available$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? Runner$class.available$lzycompute$1($this, parsed$1, available$lzy$1, bitmap$0$1) : (String)available$lzy$1.elem;
    }

    public static void $init$(Runner $this) {
    }
}

