/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export;

import com.beust.jcommander.ParameterException;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Map;
import org.geotools.data.Query;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.conf.QueryHints;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geoserver.ViewParams$;
import org.locationtech.geomesa.index.iterators.BinAggregatingScan$;
import org.locationtech.geomesa.index.planning.QueryRunner$;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.ExportCommand$;
import org.locationtech.geomesa.tools.export.formats.ExportFormat;
import org.locationtech.geomesa.tools.export.formats.ExportFormat$Arrow$;
import org.locationtech.geomesa.tools.export.formats.ExportFormat$Bin$;
import org.locationtech.geomesa.tools.export.formats.ExportFormat$Leaflet$;
import org.locationtech.geomesa.tools.export.formats.LeafletMapExporter$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ExportCommand$
implements LazyLogging {
    public static final ExportCommand$ MODULE$;
    private final String org$locationtech$geomesa$tools$export$ExportCommand$$CountKey;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new ExportCommand$();
    }

    private Logger logger$lzycompute() {
        ExportCommand$ exportCommand$ = this;
        synchronized (exportCommand$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String org$locationtech$geomesa$tools$export$ExportCommand$$CountKey() {
        return this.org$locationtech$geomesa$tools$export$ExportCommand$$CountKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Query createQuery(SimpleFeatureType sft, ExportCommand.ExportParams params) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        String[] stringArray;
        Object object;
        String typeName = (String)Option$.MODULE$.apply((Object)params).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ExportCommand.ExportParams, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 != null) {
                    A1 A12 = A1;
                    object = A12.featureName();
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ExportCommand.ExportParams x3) {
                ExportCommand.ExportParams exportParams = x3;
                boolean bl = exportParams != null;
                return bl;
            }
        }).orNull(Predef$.MODULE$.$conforms());
        Filter filter2 = (Filter)Option$.MODULE$.apply((Object)params.cqlFilter()).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IncludeFilter apply() {
                return Filter.INCLUDE;
            }
        });
        Query query2 = new Query(typeName, filter2);
        Hints hints = query2.getHints();
        Option$.MODULE$.apply((Object)params.maxFeatures()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Object x) {
                return BoxesRunTime.unboxToInt((Object)x);
            }
        }).foreach((Function1)new Serializable(query2){
            public static final long serialVersionUID = 0L;
            private final Query query$2;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.query$2.setMaxFeatures(x$1);
            }
            {
                this.query$2 = query$2;
            }
        });
        Option$.MODULE$.apply((Object)params).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ExportCommand.ExportParams, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x4;
                Object object = A12 instanceof OptionalIndexParam ? (A1 = A12) : function1.apply(x4);
                return (B1)object;
            }

            public final boolean isDefinedAt(ExportCommand.ExportParams x4) {
                ExportCommand.ExportParams exportParams = x4;
                boolean bl = exportParams instanceof OptionalIndexParam;
                return bl;
            }
        }).foreach((Function1)new Serializable(hints){
            public static final long serialVersionUID = 0L;
            public final Hints hints$2;

            public final void apply(ExportCommand.ExportParams p) {
                Option$.MODULE$.apply((Object)((OptionalIndexParam)((Object)p)).index()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createQuery.4 $outer;

                    public final Object apply(String index) {
                        BoxedUnit boxedUnit;
                        if (ExportCommand$.MODULE$.logger().underlying().isDebugEnabled()) {
                            ExportCommand$.MODULE$.logger().underlying().debug("Using index {}", new Object[]{index});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return this.$outer.hints$2.put((Object)QueryHints$.MODULE$.QUERY_INDEX(), (Object)index);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.hints$2 = hints$2;
            }
        });
        Option$.MODULE$.apply(params.hints()).foreach((Function1)new Serializable(query2, hints){
            public static final long serialVersionUID = 0L;
            private final Query query$2;
            private final Hints hints$2;

            public final void apply(Map<String, String> hintStrings) {
                this.hints$2.put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, hintStrings);
                ViewParams$.MODULE$.setHints(this.query$2);
            }
            {
                this.query$2 = query$2;
                this.hints$2 = hints$2;
            }
        });
        ExportFormat exportFormat = params.outputFormat();
        ExportFormat$Arrow$ exportFormat$Arrow$ = ExportFormat$Arrow$.MODULE$;
        if (!(exportFormat != null ? !exportFormat.equals(exportFormat$Arrow$) : exportFormat$Arrow$ != null)) {
            object = hints.put((Object)QueryHints$.MODULE$.ARROW_ENCODE(), (Object)Boolean.TRUE);
        } else {
            ExportFormat exportFormat2 = params.outputFormat();
            ExportFormat$Bin$ exportFormat$Bin$ = ExportFormat$Bin$.MODULE$;
            if (!(exportFormat2 != null ? !exportFormat2.equals(exportFormat$Bin$) : exportFormat$Bin$ != null)) {
                Object object2 = hints.containsKey((Object)QueryHints$.MODULE$.BIN_TRACK()) ? BoxedUnit.UNIT : hints.put((Object)QueryHints$.MODULE$.BIN_TRACK(), (Object)"id");
                if (!hints.containsKey((Object)QueryHints$.MODULE$.BIN_DTG())) {
                    RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).foreach((Function1)new Serializable(hints){
                        public static final long serialVersionUID = 0L;
                        private final Hints hints$2;

                        public final Object apply(String x$5) {
                            return this.hints$2.put((Object)QueryHints$.MODULE$.BIN_DTG(), (Object)x$5);
                        }
                        {
                            this.hints$2 = hints$2;
                        }
                    });
                }
            } else {
                ExportFormat exportFormat3 = params.outputFormat();
                ExportFormat$Leaflet$ exportFormat$Leaflet$ = ExportFormat$Leaflet$.MODULE$;
                if (!(exportFormat3 != null ? !exportFormat3.equals(exportFormat$Leaflet$) : exportFormat$Leaflet$ != null) && !LeafletMapExporter$.MODULE$.configure(params)) {
                    throw new ParameterException("Terminating execution");
                }
            }
            object = BoxedUnit.UNIT;
        }
        Buffer combined = ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(params.attributes()).asScala()).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(params.transforms()).asScala());
        if (combined.nonEmpty()) {
            Tuple2 tuple2;
            Tuple2 tuple22 = combined.partition((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$6) {
                    return x$6.equalsIgnoreCase("id");
                }
            });
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            Buffer id = (Buffer)tuple22._1();
            Buffer attributes = (Buffer)tuple22._2();
            Tuple2 tuple23 = tuple2 = new Tuple2((Object)id, (Object)attributes);
            Buffer id2 = (Buffer)tuple23._1();
            Buffer attributes2 = (Buffer)tuple23._2();
            Object object3 = id2.isEmpty() && !hints.containsKey((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID()) ? hints.put((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID(), (Object)Boolean.FALSE) : BoxedUnit.UNIT;
            stringArray = (String[])attributes2.toArray(ClassTag$.MODULE$.apply(String.class));
        } else {
            ExportFormat exportFormat4 = params.outputFormat();
            ExportFormat$Bin$ exportFormat$Bin$ = ExportFormat$Bin$.MODULE$;
            stringArray = !(exportFormat4 != null ? !exportFormat4.equals(exportFormat$Bin$) : exportFormat$Bin$ != null) ? (String[])BinAggregatingScan$.MODULE$.propertyNames(hints, sft).toArray(ClassTag$.MODULE$.apply(String.class)) : null;
        }
        String[] attributes = stringArray;
        query2.setPropertyNames(attributes);
        if (params.sortFields().isEmpty()) {
            if (QueryHints$.MODULE$.RichHints(hints).isArrowQuery()) {
                QueryHints$.MODULE$.RichHints(hints).getArrowSort().foreach((Function1)new Serializable(query2){
                    public static final long serialVersionUID = 0L;
                    private final Query query$2;

                    public final void apply(Tuple2<String, Object> x0$1) {
                        Tuple2<String, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String f = (String)tuple2._1();
                            boolean r = tuple2._2$mcZ$sp();
                            SortOrder order = r ? SortOrder.DESCENDING : SortOrder.ASCENDING;
                            this.query$2.setSortBy((SortBy[])((Object[])new SortBy[]{package$.MODULE$.ff().sort(f, order)}));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.query$2 = query$2;
                    }
                });
            }
        } else {
            Buffer fields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(params.sortFields()).asScala();
            if (fields.exists((Function1)new Serializable(sft){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$1;

                public final boolean apply(String a) {
                    return this.sft$1.indexOf(a) == -1;
                }
                {
                    this.sft$1 = sft$1;
                }
            })) {
                Buffer errors = (Buffer)fields.filter((Function1)new Serializable(sft){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType sft$1;

                    public final boolean apply(String a) {
                        return this.sft$1.indexOf(a) == -1;
                    }
                    {
                        this.sft$1 = sft$1;
                    }
                });
                throw new ParameterException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid sort attribute", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errors.lengthCompare(1) == 0 ? "" : "s"}))).append((Object)errors.mkString(", ")).toString());
            }
            SortOrder order = params.sortDescending() ? SortOrder.DESCENDING : SortOrder.ASCENDING;
            query2.setSortBy((SortBy[])((TraversableOnce)fields.map((Function1)new Serializable(order){
                public static final long serialVersionUID = 0L;
                private final SortOrder order$1;

                public final SortBy apply(String f) {
                    return package$.MODULE$.ff().sort(f, this.order$1);
                }
                {
                    this.order$1 = order$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SortBy.class)));
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Applying CQL filter {}", new Object[]{ECQL.toCQL((Filter)filter2)});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Applying transform {}", new Object[]{Option$.MODULE$.apply((Object)attributes).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String[] x$8) {
                    return Predef$.MODULE$.refArrayOps((Object[])x$8).mkString(",");
                }
            }).orNull(Predef$.MODULE$.$conforms())});
            boxedUnit = BoxedUnit.UNIT;
            return QueryRunner$.MODULE$.configureDefaultQuery(sft, query2);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return QueryRunner$.MODULE$.configureDefaultQuery(sft, query2);
    }

    public void disableAggregation(SimpleFeatureType sft, Hints hints) {
        if (QueryHints$.MODULE$.RichHints(hints).isArrowQuery()) {
            hints.remove((Object)QueryHints$.MODULE$.ARROW_ENCODE());
            String sort = (String)hints.remove((Object)QueryHints$.MODULE$.ARROW_SORT_FIELD());
            if (sort != null) {
                Option reverse = Option$.MODULE$.apply((Object)((Boolean)hints.remove((Object)QueryHints$.MODULE$.ARROW_SORT_REVERSE())));
                SortOrder order = reverse.exists((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Boolean x$9) {
                        return x$9;
                    }
                }) ? SortOrder.DESCENDING : SortOrder.ASCENDING;
                SortBy hint = package$.MODULE$.ff().sort(sort, order);
                hints.put((Object)QueryHints.Internal$.MODULE$.SORT_FIELDS(), (Object)QueryHints.Internal$.MODULE$.toSortHint((SortBy[])((Object[])new SortBy[]{hint})));
            }
        } else if (QueryHints$.MODULE$.RichHints(hints).isBinQuery()) {
            hints.remove((Object)QueryHints$.MODULE$.BIN_TRACK());
            if (QueryHints$.MODULE$.RichHints(hints).isBinSorting()) {
                QueryHints$.MODULE$.RichHints(hints).getBinDtgField().orElse((Function0)new Serializable(sft){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType sft$2;

                    public final Option<String> apply() {
                        return RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$2));
                    }
                    {
                        this.sft$2 = sft$2;
                    }
                }).foreach((Function1)new Serializable(hints){
                    public static final long serialVersionUID = 0L;
                    private final Hints hints$1;

                    public final Object apply(String dtg) {
                        SortBy hint = package$.MODULE$.ff().sort(dtg, SortOrder.ASCENDING);
                        return this.hints$1.put((Object)QueryHints.Internal$.MODULE$.SORT_FIELDS(), (Object)QueryHints.Internal$.MODULE$.toSortHint((SortBy[])((Object[])new SortBy[]{hint})));
                    }
                    {
                        this.hints$1 = hints$1;
                    }
                });
            }
        }
    }

    private ExportCommand$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$tools$export$ExportCommand$$CountKey = "count";
    }
}

