/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export;

import java.io.File;
import java.text.NumberFormat;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.InputSampler;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.jobs.mapreduce.JobWithLibJars;
import org.locationtech.geomesa.tools.export.ExportJob;
import org.locationtech.geomesa.tools.export.ExportJob$Config$;
import org.locationtech.geomesa.tools.export.formats.ExportFormat;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class ExportJob$
implements JobWithLibJars {
    public static final ExportJob$ MODULE$;
    private final NumberFormat org$locationtech$geomesa$tools$export$ExportJob$$jobIdFormat;
    private final NumberFormat org$locationtech$geomesa$tools$export$ExportJob$$taskIdFormat;

    static {
        new ExportJob$();
    }

    public void setLibJars(Job job, Seq<String> fileNames, Iterator<Function0<Seq<File>>> searchPath) {
        JobWithLibJars.class.setLibJars((JobWithLibJars)this, (Job)job, fileNames, searchPath);
    }

    public NumberFormat org$locationtech$geomesa$tools$export$ExportJob$$jobIdFormat() {
        return this.org$locationtech$geomesa$tools$export$ExportJob$$jobIdFormat;
    }

    public NumberFormat org$locationtech$geomesa$tools$export$ExportJob$$taskIdFormat() {
        return this.org$locationtech$geomesa$tools$export$ExportJob$$taskIdFormat;
    }

    public Job configure(Job job, Map<String, String> dsParams, SimpleFeatureType sft, Hints hints, String filename, Path output, ExportFormat format, boolean headers, Option<Object> chunks, Option<Object> gzip, int reducers, Seq<String> libjarsFiles, Iterator<Function0<Seq<File>>> libjarsPaths2) {
        block8: {
            Option option;
            block11: {
                Configuration conf;
                block10: {
                    BoxedUnit boxedUnit;
                    block9: {
                        conf = job.getConfiguration();
                        this.setLibJars(job, libjarsFiles, libjarsPaths2);
                        conf.set("mapreduce.job.user.classpath.first", "true");
                        job.setJarByClass(this.getClass());
                        job.setMapperClass(ExportJob.PassThroughMapper.class);
                        job.setOutputFormatClass(ExportJob.ExportOutputFormat.class);
                        job.setOutputKeyClass(Text.class);
                        job.setOutputValueClass(ScalaSimpleFeature.class);
                        FileOutputFormat.setOutputPath((Job)job, (Path)output);
                        ExportJob$Config$.MODULE$.setOutputFile(conf, filename);
                        ExportJob$Config$.MODULE$.setFormat(conf, format);
                        ExportJob$Config$.MODULE$.setHeaders(conf, headers);
                        chunks.foreach((Function1)new Serializable(conf){
                            public static final long serialVersionUID = 0L;
                            private final Configuration conf$1;

                            public final void apply(long x$1) {
                                this.apply$mcVJ$sp(x$1);
                            }

                            public void apply$mcVJ$sp(long x$1) {
                                ExportJob$Config$.MODULE$.setChunks(this.conf$1, x$1);
                            }
                            {
                                this.conf$1 = conf$1;
                            }
                        });
                        gzip.foreach((Function1)new Serializable(conf){
                            public static final long serialVersionUID = 0L;
                            private final Configuration conf$1;

                            public final void apply(int x$2) {
                                this.apply$mcVI$sp(x$2);
                            }

                            public void apply$mcVI$sp(int x$2) {
                                ExportJob$Config$.MODULE$.setGzip(this.conf$1, x$2);
                            }
                            {
                                this.conf$1 = conf$1;
                            }
                        });
                        ExportJob$Config$.MODULE$.setQueryHints(conf, hints);
                        if (conf.get(GeoMesaConfigurator.Keys$.MODULE$.FeatureReducer()) != null) break block8;
                        option = GeoMesaConfigurator$.MODULE$.getSorting(conf);
                        if (!None$.MODULE$.equals(option)) break block9;
                        job.setNumReduceTasks(0);
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        break block10;
                    }
                    if (!(option instanceof Some)) break block11;
                    Some some = (Some)option;
                    Seq sort = (Seq)some.x();
                    Predef$.MODULE$.require(reducers > 0, (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Reducers must be a positive number";
                        }
                    });
                    job.setNumReduceTasks(reducers);
                    job.setReducerClass(Reducer.class);
                    job.setMapperClass(ExportJob.SortKeyMapper.class);
                    Seq sortBy = (Seq)sort.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<String, Object> x$3) {
                            return (String)x$3._1();
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    boolean reverse = ((Tuple2)sort.head())._2$mcZ$sp();
                    if (sortBy.exists((Function1)new Serializable(sft){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType sft$1;

                        public final boolean apply(String x$4) {
                            return this.sft$1.indexOf(x$4) == -1;
                        }
                        {
                            this.sft$1 = sft$1;
                        }
                    })) {
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to sort by non-existing property: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sortBy.mkString(", ")})));
                    }
                    if (sort.exists((Function1)new Serializable(reverse){
                        public static final long serialVersionUID = 0L;
                        private final boolean reverse$1;

                        public final boolean apply(Tuple2<String, Object> x$5) {
                            return x$5._2$mcZ$sp() != this.reverse$1;
                        }
                        {
                            this.reverse$1 = reverse$1;
                        }
                    })) {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sort order is required to be the same across all sort properties: "})).s((Seq)Nil$.MODULE$)).append((Object)QueryHints$.MODULE$.sortReadableString(sort)).toString());
                    }
                    if (reverse) {
                        job.setSortComparatorClass(ExportJob.ReverseComparator.class);
                    }
                    if (reducers > 1) {
                        TotalOrderPartitioner.setPartitionFile((Configuration)conf, (Path)new Path(FileOutputFormat.getOutputPath((JobContext)job), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".partitions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UUID.randomUUID()}))));
                        InputSampler.writePartitionFile((Job)job, (InputSampler.Sampler)new ExportJob.FallbackSampler(0.01, 1000, 100));
                        job.setPartitionerClass(TotalOrderPartitioner.class);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                }
                job.setMapSpeculativeExecution(false);
                job.setReduceSpeculativeExecution(false);
                conf.set("mapreduce.job.reduce.slowstart.completedmaps", ".90");
                return job;
            }
            throw new MatchError((Object)option);
        }
        throw new IllegalArgumentException("Query requires a feature reduce step, which is not supported in this job");
    }

    /*
     * WARNING - void declaration
     */
    private NumberFormat createFormat(int digits) {
        void var2_2;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(digits);
        nf.setGroupingUsed(false);
        return var2_2;
    }

    private ExportJob$() {
        MODULE$ = this;
        JobWithLibJars.class.$init$((JobWithLibJars)this);
        this.org$locationtech$geomesa$tools$export$ExportJob$$jobIdFormat = this.createFormat(4);
        this.org$locationtech$geomesa$tools$export$ExportJob$$taskIdFormat = this.createFormat(5);
    }
}

