/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.locationtech.geomesa.tools.export.formats.DelimitedExporter$;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u0001=\u0011\u0011\u0003R3mS6LG/\u001a3FqB|'\u000f^3s\u0015\t\u0019A!A\u0004g_Jl\u0017\r^:\u000b\u0005\u00151\u0011AB3ya>\u0014HO\u0003\u0002\b\u0011\u0005)Ao\\8mg*\u0011\u0011BC\u0001\bO\u0016|W.Z:b\u0015\tYA\"\u0001\u0007m_\u000e\fG/[8oi\u0016\u001c\u0007NC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001C\n\t\u0003#\rr!AE\u0011\u000f\u0005M\u0001cB\u0001\u000b \u001d\t)bD\u0004\u0002\u0017;9\u0011q\u0003\b\b\u00031mi\u0011!\u0007\u0006\u000359\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u00111\u0001B\u0005\u0003E\t\tqBR3biV\u0014X-\u0012=q_J$XM]\u0005\u0003I\u0015\u00121CQ=uK\u000e{WO\u001c;fe\u0016C\bo\u001c:uKJT!A\t\u0002\u0011\u0005\u001drS\"\u0001\u0015\u000b\u0005%R\u0013\u0001D:dC2\fGn\\4hS:<'BA\u0016-\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0017\u0002\u0007\r|W.\u0003\u00020Q\tYA*\u0019>z\u0019><w-\u001b8h\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014AB:ue\u0016\fW\u000e\u0005\u0002\u0012g%\u0011A'\n\u0002\r\u000bb\u0004xN\u001d;TiJ,\u0017-\u001c\u0005\tm\u0001\u0011\t\u0011)A\u0005o\u00051am\u001c:nCR\u0004\"\u0001O \u000e\u0003eR!AO\u001e\u0002\u0007\r\u001chO\u0003\u0002={\u000591m\\7n_:\u001c(B\u0001 \r\u0003\u0019\t\u0007/Y2iK&\u0011\u0001)\u000f\u0002\n\u0007N3fi\u001c:nCRD\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IaQ\u0001\u000bo&$\b\u000eS3bI\u0016\u0014\bC\u0001#H\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%a\u0002\"p_2,\u0017M\u001c\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\u0007\u0006Q\u0011N\\2mk\u0012,\u0017\nZ:\t\u000b1\u0003A\u0011A'\u0002\rqJg.\u001b;?)\u0015q\u0005+\u0015*T!\ty\u0005!D\u0001\u0003\u0011\u0015\t4\n1\u00013\u0011\u001514\n1\u00018\u0011\u0015\u00115\n1\u0001D\u0011\u0015Q5\n1\u0001D\u0011%)\u0006\u00011AA\u0002\u0013%a+A\u0004qe&tG/\u001a:\u0016\u0003]\u0003\"\u0001\u000f-\n\u0005eK$AC\"T-B\u0013\u0018N\u001c;fe\"I1\f\u0001a\u0001\u0002\u0004%I\u0001X\u0001\faJLg\u000e^3s?\u0012*\u0017\u000f\u0006\u0002^AB\u0011AIX\u0005\u0003?\u0016\u0013A!\u00168ji\"9\u0011MWA\u0001\u0002\u00049\u0016a\u0001=%c!11\r\u0001Q!\n]\u000b\u0001\u0002\u001d:j]R,'\u000f\t\u0005\u0006K\u0002!\tEZ\u0001\u0006gR\f'\u000f\u001e\u000b\u0003;\u001eDQ\u0001\u001b3A\u0002%\f1a\u001d4u!\tQ\u0017/D\u0001l\u0015\taW.\u0001\u0004tS6\u0004H.\u001a\u0006\u0003]>\fqAZ3biV\u0014XM\u0003\u0002q\u0019\u00059q\u000e]3oO&\u001c\u0018B\u0001:l\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/\u001a\u0005\u0006\u000b\u0001!\t\u0005\u001e\u000b\u0003kn\u00042\u0001\u0012<y\u0013\t9XI\u0001\u0004PaRLwN\u001c\t\u0003\tfL!A_#\u0003\t1{gn\u001a\u0005\u0006yN\u0004\r!`\u0001\tM\u0016\fG/\u001e:fgB)a0a\u0002\u0002\u000e9\u0019q0a\u0001\u000f\u0007a\t\t!C\u0001G\u0013\r\t)!R\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI!a\u0003\u0003\u0011%#XM]1u_JT1!!\u0002F!\rQ\u0017qB\u0005\u0004\u0003#Y'!D*j[BdWMR3biV\u0014X\rC\u0004\u0002\u0016\u0001!\t%a\u0006\u0002\u000b\rdwn]3\u0015\u0003uCq!a\u0007\u0001\t\u0013\ti\"A\u0005tiJLgnZ5gsR!\u0011qDA\u0017!\u0011\t\t#a\n\u000f\u0007\u0011\u000b\u0019#C\u0002\u0002&\u0015\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0015\u0003W\u0011aa\u0015;sS:<'bAA\u0013\u000b\"A\u0011qFA\r\u0001\u0004\t\t$A\u0002pE*\u00042\u0001RA\u001a\u0013\r\t)$\u0012\u0002\u0004\u0003:LxaBA\u001d\u0005!\u0005\u00111H\u0001\u0012\t\u0016d\u0017.\\5uK\u0012,\u0005\u0010]8si\u0016\u0014\bcA(\u0002>\u00191\u0011A\u0001E\u0001\u0003\u007f\u0019B!!\u0010\u0002BA\u0019A)a\u0011\n\u0007\u0005\u0015SI\u0001\u0004B]f\u0014VM\u001a\u0005\b\u0019\u0006uB\u0011AA%)\t\tY\u0004C\u0004;\u0003{!\t!!\u0014\u0015\u000f9\u000by%!\u0015\u0002T!1\u0011'a\u0013A\u0002IBaAQA&\u0001\u0004\u0019\u0005\u0002\u0003&\u0002LA\u0005\t\u0019A\"\t\u0011\u0005]\u0013Q\bC\u0001\u00033\n1\u0001^:w)\u001dq\u00151LA/\u0003?Ba!MA+\u0001\u0004\u0011\u0004B\u0002\"\u0002V\u0001\u00071\t\u0003\u0005K\u0003+\u0002\n\u00111\u0001D\u0011)\t\u0019'!\u0010\u0012\u0002\u0013\u0005\u0011QM\u0001\u000eGN4H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u001d$fA\"\u0002j-\u0012\u00111\u000e\t\u0005\u0003[\n9(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003%)hn\u00195fG.,GMC\u0002\u0002v\u0015\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tI(a\u001c\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0002~\u0005u\u0012\u0013!C\u0001\u0003K\nQ\u0002^:wI\u0011,g-Y;mi\u0012\u001a\u0004")
public class DelimitedExporter
extends FeatureExporter.ByteCounterExporter
implements LazyLogging {
    private final FeatureExporter.ExportStream stream;
    private final CSVFormat format;
    private final boolean withHeader;
    public final boolean org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$includeIds;
    private CSVPrinter org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static boolean tsv$default$3() {
        return DelimitedExporter$.MODULE$.tsv$default$3();
    }

    public static boolean csv$default$3() {
        return DelimitedExporter$.MODULE$.csv$default$3();
    }

    public static DelimitedExporter tsv(FeatureExporter.ExportStream exportStream, boolean bl, boolean bl2) {
        return DelimitedExporter$.MODULE$.tsv(exportStream, bl, bl2);
    }

    public static DelimitedExporter csv(FeatureExporter.ExportStream exportStream, boolean bl, boolean bl2) {
        return DelimitedExporter$.MODULE$.csv(exportStream, bl, bl2);
    }

    private Logger logger$lzycompute() {
        DelimitedExporter delimitedExporter = this;
        synchronized (delimitedExporter) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public CSVPrinter org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer() {
        return this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer;
    }

    private void org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer_$eq(CSVPrinter x$1) {
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer = x$1;
    }

    @Override
    public void start(SimpleFeatureType sft) {
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer_$eq(this.format.print((Appendable)new OutputStreamWriter(this.stream.os(), StandardCharsets.UTF_8)));
        if (this.withHeader) {
            if (this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$includeIds) {
                this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().print((Object)"id");
            }
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).foreach((Function1)new Serializable(this, sft){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedExporter $outer;
                private final SimpleFeatureType sft$1;

                public final void apply(AttributeDescriptor descriptor) {
                    this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().print((Object)SimpleFeatureTypes$.MODULE$.encodeDescriptor(this.sft$1, descriptor));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.sft$1 = sft$1;
                }
            });
            this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().println();
            this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().flush();
        }
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        BoxedUnit boxedUnit;
        LongRef count2 = LongRef.create((long)0L);
        features.foreach((Function1)new Serializable(this, count2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelimitedExporter $outer;
            private final LongRef count$1;

            public final void apply(SimpleFeature sf) {
                if (this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$includeIds) {
                    this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().print((Object)sf.getID());
                }
                for (int i = 0; i < sf.getAttributeCount(); ++i) {
                    this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().print((Object)this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(sf.getAttribute(i)));
                }
                this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().println();
                ++this.count$1.elem;
                if (this.count$1.elem % 10000L == 0L) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("wrote {} features", new Object[]{BoxesRunTime.boxToLong((long)this.count$1.elem)});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.count$1 = count$1;
            }
        });
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().flush();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Exported {} features", new Object[]{BoxesRunTime.boxToLong((long)count2.elem)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)count2.elem));
    }

    @Override
    public void close() {
        if (this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer() != null) {
            this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$printer().close();
        }
    }

    public String org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(Object obj) {
        String string;
        Object object = obj;
        if (object == null) {
            string = "";
        } else if (object instanceof Geometry) {
            Geometry geometry = (Geometry)object;
            string = WKTUtils$.MODULE$.write(geometry);
        } else if (object instanceof Date) {
            Date date = (Date)object;
            string = package$.MODULE$.GeoToolsDateFormat().format(Instant.ofEpochMilli(date.getTime()).atZone(ZoneOffset.UTC));
        } else if (object instanceof List) {
            List list = (List)object;
            string = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedExporter $outer;

                public final String apply(Object obj) {
                    return this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(obj);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(",");
        } else if (object instanceof Map) {
            Map map2 = (Map)object;
            string = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map2).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelimitedExporter $outer;

                public final String apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "->", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(k), this.$outer.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$stringify(v)}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
        } else {
            string = obj.toString();
        }
        return string;
    }

    public DelimitedExporter(FeatureExporter.ExportStream stream, CSVFormat format, boolean withHeader, boolean includeIds) {
        this.stream = stream;
        this.format = format;
        this.withHeader = withHeader;
        this.org$locationtech$geomesa$tools$export$formats$DelimitedExporter$$includeIds = includeIds;
        super(stream);
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

