/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.stats;

import com.beust.jcommander.ParameterException;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata$;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.tools.stats.StatsAnalyzeCommand;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.stats.CountStat;
import org.locationtech.geomesa.utils.stats.MinMax;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;

public abstract class StatsAnalyzeCommand$class {
    public static void execute(StatsAnalyzeCommand $this) {
        $this.withDataStore(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsAnalyzeCommand $outer;

            public final void apply(DS ds) {
                StatsAnalyzeCommand$class.org$locationtech$geomesa$tools$stats$StatsAnalyzeCommand$$analyze(this.$outer, ds);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void org$locationtech$geomesa$tools$stats$StatsAnalyzeCommand$$analyze(StatsAnalyzeCommand $this, GeoMesaDataStore ds) {
        Seq seq;
        SimpleFeatureType sft = ds.getSchema($this.params().featureName());
        if (sft == null) {
            throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.params().featureName()})));
        }
        package$Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running stat analysis for feature type ", "..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()})));
        if (StatsAnalyzeCommand$class.noStats$1($this, ds, sft)) {
            while (StatsAnalyzeCommand$class.noStats$1($this, ds, sft)) {
                Thread.sleep(1000L);
            }
            Thread.sleep(1000L);
            Buffer queries = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply(AttributeDescriptor d) {
                    return Stat$.MODULE$.MinMax(d.getLocalName());
                }
            }, Buffer$.MODULE$.canBuildFrom());
            GeoMesaStats qual$1 = ds.stats();
            SimpleFeatureType x$1 = sft;
            String x$2 = Stat$.MODULE$.Count();
            Filter x$3 = qual$1.getStat$default$3();
            boolean x$4 = qual$1.getStat$default$4();
            GeoMesaStats qual$2 = ds.stats();
            SimpleFeatureType x$5 = sft;
            Seq x$6 = queries.toSeq();
            Filter x$7 = qual$2.getSeqStat$default$3();
            boolean x$8 = qual$2.getSeqStat$default$4();
            seq = (Iterable)Option$.MODULE$.option2Iterable(qual$1.getStat(x$1, x$2, x$3, x$4)).$plus$plus((GenTraversableOnce)qual$2.getSeqStat(x$5, x$6, x$7, x$8), Iterable$.MODULE$.canBuildFrom());
        } else {
            seq = ds.stats().writer().analyze(sft);
        }
        Seq stats2 = seq;
        Iterable strings = (Iterable)stats2.collect((PartialFunction)new Serializable($this, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final <A1 extends Stat, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof CountStat) {
                    CountStat countStat = (CountStat)A1;
                    object = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total features: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)countStat.count())}));
                } else if (A1 instanceof MinMax) {
                    String string;
                    MinMax minMax = (MinMax)A1;
                    if (minMax.isEmpty()) {
                        string = "[ no matching data ]";
                    } else {
                        String string2 = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1));
                        String string3 = minMax.property();
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            Envelope e = ((Geometry)minMax.min()).getEnvelopeInternal();
                            e.expandToInclude(((Geometry)minMax.max()).getEnvelopeInternal());
                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ ", ", ", ", ", ", ", " ] cardinality: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)e.getMinX()), BoxesRunTime.boxToDouble((double)e.getMinY()), BoxesRunTime.boxToDouble((double)e.getMaxX()), BoxesRunTime.boxToDouble((double)e.getMaxY()), BoxesRunTime.boxToLong((long)minMax.cardinality())}));
                        } else {
                            Function1 stringify2 = Stat$.MODULE$.stringifier(this.sft$1.getDescriptor(minMax.property()).getType().getBinding(), Stat$.MODULE$.stringifier$default$2());
                            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ ", " to ", " ] cardinality: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stringify2.apply(minMax.min()), stringify2.apply(minMax.max()), BoxesRunTime.boxToLong((long)minMax.cardinality())}));
                        }
                    }
                    String bounds = string;
                    object = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bounds for ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{minMax.property(), bounds}));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Stat x1) {
                Stat stat = x1;
                boolean bl = stat instanceof CountStat ? true : stat instanceof MinMax;
                return bl;
            }
            {
                this.sft$1 = sft$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        package$Command$.MODULE$.user().info("Stats analyzed:");
        package$Command$.MODULE$.output().info(strings.mkString("  ", "\n  ", ""));
        package$Command$.MODULE$.user().info("Use 'stats-histogram', 'stats-top-k' or 'stats-count' commands for more details");
    }

    private static final boolean noStats$1(StatsAnalyzeCommand $this, GeoMesaDataStore ds$1, SimpleFeatureType sft$1) {
        return ds$1.metadata().read(sft$1.getTypeName(), GeoMesaMetadata$.MODULE$.StatsGenerationKey(), false).isEmpty();
    }

    public static void $init$(StatsAnalyzeCommand $this) {
        $this.org$locationtech$geomesa$tools$stats$StatsAnalyzeCommand$_setter_$name_$eq("stats-analyze");
    }
}

