/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.status;

import com.beust.jcommander.ParameterException;
import java.util.Map;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.index.attribute.AttributeIndex$;
import org.locationtech.geomesa.index.index.z2.XZ2Index$;
import org.locationtech.geomesa.index.index.z2.Z2Index$;
import org.locationtech.geomesa.index.index.z3.XZ3Index$;
import org.locationtech.geomesa.index.index.z3.Z3Index$;
import org.locationtech.geomesa.tools.TypeNameParam;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.tools.status.DescribeSchemaCommand;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class DescribeSchemaCommand$class {
    public static void execute(DescribeSchemaCommand $this) {
        $this.withDataStore(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeSchemaCommand $outer;

            public final void apply(DS ds) {
                SimpleFeatureType sft = this.$outer.getSchema(ds);
                if (sft == null) {
                    String string;
                    Object object = this.$outer.params();
                    if (object instanceof TypeNameParam) {
                        TypeNameParam typeNameParam = (TypeNameParam)object;
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Feature '", "' not found"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typeNameParam.featureName()}));
                    } else {
                        string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Feature type not found"})).s((Seq)Nil$.MODULE$);
                    }
                    String msg = string;
                    throw new ParameterException(msg);
                }
                package$Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Describing attributes of feature '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sft.getTypeName()})));
                this.$outer.describe(ds, sft, (Function1<String, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(String x$1) {
                        package$Command$.MODULE$.output().info(x$1);
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static SimpleFeatureType getSchema(DescribeSchemaCommand $this, DataStore ds) {
        Object object = $this.params();
        if (object instanceof TypeNameParam) {
            TypeNameParam typeNameParam = (TypeNameParam)object;
            SimpleFeatureType simpleFeatureType = ds.getSchema(typeNameParam.featureName());
            return simpleFeatureType;
        }
        throw new MatchError(object);
    }

    public static void describe(DescribeSchemaCommand $this, DataStore ds, SimpleFeatureType sft, Function1 output) {
        Seq seq;
        DataStore dataStore = ds;
        if (dataStore instanceof GeoMesaDataStore) {
            GeoMesaDataStore geoMesaDataStore = (GeoMesaDataStore)dataStore;
            seq = geoMesaDataStore.manager().indices(sft, geoMesaDataStore.manager().indices$default$2());
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        Seq indices = seq;
        Buffer namesAndDescriptions = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1)new Serializable($this, indices){
            public static final long serialVersionUID = 0L;
            private final Seq indices$1;

            public final Tuple3<String, String, String> apply(AttributeDescriptor descriptor) {
                String name2 = descriptor.getLocalName();
                ArrayBuffer description = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                this.indices$1.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;
                    private final ArrayBuffer description$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final void apply(GeoMesaFeatureIndex<?, ?> x0$1) {
                        GeoMesaFeatureIndex<?, ?> geoMesaFeatureIndex;
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        geoMesaFeatureIndex = x0$1;
                                        String string = geoMesaFeatureIndex.name();
                                        String string2 = Z3Index$.MODULE$.name();
                                        if (!(string == null ? string2 != null : !string.equals(string2))) break block10;
                                        String string3 = geoMesaFeatureIndex.name();
                                        String string4 = XZ3Index$.MODULE$.name();
                                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block11;
                                    }
                                    if (((SeqLike)geoMesaFeatureIndex.attributes().take(2)).contains((Object)this.name$1)) {
                                        this.description$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(Spatio-temporally indexed)"}));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                }
                                String string = geoMesaFeatureIndex.name();
                                String string5 = Z2Index$.MODULE$.name();
                                if (!(string == null ? string5 != null : !string.equals(string5))) break block12;
                                String string6 = geoMesaFeatureIndex.name();
                                String string7 = XZ2Index$.MODULE$.name();
                                if (string6 != null ? !string6.equals(string7) : string7 != null) break block13;
                            }
                            if (geoMesaFeatureIndex.attributes().headOption().contains((Object)this.name$1)) {
                                this.description$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(Spatially indexed)"}));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                        String string = geoMesaFeatureIndex.name();
                        String string8 = AttributeIndex$.MODULE$.name();
                        if (!(string != null ? !string.equals(string8) : string8 != null) && geoMesaFeatureIndex.attributes().headOption().contains((Object)this.name$1)) {
                            this.description$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(Attribute indexed)"}));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        String string9 = geoMesaFeatureIndex.name();
                        String string10 = AttributeIndex$.MODULE$.JoinIndexName();
                        if (!(string9 != null ? !string9.equals(string10) : string10 != null) && geoMesaFeatureIndex.attributes().headOption().contains((Object)this.name$1)) {
                            this.description$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(Attribute indexed - join)"}));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    {
                        this.name$1 = name$1;
                        this.description$1 = description$1;
                    }
                });
                Option$.MODULE$.apply(descriptor.getDefaultValue()).foreach((Function1)new Serializable(this, description){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBuffer description$1;

                    public final void apply(Object v) {
                        this.description$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Default Value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v}))}));
                    }
                    {
                        this.description$1 = description$1;
                    }
                });
                return new Tuple3((Object)name2, (Object)descriptor.getType().getBinding().getSimpleName(), (Object)description.mkString(" "));
            }
            {
                this.indices$1 = indices$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        int maxName = BoxesRunTime.unboxToInt((Object)((TraversableOnce)namesAndDescriptions.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple3<String, String, String> x$1) {
                return ((String)x$1._1()).length();
            }
        }, Buffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        int maxType = BoxesRunTime.unboxToInt((Object)((TraversableOnce)namesAndDescriptions.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple3<String, String, String> x$2) {
                return ((String)x$2._2()).length();
            }
        }, Buffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        namesAndDescriptions.foreach((Function1)new Serializable($this, maxName, maxType, output){
            public static final long serialVersionUID = 0L;
            private final int maxName$1;
            private final int maxType$1;
            private final Function1 output$1;

            public final void apply(Tuple3<String, String, String> x0$2) {
                Tuple3<String, String, String> tuple3 = x0$2;
                if (tuple3 != null) {
                    String n = (String)tuple3._1();
                    String t = (String)tuple3._2();
                    String d = (String)tuple3._3();
                    BoxedUnit boxedUnit = (BoxedUnit)this.output$1.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " | ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString(n)).padTo(this.maxName$1, (Object)BoxesRunTime.boxToCharacter((char)' '), Predef$.MODULE$.StringCanBuildFrom()), new StringOps(Predef$.MODULE$.augmentString(t)).padTo(this.maxType$1, (Object)BoxesRunTime.boxToCharacter((char)' '), Predef$.MODULE$.StringCanBuildFrom()), d})));
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                void var4_4;
                this.maxName$1 = maxName$1;
                this.maxType$1 = maxType$1;
                this.output$1 = var4_4;
            }
        });
        Map userData = sft.getUserData();
        if (!userData.isEmpty()) {
            output.apply((Object)"\nUser data:");
            Seq namesAndValues = (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(userData).asScala()).toSeq().map((Function1)new Serializable($this, sft){
                public static final long serialVersionUID = 0L;
                private final SimpleFeatureType sft$1;

                public final Tuple2<String, String> apply(Tuple2<Object, Object> x0$3) {
                    Tuple2<Object, Object> tuple2 = x0$3;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        Object object = k;
                        String string = SimpleFeatureTypes.Configs$.MODULE$.Keywords();
                        Tuple2 tuple22 = !(object != null ? !object.equals(string) : string != null) ? new Tuple2((Object)SimpleFeatureTypes.Configs$.MODULE$.Keywords(), (Object)RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getKeywords$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1)).mkString("'", "', '", "'")) : new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k})), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v})));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.sft$1 = sft$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            int maxName2 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)namesAndValues.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<String, String> x$3) {
                    return ((String)x$3._1()).length();
                }
            }, Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
            ((IterableLike)namesAndValues.sortBy((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, String> x$4) {
                    return (String)x$4._1();
                }
            }, (Ordering)Ordering.String$.MODULE$)).foreach((Function1)new Serializable($this, maxName2, output){
                public static final long serialVersionUID = 0L;
                private final int maxName$2;
                private final Function1 output$1;

                public final void apply(Tuple2<String, String> x0$4) {
                    Tuple2<String, String> tuple2 = x0$4;
                    if (tuple2 != null) {
                        String n = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        BoxedUnit boxedUnit = (BoxedUnit)this.output$1.apply((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", " | ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString(n)).padTo(this.maxName$2, (Object)BoxesRunTime.boxToCharacter((char)' '), Predef$.MODULE$.StringCanBuildFrom()), v})));
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    void var3_3;
                    this.maxName$2 = maxName$2;
                    this.output$1 = var3_3;
                }
            });
        }
    }

    public static void $init$(DescribeSchemaCommand $this) {
        $this.org$locationtech$geomesa$tools$status$DescribeSchemaCommand$_setter_$name_$eq("describe-schema");
    }
}

