/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.utils;

import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.locationtech.geomesa.jobs.package;
import org.locationtech.geomesa.tools.package$Command$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JobRunner$ {
    public static final JobRunner$ MODULE$;

    static {
        new JobRunner$();
    }

    public package.JobResult run(Job job, package.StatusCallback reporter, Function0<Seq<Tuple2<String, Object>>> mapCounters2, Function0<Seq<Tuple2<String, Object>>> reduceCounters) {
        this.submit(job);
        return this.monitor(job, reporter, mapCounters2, reduceCounters);
    }

    public void submit(Job job) {
        package$Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Submitting job '", "' - please wait..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{job.getJobName()})));
        job.submit();
        package$Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tracking available at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{job.getStatus().getTrackingUrl()})));
    }

    public package.JobResult monitor(Job job, package.StatusCallback reporter, Function0<Seq<Tuple2<String, Object>>> mapCounters2, Function0<Seq<Tuple2<String, Object>>> reduceCounters) {
        Object status;
        Object object;
        if (job.getNumReduceTasks() != 0) {
            BooleanRef mapping = BooleanRef.create((boolean)true);
            object = new Serializable(job, reporter, mapCounters2, reduceCounters, mapping){
                public static final long serialVersionUID = 0L;
                private final Job job$1;
                private final package.StatusCallback reporter$1;
                private final Function0 mapCounters$1;
                private final Function0 reduceCounters$1;
                private final BooleanRef mapping$1;

                public final void apply(boolean done) {
                    if (this.mapping$1.elem) {
                        float mapProgress = this.job$1.mapProgress();
                        if (mapProgress < 1.0f) {
                            this.reporter$1.apply("Map:    ", mapProgress, (Seq)this.mapCounters$1.apply(), false);
                        } else {
                            this.reporter$1.apply("Map:    ", mapProgress, (Seq)this.mapCounters$1.apply(), true);
                            this.reporter$1.reset();
                            this.mapping$1.elem = false;
                        }
                    } else {
                        this.reporter$1.apply("Reduce: ", this.job$1.reduceProgress(), (Seq)this.reduceCounters$1.apply(), done);
                    }
                }
                {
                    this.job$1 = job$1;
                    this.reporter$1 = reporter$1;
                    this.mapCounters$1 = mapCounters$1;
                    this.reduceCounters$1 = reduceCounters$1;
                    this.mapping$1 = mapping$1;
                }
            };
        } else {
            object = status = new Serializable(job, reporter, mapCounters2, reduceCounters){
                public static final long serialVersionUID = 0L;
                private final Job job$1;
                private final package.StatusCallback reporter$1;
                private final Function0 mapCounters$1;
                private final Function0 reduceCounters$1;

                public final void apply(boolean done) {
                    this.reporter$1.apply("", this.job$1.mapProgress(), (Seq)((TraversableLike)this.mapCounters$1.apply()).$plus$plus((GenTraversableOnce)this.reduceCounters$1.apply(), Seq$.MODULE$.canBuildFrom()), done);
                }
                {
                    this.job$1 = job$1;
                    this.reporter$1 = reporter$1;
                    this.mapCounters$1 = mapCounters$1;
                    this.reduceCounters$1 = reduceCounters$1;
                }
            };
        }
        while (true) {
            if (job.isComplete()) {
                status.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                return job.isSuccessful() ? new package.JobResult$.JobSuccess("", ((TraversableOnce)((TraversableLike)mapCounters2.apply()).$plus$plus((GenTraversableOnce)reduceCounters.apply(), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())) : new package.JobResult$.JobFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Job failed with state ", " due to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{job.getStatus().getState(), job.getStatus().getFailureInfo()})));
            }
            JobStatus.State state = job.getStatus().getState();
            JobStatus.State state2 = JobStatus.State.PREP;
            Object object2 = !(state != null ? !state.equals(state2) : state2 != null) ? BoxedUnit.UNIT : status.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Thread.sleep(500L);
        }
    }

    private JobRunner$() {
        MODULE$ = this;
    }
}

