/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.utils;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;
import org.locationtech.geomesa.jobs.package;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.tools.utils.JobRunner$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.Nothing$;

public final class StorageJobUtils$
implements LazyLogging {
    public static final StorageJobUtils$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new StorageJobUtils$();
    }

    private Logger logger$lzycompute() {
        StorageJobUtils$ storageJobUtils$ = this;
        synchronized (storageJobUtils$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public package.JobResult distCopy(Path srcRoot, Path destRoot, package.StatusCallback statusCallback, Configuration conf) {
        statusCallback.reset();
        package$Command$.MODULE$.user().info("Submitting job 'DistCp' - please wait...");
        DistCpOptions opts = this.distCpOptions(srcRoot, destRoot);
        Job job = new DistCp(conf, opts).execute();
        package$Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tracking available at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{job.getStatus().getTrackingUrl()})));
        return JobRunner$.MODULE$.monitor(job, statusCallback, (Function0<Seq<Tuple2<String, Object>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        }, (Function0<Seq<Tuple2<String, Object>>>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        }).merge((Function0)new Serializable(destRoot){
            public static final long serialVersionUID = 0L;
            private final Path destRoot$1;

            public final Some<package.JobResult$.JobSuccess> apply() {
                return new Some((Object)new package.JobResult$.JobSuccess(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully copied data to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.destRoot$1})), Predef$.MODULE$.Map().empty()));
            }
            {
                this.destRoot$1 = destRoot$1;
            }
        });
    }

    public Configuration distCopy$default$4() {
        return new Configuration();
    }

    private DistCpOptions distCpOptions(Path src, Path dest) {
        DistCpOptions distCpOptions;
        try {
            distCpOptions = this.distCpOptions3(src, dest);
        }
        catch (ClassNotFoundException classNotFoundException) {
            distCpOptions = this.distCpOptions2(src, dest);
        }
        return distCpOptions;
    }

    private DistCpOptions distCpOptions3(Path src, Path dest) {
        Class<?> clas = Class.forName("org.apache.hadoop.tools.DistCpOptions$Builder");
        Constructor<?> constructor = clas.getConstructor(List.class, Path.class);
        Object builder = constructor.newInstance(Collections.singletonList(src), dest);
        clas.getMethod("withAppend", Boolean.TYPE).invoke(builder, Boolean.FALSE);
        clas.getMethod("withOverwrite", Boolean.TYPE).invoke(builder, Boolean.TRUE);
        clas.getMethod("withBlocking", Boolean.TYPE).invoke(builder, Boolean.FALSE);
        clas.getMethod("withCopyStrategy", String.class).invoke(builder, "dynamic");
        return (DistCpOptions)clas.getMethod("build", new Class[0]).invoke(builder, new Object[0]);
    }

    private DistCpOptions distCpOptions2(Path src, Path dest) {
        Constructor constructor = DistCpOptions.class.getConstructor(List.class, Path.class);
        DistCpOptions opts = (DistCpOptions)constructor.newInstance(Collections.singletonList(src), dest);
        DistCpOptions.class.getMethod("setAppend", Boolean.TYPE).invoke((Object)opts, Boolean.FALSE);
        DistCpOptions.class.getMethod("setOverwrite", Boolean.TYPE).invoke((Object)opts, Boolean.TRUE);
        DistCpOptions.class.getMethod("setCopyStrategy", String.class).invoke((Object)opts, "dynamic");
        return opts;
    }

    private StorageJobUtils$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

