/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import java.io.File;
import java.io.Serializable;
import org.apache.commons.io.FilenameUtils;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.sys.package$;

public final class LeafletMapExporter$ {
    public static LeafletMapExporter$ MODULE$;
    private String[] Template;
    private String IndexHead;
    private String IndexTail;
    private final int MaxFeatures;
    private volatile byte bitmap$0;

    static {
        new LeafletMapExporter$();
    }

    private String[] Template$lzycompute() {
        LeafletMapExporter$ leafletMapExporter$ = this;
        synchronized (leafletMapExporter$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.Template = (String[])package.WithClose$.MODULE$.apply((Object)this.getClass().getClassLoader().getResourceAsStream("leaflet/index.html"), (Function1 & Serializable & scala.Serializable)is -> {
                    void var1_1;
                    String[] indexArray = Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString().split("\\|codegen\\|");
                    Predef$.MODULE$.require(indexArray.length == 2, (Function0 & Serializable & scala.Serializable)() -> "Malformed index.html, unable to render map");
                    return var1_1;
                }, IsCloseable$.MODULE$.closeableIsCloseable());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.Template;
    }

    private String[] Template() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.Template$lzycompute() : this.Template;
    }

    private String IndexHead$lzycompute() {
        LeafletMapExporter$ leafletMapExporter$ = this;
        synchronized (leafletMapExporter$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.IndexHead = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.Template())).head();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.IndexHead;
    }

    public String IndexHead() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.IndexHead$lzycompute() : this.IndexHead;
    }

    private String IndexTail$lzycompute() {
        LeafletMapExporter$ leafletMapExporter$ = this;
        synchronized (leafletMapExporter$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.IndexTail = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.Template())).last();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.IndexTail;
    }

    public String IndexTail() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.IndexTail$lzycompute() : this.IndexTail;
    }

    public int MaxFeatures() {
        return this.MaxFeatures;
    }

    public boolean configure(ExportCommand.ExportParams params) {
        String large = "The Leaflet map may exhibit performance issues when displaying large numbers of features. For a more robust solution, consider using GeoServer.";
        if (params.maxFeatures() == null) {
            package$Command$.MODULE$.user().warn(large);
            package$Command$.MODULE$.user().warn(new StringBuilder(65).append("Limiting max features to ").append(this.MaxFeatures()).append(". To override, ").append("please use --max-features").toString());
            params.maxFeatures_$eq(Predef$.MODULE$.int2Integer(this.MaxFeatures()));
        } else if (Predef$.MODULE$.Integer2int(params.maxFeatures()) > this.MaxFeatures()) {
            if (params.force()) {
                package$Command$.MODULE$.user().warn(large);
            } else {
                Object x$3;
                List<String> x$2;
                String x$1 = new StringBuilder(42).append(large).append(" Would you like to continue anyway (y/n)? ").toString();
                if (!Prompt$.MODULE$.confirm(x$1, x$2 = Prompt$.MODULE$.confirm$default$2(), x$3 = Prompt$.MODULE$.confirm$default$3(x$1, x$2))) {
                    return false;
                }
            }
        }
        if (params.gzip() != null) {
            package$Command$.MODULE$.user().warn("Ignoring gzip parameter for Leaflet export");
            params.gzip_$eq(null);
        }
        if (params.file() == null) {
            params.file_$eq((String)package$.MODULE$.props().apply((Object)"user.dir"));
        }
        if (PathUtils$.MODULE$.isRemote(params.file())) {
            if (params.file().endsWith("/")) {
                params.file_$eq(new StringBuilder(10).append(params.file()).append("index.html").toString());
            } else if (FilenameUtils.indexOfExtension((String)params.file()) == -1) {
                params.file_$eq(new StringBuilder(11).append(params.file()).append("/index.html").toString());
            }
        } else {
            File file = new File(params.file());
            File destination = file.isDirectory() || !file.exists() && file.getName().indexOf(".") == -1 ? new File(file, "index.html") : file;
            params.file_$eq(destination.getAbsolutePath());
        }
        return true;
    }

    public String getFeatureInfo(SimpleFeatureType sft) {
        String string;
        scala.collection.mutable.StringBuilder str = new scala.collection.mutable.StringBuilder();
        str.append("    function onEachFeature(feature, layer) {\n");
        if (sft == null) {
            string = str.append("\n    };\n\n").toString();
        } else {
            Buffer attributes = (Buffer)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(sft.getAttributeDescriptors()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getLocalName(), Buffer$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1;
                    A1 A12 = A1 = x1;
                    String string = "geom";
                    Object object = (A12 == null ? string != null : !A12.equals(string)) ? new StringBuilder(26).append("\"").append(A1).append(": \" + feature.properties.").append(A1).toString() : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(String x1) {
                    String string;
                    String string2 = string = x1;
                    String string3 = "geom";
                    boolean bl = string2 == null ? string3 != null : !string2.equals(string3);
                    return bl;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            str.append("        layer.bindPopup(\"ID: \" + feature.id + \"<br>\" + ");
            str.append("\"GEOM: \" + feature.geometry.type + \"[\" + feature.geometry.coordinates + \"]<br>\" + ");
            string = str.append(attributes.mkString(" + \"<br>\" + "));
        }
        str.append(");\n    }\n\n");
        return str.toString();
    }

    private LeafletMapExporter$() {
        MODULE$ = this;
        this.MaxFeatures = 10000;
    }
}

