/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.utils;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;
import org.locationtech.geomesa.jobs.package;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.tools.utils.JobRunner$;
import scala.Function0;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;

public final class StorageJobUtils$
implements LazyLogging {
    public static StorageJobUtils$ MODULE$;
    private Logger logger;
    private volatile boolean bitmap$0;

    static {
        new StorageJobUtils$();
    }

    private Logger logger$lzycompute() {
        StorageJobUtils$ storageJobUtils$ = this;
        synchronized (storageJobUtils$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public package.JobResult distCopy(Path srcRoot, Path destRoot, package.StatusCallback statusCallback, Configuration conf) {
        statusCallback.reset();
        package$Command$.MODULE$.user().info("Submitting job 'DistCp' - please wait...");
        DistCpOptions opts = this.distCpOptions(srcRoot, destRoot);
        Job job = new DistCp(conf, opts).execute();
        package$Command$.MODULE$.user().info(new StringBuilder(22).append("Tracking available at ").append(job.getStatus().getTrackingUrl()).toString());
        return JobRunner$.MODULE$.monitor(job, statusCallback, (Function0<Seq<Tuple2<String, Object>>>)(Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$, (Function0<Seq<Tuple2<String, Object>>>)(Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$).merge((Function0 & Serializable & scala.Serializable)() -> new Some((Object)new package.JobResult$.JobSuccess(new StringBuilder(28).append("Successfully copied data to ").append(destRoot).toString(), Predef$.MODULE$.Map().empty())));
    }

    public Configuration distCopy$default$4() {
        return new Configuration();
    }

    private DistCpOptions distCpOptions(Path src, Path dest) {
        DistCpOptions distCpOptions;
        try {
            distCpOptions = this.distCpOptions3(src, dest);
        }
        catch (ClassNotFoundException classNotFoundException) {
            distCpOptions = this.distCpOptions2(src, dest);
        }
        return distCpOptions;
    }

    private DistCpOptions distCpOptions3(Path src, Path dest) {
        Class<?> clas = Class.forName("org.apache.hadoop.tools.DistCpOptions$Builder");
        Constructor<?> constructor = clas.getConstructor(List.class, Path.class);
        Object builder = constructor.newInstance(Collections.singletonList(src), dest);
        clas.getMethod("withAppend", Boolean.TYPE).invoke(builder, Boolean.FALSE);
        clas.getMethod("withOverwrite", Boolean.TYPE).invoke(builder, Boolean.TRUE);
        clas.getMethod("withBlocking", Boolean.TYPE).invoke(builder, Boolean.FALSE);
        clas.getMethod("withCopyStrategy", String.class).invoke(builder, "dynamic");
        return (DistCpOptions)clas.getMethod("build", new Class[0]).invoke(builder, new Object[0]);
    }

    private DistCpOptions distCpOptions2(Path src, Path dest) {
        Constructor constructor = DistCpOptions.class.getConstructor(List.class, Path.class);
        DistCpOptions opts = (DistCpOptions)constructor.newInstance(Collections.singletonList(src), dest);
        DistCpOptions.class.getMethod("setAppend", Boolean.TYPE).invoke((Object)opts, Boolean.FALSE);
        DistCpOptions.class.getMethod("setOverwrite", Boolean.TYPE).invoke((Object)opts, Boolean.TRUE);
        DistCpOptions.class.getMethod("setCopyStrategy", String.class).invoke((Object)opts, "dynamic");
        return opts;
    }

    private StorageJobUtils$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

