/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.locationtech.geomesa.tools.export.formats.DelimitedExporter$;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.package$;
import org.locationtech.geomesa.utils.text.WKTUtils$;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001\u0002\u000b\u0016\u0001\tB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003T\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011%\u0011\u0007\u00011AA\u0002\u0013%1\rC\u0005h\u0001\u0001\u0007\t\u0019!C\u0005Q\"Ia\u000e\u0001a\u0001\u0002\u0003\u0006K\u0001\u001a\u0005\u0006_\u0002!\t\u0005\u001d\u0005\u00061\u0001!\t% \u0005\b\u0003K\u0001A\u0011IA\u0014\u0011\u001d\tI\u0003\u0001C\u0005\u0003W9q!a\u0012\u0016\u0011\u0003\tIE\u0002\u0004\u0015+!\u0005\u00111\n\u0005\u00075:!\t!a\u0015\t\r-sA\u0011AA+\u0011%\tiFDI\u0001\n\u0003\ty\u0006C\u0004\u0002v9!\t!a\u001e\t\u0013\u0005}d\"%A\u0005\u0002\u0005}#!\u0005#fY&l\u0017\u000e^3e\u000bb\u0004xN\u001d;fe*\u0011acF\u0001\bM>\u0014X.\u0019;t\u0015\tA\u0012$\u0001\u0004fqB|'\u000f\u001e\u0006\u00035m\tQ\u0001^8pYNT!\u0001H\u000f\u0002\u000f\u001d,w.\\3tC*\u0011adH\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002A\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aI\u001d\u0011\u0005\u00112dBA\u00135\u001d\t13G\u0004\u0002(e9\u0011\u0001&\r\b\u0003SAr!AK\u0018\u000f\u0005-rS\"\u0001\u0017\u000b\u00055\n\u0013A\u0002\u001fs_>$h(C\u0001!\u0013\tqr$\u0003\u0002\u001d;%\u0011!dG\u0005\u00031eI!AF\f\n\u0005U*\u0012a\u0004$fCR,(/Z#ya>\u0014H/\u001a:\n\u0005]B$a\u0005\"zi\u0016\u001cu.\u001e8uKJ,\u0005\u0010]8si\u0016\u0014(BA\u001b\u0016!\tQ\u0014)D\u0001<\u0015\taT(\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002?\u007f\u0005AA/\u001f9fg\u00064WMC\u0001A\u0003\r\u0019w.\\\u0005\u0003\u0005n\u00121\u0002T1{s2{wmZ5oO\u000611\u000f\u001e:fC6\u0004\"\u0001J#\n\u0005\u0019C$\u0001D#ya>\u0014Ho\u0015;sK\u0006l\u0017A\u00024pe6\fG\u000f\u0005\u0002J!6\t!J\u0003\u0002L\u0019\u0006\u00191m\u001d<\u000b\u00055s\u0015aB2p[6|gn\u001d\u0006\u0003\u001f~\ta!\u00199bG\",\u0017BA)K\u0005%\u00195K\u0016$pe6\fG/\u0001\u0006xSRD\u0007*Z1eKJ\u0004\"\u0001V,\u000e\u0003US\u0011AV\u0001\u0006g\u000e\fG.Y\u0005\u00031V\u0013qAQ8pY\u0016\fg.\u0001\u0006j]\u000edW\u000fZ3JIN\fa\u0001P5oSRtD#\u0002/_?\u0002\f\u0007CA/\u0001\u001b\u0005)\u0002\"B\"\u0006\u0001\u0004!\u0005\"B$\u0006\u0001\u0004A\u0005\"\u0002*\u0006\u0001\u0004\u0019\u0006\"B-\u0006\u0001\u0004\u0019\u0016a\u00029sS:$XM]\u000b\u0002IB\u0011\u0011*Z\u0005\u0003M*\u0013!bQ*W!JLg\u000e^3s\u0003-\u0001(/\u001b8uKJ|F%Z9\u0015\u0005%d\u0007C\u0001+k\u0013\tYWK\u0001\u0003V]&$\bbB7\b\u0003\u0003\u0005\r\u0001Z\u0001\u0004q\u0012\n\u0014\u0001\u00039sS:$XM\u001d\u0011\u0002\u000bM$\u0018M\u001d;\u0015\u0005%\f\b\"\u0002:\n\u0001\u0004\u0019\u0018aA:giB\u0011Ao_\u0007\u0002k*\u0011ao^\u0001\u0007g&l\u0007\u000f\\3\u000b\u0005aL\u0018a\u00024fCR,(/\u001a\u0006\u0003u~\tqa\u001c9f]\u001eL7/\u0003\u0002}k\n\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\u0015\u0007y\fI\u0001\u0005\u0003U\u007f\u0006\r\u0011bAA\u0001+\n1q\n\u001d;j_:\u00042\u0001VA\u0003\u0013\r\t9!\u0016\u0002\u0005\u0019>tw\rC\u0004\u0002\f)\u0001\r!!\u0004\u0002\u0011\u0019,\u0017\r^;sKN\u0004b!a\u0004\u0002\u001a\u0005}a\u0002BA\t\u0003+q1aKA\n\u0013\u00051\u0016bAA\f+\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u000e\u0003;\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003/)\u0006c\u0001;\u0002\"%\u0019\u00111E;\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0003\u0015\u0019Gn\\:f)\u0005I\u0017!C:ue&tw-\u001b4z)\u0011\ti#!\u0010\u0011\t\u0005=\u0012q\u0007\b\u0005\u0003c\t\u0019\u0004\u0005\u0002,+&\u0019\u0011QG+\u0002\rA\u0013X\rZ3g\u0013\u0011\tI$a\u000f\u0003\rM#(/\u001b8h\u0015\r\t)$\u0016\u0005\b\u0003\u007fa\u0001\u0019AA!\u0003\ry'M\u001b\t\u0004)\u0006\r\u0013bAA#+\n\u0019\u0011I\\=\u0002#\u0011+G.[7ji\u0016$W\t\u001f9peR,'\u000f\u0005\u0002^\u001dM\u0019a\"!\u0014\u0011\u0007Q\u000by%C\u0002\u0002RU\u0013a!\u00118z%\u00164GCAA%)\u001da\u0016qKA-\u00037BQa\u0011\tA\u0002\u0011CQA\u0015\tA\u0002MCq!\u0017\t\u0011\u0002\u0003\u00071+A\u0007dgZ$C-\u001a4bk2$HeM\u000b\u0003\u0003CR3aUA2W\t\t)\u0007\u0005\u0003\u0002h\u0005ETBAA5\u0015\u0011\tY'!\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAA8+\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0014\u0011\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0001;tmR9A,!\u001f\u0002|\u0005u\u0004\"B\"\u0013\u0001\u0004!\u0005\"\u0002*\u0013\u0001\u0004\u0019\u0006bB-\u0013!\u0003\u0005\raU\u0001\u000eiN4H\u0005Z3gCVdG\u000fJ\u001a")
public class DelimitedExporter
extends FeatureExporter.ByteCounterExporter
implements LazyLogging {
    private final FeatureExporter.ExportStream stream;
    private final CSVFormat format;
    private final boolean withHeader;
    private final boolean includeIds;
    private CSVPrinter printer;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static boolean tsv$default$3() {
        return DelimitedExporter$.MODULE$.tsv$default$3();
    }

    public static DelimitedExporter tsv(FeatureExporter.ExportStream exportStream, boolean bl, boolean bl2) {
        return DelimitedExporter$.MODULE$.tsv(exportStream, bl, bl2);
    }

    public static boolean csv$default$3() {
        return DelimitedExporter$.MODULE$.csv$default$3();
    }

    public static DelimitedExporter csv(FeatureExporter.ExportStream exportStream, boolean bl, boolean bl2) {
        return DelimitedExporter$.MODULE$.csv(exportStream, bl, bl2);
    }

    private Logger logger$lzycompute() {
        DelimitedExporter delimitedExporter = this;
        synchronized (delimitedExporter) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private CSVPrinter printer() {
        return this.printer;
    }

    private void printer_$eq(CSVPrinter x$1) {
        this.printer = x$1;
    }

    @Override
    public void start(SimpleFeatureType sft) {
        this.printer_$eq(this.format.print((Appendable)new OutputStreamWriter(this.stream.os(), StandardCharsets.UTF_8)));
        if (this.withHeader) {
            if (this.includeIds) {
                this.printer().print((Object)"id");
            }
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).foreach((Function1 & Serializable & scala.Serializable)descriptor -> {
                DelimitedExporter.$anonfun$start$1(this, sft, descriptor);
                return BoxedUnit.UNIT;
            });
            this.printer().println();
            this.printer().flush();
            return;
        }
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        BoxedUnit boxedUnit;
        LongRef count2 = LongRef.create((long)0L);
        features.foreach((Function1 & Serializable & scala.Serializable)sf -> {
            DelimitedExporter.$anonfun$export$1(this, count2, sf);
            return BoxedUnit.UNIT;
        });
        this.printer().flush();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Exported {} features", new Object[]{BoxesRunTime.boxToLong((long)count2.elem)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)count2.elem));
    }

    @Override
    public void close() {
        if (this.printer() != null) {
            this.printer().close();
            return;
        }
    }

    private String stringify(Object obj2) {
        Object object = obj2;
        if (object == null) {
            return "";
        }
        if (object instanceof Geometry) {
            Geometry geometry = (Geometry)object;
            return WKTUtils$.MODULE$.write(geometry);
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return package$.MODULE$.GeoToolsDateFormat().format(Instant.ofEpochMilli(date.getTime()).atZone(ZoneOffset.UTC));
        }
        if (object instanceof List) {
            List list = (List)object;
            return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).map((Function1 & Serializable & scala.Serializable)obj -> this.stringify(obj), Buffer$.MODULE$.canBuildFrom())).mkString(",");
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    return new StringBuilder(2).append(this.stringify(k)).append("->").append(this.stringify(v)).toString();
                }
                throw new MatchError((Object)tuple2);
            }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
        }
        return obj2.toString();
    }

    public static final /* synthetic */ void $anonfun$start$1(DelimitedExporter $this, SimpleFeatureType sft$1, AttributeDescriptor descriptor) {
        $this.printer().print((Object)SimpleFeatureTypes$.MODULE$.encodeDescriptor(sft$1, descriptor));
    }

    public static final /* synthetic */ void $anonfun$export$1(DelimitedExporter $this, LongRef count$1, SimpleFeature sf) {
        if ($this.includeIds) {
            $this.printer().print((Object)sf.getID());
        }
        for (int i = 0; i < sf.getAttributeCount(); ++i) {
            $this.printer().print((Object)$this.stringify(sf.getAttribute(i)));
        }
        $this.printer().println();
        ++count$1.elem;
        if (count$1.elem % 10000L == 0L) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug("wrote {} features", new Object[]{BoxesRunTime.boxToLong((long)count$1.elem)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public DelimitedExporter(FeatureExporter.ExportStream stream, CSVFormat format, boolean withHeader, boolean includeIds) {
        this.stream = stream;
        this.format = format;
        this.withHeader = withHeader;
        this.includeIds = includeIds;
        super(stream);
        LazyLogging.$init$((LazyLogging)this);
    }
}

