/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.utils;

import com.beust.jcommander.IValueValidator;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.BaseConverter;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.convert.Modes;
import org.locationtech.geomesa.tools.export.formats.ExportFormat;
import org.locationtech.geomesa.tools.export.formats.ExportFormat$;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.geomesa.utils.text.DurationParsing$;
import org.locationtech.geomesa.utils.text.Suffixes;
import org.opengis.filter.Filter;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005=w!\u0002\u0014(\u0011\u0003\u0011d!\u0002\u001b(\u0011\u0003)\u0004\"\u0002\u001f\u0002\t\u0003id\u0001\u0002 \u0002\u0001}B\u0001bX\u0002\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\u0006y\r!\t\u0001\u0019\u0005\u0006I\u000e!\t%\u001a\u0004\u0005Q\u0006\u0001\u0011\u000e\u0003\u0005`\u000f\t\u0005\t\u0015!\u0003U\u0011\u0015at\u0001\"\u0001t\u0011\u0015!w\u0001\"\u0011w\r\u0011A\u0018\u0001A=\t\u0011}[!\u0011!Q\u0001\nQCa\u0001P\u0006\u0005\u0002\u0005\u001d\u0001B\u00023\f\t\u0003\niA\u0002\u0004\u0002\u0012\u0005\u0001\u00111\u0003\u0005\t?>\u0011\t\u0011)A\u0005)\"1Ah\u0004C\u0001\u0003OAa\u0001Z\b\u0005B\u00055bABA\u0019\u0003\u0001\t\u0019\u0004\u0003\u0005`'\t\u0005\t\u0015!\u0003U\u0011\u0019a4\u0003\"\u0001\u0002>!1Am\u0005C!\u0003\u00072a!a\u0012\u0002\u0001\u0005%\u0003\u0002C0\u0018\u0005\u0003\u0005\u000b\u0011\u0002+\t\rq:B\u0011AA+\u0011\u0019!w\u0003\"\u0011\u0002\\\u00191\u0011qL\u0001\u0001\u0003CB\u0001bX\u000e\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\u0007ym!\t!!\"\t\r\u0011\\B\u0011IAF\r\u0019\ty)\u0001\u0001\u0002\u0012\"Aql\bB\u0001B\u0003%A\u000b\u0003\u0004=?\u0011\u0005\u0011\u0011\u0015\u0005\u0007I~!\t%a*\u0007\r\u0005-\u0016\u0001AAW\u0011\u0019a4\u0005\"\u0001\u0002>\"9\u0011\u0011Y\u0012\u0005B\u0005\r\u0017a\u0005)be\u0006lW\r^3s\u0007>tg/\u001a:uKJ\u001c(B\u0001\u0015*\u0003\u0015)H/\u001b7t\u0015\tQ3&A\u0003u_>d7O\u0003\u0002-[\u00059q-Z8nKN\f'B\u0001\u00180\u00031awnY1uS>tG/Z2i\u0015\u0005\u0001\u0014aA8sO\u000e\u0001\u0001CA\u001a\u0002\u001b\u00059#a\u0005)be\u0006lW\r^3s\u0007>tg/\u001a:uKJ\u001c8CA\u00017!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\r\u0002\u000e\u0011&tGoQ8om\u0016\u0014H/\u001a:\u0014\u0005\r\u0001\u0005cA!K\u00196\t!I\u0003\u0002D\t\u0006Q1m\u001c8wKJ$XM]:\u000b\u0005\u00153\u0015A\u00036d_6l\u0017M\u001c3fe*\u0011q\tS\u0001\u0006E\u0016,8\u000f\u001e\u0006\u0002\u0013\u0006\u00191m\\7\n\u0005-\u0013%!\u0004\"bg\u0016\u001cuN\u001c<feR,'\u000f\u0005\u0003N%R#V\"\u0001(\u000b\u0005=\u0003\u0016\u0001B;uS2T\u0011!U\u0001\u0005U\u00064\u0018-\u0003\u0002T\u001d\n\u0019Q*\u00199\u0011\u0005UcfB\u0001,[!\t9\u0006(D\u0001Y\u0015\tI\u0016'\u0001\u0004=e>|GOP\u0005\u00037b\na\u0001\u0015:fI\u00164\u0017BA/_\u0005\u0019\u0019FO]5oO*\u00111\fO\u0001\u0005]\u0006lW\r\u0006\u0002bGB\u0011!mA\u0007\u0002\u0003!)q,\u0002a\u0001)\u000691m\u001c8wKJ$HC\u0001'g\u0011\u00159g\u00011\u0001U\u0003\u00151\u0018\r\\;f\u0005E!UO]1uS>t7i\u001c8wKJ$XM]\n\u0003\u000f)\u00042!\u0011&l!\ta\u0017/D\u0001n\u0015\tqw.\u0001\u0005ekJ\fG/[8o\u0015\t\u0001\b(\u0001\u0006d_:\u001cWO\u001d:f]RL!A]7\u0003\u0011\u0011+(/\u0019;j_:$\"\u0001^;\u0011\u0005\t<\u0001\"B0\n\u0001\u0004!FCA6x\u0011\u00159'\u00021\u0001U\u0005=1\u0015\u000e\u001c;fe\u000e{gN^3si\u0016\u00148CA\u0006{!\r\t%j\u001f\t\u0004y\u0006\rQ\"A?\u000b\u0005y|\u0018A\u00024jYR,'OC\u0002\u0002\u0002=\nqa\u001c9f]\u001eL7/C\u0002\u0002\u0006u\u0014aAR5mi\u0016\u0014H\u0003BA\u0005\u0003\u0017\u0001\"AY\u0006\t\u000b}k\u0001\u0019\u0001+\u0015\u0007m\fy\u0001C\u0003h\u001d\u0001\u0007AKA\u000bFqB|'\u000f\u001e$pe6\fGoQ8om\u0016\u0014H/\u001a:\u0014\u0007=\t)\u0002\u0005\u0003B\u0015\u0006]\u0001\u0003BA\r\u0003Gi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\bM>\u0014X.\u0019;t\u0015\r\t\t#K\u0001\u0007Kb\u0004xN\u001d;\n\t\u0005\u0015\u00121\u0004\u0002\r\u000bb\u0004xN\u001d;G_Jl\u0017\r\u001e\u000b\u0005\u0003S\tY\u0003\u0005\u0002c\u001f!)q,\u0005a\u0001)R!\u0011qCA\u0018\u0011\u00159'\u00031\u0001U\u0005EYU-\u001f,bYV,7i\u001c8wKJ$XM]\n\u0004'\u0005U\u0002\u0003B!K\u0003o\u0001RaNA\u001d)RK1!a\u000f9\u0005\u0019!V\u000f\u001d7feQ!\u0011qHA!!\t\u00117\u0003C\u0003`+\u0001\u0007A\u000b\u0006\u0003\u00028\u0005\u0015\u0003\"B4\u0017\u0001\u0004!&!E%oi\u0016\u0014h/\u00197D_:4XM\u001d;feN\u0019q#a\u0013\u0011\t\u0005S\u0015Q\n\t\bo\u0005e\u0012qJA(!\ri\u0015\u0011K\u0005\u0004\u0003'r%\u0001\u0002#bi\u0016$B!a\u0016\u0002ZA\u0011!m\u0006\u0005\u0006?f\u0001\r\u0001\u0016\u000b\u0005\u0003\u001b\ni\u0006C\u0003h5\u0001\u0007AK\u0001\nFeJ|'/T8eK\u000e{gN^3si\u0016\u00148cA\u000e\u0002dA!\u0011ISA3!\u0011\t9'a \u000f\t\u0005%\u0014\u0011\u0010\b\u0005\u0003W\n9H\u0004\u0003\u0002n\u0005Ud\u0002BA8\u0003gr1aVA9\u0013\u0005\u0001\u0014B\u0001\u00180\u0013\taS&\u0003\u0002eW%!\u00111PA?\u0003\u0015iu\u000eZ3t\u0015\t!7&\u0003\u0003\u0002\u0002\u0006\r%!C#se>\u0014Xj\u001c3f\u0015\u0011\tY(! \u0015\t\u0005\u001d\u0015\u0011\u0012\t\u0003EnAQaX\u000fA\u0002Q#B!!\u001a\u0002\u000e\")qM\ba\u0001)\nq!)\u001f;fg\u000e{gN^3si\u0016\u00148cA\u0010\u0002\u0014B!\u0011ISAK!\u0011\t9*!(\u000e\u0005\u0005e%bAAN!\u0006!A.\u00198h\u0013\u0011\ty*!'\u0003\t1{gn\u001a\u000b\u0005\u0003G\u000b)\u000b\u0005\u0002c?!)q,\ta\u0001)R!\u0011QSAU\u0011\u00159'\u00051\u0001U\u00059\u0011\u0015\u0010^3t-\u0006d\u0017\u000eZ1u_J\u001cRaIAX\u0003k\u0003B!a&\u00022&!\u00111WAM\u0005\u0019y%M[3diB)\u0011qWA])6\tA)C\u0002\u0002<\u0012\u0013q\"\u0013,bYV,g+\u00197jI\u0006$xN\u001d\u000b\u0003\u0003\u007f\u0003\"AY\u0012\u0002\u0011Y\fG.\u001b3bi\u0016$b!!2\u0002L\u00065\u0007cA\u001c\u0002H&\u0019\u0011\u0011\u001a\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006?\u0016\u0002\r\u0001\u0016\u0005\u0006O\u0016\u0002\r\u0001\u0016")
public final class ParameterConverters {

    public static class BytesConverter
    extends BaseConverter<Long> {
        public Long convert(String value) {
            Try try_ = Suffixes.Memory$.MODULE$.bytes(value);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                long b = BoxesRunTime.unboxToLong((Object)success.value());
                return Predef$.MODULE$.long2Long(b);
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new ParameterException(new StringBuilder(22).append("Invalid byte string '").append(value).append("'").toString(), e);
            }
            throw new MatchError((Object)try_);
        }

        public BytesConverter(String name) {
            super(name);
        }
    }

    public static class BytesValidator
    implements IValueValidator<String> {
        public void validate(String name, String value) {
            Suffixes.Memory$.MODULE$.bytes(value).failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                throw new ParameterException(new StringBuilder(22).append("Invalid byte string '").append(value).append("'").toString(), e);
            });
        }
    }

    public static class DurationConverter
    extends BaseConverter<Duration> {
        public Duration convert(String value) {
            Duration duration;
            try {
                duration = DurationParsing$.MODULE$.caseInsensitive(value);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(10).append("duration: ").append(e).toString()));
                }
                throw throwable;
            }
            return duration;
        }

        public DurationConverter(String name) {
            super(name);
        }
    }

    public static class ErrorModeConverter
    extends BaseConverter<Enumeration.Value> {
        public Enumeration.Value convert(String value) {
            return (Enumeration.Value)Modes.ErrorMode$.MODULE$.values().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ErrorModeConverter.$anonfun$convert$4(value, x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new ParameterException(new StringBuilder(40).append("Invalid error mode '").append(value).append("'. Valid values are ").append(((TraversableOnce)Modes.ErrorMode$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$))).mkString("'", "', '", "'")).toString());
            });
        }

        public static final /* synthetic */ boolean $anonfun$convert$4(String value$2, Enumeration.Value x$3) {
            return x$3.toString().equalsIgnoreCase(value$2);
        }

        public ErrorModeConverter(String name) {
            super(name);
        }
    }

    public static class ExportFormatConverter
    extends BaseConverter<ExportFormat> {
        public ExportFormat convert(String value) {
            ExportFormat exportFormat;
            try {
                exportFormat = (ExportFormat)ExportFormat$.MODULE$.apply(value).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new ParameterException(new StringBuilder(36).append("Invalid format '").append(value).append("'. Valid values are ").append(((TraversableOnce)((SeqLike)ExportFormat$.MODULE$.Formats().flatMap((Function1 & Serializable & scala.Serializable)f -> {
                        Seq<String> seq = f.extensions();
                        return (IndexedSeq)new StringOps(Predef$.MODULE$.augmentString(f.name())).$plus$colon(seq, Predef$.MODULE$.fallbackStringCanBuildFrom());
                    }, Seq$.MODULE$.canBuildFrom())).distinct()).mkString("'", "', '", "'")).toString());
                });
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("format: ").append(e).toString()));
                }
                throw throwable;
            }
            return exportFormat;
        }

        public ExportFormatConverter(String name) {
            super(name);
        }
    }

    public static class FilterConverter
    extends BaseConverter<Filter> {
        public Filter convert(String value) {
            Filter filter;
            try {
                filter = ECQL.toFilter((String)value);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("filter: ").append(e).toString()));
                }
                throw throwable;
            }
            return filter;
        }

        public FilterConverter(String name) {
            super(name);
        }
    }

    public static class HintConverter
    extends BaseConverter<Map<String, String>> {
        /*
         * WARNING - void declaration
         */
        public Map<String, String> convert(String value) {
            void v0;
            try {
                void var3_2;
                HashMap map = new HashMap();
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value.split(";"))).foreach((Function1 & Serializable & scala.Serializable)part -> {
                    String[] stringArray = part.split("=");
                    Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                        throw new MatchError((Object)stringArray);
                    }
                    String k = (String)((SeqLike)option.get()).apply(0);
                    String v = (String)((SeqLike)option.get()).apply(1);
                    Tuple2 tuple2 = new Tuple2((Object)k, (Object)v);
                    String k2 = (String)tuple2._1();
                    String v2 = (String)tuple2._2();
                    return map.put(k2.trim(), v2.trim());
                });
                v0 = var3_2;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(10).append("hint map: ").append(e).toString()));
                }
                throw throwable;
            }
            return v0;
        }

        public HintConverter(String name) {
            super(name);
        }
    }

    public static class IntervalConverter
    extends BaseConverter<Tuple2<Date, Date>> {
        public Tuple2<Date, Date> convert(String value) {
            Tuple2 tuple2;
            try {
                int i = value.indexOf(47);
                if (i == -1 || value.indexOf(47, i + 1) != -1) {
                    throw new IllegalArgumentException("Interval from/to must be separated by a single '/'");
                }
                Date start = (Date)FastConverter$.MODULE$.convert((Object)value.substring(0, i), Date.class);
                Date end = (Date)FastConverter$.MODULE$.convert((Object)value.substring(i + 1), Date.class);
                if (start == null || end == null) {
                    throw new IllegalArgumentException(new StringBuilder(35).append("Could not convert ").append(value).append(" to date interval").toString());
                }
                tuple2 = new Tuple2((Object)start, (Object)end);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("format: ").append(e).toString()));
                }
                throw throwable;
            }
            return tuple2;
        }

        public IntervalConverter(String name) {
            super(name);
        }
    }

    public static class KeyValueConverter
    extends BaseConverter<Tuple2<String, String>> {
        public Tuple2<String, String> convert(String value) {
            Tuple2 tuple2;
            try {
                int i = value.indexOf(61);
                if (i == -1 || value.indexOf(61, i + 1) != -1) {
                    throw new IllegalArgumentException("key-value pairs must be separated by a single '='");
                }
                tuple2 = new Tuple2((Object)value.substring(0, i), (Object)value.substring(i + 1));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("format: ").append(e).toString()));
                }
                throw throwable;
            }
            return tuple2;
        }

        public KeyValueConverter(String name) {
            super(name);
        }
    }
}

