/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import java.io.Serializable;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder;
import org.locationtech.geomesa.utils.bin.BinaryOutputEncoder$;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001\u0002\u0007\u000e\u0001iA\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tk\u0001\u0011\t\u0011)A\u0005m!)\u0001\t\u0001C\u0001\u0003\"9a\t\u0001b\u0001\n\u00139\u0005B\u0002(\u0001A\u0003%\u0001\nC\u0004P\u0001\u0001\u0007I\u0011\u0002)\t\u000fq\u0003\u0001\u0019!C\u0005;\"11\r\u0001Q!\nECQ\u0001\u001a\u0001\u0005B\u0015DQ\u0001\u0005\u0001\u0005BIDq!a\u0003\u0001\t\u0003\niAA\u0006CS:,\u0005\u0010]8si\u0016\u0014(B\u0001\b\u0010\u0003\u001d1wN]7biNT!\u0001E\t\u0002\r\u0015D\bo\u001c:u\u0015\t\u00112#A\u0003u_>d7O\u0003\u0002\u0015+\u00059q-Z8nKN\f'B\u0001\f\u0018\u00031awnY1uS>tG/Z2i\u0015\u0005A\u0012aA8sO\u000e\u00011C\u0001\u0001\u001c!\tabF\u0004\u0002\u001eY9\u0011ad\u000b\b\u0003?)r!\u0001I\u0015\u000f\u0005\u0005BcB\u0001\u0012(\u001d\t\u0019c%D\u0001%\u0015\t)\u0013$\u0001\u0004=e>|GOP\u0005\u00021%\u0011acF\u0005\u0003)UI!AE\n\n\u0005A\t\u0012B\u0001\b\u0010\u0013\tiS\"A\bGK\u0006$XO]3FqB|'\u000f^3s\u0013\ty\u0003GA\nCsR,7i\\;oi\u0016\u0014X\t\u001f9peR,'O\u0003\u0002.\u001b\u000511\u000f\u001e:fC6\u0004\"\u0001H\u001a\n\u0005Q\u0002$\u0001D#ya>\u0014Ho\u0015;sK\u0006l\u0017!\u00025j]R\u001c\bCA\u001c?\u001b\u0005A$BA\u001d;\u0003\u001d1\u0017m\u0019;pefT!a\u000f\u001f\u0002\tU$\u0018\u000e\u001c\u0006\u0003{]\t\u0001bZ3pi>|Gn]\u0005\u0003\u007fa\u0012Q\u0001S5oiN\fa\u0001P5oSRtDc\u0001\"E\u000bB\u00111\tA\u0007\u0002\u001b!)\u0011g\u0001a\u0001e!)Qg\u0001a\u0001m\u0005)A.\u00192fYV\t\u0001\n\u0005\u0002J\u00196\t!JC\u0001L\u0003\u0015\u00198-\u00197b\u0013\ti%JA\u0004C_>dW-\u00198\u0002\r1\f'-\u001a7!\u0003\u001d)gnY8eKJ,\u0012!\u0015\t\u0004\u0013J#\u0016BA*K\u0005\u0019y\u0005\u000f^5p]B\u0011QKW\u0007\u0002-*\u0011q\u000bW\u0001\u0004E&t'BA-\u0014\u0003\u0015)H/\u001b7t\u0013\tYfKA\nCS:\f'/_(viB,H/\u00128d_\u0012,'/A\u0006f]\u000e|G-\u001a:`I\u0015\fHC\u00010b!\tIu,\u0003\u0002a\u0015\n!QK\\5u\u0011\u001d\u0011w!!AA\u0002E\u000b1\u0001\u001f\u00132\u0003!)gnY8eKJ\u0004\u0013!B:uCJ$HC\u00010g\u0011\u00159\u0017\u00021\u0001i\u0003\r\u0019h\r\u001e\t\u0003SBl\u0011A\u001b\u0006\u0003W2\faa]5na2,'BA7o\u0003\u001d1W-\u0019;ve\u0016T!a\\\f\u0002\u000f=\u0004XM\\4jg&\u0011\u0011O\u001b\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,GCA:x!\rI%\u000b\u001e\t\u0003\u0013VL!A\u001e&\u0003\t1{gn\u001a\u0005\u0006q*\u0001\r!_\u0001\tM\u0016\fG/\u001e:fgB!!p`A\u0003\u001d\tYXP\u0004\u0002$y&\t1*\u0003\u0002\u007f\u0015\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0001\u0003\u0007\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003}*\u00032![A\u0004\u0013\r\tIA\u001b\u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\u0002\u000b\rdwn]3\u0015\u0003y\u0003")
public class BinExporter
extends FeatureExporter.ByteCounterExporter {
    private final FeatureExporter.ExportStream stream;
    private final Hints hints;
    private final boolean label;
    private Option<BinaryOutputEncoder> encoder;

    private boolean label() {
        return this.label;
    }

    private Option<BinaryOutputEncoder> encoder() {
        return this.encoder;
    }

    private void encoder_$eq(Option<BinaryOutputEncoder> x$1) {
        this.encoder = x$1;
    }

    @Override
    public void start(SimpleFeatureType sft) {
        SimpleFeatureType simpleFeatureType = sft;
        SimpleFeatureType simpleFeatureType2 = BinaryOutputEncoder$.MODULE$.BinEncodedSft();
        if (!(simpleFeatureType != null ? !simpleFeatureType.equals(simpleFeatureType2) : simpleFeatureType2 != null)) {
            this.encoder_$eq((Option<BinaryOutputEncoder>)None$.MODULE$);
            return;
        }
        Option geom = QueryHints$.MODULE$.RichHints(this.hints).getBinGeomField().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1)));
        Option dtg = QueryHints$.MODULE$.RichHints(this.hints).getBinDtgField().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1)));
        Option track = Option$.MODULE$.apply((Object)QueryHints$.MODULE$.RichHints(this.hints).getBinTrackIdField()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BinExporter.$anonfun$start$3(x$1))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1)));
        BinaryOutputEncoder.EncodingOptions options = new BinaryOutputEncoder.EncodingOptions(geom, dtg, track, QueryHints$.MODULE$.RichHints(this.hints).getBinLabelField().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)sft.indexOf(x$1))), BinaryOutputEncoder.EncodingOptions$.MODULE$.apply$default$5());
        this.encoder_$eq((Option<BinaryOutputEncoder>)new Some((Object)BinaryOutputEncoder$.MODULE$.apply(sft, options)));
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        long l;
        Option<BinaryOutputEncoder> option = this.encoder();
        if (option instanceof Some) {
            Some some = (Some)option;
            BinaryOutputEncoder e = (BinaryOutputEncoder)some.value();
            l = e.encode(CloseableIterator$.MODULE$.iteratorToCloseable(features), this.stream.os(), e.encode$default$3());
        } else if (None$.MODULE$.equals(option)) {
            LongRef numBytes = LongRef.create((long)0L);
            features.foreach((Function1 & Serializable & scala.Serializable)f -> {
                BinExporter.$anonfun$export$1(this, numBytes, f);
                return BoxedUnit.UNIT;
            });
            l = numBytes.elem / (long)(this.label() ? 24 : 16);
        } else {
            throw new MatchError(option);
        }
        long count2 = l;
        this.stream.os().flush();
        return new Some((Object)BoxesRunTime.boxToLong((long)count2));
    }

    @Override
    public void close() {
        this.stream.close();
    }

    public static final /* synthetic */ boolean $anonfun$start$3(String x$1) {
        String string = x$1;
        String string2 = "id";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$export$1(BinExporter $this, LongRef numBytes$1, SimpleFeature f) {
        byte[] bytes = (byte[])f.getAttribute(0);
        $this.stream.os().write(bytes);
        numBytes$1.elem += (long)bytes.length;
    }

    public BinExporter(FeatureExporter.ExportStream stream, Hints hints) {
        this.stream = stream;
        this.hints = hints;
        super(stream);
        this.label = QueryHints$.MODULE$.RichHints(hints).getBinLabelField().isDefined();
        this.encoder = None$.MODULE$;
    }
}

