/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import com.google.gson.stream.JsonWriter;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.locationtech.geomesa.features.serialization.GeoJsonSerializer;
import org.locationtech.geomesa.features.serialization.GeoJsonSerializer$;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.export.formats.LeafletMapExporter$;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eh\u0001\u0002\u0010 \u00011B\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\u0006#\u0002!\tA\u0015\u0005\b-\u0002\u0011\r\u0011\"\u0003X\u0011\u0019q\u0007\u0001)A\u00051\"Iq\u000e\u0001a\u0001\u0002\u0004%I\u0001\u001d\u0005\ns\u0002\u0001\r\u00111A\u0005\niD!\"!\u0001\u0001\u0001\u0004\u0005\t\u0015)\u0003r\u0011-\t\u0019\u0001\u0001a\u0001\u0002\u0004%I!!\u0002\t\u0017\u0005e\u0001\u00011AA\u0002\u0013%\u00111\u0004\u0005\f\u0003?\u0001\u0001\u0019!A!B\u0013\t9\u0001C\u0006\u0002\"\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0002bCA\u001b\u0001\u0001\u0007\t\u0019!C\u0005\u0003oA1\"a\u000f\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002&!I\u0011Q\b\u0001A\u0002\u0013%\u0011q\b\u0005\n\u0003\u001b\u0002\u0001\u0019!C\u0005\u0003\u001fB\u0001\"a\u0015\u0001A\u0003&\u0011\u0011\t\u0005\b\u0003+\u0002A\u0011IA,\u0011\u0019\u0011\u0003\u0001\"\u0011\u0002r!9\u0011\u0011\u0014\u0001\u0005B\u0005muaBAO?!\u0005\u0011q\u0014\u0004\u0007=}A\t!!)\t\rE+B\u0011AAU\u0011)\tY+\u0006EC\u0002\u0013%\u0011Q\u0016\u0005\u000b\u0003\u0007,\u0002R1A\u0005\u0002\u0005\u0015\u0007BCAd+!\u0015\r\u0011\"\u0001\u0002F\"I\u0011\u0011Z\u000bC\u0002\u0013\u0005\u00111\u001a\u0005\b\u0003\u001b,\u0002\u0015!\u0003k\u0011\u001d\ty-\u0006C\u0001\u0003#Dq!a;\u0016\t\u0003\tiO\u0001\nMK\u00064G.\u001a;NCB,\u0005\u0010]8si\u0016\u0014(B\u0001\u0011\"\u0003\u001d1wN]7biNT!AI\u0012\u0002\r\u0015D\bo\u001c:u\u0015\t!S%A\u0003u_>d7O\u0003\u0002'O\u00059q-Z8nKN\f'B\u0001\u0015*\u00031awnY1uS>tG/Z2i\u0015\u0005Q\u0013aA8sO\u000e\u00011c\u0001\u0001.\u0007B\u0011a\u0006\u0011\b\u0003_yr!\u0001M\u001f\u000f\u0005EbdB\u0001\u001a<\u001d\t\u0019$H\u0004\u00025s9\u0011Q\u0007O\u0007\u0002m)\u0011qgK\u0001\u0007yI|w\u000e\u001e \n\u0003)J!\u0001K\u0015\n\u0005\u0019:\u0013B\u0001\u0013&\u0013\t\u00113%\u0003\u0002!C%\u0011qhH\u0001\u0010\r\u0016\fG/\u001e:f\u000bb\u0004xN\u001d;fe&\u0011\u0011I\u0011\u0002\u0014\u0005f$XmQ8v]R,'/\u0012=q_J$XM\u001d\u0006\u0003\u007f}\u0001\"\u0001R&\u000e\u0003\u0015S!AR$\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005!K\u0015\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003)\u000b1aY8n\u0013\taUIA\u0006MCjLHj\\4hS:<\u0017AB:ue\u0016\fW\u000e\u0005\u0002/\u001f&\u0011\u0001K\u0011\u0002\r\u000bb\u0004xN\u001d;TiJ,\u0017-\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005M+\u0006C\u0001+\u0001\u001b\u0005y\u0002\"B'\u0003\u0001\u0004q\u0015\u0001C2p_J$W*\u00199\u0016\u0003a\u0003B!\u00171cU6\t!L\u0003\u0002\\9\u00069Q.\u001e;bE2,'BA/_\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002?\u0006)1oY1mC&\u0011\u0011M\u0017\u0002\u0004\u001b\u0006\u0004\bCA2i\u001b\u0005!'BA3g\u0003\u00119Wm\\7\u000b\u0005\u001d<\u0013a\u00016ug&\u0011\u0011\u000e\u001a\u0002\u000b\u0007>|'\u000fZ5oCR,\u0007CA6m\u001b\u0005q\u0016BA7_\u0005\rIe\u000e^\u0001\nG>|'\u000fZ'ba\u0002\naa\u001e:ji\u0016\u0014X#A9\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018AA5p\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001_:\u0003%=+H\u000f];u'R\u0014X-Y7Xe&$XM]\u0001\u000boJLG/\u001a:`I\u0015\fHCA>\u007f!\tYG0\u0003\u0002~=\n!QK\\5u\u0011\u001dyh!!AA\u0002E\f1\u0001\u001f\u00132\u0003\u001d9(/\u001b;fe\u0002\n!B[:p]^\u0013\u0018\u000e^3s+\t\t9\u0001\u0005\u0003\u0002\n\u0005UQBAA\u0006\u0015\ri\u0015Q\u0002\u0006\u0005\u0003\u001f\t\t\"\u0001\u0003hg>t'bAA\n\u0013\u00061qm\\8hY\u0016LA!a\u0006\u0002\f\tQ!j]8o/JLG/\u001a:\u0002\u001d)\u001cxN\\,sSR,'o\u0018\u0013fcR\u001910!\b\t\u0011}L\u0011\u0011!a\u0001\u0003\u000f\t1B[:p]^\u0013\u0018\u000e^3sA\u0005q!n]8o'\u0016\u0014\u0018.\u00197ju\u0016\u0014XCAA\u0013!\u0011\t9#!\r\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\tQb]3sS\u0006d\u0017N_1uS>t'bAA\u0018K\u0005Aa-Z1ukJ,7/\u0003\u0003\u00024\u0005%\"!E$f_*\u001bxN\\*fe&\fG.\u001b>fe\u0006\u0011\"n]8o'\u0016\u0014\u0018.\u00197ju\u0016\u0014x\fJ3r)\rY\u0018\u0011\b\u0005\t\u007f2\t\t\u00111\u0001\u0002&\u0005y!n]8o'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b%A\u0006gK\u0006$XO]3J]\u001a|WCAA!!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#bAA$k\u0006!A.\u00198h\u0013\u0011\tY%!\u0012\u0003\rM#(/\u001b8h\u0003=1W-\u0019;ve\u0016LeNZ8`I\u0015\fHcA>\u0002R!AqpDA\u0001\u0002\u0004\t\t%\u0001\u0007gK\u0006$XO]3J]\u001a|\u0007%A\u0003ti\u0006\u0014H\u000fF\u0002|\u00033Bq!a\u0017\u0012\u0001\u0004\ti&A\u0002tMR\u0004B!a\u0018\u0002n5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'\u0001\u0004tS6\u0004H.\u001a\u0006\u0005\u0003O\nI'A\u0004gK\u0006$XO]3\u000b\u0007\u0005-\u0014&A\u0004pa\u0016tw-[:\n\t\u0005=\u0014\u0011\r\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,G\u0003BA:\u0003\u007f\u0002Ra[A;\u0003sJ1!a\u001e_\u0005\u0019y\u0005\u000f^5p]B\u00191.a\u001f\n\u0007\u0005udL\u0001\u0003M_:<\u0007bBA\u0018%\u0001\u0007\u0011\u0011\u0011\t\u0007\u0003\u0007\u000bi)a%\u000f\t\u0005\u0015\u0015\u0011\u0012\b\u0004k\u0005\u001d\u0015\"A0\n\u0007\u0005-e,A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0015\u0011\u0013\u0002\t\u0013R,'/\u0019;pe*\u0019\u00111\u00120\u0011\t\u0005}\u0013QS\u0005\u0005\u0003/\u000b\tGA\u0007TS6\u0004H.\u001a$fCR,(/Z\u0001\u0006G2|7/\u001a\u000b\u0002w\u0006\u0011B*Z1gY\u0016$X*\u00199FqB|'\u000f^3s!\t!VcE\u0002\u0016\u0003G\u00032a[AS\u0013\r\t9K\u0018\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005}\u0015\u0001\u0003+f[Bd\u0017\r^3\u0016\u0005\u0005=\u0006#B6\u00022\u0006U\u0016bAAZ=\n)\u0011I\u001d:bsB!\u0011qWA`\u001d\u0011\tI,a/\u0011\u0005Ur\u0016bAA_=\u00061\u0001K]3eK\u001aLA!a\u0013\u0002B*\u0019\u0011Q\u00180\u0002\u0013%sG-\u001a=IK\u0006$WCAA[\u0003%Ie\u000eZ3y)\u0006LG.A\u0006NCb4U-\u0019;ve\u0016\u001cX#\u00016\u0002\u00195\u000b\u0007PR3biV\u0014Xm\u001d\u0011\u0002\u0013\r|gNZ5hkJ,G\u0003BAj\u00033\u00042a[Ak\u0013\r\t9N\u0018\u0002\b\u0005>|G.Z1o\u0011\u001d\tY\u000e\ba\u0001\u0003;\fa\u0001]1sC6\u001c\b\u0003BAp\u0003Kt1\u0001MAq\u0013\r\t\u0019/I\u0001\u000e\u000bb\u0004xN\u001d;D_6l\u0017M\u001c3\n\t\u0005\u001d\u0018\u0011\u001e\u0002\r\u000bb\u0004xN\u001d;QCJ\fWn\u001d\u0006\u0004\u0003G\f\u0013AD4fi\u001a+\u0017\r^;sK&sgm\u001c\u000b\u0005\u0003k\u000by\u000fC\u0004\u0002\\u\u0001\r!!\u0018")
public class LeafletMapExporter
extends FeatureExporter.ByteCounterExporter
implements LazyLogging {
    private final FeatureExporter.ExportStream stream;
    private final Map<Coordinate, Object> coordMap;
    private OutputStreamWriter writer;
    private JsonWriter jsonWriter;
    private GeoJsonSerializer jsonSerializer;
    private String featureInfo;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static String getFeatureInfo(SimpleFeatureType simpleFeatureType) {
        return LeafletMapExporter$.MODULE$.getFeatureInfo(simpleFeatureType);
    }

    public static boolean configure(ExportCommand.ExportParams exportParams) {
        return LeafletMapExporter$.MODULE$.configure(exportParams);
    }

    public static int MaxFeatures() {
        return LeafletMapExporter$.MODULE$.MaxFeatures();
    }

    public static String IndexTail() {
        return LeafletMapExporter$.MODULE$.IndexTail();
    }

    public static String IndexHead() {
        return LeafletMapExporter$.MODULE$.IndexHead();
    }

    private Logger logger$lzycompute() {
        LeafletMapExporter leafletMapExporter = this;
        synchronized (leafletMapExporter) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Map<Coordinate, Object> coordMap() {
        return this.coordMap;
    }

    private OutputStreamWriter writer() {
        return this.writer;
    }

    private void writer_$eq(OutputStreamWriter x$1) {
        this.writer = x$1;
    }

    private JsonWriter jsonWriter() {
        return this.jsonWriter;
    }

    private void jsonWriter_$eq(JsonWriter x$1) {
        this.jsonWriter = x$1;
    }

    private GeoJsonSerializer jsonSerializer() {
        return this.jsonSerializer;
    }

    private void jsonSerializer_$eq(GeoJsonSerializer x$1) {
        this.jsonSerializer = x$1;
    }

    private String featureInfo() {
        return this.featureInfo;
    }

    private void featureInfo_$eq(String x$1) {
        this.featureInfo = x$1;
    }

    @Override
    public void start(SimpleFeatureType sft) {
        this.featureInfo_$eq(LeafletMapExporter$.MODULE$.getFeatureInfo(sft));
        this.writer_$eq(new OutputStreamWriter(this.stream.os(), StandardCharsets.UTF_8));
        this.jsonWriter_$eq(GeoJsonSerializer$.MODULE$.writer((Writer)this.writer()));
        this.writer().write(LeafletMapExporter$.MODULE$.IndexHead());
        this.writer().write("var points = ");
        this.writer().flush();
        this.jsonSerializer_$eq(new GeoJsonSerializer(sft));
        this.jsonSerializer().startFeatureCollection(this.jsonWriter());
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        long count2 = 0L;
        while (features.hasNext()) {
            SimpleFeature feature = (SimpleFeature)features.next();
            this.jsonSerializer().write(this.jsonWriter(), feature);
            Geometry geom = (Geometry)feature.getDefaultGeometry();
            if (geom != null) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])geom.getCoordinates())).foreach((Function1 & Serializable & scala.Serializable)c -> {
                    LeafletMapExporter.$anonfun$export$1(this, c);
                    return BoxedUnit.UNIT;
                });
            }
            ++count2;
        }
        this.jsonWriter().flush();
        return new Some((Object)BoxesRunTime.boxToLong((long)count2));
    }

    @Override
    public void close() {
        if (this.writer() != null) {
            try {
                this.jsonSerializer().endFeatureCollection(this.jsonWriter());
                this.jsonWriter().flush();
                this.writer().write(";\n\n");
                this.writer().write(this.featureInfo());
                this.writer().write("var heat = L.heatLayer([\n");
                if (this.coordMap().isEmpty()) {
                    package$Command$.MODULE$.user().warn("No features were exported - the map will not render correctly");
                } else {
                    int max = ((Tuple2)this.coordMap().maxBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$))._2$mcI$sp();
                    Iterator iter = this.coordMap().iterator();
                    iter.take(1).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        LeafletMapExporter.$anonfun$close$2(this, max, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    iter.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        LeafletMapExporter.$anonfun$close$3(this, max, x0$2);
                        return BoxedUnit.UNIT;
                    });
                }
                this.writer().write("\n    ], { radius: 25 });\n\n");
                this.writer().write(LeafletMapExporter$.MODULE$.IndexTail());
            }
            finally {
                this.jsonWriter().close();
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$export$1(LeafletMapExporter $this, Coordinate c) {
        $this.coordMap().update((Object)c, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)$this.coordMap().apply((Object)c)) + 1)));
    }

    public static final /* synthetic */ void $anonfun$close$2(LeafletMapExporter $this, int max$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Coordinate coord = (Coordinate)tuple2._1();
            int weight = tuple2._2$mcI$sp();
            $this.writer().write(new StringBuilder(14).append("        [").append(coord.y).append(", ").append(coord.x).append(", ").append(weight / max$1).append("]").toString());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$close$3(LeafletMapExporter $this, int max$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Coordinate coord = (Coordinate)tuple2._1();
            int weight = tuple2._2$mcI$sp();
            $this.writer().write(new StringBuilder(16).append(",\n        [").append(coord.y).append(", ").append(coord.x).append(", ").append(weight / max$1).append("]").toString());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public LeafletMapExporter(FeatureExporter.ExportStream stream) {
        this.stream = stream;
        super(stream);
        LazyLogging.$init$((LazyLogging)this);
        this.coordMap = Map$.MODULE$.empty().withDefaultValue((Object)BoxesRunTime.boxToInteger((int)0));
        this.featureInfo = "";
    }
}

