/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.stats;

import com.beust.jcommander.ParameterException;
import java.io.Serializable;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.metadata.GeoMesaMetadata$;
import org.locationtech.geomesa.index.stats.GeoMesaStats;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.TypeNameParam;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.locationtech.geomesa.utils.stats.CountStat;
import org.locationtech.geomesa.utils.stats.MinMax;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000114qAC\u0006\u0011\u0002\u0007\u0005a\u0003C\u0003F\u0001\u0011\u0005a\tC\u0004K\u0001\t\u0007I\u0011I&\t\u000b=\u0003a\u0011\t)\t\u000b\u001d\u0004A\u0011\t$\t\u000b!\u0004A\u0011B5\b\u000bU[\u0001\u0012\u0001,\u0007\u000b)Y\u0001\u0012\u0001-\t\u000bq;A\u0011A/\u0007\u000fy;\u0001\u0013aI\u0001?\n\u00192\u000b^1ug\u0006s\u0017\r\\={K\u000e{W.\\1oI*\u0011A\"D\u0001\u0006gR\fGo\u001d\u0006\u0003\u001d=\tQ\u0001^8pYNT!\u0001E\t\u0002\u000f\u001d,w.\\3tC*\u0011!cE\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002)\u0005\u0019qN]4\u0004\u0001U\u0011q\u0003N\n\u0004\u0001a\u0001\u0003CA\r\u001f\u001b\u0005Q\"BA\u000e\u001d\u0003\u0011a\u0017M\\4\u000b\u0003u\tAA[1wC&\u0011qD\u0007\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007\u0005z#G\u0004\u0002#[9\u00111\u0005\f\b\u0003I-r!!\n\u0016\u000f\u0005\u0019JS\"A\u0014\u000b\u0005!*\u0012A\u0002\u001fs_>$h(C\u0001\u0015\u0013\t\u00112#\u0003\u0002\u0011#%\u0011abD\u0005\u0003]5\tq\u0001]1dW\u0006<W-\u0003\u00021c\t\u0001B)\u0019;b'R|'/Z\"p[6\fg\u000e\u001a\u0006\u0003]5\u0001\"a\r\u001b\r\u0001\u0011)Q\u0007\u0001b\u0001m\t\u0011AiU\t\u0003ou\u0002\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012qAT8uQ&tw\rE\u0002?\u0007Jj\u0011a\u0010\u0006\u0003\u0001\u0006\u000b\u0001bZ3pi>|Gn\u001d\u0006\u0003\u0005>\tQ!\u001b8eKbL!\u0001R \u0003!\u001d+w.T3tC\u0012\u000bG/Y*u_J,\u0017A\u0002\u0013j]&$H\u0005F\u0001H!\tA\u0004*\u0003\u0002Js\t!QK\\5u\u0003\u0011q\u0017-\\3\u0016\u00031\u0003\"!G'\n\u00059S\"AB*ue&tw-\u0001\u0004qCJ\fWn]\u000b\u0002#B\u0011!+\u0003\b\u0003'\u001aq!A\t+\n\u00051i\u0011aE*uCR\u001c\u0018I\\1msj,7i\\7nC:$\u0007CA,\b\u001b\u0005Y1CA\u0004Z!\tA$,\u0003\u0002\\s\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001,\u0003%M#\u0018\r^:B]\u0006d\u0017P_3QCJ\fWn]\n\u0005\u0013e\u0003G\r\u0005\u0002bE6\tQ\"\u0003\u0002d\u001b\ta1)\u0019;bY><\u0007+\u0019:b[B\u0011\u0011-Z\u0005\u0003M6\u0011Q\u0002V=qK:\u000bW.\u001a)be\u0006l\u0017aB3yK\u000e,H/Z\u0001\bC:\fG.\u001f>f)\t9%\u000eC\u0003l\u000b\u0001\u0007!'\u0001\u0002eg\u0002")
public interface StatsAnalyzeCommand<DS extends GeoMesaDataStore<DS>>
extends package.DataStoreCommand<DS> {
    public void org$locationtech$geomesa$tools$stats$StatsAnalyzeCommand$_setter_$name_$eq(String var1);

    @Override
    public String name();

    @Override
    public StatsAnalyzeParams params();

    public static /* synthetic */ void execute$(StatsAnalyzeCommand $this) {
        $this.execute();
    }

    @Override
    default public void execute() {
        this.withDataStore((Function1 & Serializable & scala.Serializable)ds -> {
            this.analyze(ds);
            return BoxedUnit.UNIT;
        });
    }

    private void analyze(DS ds) {
        Seq seq;
        SimpleFeatureType sft = ds.getSchema(this.params().featureName());
        if (sft == null) {
            throw new ParameterException(new StringBuilder(24).append("Schema '").append(this.params().featureName()).append("' does not exist").toString());
        }
        package$Command$.MODULE$.user().info(new StringBuilder(42).append("Running stat analysis for feature type ").append(sft.getTypeName()).append("...").toString());
        if (StatsAnalyzeCommand.noStats$1(ds, sft)) {
            while (StatsAnalyzeCommand.noStats$1(ds, sft)) {
                Thread.sleep(1000L);
            }
            Thread.sleep(1000L);
            Buffer queries = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)d -> Stat$.MODULE$.MinMax(d.getLocalName()), Buffer$.MODULE$.canBuildFrom());
            GeoMesaStats qual$1 = ds.stats();
            SimpleFeatureType x$1 = sft;
            String x$2 = Stat$.MODULE$.Count();
            Filter x$3 = qual$1.getStat$default$3();
            boolean x$4 = qual$1.getStat$default$4();
            GeoMesaStats qual$2 = ds.stats();
            SimpleFeatureType x$5 = sft;
            Seq x$6 = queries.toSeq();
            Filter x$7 = qual$2.getSeqStat$default$3();
            boolean x$8 = qual$2.getSeqStat$default$4();
            seq = (Iterable)Option$.MODULE$.option2Iterable(qual$1.getStat(x$1, x$2, x$3, x$4)).$plus$plus((GenTraversableOnce)qual$2.getSeqStat(x$5, x$6, x$7, x$8), Iterable$.MODULE$.canBuildFrom());
        } else {
            seq = ds.stats().writer().analyze(sft);
        }
        Seq stats = seq;
        Iterable strings = (Iterable)stats.collect((PartialFunction)new scala.Serializable(null, sft){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType sft$1;

            public final <A1 extends Stat, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof CountStat) {
                    CountStat countStat = (CountStat)A1;
                    return (B1)new StringBuilder(16).append("Total features: ").append(countStat.count()).toString();
                }
                if (A1 instanceof MinMax) {
                    String string;
                    MinMax minMax = (MinMax)A1;
                    if (minMax.isEmpty()) {
                        string = "[ no matching data ]";
                    } else {
                        String string2 = RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getGeomField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(this.sft$1));
                        String string3 = minMax.property();
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            Envelope e = ((Geometry)minMax.min()).getEnvelopeInternal();
                            e.expandToInclude(((Geometry)minMax.max()).getEnvelopeInternal());
                            string = new StringBuilder(24).append("[ ").append(e.getMinX()).append(", ").append(e.getMinY()).append(", ").append(e.getMaxX()).append(", ").append(e.getMaxY()).append(" ] cardinality: ").append(minMax.cardinality()).toString();
                        } else {
                            Function1 stringify = Stat$.MODULE$.stringifier(this.sft$1.getDescriptor(minMax.property()).getType().getBinding(), Stat$.MODULE$.stringifier$default$2());
                            string = new StringBuilder(22).append("[ ").append(stringify.apply(minMax.min())).append(" to ").append(stringify.apply(minMax.max())).append(" ] cardinality: ").append(minMax.cardinality()).toString();
                        }
                    }
                    String bounds = string;
                    return (B1)new StringBuilder(13).append("Bounds for ").append(minMax.property()).append(": ").append(bounds).toString();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Stat x1) {
                Stat stat = x1;
                if (stat instanceof CountStat) {
                    return true;
                }
                return stat instanceof MinMax;
            }
            {
                this.sft$1 = sft$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        package$Command$.MODULE$.user().info("Stats analyzed:");
        package$Command$.MODULE$.output().info(strings.mkString("  ", "\n  ", ""));
        package$Command$.MODULE$.user().info("Use 'stats-histogram', 'stats-top-k' or 'stats-count' commands for more details");
    }

    private static boolean noStats$1(GeoMesaDataStore ds$1, SimpleFeatureType sft$1) {
        return ds$1.metadata().read(sft$1.getTypeName(), GeoMesaMetadata$.MODULE$.StatsGenerationKey(), false).isEmpty();
    }

    public static void $init$(StatsAnalyzeCommand $this) {
        $this.org$locationtech$geomesa$tools$stats$StatsAnalyzeCommand$_setter_$name_$eq("stats-analyze");
    }

    public static interface StatsAnalyzeParams
    extends CatalogParam,
    TypeNameParam {
    }
}

