/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export;

import com.beust.jcommander.ParameterException;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import org.geotools.data.Query;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.conf.QueryHints;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.geoserver.ViewParams$;
import org.locationtech.geomesa.index.iterators.BinAggregatingScan$;
import org.locationtech.geomesa.index.planning.QueryRunner$;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.ExportFormat;
import org.locationtech.geomesa.tools.export.formats.ExportFormat$Arrow$;
import org.locationtech.geomesa.tools.export.formats.ExportFormat$Bin$;
import org.locationtech.geomesa.tools.export.formats.ExportFormat$Leaflet$;
import org.locationtech.geomesa.tools.export.formats.LeafletMapExporter$;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType;
import org.locationtech.geomesa.utils.geotools.RichSimpleFeatureType$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.BufferLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class ExportCommand$
implements LazyLogging {
    public static ExportCommand$ MODULE$;
    private final String org$locationtech$geomesa$tools$export$ExportCommand$$CountKey;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ExportCommand$();
    }

    private Logger logger$lzycompute() {
        ExportCommand$ exportCommand$ = this;
        synchronized (exportCommand$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String org$locationtech$geomesa$tools$export$ExportCommand$$CountKey() {
        return this.org$locationtech$geomesa$tools$export$ExportCommand$$CountKey;
    }

    public Query createQuery(SimpleFeatureType sft, ExportCommand.ExportParams params) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        String[] stringArray;
        Object object;
        String typeName = (String)Option$.MODULE$.apply((Object)params).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ExportCommand.ExportParams, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    return (B1)A12.featureName();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(ExportCommand.ExportParams x1) {
                ExportCommand.ExportParams exportParams = x1;
                return exportParams != null;
            }
        }).orNull(Predef$.MODULE$.$conforms());
        Filter filter = (Filter)Option$.MODULE$.apply((Object)params.cqlFilter()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Filter.INCLUDE);
        Query query = new Query(typeName, filter);
        Hints hints = query.getHints();
        Option$.MODULE$.apply((Object)params.maxFeatures()).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)ExportCommand$.$anonfun$createQuery$2(x))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> query.setMaxFeatures(x$1));
        Option$.MODULE$.apply((Object)params).collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ExportCommand.ExportParams, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof OptionalIndexParam) {
                    A1 A12 = A1;
                    return (B1)A12;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(ExportCommand.ExportParams x2) {
                ExportCommand.ExportParams exportParams = x2;
                return exportParams instanceof OptionalIndexParam;
            }
        }).foreach((Function1 & Serializable & scala.Serializable)p -> {
            ExportCommand$.$anonfun$createQuery$5(hints, p);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply(params.hints()).foreach((Function1 & Serializable & scala.Serializable)hintStrings -> {
            ExportCommand$.$anonfun$createQuery$7(hints, query, hintStrings);
            return BoxedUnit.UNIT;
        });
        ExportFormat exportFormat = params.outputFormat();
        ExportFormat$Arrow$ exportFormat$Arrow$ = ExportFormat$Arrow$.MODULE$;
        if (!(exportFormat != null ? !exportFormat.equals(exportFormat$Arrow$) : exportFormat$Arrow$ != null)) {
            object = hints.put((Object)QueryHints$.MODULE$.ARROW_ENCODE(), (Object)Boolean.TRUE);
        } else {
            ExportFormat exportFormat2 = params.outputFormat();
            ExportFormat$Bin$ exportFormat$Bin$ = ExportFormat$Bin$.MODULE$;
            if (!(exportFormat2 != null ? !exportFormat2.equals(exportFormat$Bin$) : exportFormat$Bin$ != null)) {
                Object object2 = !hints.containsKey((Object)QueryHints$.MODULE$.BIN_TRACK()) ? hints.put((Object)QueryHints$.MODULE$.BIN_TRACK(), (Object)"id") : BoxedUnit.UNIT;
                if (!hints.containsKey((Object)QueryHints$.MODULE$.BIN_DTG())) {
                    RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft)).foreach((Function1 & Serializable & scala.Serializable)x$5 -> hints.put((Object)QueryHints$.MODULE$.BIN_DTG(), x$5));
                }
            } else {
                ExportFormat exportFormat3 = params.outputFormat();
                ExportFormat$Leaflet$ exportFormat$Leaflet$ = ExportFormat$Leaflet$.MODULE$;
                if (!(exportFormat3 != null ? !exportFormat3.equals(exportFormat$Leaflet$) : exportFormat$Leaflet$ != null) && !LeafletMapExporter$.MODULE$.configure(params)) {
                    throw new ParameterException("Terminating execution");
                }
            }
            object = BoxedUnit.UNIT;
        }
        Buffer combined = ((BufferLike)JavaConverters$.MODULE$.asScalaBufferConverter(params.attributes()).asScala()).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(params.transforms()).asScala());
        if (combined.nonEmpty()) {
            Tuple2 tuple2 = combined.partition((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.equalsIgnoreCase("id")));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer id = (Buffer)tuple2._1();
            Buffer attributes = (Buffer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)id, (Object)attributes);
            Buffer id2 = (Buffer)tuple22._1();
            Buffer attributes2 = (Buffer)tuple22._2();
            Object object3 = id2.isEmpty() && !hints.containsKey((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID()) ? hints.put((Object)QueryHints$.MODULE$.ARROW_INCLUDE_FID(), (Object)Boolean.FALSE) : BoxedUnit.UNIT;
            stringArray = (String[])attributes2.toArray(ClassTag$.MODULE$.apply(String.class));
        } else {
            ExportFormat exportFormat4 = params.outputFormat();
            ExportFormat$Bin$ exportFormat$Bin$ = ExportFormat$Bin$.MODULE$;
            stringArray = !(exportFormat4 != null ? !exportFormat4.equals(exportFormat$Bin$) : exportFormat$Bin$ != null) ? (String[])BinAggregatingScan$.MODULE$.propertyNames(hints, sft).toArray(ClassTag$.MODULE$.apply(String.class)) : null;
        }
        String[] attributes = stringArray;
        query.setPropertyNames(attributes);
        if (!params.sortFields().isEmpty()) {
            Seq fields = ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(params.sortFields()).asScala()).toSeq();
            if (fields.exists((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)ExportCommand$.$anonfun$createQuery$10(sft, a)))) {
                Seq errors = (Seq)fields.filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)ExportCommand$.$anonfun$createQuery$11(sft, a)));
                throw new ParameterException(new StringBuilder(24).append("Invalid sort attribute").append((Object)(errors.lengthCompare(1) == 0 ? "" : "s")).append(": ").append(errors.mkString(", ")).toString());
            }
            SortOrder order = params.sortDescending() ? SortOrder.DESCENDING : SortOrder.ASCENDING;
            query.setSortBy((SortBy[])((TraversableOnce)fields.map((Function1 & Serializable & scala.Serializable)f -> package$.MODULE$.ff().sort(f, order), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SortBy.class)));
        } else if (QueryHints$.MODULE$.RichHints(hints).isArrowQuery()) {
            QueryHints$.MODULE$.RichHints(hints).getArrowSort().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ExportCommand$.$anonfun$createQuery$13(query, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Applying CQL filter {}", new Object[]{ECQL.toCQL((Filter)filter)});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Applying transform {}", new Object[]{Option$.MODULE$.apply((Object)attributes).map((Function1 & Serializable & scala.Serializable)x$8 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$8)).mkString(",")).orNull(Predef$.MODULE$.$conforms())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return QueryRunner$.MODULE$.configureDefaultQuery(sft, query);
    }

    public void disableAggregation(SimpleFeatureType sft, Hints hints) {
        if (QueryHints$.MODULE$.RichHints(hints).isArrowQuery()) {
            hints.remove((Object)QueryHints$.MODULE$.ARROW_ENCODE());
            String sort = (String)hints.remove((Object)QueryHints$.MODULE$.ARROW_SORT_FIELD());
            if (sort != null) {
                Option reverse = Option$.MODULE$.apply((Object)((Boolean)hints.remove((Object)QueryHints$.MODULE$.ARROW_SORT_REVERSE())));
                SortOrder order = reverse.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9)) ? SortOrder.DESCENDING : SortOrder.ASCENDING;
                SortBy hint = package$.MODULE$.ff().sort(sort, order);
                hints.put((Object)QueryHints.Internal$.MODULE$.SORT_FIELDS(), (Object)QueryHints.Internal$.MODULE$.toSortHint((SortBy[])((Object[])new SortBy[]{hint})));
                return;
            }
            return;
        }
        if (QueryHints$.MODULE$.RichHints(hints).isBinQuery()) {
            hints.remove((Object)QueryHints$.MODULE$.BIN_TRACK());
            if (QueryHints$.MODULE$.RichHints(hints).isBinSorting()) {
                QueryHints$.MODULE$.RichHints(hints).getBinDtgField().orElse((Function0 & Serializable & scala.Serializable)() -> RichSimpleFeatureType.RichSimpleFeatureType$.MODULE$.getDtgField$extension(RichSimpleFeatureType$.MODULE$.RichSimpleFeatureType(sft))).foreach((Function1 & Serializable & scala.Serializable)dtg -> {
                    SortBy hint = package$.MODULE$.ff().sort(dtg, SortOrder.ASCENDING);
                    return hints.put((Object)QueryHints.Internal$.MODULE$.SORT_FIELDS(), (Object)QueryHints.Internal$.MODULE$.toSortHint((SortBy[])((Object[])new SortBy[]{hint})));
                });
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$createQuery$2(Object x) {
        return BoxesRunTime.unboxToInt((Object)x);
    }

    public static final /* synthetic */ void $anonfun$createQuery$5(Hints hints$1, ExportCommand.ExportParams p) {
        Option$.MODULE$.apply((Object)((OptionalIndexParam)((Object)p)).index()).foreach((Function1 & Serializable & scala.Serializable)index -> {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isDebugEnabled()) {
                MODULE$.logger().underlying().debug("Using index {}", new Object[]{index});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return hints$1.put((Object)QueryHints$.MODULE$.QUERY_INDEX(), index);
        });
    }

    public static final /* synthetic */ void $anonfun$createQuery$7(Hints hints$1, Query query$1, Map hintStrings) {
        hints$1.put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, (Object)hintStrings);
        ViewParams$.MODULE$.setHints(query$1);
    }

    public static final /* synthetic */ boolean $anonfun$createQuery$10(SimpleFeatureType sft$1, String a) {
        return sft$1.indexOf(a) == -1;
    }

    public static final /* synthetic */ boolean $anonfun$createQuery$11(SimpleFeatureType sft$1, String a) {
        return sft$1.indexOf(a) == -1;
    }

    public static final /* synthetic */ void $anonfun$createQuery$13(Query query$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String f = (String)tuple2._1();
            boolean r = tuple2._2$mcZ$sp();
            SortOrder order = r ? SortOrder.DESCENDING : SortOrder.ASCENDING;
            query$1.setSortBy(new SortBy[]{package$.MODULE$.ff().sort(f, order)});
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private ExportCommand$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$tools$export$ExportCommand$$CountKey = "count";
    }
}

