/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.utils;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.validators.PositiveInteger;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.facebook.nailgun.NGServer;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.utils.NailgunServer$;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.concurrent.CachedThreadPool$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.MapLike;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0011ub\u0001\u00020`\u0001)D\u0001\"\u001e\u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\t}\u0002\u0011\t\u0011)A\u0005\u007f\"I\u00111\u0002\u0001\u0003\u0002\u0003\u0006Ia \u0005\n\u0003\u001b\u0001!\u0011!Q\u0001\n}D!\"a\u0004\u0001\u0005\u0003\u0005\u000b\u0011BA\t\u0011\u001d\t9\u0002\u0001C\u0001\u00033A\u0011\"!\u000b\u0001\u0005\u0004%I!a\u000b\t\u0011\u0005u\u0002\u0001)A\u0005\u0003[A\u0011\"a\u0010\u0001\u0005\u0004%I!!\u0011\t\u0011\u0005M\u0003\u0001)A\u0005\u0003\u0007B\u0011\"!\u0016\u0001\u0005\u0004%I!a\u0016\t\u0011\u0005e\u0003\u0001)A\u0005\u0003#A\u0011\"a\u0017\u0001\u0005\u0004%I!!\u0018\t\u0011\u0005-\u0004\u0001)A\u0005\u0003?B\u0011\"!\u001c\u0001\u0005\u0004%I!a\u001c\t\u0011\u0005E\u0006\u0001)A\u0005\u0003cB\u0011\"a-\u0001\u0005\u0004%I!!.\t\u0011\u0005\u001d\u0007\u0001)A\u0005\u0003oCq!a6\u0001\t\u0003\tI\u000eC\u0004\u0003\u0004\u0001!\t!a\u0016\t\u000f\t\u0015\u0001\u0001\"\u0001\u0003\b!9A\u0011\u0007\u0001\u0005B\t=cA\u0002C\u001a\u0001\u0001!)\u0004C\u0004\u0002\u0018]!\t\u0001b\u000e\t\u000f\rUt\u0003\"\u0011\u0003P\u001d9!\u0011E0\t\u0002\t\rbA\u00020`\u0011\u0003\u0011)\u0003C\u0004\u0002\u0018m!\tA!\f\t\u000f\t=2\u0004\"\u0001\u00032\u0019I!QH\u000e\u0011\u0002\u0007\u0005!q\b\u0005\b\u0005\u001brB\u0011\u0001B(\u0011!qg\u00041A\u0005\u0002\tE\u0003\"\u0003B-=\u0001\u0007I\u0011\u0001B.\r\u0019\u0011\tg\u0007!\u0003d!Q!\u0011\u000f\u0012\u0003\u0016\u0004%\tAa\u001d\t\u0015\tU$E!E!\u0002\u0013\tI\t\u0003\u0006\u0003x\t\u0012)\u001a!C\u0001\u0005sB\u0011Ba\u001f#\u0005#\u0005\u000b\u0011B@\t\u0015\tu$E!f\u0001\n\u0003\t9\u0006\u0003\u0006\u0003\u0000\t\u0012\t\u0012)A\u0005\u0003#A!B!!#\u0005+\u0007I\u0011\u0001BB\u0011)\u0011YI\tB\tB\u0003%!Q\u0011\u0005\u000b\u0005\u001b\u0013#Q3A\u0005\u0002\t\r\u0005B\u0003BHE\tE\t\u0015!\u0003\u0003\u0006\"Q!\u0011\u0013\u0012\u0003\u0016\u0004%\tAa!\t\u0015\tM%E!E!\u0002\u0013\u0011)\t\u0003\u0006\u0003\u0016\n\u0012)\u001a!C\u0001\u0005\u0007C!Ba&#\u0005#\u0005\u000b\u0011\u0002BC\u0011\u001d\t9B\tC\u0001\u00053C\u0011B!,#\u0003\u0003%\tAa,\t\u0013\t}&%%A\u0005\u0002\t\u0005\u0007\"\u0003BlEE\u0005I\u0011\u0001Bm\u0011%\u0011iNII\u0001\n\u0003\u0011y\u000eC\u0005\u0003d\n\n\n\u0011\"\u0001\u0003f\"I!\u0011\u001e\u0012\u0012\u0002\u0013\u0005!Q\u001d\u0005\n\u0005W\u0014\u0013\u0013!C\u0001\u0005KD\u0011B!<##\u0003%\tA!:\t\u0013\t=(%!A\u0005B\tE\b\"\u0003B|E\u0005\u0005I\u0011\u0001B=\u0011%\u0011IPIA\u0001\n\u0003\u0011Y\u0010C\u0005\u0003\u0000\n\n\t\u0011\"\u0011\u0004\u0002!I1q\u0002\u0012\u0002\u0002\u0013\u00051\u0011\u0003\u0005\n\u00077\u0011\u0013\u0011!C!\u0007;A\u0011ba\b#\u0003\u0003%\te!\t\t\u0013\r\r\"%!A\u0005B\r\u0015r!CB\u00157\u0005\u0005\t\u0012AB\u0016\r%\u0011\tgGA\u0001\u0012\u0003\u0019i\u0003C\u0004\u0002\u0018\r#\taa\u000f\t\u0013\r}1)!A\u0005F\r\u0005\u0002\"CB\u001f\u0007\u0006\u0005I\u0011QB \u0011%\u0019yeQA\u0001\n\u0003\u001b\t\u0006C\u0005\u0004`\r\u000b\t\u0011\"\u0003\u0004b\u0019111M\u000e\u0001\u0007KB\u0011b!\u001cJ\u0005\u0003\u0005\u000b\u0011B6\t\u000f\u0005]\u0011\n\"\u0001\u0004p!91QO%\u0005B\t=cABB<7\u0001\u0019I\bC\u0004\u0002\u00185#\taa\u001f\t\u0017\r}T\n1AA\u0002\u0013\u0005!1\u000f\u0005\f\u0007\u0003k\u0005\u0019!a\u0001\n\u0003\u0019\u0019\tC\u0006\u0004\b6\u0003\r\u0011!Q!\n\u0005%\u0005\u0002\u0003@N\u0001\u0004%\tA!\u001f\t\u0013\r%V\n1A\u0005\u0002\r-\u0006bBBX\u001b\u0002\u0006Ka \u0005\n\u0007\u001fl\u0005\u0019!C\u0001\u0005sB\u0011b!5N\u0001\u0004%\taa5\t\u000f\r]W\n)Q\u0005\u007f\"I1q]'A\u0002\u0013\u00051\u0011\u001e\u0005\n\u0007sl\u0005\u0019!C\u0001\u0007wD\u0001ba@NA\u0003&11\u001e\u0005\n\u0003gk\u0005\u0019!C\u0001\u0007SD\u0011\u0002b\bN\u0001\u0004%\t\u0001\"\t\t\u0011\u0005\u001dW\n)Q\u0005\u0007W\u0014QBT1jY\u001e,hnU3sm\u0016\u0014(B\u00011b\u0003\u0015)H/\u001b7t\u0015\t\u00117-A\u0003u_>d7O\u0003\u0002eK\u00069q-Z8nKN\f'B\u00014h\u00031awnY1uS>tG/Z2i\u0015\u0005A\u0017aA8sO\u000e\u00011C\u0001\u0001l!\ta7/D\u0001n\u0015\tqw.A\u0004oC&dw-\u001e8\u000b\u0005A\f\u0018\u0001\u00034bG\u0016\u0014wn\\6\u000b\u0003I\f1aY8n\u0013\t!XN\u0001\u0005O\u000fN+'O^3s\u0003\u0011\tG\r\u001a:\u0011\u0005]dX\"\u0001=\u000b\u0005eT\u0018a\u00018fi*\t10\u0001\u0003kCZ\f\u0017BA?y\u0005-Ie.\u001a;BI\u0012\u0014Xm]:\u0002\tA|'\u000f\u001e\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0011\u0011QA\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003\u0013\t\u0019AA\u0002J]R\fqb]3tg&|g\u000eU8pYNK'0Z\u0001\u000ei&lWm\\;u\u001b&dG.[:\u0002#%$G.\u001a+j[\u0016|W\u000f^'jY2L7\u000f\u0005\u0003\u0002\u0002\u0005M\u0011\u0002BA\u000b\u0003\u0007\u0011A\u0001T8oO\u00061A(\u001b8jiz\"B\"a\u0007\u0002 \u0005\u0005\u00121EA\u0013\u0003O\u00012!!\b\u0001\u001b\u0005y\u0006\"B;\u0007\u0001\u00041\b\"\u0002@\u0007\u0001\u0004y\bBBA\u0006\r\u0001\u0007q\u0010\u0003\u0004\u0002\u000e\u0019\u0001\ra \u0005\b\u0003\u001f1\u0001\u0019AA\t\u0003!\u0011XmZ5tiJLXCAA\u0017!\u0011\ty#!\u000f\u000e\u0005\u0005E\"\u0002BA\u001a\u0003k\tq!\\3ue&\u001c7OC\u0002\u00028E\f\u0001bY8eC\"\fG.Z\u0005\u0005\u0003w\t\tD\u0001\bNKR\u0014\u0018n\u0019*fO&\u001cHO]=\u0002\u0013I,w-[:uef\u0004\u0013\u0001\u0003:fcV,7\u000f^:\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u001fj!!a\u0012\u000b\t\u0005%\u00131J\u0001\u000bG>t7-\u001e:sK:$(bAA'u\u0006!Q\u000f^5m\u0013\u0011\t\t&a\u0012\u0003\rAC\u0017m]3s\u0003%\u0011X-];fgR\u001c\b%A\u0003ti\u0006\u0014H/\u0006\u0002\u0002\u0012\u000511\u000f^1si\u0002\n1\u0002\\1tiJ+\u0017/^3tiV\u0011\u0011q\f\t\u0005\u0003C\n9'\u0004\u0002\u0002d)!\u0011QMA$\u0003\u0019\tGo\\7jG&!\u0011\u0011NA2\u0005)\tEo\\7jG2{gnZ\u0001\rY\u0006\u001cHOU3rk\u0016\u001cH\u000fI\u0001\u0007i&lWM]:\u0016\u0005\u0005E\u0004\u0003CA:\u0003\u000b\u000bI)a(\u000e\u0005\u0005U$\u0002BA<\u0003s\nQaY1dQ\u0016TA!a\u001f\u0002~\u0005A1-\u00194gK&tWM\u0003\u0003\u0002\u0000\u0005\u0005\u0015\u0001\u00032f]6\fg.Z:\u000b\u0007\u0005\r\u0015/\u0001\u0004hSRDWOY\u0005\u0005\u0003\u000f\u000b)H\u0001\u0007M_\u0006$\u0017N\\4DC\u000eDW\r\u0005\u0003\u0002\f\u0006ee\u0002BAG\u0003+\u0003B!a$\u0002\u00045\u0011\u0011\u0011\u0013\u0006\u0004\u0003'K\u0017A\u0002\u001fs_>$h(\u0003\u0003\u0002\u0018\u0006\r\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001c\u0006u%AB*ue&twM\u0003\u0003\u0002\u0018\u0006\r\u0001\u0003CA\u0001\u0003C\u000b)+a+\n\t\u0005\r\u00161\u0001\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005\u0005\u0014qU\u0005\u0005\u0003S\u000b\u0019GA\u0007Bi>l\u0017nY%oi\u0016<WM\u001d\t\u0005\u0003_\ti+\u0003\u0003\u00020\u0006E\"!\u0002+j[\u0016\u0014\u0018a\u0002;j[\u0016\u00148\u000fI\u0001\u0005S\u0012dW-\u0006\u0002\u00028B\"\u0011\u0011XAb!\u0019\t)%a/\u0002@&!\u0011QXA$\u0005\u00191U\u000f^;sKB!\u0011\u0011YAb\u0019\u0001!1\"!2\u0013\u0003\u0003\u0005\tQ!\u0001\u0002J\n\u0019q\fJ\u0019\u0002\u000b%$G.\u001a\u0011\u0012\t\u0005-\u0017\u0011\u001b\t\u0005\u0003\u0003\ti-\u0003\u0003\u0002P\u0006\r!a\u0002(pi\"Lgn\u001a\t\u0005\u0003\u0003\t\u0019.\u0003\u0003\u0002V\u0006\r!aA!os\u00069Q\r_3dkR,G\u0003BAn\u0003C\u0004B!!\u0001\u0002^&!\u0011q\\A\u0002\u0005\u0011)f.\u001b;\t\u000f\u0005\r8\u00031\u0001\u0002f\u000691m\\7nC:$\u0007\u0003BAt\u0003{tA!!;\u0002z:!\u00111^A|\u001d\u0011\ti/!>\u000f\t\u0005=\u00181\u001f\b\u0005\u0003\u001f\u000b\t0C\u0001i\u0013\t1w-\u0003\u0002eK&\u0011!mY\u0005\u0004\u0003w\f\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003\u007f\u0014\tAA\u0004D_6l\u0017M\u001c3\u000b\u0007\u0005m\u0018-A\u0004ti\u0006\u0014H/\u001a3\u0002\u000bM$\u0018\r^:\u0016\u0005\t%\u0001C\u0002B\u0006\u0005'\u0011IB\u0004\u0003\u0003\u000e\tEa\u0002BAH\u0005\u001fI!!!\u0002\n\t\u0005m\u00181A\u0005\u0005\u0005+\u00119BA\u0002TKFTA!a?\u0002\u0004A\u0019!1\u0004\u0012\u000f\u0007\tu!D\u0004\u0003\u0002j\n}\u0011B\u00011b\u00035q\u0015-\u001b7hk:\u001cVM\u001d<feB\u0019\u0011QD\u000e\u0014\u0007m\u00119\u0003\u0005\u0003\u0002\u0002\t%\u0012\u0002\u0002B\u0016\u0003\u0007\u0011a!\u00118z%\u00164GC\u0001B\u0012\u0003\u0011i\u0017-\u001b8\u0015\t\u0005m'1\u0007\u0005\b\u0005ki\u0002\u0019\u0001B\u001c\u0003\u0011\t'oZ:\u0011\r\u0005\u0005!\u0011HAE\u0013\u0011\u0011Y$a\u0001\u0003\u000b\u0005\u0013(/Y=\u0003\u00199\u000b\u0017\u000e\\4v]\u0006;\u0018M]3\u0014\u000by\u0011\t%!:\u0011\t\t\r#\u0011J\u0007\u0003\u0005\u000bR1Aa\u0012{\u0003\u0011a\u0017M\\4\n\t\t-#Q\t\u0002\u0007\u001f\nTWm\u0019;\u0002\r\u0011Jg.\u001b;%)\t\tY.\u0006\u0002\u0003TA1\u0011\u0011\u0001B+\u00037IAAa\u0016\u0002\u0004\t1q\n\u001d;j_:\f1B\\1jY\u001e,hn\u0018\u0013fcR!\u00111\u001cB/\u0011%\u0011y&IA\u0001\u0002\u0004\u0011\u0019&A\u0002yIE\u00121bQ8n[\u0006tGm\u0015;biN9!Ea\n\u0003f\t-\u0004\u0003BA\u0001\u0005OJAA!\u001b\u0002\u0004\t9\u0001K]8ek\u000e$\b\u0003BA\u0001\u0005[JAAa\u001c\u0002\u0004\ta1+\u001a:jC2L'0\u00192mK\u0006!a.Y7f+\t\tI)A\u0003oC6,\u0007%\u0001\u0004bGRLg/Z\u000b\u0002\u007f\u00069\u0011m\u0019;jm\u0016\u0004\u0013\u0001C2p[BdW\r^3\u0002\u0013\r|W\u000e\u001d7fi\u0016\u0004\u0013\u0001B7fC:,\"A!\"\u0011\t\u0005\u0005!qQ\u0005\u0005\u0005\u0013\u000b\u0019A\u0001\u0004E_V\u0014G.Z\u0001\u0006[\u0016\fg\u000eI\u0001\u0007[\u0016$\u0017.\u00198\u0002\u000f5,G-[1oA\u0005\u0019a.O\u001b\u0002\t9LT\u0007I\u0001\u0005e\u0006$X-A\u0003sCR,\u0007\u0005\u0006\t\u0003\u001c\n}%\u0011\u0015BR\u0005K\u00139K!+\u0003,B\u0019!Q\u0014\u0012\u000e\u0003mAqA!\u001d2\u0001\u0004\tI\t\u0003\u0004\u0003xE\u0002\ra \u0005\b\u0005{\n\u0004\u0019AA\t\u0011\u001d\u0011\t)\ra\u0001\u0005\u000bCqA!$2\u0001\u0004\u0011)\tC\u0004\u0003\u0012F\u0002\rA!\"\t\u000f\tU\u0015\u00071\u0001\u0003\u0006\u0006!1m\u001c9z)A\u0011YJ!-\u00034\nU&q\u0017B]\u0005w\u0013i\fC\u0005\u0003rI\u0002\n\u00111\u0001\u0002\n\"A!q\u000f\u001a\u0011\u0002\u0003\u0007q\u0010C\u0005\u0003~I\u0002\n\u00111\u0001\u0002\u0012!I!\u0011\u0011\u001a\u0011\u0002\u0003\u0007!Q\u0011\u0005\n\u0005\u001b\u0013\u0004\u0013!a\u0001\u0005\u000bC\u0011B!%3!\u0003\u0005\rA!\"\t\u0013\tU%\u0007%AA\u0002\t\u0015\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u0007TC!!#\u0003F.\u0012!q\u0019\t\u0005\u0005\u0013\u0014\u0019.\u0004\u0002\u0003L*!!Q\u001aBh\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003R\u0006\r\u0011AC1o]>$\u0018\r^5p]&!!Q\u001bBf\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011YNK\u0002\u0000\u0005\u000b\fabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003b*\"\u0011\u0011\u0003Bc\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"Aa:+\t\t\u0015%QY\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY\nabY8qs\u0012\"WMZ1vYR$s'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005g\u0004BAa\u0011\u0003v&!\u00111\u0014B#\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!5\u0003~\"A!q\f\u001f\u0002\u0002\u0003\u0007q0A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019\u0019\u0001\u0005\u0004\u0004\u0006\r-\u0011\u0011[\u0007\u0003\u0007\u000fQAa!\u0003\u0002\u0004\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\r51q\u0001\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0004\u0014\re\u0001\u0003BA\u0001\u0007+IAaa\u0006\u0002\u0004\t9!i\\8mK\u0006t\u0007\"\u0003B0}\u0005\u0005\t\u0019AAi\u0003!A\u0017m\u001d5D_\u0012,G#A@\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa=\u0002\r\u0015\fX/\u00197t)\u0011\u0019\u0019ba\n\t\u0013\t}\u0013)!AA\u0002\u0005E\u0017aC\"p[6\fg\u000eZ*uCR\u00042A!(D'\u0015\u00195q\u0006B6!M\u0019\tda\u000e\u0002\n~\f\tB!\"\u0003\u0006\n\u0015%Q\u0011BN\u001b\t\u0019\u0019D\u0003\u0003\u00046\u0005\r\u0011a\u0002:v]RLW.Z\u0005\u0005\u0007s\u0019\u0019DA\tBEN$(/Y2u\rVt7\r^5p]^\"\"aa\u000b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015!\tm5\u0011IB\"\u0007\u000b\u001a9e!\u0013\u0004L\r5\u0003b\u0002B9\r\u0002\u0007\u0011\u0011\u0012\u0005\u0007\u0005o2\u0005\u0019A@\t\u000f\tud\t1\u0001\u0002\u0012!9!\u0011\u0011$A\u0002\t\u0015\u0005b\u0002BG\r\u0002\u0007!Q\u0011\u0005\b\u0005#3\u0005\u0019\u0001BC\u0011\u001d\u0011)J\u0012a\u0001\u0005\u000b\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004T\rm\u0003CBA\u0001\u0005+\u001a)\u0006E\t\u0002\u0002\r]\u0013\u0011R@\u0002\u0012\t\u0015%Q\u0011BC\u0005\u000bKAa!\u0017\u0002\u0004\t1A+\u001e9mK^B\u0011b!\u0018H\u0003\u0003\u0005\rAa'\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B!\u0005!\u0019\u0006.\u001e;e_^t7#B%\u0003B\r\u001d\u0004\u0003\u0002B\"\u0007SJAaa\u001b\u0003F\tA!+\u001e8oC\ndW-\u0001\u0002oOR!1\u0011OB:!\r\u0011i*\u0013\u0005\u0007\u0007[Z\u0005\u0019A6\u0002\u0007I,hNA\u0007OC&dw-\u001e8QCJ\fWn]\n\u0004\u001b\n\u001dBCAB?!\r\u0011i*T\u0001\u0005Q>\u001cH/\u0001\u0005i_N$x\fJ3r)\u0011\tYn!\"\t\u0013\t}\u0003+!AA\u0002\u0005%\u0015!\u00025pgR\u0004\u0003fC)\u0004\f\u000em5QTBR\u0007K\u0003Ba!$\u0004\u00186\u00111q\u0012\u0006\u0005\u0007#\u001b\u0019*\u0001\u0006kG>lW.\u00198eKJT1a!&r\u0003\u0015\u0011W-^:u\u0013\u0011\u0019Ija$\u0003\u0013A\u000b'/Y7fi\u0016\u0014\u0018!\u00028b[\u0016\u001cHFABPC\t\u0019\t+\u0001\u0004.[!|7\u000f^\u0001\fI\u0016\u001c8M]5qi&|g.\t\u0002\u0004(\u00069\u0012\t\u001a3sKN\u001c\b\u0005^8!E&tG\rI1hC&t7\u000f^\u0001\ta>\u0014Ho\u0018\u0013fcR!\u00111\\BW\u0011!\u0011yfUA\u0001\u0002\u0004y\u0018!\u00029peR\u0004\u0003f\u0004+\u0004\f\u000em51WBR\u0007s\u001bila0-\u0005\rU\u0016EAB\\\u0003\u0019iS\u0006]8si\u0006\u001211X\u0001\u0015!>\u0014H\u000f\t;pA\tLg\u000e\u001a\u0011bO\u0006Lgn\u001d;\u0002\u0019Y\fG.\u001b3bi\u0016<\u0016\u000e\u001e5-\u0005\r\u00057EABb!\u0011\u0019)ma3\u000e\u0005\r\u001d'\u0002BBe\u0007\u001f\u000b!B^1mS\u0012\fGo\u001c:t\u0013\u0011\u0019ima2\u0003\u001fA{7/\u001b;jm\u0016Le\u000e^3hKJ\f\u0001\u0002]8pYNK'0Z\u0001\ra>|GnU5{K~#S-\u001d\u000b\u0005\u00037\u001c)\u000e\u0003\u0005\u0003`Y\u000b\t\u00111\u0001\u0000\u0003%\u0001xn\u001c7TSj,\u0007\u0005K\bX\u0007\u0017\u001bYja7\u0004$\u000e\u00058QXBsY\t\u0019i.\t\u0002\u0004`\u0006YQ&\f9p_2l3/\u001b>fC\t\u0019\u0019/\u0001\u001aTSj,\u0007e\u001c4!i\",\u0007\u0005\u001e5sK\u0006$\u0007\u0005]8pY\u0002*8/\u001a3!M>\u0014\b\u0005[1oI2Lgn\u001a\u0011sKF,Xm\u001d;tY\t\u0019\t-A\u0004uS6,w.\u001e;\u0016\u0005\r-\b\u0003BBw\u0007kl!aa<\u000b\t\rE81_\u0001\tIV\u0014\u0018\r^5p]*!\u0011\u0011JA\u0002\u0013\u0011\u00199pa<\u0003\u0011\u0011+(/\u0019;j_:\f1\u0002^5nK>,Ho\u0018\u0013fcR!\u00111\\B\u007f\u0011%\u0011y&WA\u0001\u0002\u0004\u0019Y/\u0001\u0005uS6,w.\u001e;!Q=Q61RBN\t\u0007\u0019\u0019\u000b\"\u0003\u0005\u000e\u0011=AF\u0001C\u0003C\t!9!A\u0005.[QLW.Z8vi\u0006\u0012A1B\u0001[\u001b\u0006D\u0018.\\;nA%tG/\u001a:wC2\u0004Co\u001c\u0011xC&$\bEY3uo\u0016,g\u000e\t5fCJ$(-Z1ug\u0002\u0012WMZ8sK\u0002\u001awN\\:jI\u0016\u0014\u0018N\\4!G2LWM\u001c;!i>\u0004\u0003.\u0019<fA\u0011L7oY8o]\u0016\u001cG/\u001a3\u0002\u0013\r|gN^3si\u0016\u00148E\u0001C\t!\u0011!\u0019\u0002\"\u0007\u000f\t\tuAQC\u0005\u0004\t/y\u0016a\u0005)be\u0006lW\r^3s\u0007>tg/\u001a:uKJ\u001c\u0018\u0002\u0002C\u000e\t;\u0011\u0011\u0003R;sCRLwN\\\"p]Z,'\u000f^3s\u0015\r!9bX\u0001\tS\u0012dWm\u0018\u0013fcR!\u00111\u001cC\u0012\u0011%\u0011y\u0006XA\u0001\u0002\u0004\u0019Y\u000fK\b^\u0007\u0017\u001bY\nb\n\u0004$\u00125BQ\u0002C\bY\t!I#\t\u0002\u0005,\u00051Q&L5eY\u0016\f#\u0001b\f\u0002kQKW.\u001a\u0011cK\u001a|'/\u001a\u0011uQ\u0016\u00043/\u001a:wKJ\u0004\u0013n\u001d\u0011tQV$\b\u0005Z8x]\u0002\"W/\u001a\u0011u_\u0002Jg.Y2uSZLG/_\u0001\tg\",H\u000fZ8x]\nI\u0011\n\u001a7f\u0007\",7m[\n\u0006/\t\u00053q\r\u000b\u0003\ts\u00012\u0001b\u000f\u0018\u001b\u0005\u0001\u0001")
public class NailgunServer
extends NGServer {
    public final long org$locationtech$geomesa$tools$utils$NailgunServer$$idleTimeoutMillis;
    private final MetricRegistry org$locationtech$geomesa$tools$utils$NailgunServer$$registry;
    private final Phaser org$locationtech$geomesa$tools$utils$NailgunServer$$requests;
    private final long start;
    private final AtomicLong org$locationtech$geomesa$tools$utils$NailgunServer$$lastRequest;
    private final LoadingCache<String, Tuple2<AtomicInteger, Timer>> timers;
    private final Future<?> idle;

    public static void main(String[] stringArray) {
        NailgunServer$.MODULE$.main(stringArray);
    }

    public MetricRegistry org$locationtech$geomesa$tools$utils$NailgunServer$$registry() {
        return this.org$locationtech$geomesa$tools$utils$NailgunServer$$registry;
    }

    public Phaser org$locationtech$geomesa$tools$utils$NailgunServer$$requests() {
        return this.org$locationtech$geomesa$tools$utils$NailgunServer$$requests;
    }

    private long start() {
        return this.start;
    }

    public AtomicLong org$locationtech$geomesa$tools$utils$NailgunServer$$lastRequest() {
        return this.org$locationtech$geomesa$tools$utils$NailgunServer$$lastRequest;
    }

    private LoadingCache<String, Tuple2<AtomicInteger, Timer>> timers() {
        return this.timers;
    }

    private Future<?> idle() {
        return this.idle;
    }

    public void execute(package.Command command) {
        this.org$locationtech$geomesa$tools$utils$NailgunServer$$requests().register();
        this.org$locationtech$geomesa$tools$utils$NailgunServer$$lastRequest().set(System.currentTimeMillis());
        try {
            package.Command command2 = command;
            if (command2 instanceof NailgunAware) {
                NailgunAware nailgunAware = (NailgunAware)command2;
                nailgunAware.nailgun_$eq((Option<NailgunServer>)new Some((Object)this));
            }
            Tuple2 tuple2 = (Tuple2)this.timers().get((Object)command.name());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AtomicInteger active = (AtomicInteger)tuple2._1();
            Timer timer = (Timer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)active, (Object)timer);
            AtomicInteger active2 = (AtomicInteger)tuple22._1();
            Timer timer2 = (Timer)tuple22._2();
            active2.incrementAndGet();
            try {
                timer2.time((Runnable)command);
            }
            finally {
                active2.decrementAndGet();
            }
        }
        finally {
            this.org$locationtech$geomesa$tools$utils$NailgunServer$$requests().arriveAndDeregister();
        }
    }

    public long started() {
        return this.start();
    }

    public Seq<CommandStat> stats() {
        return (Seq)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.timers().asMap()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    AtomicInteger active = (AtomicInteger)tuple22._1();
                    Timer timer = (Timer)tuple22._2();
                    Snapshot snap = timer.getSnapshot();
                    return new CommandStat(name, active.get(), timer.getCount(), snap.getMean(), snap.getMedian(), snap.get95thPercentile(), timer.getMeanRate());
                }
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void shutdown() {
        super.shutdown();
        this.idle().cancel(true);
    }

    public NailgunServer(InetAddress addr, int port, int sessionPoolSize, int timeoutMillis, long idleTimeoutMillis) {
        this.org$locationtech$geomesa$tools$utils$NailgunServer$$idleTimeoutMillis = idleTimeoutMillis;
        super(addr, port, sessionPoolSize, timeoutMillis);
        this.org$locationtech$geomesa$tools$utils$NailgunServer$$registry = new MetricRegistry();
        this.org$locationtech$geomesa$tools$utils$NailgunServer$$requests = new Phaser(1);
        this.start = System.currentTimeMillis();
        this.org$locationtech$geomesa$tools$utils$NailgunServer$$lastRequest = new AtomicLong(System.currentTimeMillis());
        this.timers = Caffeine.newBuilder().build((CacheLoader)new CacheLoader<String, Tuple2<AtomicInteger, Timer>>(this){
            private final /* synthetic */ NailgunServer $outer;

            public Map<String, Tuple2<AtomicInteger, Timer>> loadAll(Iterable<? extends String> x$1) throws Exception {
                return super.loadAll(x$1);
            }

            public CompletableFuture asyncLoad(Object x$1, Executor x$2) {
                return super.asyncLoad(x$1, x$2);
            }

            public CompletableFuture<Map<String, Tuple2<AtomicInteger, Timer>>> asyncLoadAll(Iterable<? extends String> x$1, Executor x$2) {
                return super.asyncLoadAll(x$1, x$2);
            }

            public Object reload(Object x$1, Object x$2) throws Exception {
                return super.reload(x$1, x$2);
            }

            public CompletableFuture asyncReload(Object x$1, Object x$2, Executor x$3) {
                return super.asyncReload(x$1, x$2, x$3);
            }

            public Tuple2<AtomicInteger, Timer> load(String k) {
                return new Tuple2((Object)new AtomicInteger(0), (Object)this.$outer.org$locationtech$geomesa$tools$utils$NailgunServer$$registry().timer(k));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.idle = CachedThreadPool$.MODULE$.submit((Runnable)new IdleCheck());
    }

    public static class CommandStat
    implements Product,
    scala.Serializable {
        private final String name;
        private final int active;
        private final long complete;
        private final double mean;
        private final double median;
        private final double n95;
        private final double rate;

        public String name() {
            return this.name;
        }

        public int active() {
            return this.active;
        }

        public long complete() {
            return this.complete;
        }

        public double mean() {
            return this.mean;
        }

        public double median() {
            return this.median;
        }

        public double n95() {
            return this.n95;
        }

        public double rate() {
            return this.rate;
        }

        public CommandStat copy(String name, int active, long complete, double mean, double median, double n95, double rate) {
            return new CommandStat(name, active, complete, mean, median, n95, rate);
        }

        public String copy$default$1() {
            return this.name();
        }

        public int copy$default$2() {
            return this.active();
        }

        public long copy$default$3() {
            return this.complete();
        }

        public double copy$default$4() {
            return this.mean();
        }

        public double copy$default$5() {
            return this.median();
        }

        public double copy$default$6() {
            return this.n95();
        }

        public double copy$default$7() {
            return this.rate();
        }

        public String productPrefix() {
            return "CommandStat";
        }

        public int productArity() {
            return 7;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.active());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this.complete());
                }
                case 3: {
                    return BoxesRunTime.boxToDouble((double)this.mean());
                }
                case 4: {
                    return BoxesRunTime.boxToDouble((double)this.median());
                }
                case 5: {
                    return BoxesRunTime.boxToDouble((double)this.n95());
                }
                case 6: {
                    return BoxesRunTime.boxToDouble((double)this.rate());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof CommandStat;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)this.active());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.complete()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.mean()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.median()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.n95()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.rate()));
            return Statics.finalizeHash((int)n, (int)7);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof CommandStat)) return false;
            boolean bl = true;
            if (!bl) return false;
            CommandStat commandStat = (CommandStat)x$1;
            String string = this.name();
            String string2 = commandStat.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.active() != commandStat.active()) return false;
            if (this.complete() != commandStat.complete()) return false;
            if (this.mean() != commandStat.mean()) return false;
            if (this.median() != commandStat.median()) return false;
            if (this.n95() != commandStat.n95()) return false;
            if (this.rate() != commandStat.rate()) return false;
            if (!commandStat.canEqual(this)) return false;
            return true;
        }

        public CommandStat(String name, int active, long complete, double mean, double median, double n95, double rate) {
            this.name = name;
            this.active = active;
            this.complete = complete;
            this.mean = mean;
            this.median = median;
            this.n95 = n95;
            this.rate = rate;
            Product.$init$((Product)this);
        }
    }

    public class IdleCheck
    implements Runnable {
        @Override
        public void run() {
            boolean loop = true;
            try {
                Thread.sleep(this.org$locationtech$geomesa$tools$utils$NailgunServer$IdleCheck$$$outer().org$locationtech$geomesa$tools$utils$NailgunServer$$idleTimeoutMillis);
            }
            catch (InterruptedException interruptedException) {
                loop = false;
            }
            while (loop) {
                try {
                    long remaining;
                    int phase = this.org$locationtech$geomesa$tools$utils$NailgunServer$IdleCheck$$$outer().org$locationtech$geomesa$tools$utils$NailgunServer$$requests().arrive();
                    if (this.org$locationtech$geomesa$tools$utils$NailgunServer$IdleCheck$$$outer().org$locationtech$geomesa$tools$utils$NailgunServer$$requests().getPhase() == phase) {
                        this.org$locationtech$geomesa$tools$utils$NailgunServer$IdleCheck$$$outer().org$locationtech$geomesa$tools$utils$NailgunServer$$requests().awaitAdvanceInterruptibly(phase);
                        Thread.sleep(30000L);
                    }
                    if ((remaining = this.org$locationtech$geomesa$tools$utils$NailgunServer$IdleCheck$$$outer().org$locationtech$geomesa$tools$utils$NailgunServer$$idleTimeoutMillis - (System.currentTimeMillis() - this.org$locationtech$geomesa$tools$utils$NailgunServer$IdleCheck$$$outer().org$locationtech$geomesa$tools$utils$NailgunServer$$lastRequest().get())) <= 0L) {
                        loop = false;
                        this.org$locationtech$geomesa$tools$utils$NailgunServer$IdleCheck$$$outer().shutdown();
                        continue;
                    }
                    Thread.sleep(remaining);
                }
                catch (InterruptedException interruptedException) {
                    loop = false;
                }
            }
        }

        public /* synthetic */ NailgunServer org$locationtech$geomesa$tools$utils$NailgunServer$IdleCheck$$$outer() {
            return NailgunServer.this;
        }

        public IdleCheck() {
            if (NailgunServer.this == null) {
                throw null;
            }
        }
    }

    public static interface NailgunAware
    extends package.Command {
        public Option<NailgunServer> nailgun();

        public void nailgun_$eq(Option<NailgunServer> var1);

        public static void $init$(NailgunAware $this) {
            $this.nailgun_$eq((Option<NailgunServer>)None$.MODULE$);
        }
    }

    public static class NailgunParams {
        @Parameter(names={"--host"}, description="Address to bind against")
        private String host;
        @Parameter(names={"--port"}, description="Port to bind against", validateWith={PositiveInteger.class})
        private int port = 2113;
        @Parameter(names={"--pool-size"}, description="Size of the thread pool used for handling requests", validateWith={PositiveInteger.class})
        private int poolSize = 2;
        @Parameter(names={"--timeout"}, description="Maximum interval to wait between heartbeats before considering client to have disconnected", converter=ParameterConverters.DurationConverter.class)
        private Duration timeout = Duration$.MODULE$.apply(10000L, TimeUnit.MILLISECONDS);
        @Parameter(names={"--idle"}, description="Time before the server is shut down due to inactivity", converter=ParameterConverters.DurationConverter.class)
        private Duration idle = Duration$.MODULE$.apply(1L, TimeUnit.HOURS);

        public String host() {
            return this.host;
        }

        public void host_$eq(String x$1) {
            this.host = x$1;
        }

        public int port() {
            return this.port;
        }

        public void port_$eq(int x$1) {
            this.port = x$1;
        }

        public int poolSize() {
            return this.poolSize;
        }

        public void poolSize_$eq(int x$1) {
            this.poolSize = x$1;
        }

        public Duration timeout() {
            return this.timeout;
        }

        public void timeout_$eq(Duration x$1) {
            this.timeout = x$1;
        }

        public Duration idle() {
            return this.idle;
        }

        public void idle_$eq(Duration x$1) {
            this.idle = x$1;
        }
    }

    public static class Shutdown
    implements Runnable {
        private final NGServer ng;

        @Override
        public void run() {
            this.ng.shutdown();
            for (int count2 = 0; this.ng.isRunning() && count2 < 50; ++count2) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.ng.isRunning()) {
                System.err.println("Unable to cleanly shutdown server.  Exiting JVM Anyway.");
                return;
            }
            System.out.println("NGServer shut down.");
        }

        public Shutdown(NGServer ng) {
            this.ng = ng;
        }
    }
}

