/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.utils;

import java.io.Serializable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.locationtech.geomesa.jobs.package;
import org.locationtech.geomesa.tools.package$Command$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JobRunner$ {
    public static JobRunner$ MODULE$;

    static {
        new JobRunner$();
    }

    public package.JobResult run(Job job, package.StatusCallback reporter, Function0<Seq<Tuple2<String, Object>>> mapCounters, Function0<Seq<Tuple2<String, Object>>> reduceCounters) {
        this.submit(job);
        return this.monitor(job, reporter, mapCounters, reduceCounters);
    }

    public void submit(Job job) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (package$Command$.MODULE$.user().underlying().isInfoEnabled()) {
            package$Command$.MODULE$.user().underlying().info("Submitting job '{}' - please wait...", new Object[]{job.getJobName()});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        job.submit();
        if (package$Command$.MODULE$.user().underlying().isInfoEnabled()) {
            package$Command$.MODULE$.user().underlying().info("Tracking available at {}", new Object[]{job.getStatus().getTrackingUrl()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public package.JobResult monitor(Job job, package.StatusCallback reporter, Function0<Seq<Tuple2<String, Object>>> mapCounters, Function0<Seq<Tuple2<String, Object>>> reduceCounters) {
        Function1 & Serializable & scala.Serializable status;
        Function1 & Serializable & scala.Serializable intersect;
        if (job.getNumReduceTasks() != 0) {
            BooleanRef mapping = BooleanRef.create((boolean)true);
            intersect = (Function1 & Serializable & scala.Serializable)done -> {
                JobRunner$.$anonfun$monitor$1(mapping, job, reporter, mapCounters, reduceCounters, BoxesRunTime.unboxToBoolean((Object)done));
                return BoxedUnit.UNIT;
            };
        } else {
            intersect = status = (Function1 & Serializable & scala.Serializable)done -> {
                reporter.apply("", job.mapProgress(), (Seq)((TraversableLike)mapCounters.apply()).$plus$plus((GenTraversableOnce)reduceCounters.apply(), Seq$.MODULE$.canBuildFrom()), BoxesRunTime.unboxToBoolean((Object)done));
                return BoxedUnit.UNIT;
            };
        }
        while (!job.isComplete()) {
            JobStatus.State state = job.getStatus().getState();
            JobStatus.State state2 = JobStatus.State.PREP;
            Object object = (state == null ? state2 != null : !state.equals(state2)) ? status.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)) : BoxedUnit.UNIT;
            Thread.sleep(500L);
        }
        status.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
        if (job.isSuccessful()) {
            return new package.JobResult$.JobSuccess("", ((TraversableOnce)((TraversableLike)mapCounters.apply()).$plus$plus((GenTraversableOnce)reduceCounters.apply(), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        return new package.JobResult$.JobFailure(new StringBuilder(31).append("Job failed with state ").append(job.getStatus().getState()).append(" due to: ").append(job.getStatus().getFailureInfo()).toString());
    }

    public static final /* synthetic */ void $anonfun$monitor$1(BooleanRef mapping$1, Job job$1, package.StatusCallback reporter$1, Function0 mapCounters$1, Function0 reduceCounters$1, boolean done) {
        if (mapping$1.elem) {
            float mapProgress = job$1.mapProgress();
            if (mapProgress < 1.0f) {
                reporter$1.apply("Map:    ", mapProgress, (Seq)mapCounters$1.apply(), false);
                return;
            }
            reporter$1.apply("Map:    ", mapProgress, (Seq)mapCounters$1.apply(), true);
            reporter$1.reset();
            mapping$1.elem = false;
            return;
        }
        reporter$1.apply("Reduce: ", job$1.reduceProgress(), (Seq)reduceCounters$1.apply(), done);
    }

    private JobRunner$() {
        MODULE$ = this;
    }
}

