/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.data;

import com.beust.jcommander.ParameterException;
import java.io.IOException;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.geotools.api.data.DataStore;
import org.locationtech.geomesa.tools.data.RemoveSchemaParams;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.tools.utils.Prompt$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4q\u0001C\u0005\u0011\u0002\u0007\u0005A\u0003C\u0003E\u0001\u0011\u0005Q\tC\u0004J\u0001\t\u0007I\u0011\t&\t\u000b9\u0003a\u0011I(\t\u000bQ\u0003A\u0011I#\t\u000bU\u0003A\u0011\u0003,\t\u000bU\u0003A\u0011C2\t\u000bY\u0004A\u0011C<\u0003'I+Wn\u001c<f'\u000eDW-\\1D_6l\u0017M\u001c3\u000b\u0005)Y\u0011\u0001\u00023bi\u0006T!\u0001D\u0007\u0002\u000bQ|w\u000e\\:\u000b\u00059y\u0011aB4f_6,7/\u0019\u0006\u0003!E\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011AE\u0001\u0004_J<7\u0001A\u000b\u0003+I\u001a2\u0001\u0001\f\u001f!\t9B$D\u0001\u0019\u0015\tI\"$\u0001\u0003mC:<'\"A\u000e\u0002\t)\fg/Y\u0005\u0003;a\u0011aa\u00142kK\u000e$\bcA\u0010.a9\u0011\u0001e\u000b\b\u0003C)r!AI\u0015\u000f\u0005\rBcB\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0014\u0003\u0019a$o\\8u}%\t!#\u0003\u0002\u0011#%\u0011abD\u0005\u0003\u00195I!\u0001L\u0006\u0002\u000fA\f7m[1hK&\u0011af\f\u0002\u0011\t\u0006$\u0018m\u0015;pe\u0016\u001cu.\\7b]\u0012T!\u0001L\u0006\u0011\u0005E\u0012D\u0002\u0001\u0003\u0006g\u0001\u0011\r\u0001\u000e\u0002\u0003\tN\u000b\"!N\u001e\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\u000f9{G\u000f[5oOB\u0011AHQ\u0007\u0002{)\u0011!B\u0010\u0006\u0003\u007f\u0001\u000b1!\u00199j\u0015\t\t\u0015#\u0001\u0005hK>$xn\u001c7t\u0013\t\u0019UHA\u0005ECR\f7\u000b^8sK\u00061A%\u001b8ji\u0012\"\u0012A\u0012\t\u0003m\u001dK!\u0001S\u001c\u0003\tUs\u0017\u000e^\u0001\u0005]\u0006lW-F\u0001L!\t9B*\u0003\u0002N1\t11\u000b\u001e:j]\u001e\fa\u0001]1sC6\u001cX#\u0001)\u0011\u0005E\u0013V\"A\u0005\n\u0005MK!A\u0005*f[>4XmU2iK6\f\u0007+\u0019:b[N\fq!\u001a=fGV$X-\u0001\u0004sK6|g/\u001a\u000b\u0004\r^K\u0006\"\u0002-\u0006\u0001\u0004\u0001\u0014A\u00013t\u0011\u0015QV\u00011\u0001\\\u0003\u001d\u0001\u0018\r\u001e;fe:\u0004\"\u0001X1\u000e\u0003uS!AX0\u0002\u000bI,w-\u001a=\u000b\u0005\u0001T\u0012\u0001B;uS2L!AY/\u0003\u000fA\u000bG\u000f^3s]R\u0019a\tZ3\t\u000ba3\u0001\u0019\u0001\u0019\t\u000b\u00194\u0001\u0019A4\u0002\u0013QL\b/\u001a(b[\u0016\u001c\bc\u00015m_:\u0011\u0011n\u001b\b\u0003I)L\u0011\u0001O\u0005\u0003Y]J!!\u001c8\u0003\u0007M+\u0017O\u0003\u0002-oA\u0011\u0001\u000f\u001e\b\u0003cJ\u0004\"\u0001J\u001c\n\u0005M<\u0014A\u0002)sK\u0012,g-\u0003\u0002Nk*\u00111oN\u0001\u000eaJ|W\u000e\u001d;D_:4\u0017N]7\u0015\u0005a\\\bC\u0001\u001cz\u0013\tQxGA\u0004C_>dW-\u00198\t\u000bq<\u0001\u0019A4\u0002\u0019\u0019,\u0017\r^;sK:\u000bW.Z:")
public interface RemoveSchemaCommand<DS extends DataStore>
extends package.DataStoreCommand<DS> {
    public void org$locationtech$geomesa$tools$data$RemoveSchemaCommand$_setter_$name_$eq(String var1);

    @Override
    public String name();

    @Override
    public RemoveSchemaParams params();

    public static /* synthetic */ void execute$(RemoveSchemaCommand $this) {
        $this.execute();
    }

    @Override
    default public void execute() {
        Tuple2 tuple2 = new Tuple2((Object)Option$.MODULE$.apply((Object)this.params().pattern()), (Object)Option$.MODULE$.apply((Object)this.params().featureName()));
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new ParameterException("Please provide either featureName or pattern");
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option instanceof Some && option3 instanceof Some) {
                throw new ParameterException("Cannot specify both featureName and pattern");
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option4 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                Pattern pattern = (Pattern)some.value();
                if (None$.MODULE$.equals(option4)) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)this.withDataStore((Function1 & Serializable & scala.Serializable)x$1 -> {
                        this.remove(x$1, pattern);
                        return BoxedUnit.UNIT;
                    });
                    return;
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option5 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option5 instanceof Some) {
                Some some = (Some)option5;
                String typeName = (String)some.value();
                BoxedUnit cfr_ignored_1 = (BoxedUnit)this.withDataStore((Function1 & Serializable & scala.Serializable)x$2 -> {
                    this.remove(x$2, (Seq<String>)((Seq)new .colon.colon((Object)typeName, (List)Nil$.MODULE$)));
                    return BoxedUnit.UNIT;
                });
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ void remove$(RemoveSchemaCommand $this, DataStore ds, Pattern pattern) {
        $this.remove(ds, pattern);
    }

    default public void remove(DS ds, Pattern pattern) {
        String[] typeNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ds.getTypeNames())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)RemoveSchemaCommand.$anonfun$remove$1(pattern, x$3)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])typeNames)).isEmpty()) {
            BoxedUnit boxedUnit;
            if (package$Command$.MODULE$.user().underlying().isWarnEnabled()) {
                package$Command$.MODULE$.user().underlying().warn("No schemas matched the provided pattern");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        this.remove(ds, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])typeNames));
    }

    public static /* synthetic */ void remove$(RemoveSchemaCommand $this, DataStore ds, Seq typeNames) {
        $this.remove(ds, (Seq<String>)typeNames);
    }

    default public void remove(DS ds, Seq<String> typeNames) {
        BoxedUnit boxedUnit;
        if (this.params().force() || this.promptConfirm(typeNames)) {
            typeNames.foreach((Function1 & Serializable & scala.Serializable)typeName -> {
                RemoveSchemaCommand.$anonfun$remove$2(ds, typeName);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (package$Command$.MODULE$.user().underlying().isInfoEnabled()) {
            package$Command$.MODULE$.user().underlying().info("Cancelled schema removal");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static /* synthetic */ boolean promptConfirm$(RemoveSchemaCommand $this, Seq featureNames) {
        return $this.promptConfirm((Seq<String>)featureNames);
    }

    default public boolean promptConfirm(Seq<String> featureNames) {
        String x$1 = new StringBuilder(25).append("Remove schema(s) ").append(featureNames.mkString(", ")).append(" (y/n)? ").toString();
        List<String> x$2 = Prompt$.MODULE$.confirm$default$2();
        String x$3 = Prompt$.MODULE$.confirm$default$3();
        Object x$4 = Prompt$.MODULE$.confirm$default$4(x$1, x$2, x$3);
        return Prompt$.MODULE$.confirm(x$1, x$2, x$3, x$4);
    }

    public static /* synthetic */ boolean $anonfun$remove$1(Pattern pattern$2, String x$3) {
        return pattern$2.matcher(x$3).matches();
    }

    public static /* synthetic */ void $anonfun$remove$2(DataStore ds$1, String typeName) {
        boolean bl;
        BoxedUnit boxedUnit;
        boolean bl2;
        try {
            bl2 = ds$1.getSchema(typeName) == null;
        }
        catch (IOException iOException) {
            bl2 = true;
        }
        if (bl2) {
            BoxedUnit boxedUnit2;
            if (package$Command$.MODULE$.user().underlying().isWarnEnabled()) {
                package$Command$.MODULE$.user().underlying().warn("Schema '{}' doesn't exist", new Object[]{typeName});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return;
        }
        if (package$Command$.MODULE$.user().underlying().isInfoEnabled()) {
            package$Command$.MODULE$.user().underlying().info("Removing '{}'", new Object[]{typeName});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        ds$1.removeSchema(typeName);
        try {
            bl = ds$1.getSchema(typeName) != null;
        }
        catch (IOException iOException) {
            bl = false;
        }
        if (bl) {
            BoxedUnit boxedUnit3;
            if (package$Command$.MODULE$.user().underlying().isErrorEnabled()) {
                package$Command$.MODULE$.user().underlying().error("Error removing feature type '{}'", new Object[]{typeName});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public static void $init$(RemoveSchemaCommand $this) {
        $this.org$locationtech$geomesa$tools$data$RemoveSchemaCommand$_setter_$name_$eq("remove-schema");
    }
}

