/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.Serializable;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.IncludeFilter;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert.EvaluationContext$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.planning.LocalQueryRunner$;
import org.locationtech.geomesa.tools.export.ConvertCommand;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ConvertCommand$
implements LazyLogging {
    public static ConvertCommand$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ConvertCommand$();
    }

    private Logger logger$lzycompute() {
        ConvertCommand$ convertCommand$ = this;
        synchronized (convertCommand$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public CloseableIterator<SimpleFeature> org$locationtech$geomesa$tools$export$ConvertCommand$$convertFeatures(Iterator<FileSystemDelegate.FileHandle> files, SimpleFeatureConverter converter, ConvertCommand.ResultTracker tracker, Query query) {
        return ConvertCommand$.transform$1(ConvertCommand$.limit$1(ConvertCommand$.filter$1(ConvertCommand$.convert$1(files, converter, tracker), query), query), converter, query);
    }

    private static final CloseableIterator convert$1(Iterator files$2, SimpleFeatureConverter converter$1, ConvertCommand.ResultTracker tracker$1) {
        return CloseableIterator$.MODULE$.apply(files$2, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CloseableIterator$.MODULE$.apply$default$2()).flatMap((Function1 & Serializable & scala.Serializable)file -> file.open().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option name = (Option)tuple2._1();
                InputStream is = (InputStream)tuple2._2();
                Map params = EvaluationContext$.MODULE$.inputFileParam((String)name.getOrElse((Function0 & Serializable & scala.Serializable)() -> file.path()));
                EvaluationContext context = converter$1.createEvaluationContext(params);
                CloseableIterator features = converter$1.process(is, context);
                return CloseableIterator$.MODULE$.apply((Iterator)features, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    features.close();
                    tracker$1.update(context);
                });
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private static final CloseableIterator filter$1(CloseableIterator iter, Query query$2) {
        Filter filter = query$2.getFilter();
        IncludeFilter includeFilter = Filter.INCLUDE;
        if (!(filter != null ? !filter.equals(includeFilter) : includeFilter != null)) {
            return iter;
        }
        Filter filter2 = query$2.getFilter();
        return iter.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter2.evaluate(x$1)));
    }

    private static final CloseableIterator limit$1(CloseableIterator iter, Query query$2) {
        Option option = QueryHints$.MODULE$.RichHints(query$2.getHints()).getMaxFeatures();
        if (None$.MODULE$.equals(option)) {
            return iter;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            int m = BoxesRunTime.unboxToInt((Object)some.value());
            return iter.take(m);
        }
        throw new MatchError((Object)option);
    }

    private static final CloseableIterator transform$1(CloseableIterator iter, SimpleFeatureConverter converter$1, Query query$2) {
        return LocalQueryRunner$.MODULE$.transform(converter$1.targetSft(), iter, QueryHints$.MODULE$.RichHints(query$2.getHints()).getTransform(), query$2.getHints());
    }

    private ConvertCommand$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

