/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.utils;

import com.beust.jcommander.IValueValidator;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.BaseConverter;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.geotools.api.filter.Filter;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.convert.Modes;
import org.locationtech.geomesa.tools.export.ExportFormat;
import org.locationtech.geomesa.tools.export.ExportFormat$;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.geomesa.utils.text.DurationParsing$;
import org.locationtech.geomesa.utils.text.Suffixes;
import org.locationtech.geomesa.utils.text.TextTools$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ux!B\u0016-\u0011\u00039d!B\u001d-\u0011\u0003Q\u0004\"B!\u0002\t\u0003\u0011e\u0001B\"\u0002\u0001\u0011C\u0001\u0002Z\u0002\u0003\u0002\u0003\u0006I!\u0017\u0005\u0006\u0003\u000e!\t!\u001a\u0005\u0006S\u000e!\tE\u001b\u0004\u0005[\u0006\u0001a\u000e\u0003\u0005e\u000f\t\u0005\t\u0015!\u0003Z\u0011\u0015\tu\u0001\"\u0001y\u0011\u0015Iw\u0001\"\u0011|\r\u0011i\u0018\u0001\u0001@\t\u0011\u0011\\!\u0011!Q\u0001\neCa!Q\u0006\u0005\u0002\u0005U\u0001BB5\f\t\u0003\nYB\u0002\u0004\u0002 \u0005\u0001\u0011\u0011\u0005\u0005\tI>\u0011\t\u0011)A\u00053\"1\u0011i\u0004C\u0001\u0003cAa![\b\u0005B\u0005]\u0002\u0002DA\u001e\u001fA\u0005\t\u0011!A\u0005\u0002\u0005ubABA+\u0003\u0001\t9\u0006\u0003\u0005e)\t\u0005\t\u0015!\u0003Z\u0011\u0019\tE\u0003\"\u0001\u0002b!1\u0011\u000e\u0006C!\u0003O2a!a\u001b\u0002\u0001\u00055\u0004\u0002\u00033\u0019\u0005\u0003\u0005\u000b\u0011B-\t\r\u0005CB\u0011AA<\u0011\u0019I\u0007\u0004\"\u0011\u0002~\u00191\u0011\u0011Q\u0001\u0001\u0003\u0007C\u0001\u0002\u001a\u000f\u0003\u0002\u0003\u0006I!\u0017\u0005\u0007\u0003r!\t!!#\t\r%dB\u0011IAH\r\u0019\t\u0019*\u0001\u0001\u0002\u0016\"AA\r\tB\u0001B\u0003%\u0011\f\u0003\u0004BA\u0011\u0005\u0011\u0011\u0018\u0005\u0007S\u0002\"\t%a0\u0007\r\u0005\r\u0017\u0001AAc\u0011!!GE!A!\u0002\u0013I\u0006BB!%\t\u0003\ty\r\u0003\u0004jI\u0011\u0005\u0013Q\u001b\u0004\u0007\u00033\f\u0001!a7\t\r\u0005CC\u0011AAv\u0011\u001d\ty\u000f\u000bC!\u0003c\f1\u0003U1sC6,G/\u001a:D_:4XM\u001d;feNT!!\f\u0018\u0002\u000bU$\u0018\u000e\\:\u000b\u0005=\u0002\u0014!\u0002;p_2\u001c(BA\u00193\u0003\u001d9Wm\\7fg\u0006T!a\r\u001b\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003U\n1a\u001c:h\u0007\u0001\u0001\"\u0001O\u0001\u000e\u00031\u00121\u0003U1sC6,G/\u001a:D_:4XM\u001d;feN\u001c\"!A\u001e\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tqGA\u0007IS:$8i\u001c8wKJ$XM]\n\u0003\u0007\u0015\u00032AR(R\u001b\u00059%B\u0001%J\u0003)\u0019wN\u001c<feR,'o\u001d\u0006\u0003\u0015.\u000b!B[2p[6\fg\u000eZ3s\u0015\taU*A\u0003cKV\u001cHOC\u0001O\u0003\r\u0019w.\\\u0005\u0003!\u001e\u0013QBQ1tK\u000e{gN^3si\u0016\u0014\b\u0003\u0002*X3fk\u0011a\u0015\u0006\u0003)V\u000bA!\u001e;jY*\ta+\u0001\u0003kCZ\f\u0017B\u0001-T\u0005\ri\u0015\r\u001d\t\u00035\u0006t!aW0\u0011\u0005qkT\"A/\u000b\u0005y3\u0014A\u0002\u001fs_>$h(\u0003\u0002a{\u00051\u0001K]3eK\u001aL!AY2\u0003\rM#(/\u001b8h\u0015\t\u0001W(\u0001\u0003oC6,GC\u00014i!\t97!D\u0001\u0002\u0011\u0015!W\u00011\u0001Z\u0003\u001d\u0019wN\u001c<feR$\"!U6\t\u000b14\u0001\u0019A-\u0002\u000bY\fG.^3\u0003#\u0011+(/\u0019;j_:\u001cuN\u001c<feR,'o\u0005\u0002\b_B\u0019ai\u00149\u0011\u0005E4X\"\u0001:\u000b\u0005M$\u0018\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005Ul\u0014AC2p]\u000e,(O]3oi&\u0011qO\u001d\u0002\t\tV\u0014\u0018\r^5p]R\u0011\u0011P\u001f\t\u0003O\u001eAQ\u0001Z\u0005A\u0002e#\"\u0001\u001d?\t\u000b1T\u0001\u0019A-\u0003\u001f\u0019KG\u000e^3s\u0007>tg/\u001a:uKJ\u001c\"aC@\u0011\t\u0019{\u0015\u0011\u0001\t\u0005\u0003\u0007\t\t\"\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003\u00191\u0017\u000e\u001c;fe*!\u00111BA\u0007\u0003\r\t\u0007/\u001b\u0006\u0004\u0003\u001f!\u0014\u0001C4f_R|w\u000e\\:\n\t\u0005M\u0011Q\u0001\u0002\u0007\r&dG/\u001a:\u0015\t\u0005]\u0011\u0011\u0004\t\u0003O.AQ\u0001Z\u0007A\u0002e#B!!\u0001\u0002\u001e!)AN\u0004a\u00013\n)R\t\u001f9peR4uN]7bi\u000e{gN^3si\u0016\u00148cA\b\u0002$A!aiTA\u0013!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016]\u00051Q\r\u001f9peRLA!a\f\u0002*\taQ\t\u001f9peR4uN]7biR!\u00111GA\u001b!\t9w\u0002C\u0003e#\u0001\u0007\u0011\f\u0006\u0003\u0002&\u0005e\u0002\"\u00027\u0013\u0001\u0004I\u0016\u0001\u00079s_R,7\r^3eI\u001d,G/\u0012:s_J\u001cFO]5oOR!\u0011qHA*)\u0019\t\t%a\u0013\u0002PA!\u00111IA%\u001b\t\t)EC\u0002\u0002HU\u000bA\u0001\\1oO&\u0019!-!\u0012\t\u0013\u000553#!AA\u0002\u0005\u0005\u0013a\u0001=%c!I\u0011\u0011K\n\u0002\u0002\u0003\u0007\u0011\u0011I\u0001\u0004q\u0012\u0012\u0004\"CA''\u0005\u0005\t\u0019AA\u001a\u0005EYU-\u001f,bYV,7i\u001c8wKJ$XM]\n\u0004)\u0005e\u0003\u0003\u0002$P\u00037\u0002R\u0001PA/3fK1!a\u0018>\u0005\u0019!V\u000f\u001d7feQ!\u00111MA3!\t9G\u0003C\u0003e-\u0001\u0007\u0011\f\u0006\u0003\u0002\\\u0005%\u0004\"\u00027\u0018\u0001\u0004I&!\u0004#bi\u0016\u001cuN\u001c<feR,'oE\u0002\u0019\u0003_\u0002BAR(\u0002rA\u0019!+a\u001d\n\u0007\u0005U4K\u0001\u0003ECR,G\u0003BA=\u0003w\u0002\"a\u001a\r\t\u000b\u0011T\u0002\u0019A-\u0015\t\u0005E\u0014q\u0010\u0005\u0006Yn\u0001\r!\u0017\u0002\u0012\u0013:$XM\u001d<bY\u000e{gN^3si\u0016\u00148c\u0001\u000f\u0002\u0006B!aiTAD!\u001da\u0014QLA9\u0003c\"B!a#\u0002\u000eB\u0011q\r\b\u0005\u0006Iz\u0001\r!\u0017\u000b\u0005\u0003\u000f\u000b\t\nC\u0003m?\u0001\u0007\u0011L\u0001\nFeJ|'/T8eK\u000e{gN^3si\u0016\u00148c\u0001\u0011\u0002\u0018B!aiTAM!\u0011\tY*a-\u000f\t\u0005u\u0015Q\u0016\b\u0005\u0003?\u000bYK\u0004\u0003\u0002\"\u0006%f\u0002BAR\u0003Os1\u0001XAS\u0013\u0005)\u0014BA\u001a5\u0013\t\t$'\u0003\u0002ja%!\u0011qVAY\u0003\u0015iu\u000eZ3t\u0015\tI\u0007'\u0003\u0003\u00026\u0006]&!C#se>\u0014Xj\u001c3f\u0015\u0011\ty+!-\u0015\t\u0005m\u0016Q\u0018\t\u0003O\u0002BQ\u0001\u001a\u0012A\u0002e#B!!'\u0002B\")An\ta\u00013\nq!)\u001f;fg\u000e{gN^3si\u0016\u00148c\u0001\u0013\u0002HB!aiTAe!\u0011\t\u0019%a3\n\t\u00055\u0017Q\t\u0002\u0005\u0019>tw\r\u0006\u0003\u0002R\u0006M\u0007CA4%\u0011\u0015!g\u00051\u0001Z)\u0011\tI-a6\t\u000b1<\u0003\u0019A-\u0003\u001d\tKH/Z:WC2LG-\u0019;peN)\u0001&!8\u0002dB!\u00111IAp\u0013\u0011\t\t/!\u0012\u0003\r=\u0013'.Z2u!\u0015\t)/a:Z\u001b\u0005I\u0015bAAu\u0013\ny\u0011JV1mk\u00164\u0016\r\\5eCR|'\u000f\u0006\u0002\u0002nB\u0011q\rK\u0001\tm\u0006d\u0017\u000eZ1uKR1\u00111_A}\u0003w\u00042\u0001PA{\u0013\r\t90\u0010\u0002\u0005+:LG\u000fC\u0003eU\u0001\u0007\u0011\fC\u0003mU\u0001\u0007\u0011\f")
public final class ParameterConverters {

    public static class BytesConverter
    extends BaseConverter<Long> {
        public Long convert(String value) {
            Try try_ = Suffixes.Memory$.MODULE$.bytes(value);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                long b = BoxesRunTime.unboxToLong((Object)success.value());
                return Predef$.MODULE$.long2Long(b);
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new ParameterException(new StringBuilder(22).append("Invalid byte string '").append(value).append("'").toString(), e);
            }
            throw new MatchError((Object)try_);
        }

        public BytesConverter(String name) {
            super(name);
        }
    }

    public static class BytesValidator
    implements IValueValidator<String> {
        public void validate(String name, String value) {
            Suffixes.Memory$.MODULE$.bytes(value).failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                throw new ParameterException(new StringBuilder(22).append("Invalid byte string '").append(value).append("'").toString(), e);
            });
        }
    }

    public static class DateConverter
    extends BaseConverter<Date> {
        /*
         * WARNING - void declaration
         */
        public Date convert(String value) {
            void v0;
            try {
                void var3_2;
                Date date = (Date)FastConverter$.MODULE$.convert((Object)value, Date.class);
                if (date == null) {
                    throw new IllegalArgumentException(new StringBuilder(26).append("Could not convert ").append(value).append(" to date").toString());
                }
                v0 = var3_2;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("format: ").append(e).toString()));
                }
                throw throwable;
            }
            return v0;
        }

        public DateConverter(String name) {
            super(name);
        }
    }

    public static class DurationConverter
    extends BaseConverter<Duration> {
        public Duration convert(String value) {
            Duration duration;
            try {
                duration = DurationParsing$.MODULE$.caseInsensitive(value);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(10).append("duration: ").append(e).toString()));
                }
                throw throwable;
            }
            return duration;
        }

        public DurationConverter(String name) {
            super(name);
        }
    }

    public static class ErrorModeConverter
    extends BaseConverter<Enumeration.Value> {
        public Enumeration.Value convert(String value) {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Modes.ErrorMode$.MODULE$.apply(value));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Enumeration.Value m = (Enumeration.Value)success.value();
                return m;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new ParameterException(e.getMessage());
            }
            throw new MatchError((Object)try_);
        }

        public ErrorModeConverter(String name) {
            super(name);
        }
    }

    public static class ExportFormatConverter
    extends BaseConverter<ExportFormat> {
        public /* synthetic */ String protected$getErrorString(ExportFormatConverter x$1, String x$12, String x$2) {
            return x$1.getErrorString(x$12, x$2);
        }

        public ExportFormat convert(String value) {
            return (ExportFormat)ExportFormat$.MODULE$.apply(value).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Seq valid = (Seq)((SeqLike)ExportFormat$.MODULE$.Formats().flatMap((Function1 & Serializable & scala.Serializable)f -> (Seq)f.extensions().$colon$plus((Object)f.name(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).distinct();
                throw new ParameterException(this.protected$getErrorString(this, value, new StringBuilder(37).append("an export format. Valid formats are: ").append(TextTools$.MODULE$.wordList((Iterable)valid)).toString()));
            });
        }

        public ExportFormatConverter(String name) {
            super(name);
        }
    }

    public static class FilterConverter
    extends BaseConverter<Filter> {
        public Filter convert(String value) {
            Filter filter;
            try {
                filter = ECQL.toFilter((String)value);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("filter: ").append(e).toString()));
                }
                throw throwable;
            }
            return filter;
        }

        public FilterConverter(String name) {
            super(name);
        }
    }

    public static class HintConverter
    extends BaseConverter<Map<String, String>> {
        /*
         * WARNING - void declaration
         */
        public Map<String, String> convert(String value) {
            void v0;
            try {
                void var3_2;
                HashMap map = new HashMap();
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value.split(";"))).foreach((Function1 & Serializable & scala.Serializable)part -> {
                    String[] stringArray = part.split("=");
                    Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                    if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
                        throw new MatchError((Object)stringArray);
                    }
                    String k = (String)((SeqLike)option.get()).apply(0);
                    String v = (String)((SeqLike)option.get()).apply(1);
                    Tuple2 tuple2 = new Tuple2((Object)k, (Object)v);
                    String k2 = (String)tuple2._1();
                    String v2 = (String)tuple2._2();
                    return map.put(k2.trim(), v2.trim());
                });
                v0 = var3_2;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(10).append("hint map: ").append(e).toString()));
                }
                throw throwable;
            }
            return v0;
        }

        public HintConverter(String name) {
            super(name);
        }
    }

    public static class IntervalConverter
    extends BaseConverter<Tuple2<Date, Date>> {
        public Tuple2<Date, Date> convert(String value) {
            Tuple2 tuple2;
            try {
                int i = value.indexOf(47);
                if (i == -1 || value.indexOf(47, i + 1) != -1) {
                    throw new IllegalArgumentException("Interval from/to must be separated by a single '/'");
                }
                Date start = (Date)FastConverter$.MODULE$.convert((Object)value.substring(0, i), Date.class);
                Date end = (Date)FastConverter$.MODULE$.convert((Object)value.substring(i + 1), Date.class);
                if (start == null || end == null) {
                    throw new IllegalArgumentException(new StringBuilder(35).append("Could not convert ").append(value).append(" to date interval").toString());
                }
                tuple2 = new Tuple2((Object)start, (Object)end);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("format: ").append(e).toString()));
                }
                throw throwable;
            }
            return tuple2;
        }

        public IntervalConverter(String name) {
            super(name);
        }
    }

    public static class KeyValueConverter
    extends BaseConverter<Tuple2<String, String>> {
        public Tuple2<String, String> convert(String value) {
            Tuple2 tuple2;
            try {
                int i = value.indexOf(61);
                if (i == -1 || value.indexOf(61, i + 1) != -1) {
                    throw new IllegalArgumentException("key-value pairs must be separated by a single '='");
                }
                tuple2 = new Tuple2((Object)value.substring(0, i), (Object)value.substring(i + 1));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("format: ").append(e).toString()));
                }
                throw throwable;
            }
            return tuple2;
        }

        public KeyValueConverter(String name) {
            super(name);
        }
    }
}

