/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.PositiveInteger;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.tools.ConverterConfigParam;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.InputFilesParam;
import org.locationtech.geomesa.tools.NumReducersParam;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalFeatureSpecParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalInputFormatParam;
import org.locationtech.geomesa.tools.OptionalTypeNameParam;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.export.ConvertCommand$;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.ExportCommand$;
import org.locationtech.geomesa.tools.export.ExportCommand$ExportOptions$;
import org.locationtech.geomesa.tools.export.formats.ExportFormat;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.ingest.IngestCommand$;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.tools.utils.NoopParameterSplitter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.LocalDelegate;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\b\u0010\u0001iAQa\u0012\u0001\u0005\u0002!Cqa\u0013\u0001C\u0002\u0013\u0005C\n\u0003\u0004Q\u0001\u0001\u0006I!\u0014\u0005\b#\u0002\u0011\r\u0011\"\u0011S\u0011\u001d\t\t\u000b\u0001Q\u0001\nMCq!a)\u0001\t\u0003\n)\u000bC\u0004\u0002.\u0002!I!a,\b\u000b]{\u0001\u0012\u0001-\u0007\u000b9y\u0001\u0012A-\t\u000b\u001dKA\u0011\u00011\t\u000b\u0005LA\u0011\u00012\u0007\r\u0005E\u0013\u0002AA*\u0011\u00199E\u0002\"\u0001\u0002\u0004\nq1i\u001c8wKJ$8i\\7nC:$'B\u0001\t\u0012\u0003\u0019)\u0007\u0010]8si*\u0011!cE\u0001\u0006i>|Gn\u001d\u0006\u0003)U\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u0017/\u0005aAn\\2bi&|g\u000e^3dQ*\t\u0001$A\u0002pe\u001e\u001c\u0001aE\u0003\u00017\r*T\b\u0005\u0002\u001dC5\tQD\u0003\u0002\u001f?\u0005!A.\u00198h\u0015\u0005\u0001\u0013\u0001\u00026bm\u0006L!AI\u000f\u0003\r=\u0013'.Z2u!\t!#G\u0004\u0002&a9\u0011ae\f\b\u0003O9r!\u0001K\u0017\u000f\u0005%bS\"\u0001\u0016\u000b\u0005-J\u0012A\u0002\u001fs_>$h(C\u0001\u0019\u0013\t1r#\u0003\u0002\u0015+%\u0011!cE\u0005\u0003cE\tq\u0001]1dW\u0006<W-\u0003\u00024i\t91i\\7nC:$'BA\u0019\u0012!\t14(D\u00018\u0015\tA\u0014(A\u0003ti\u0006$8O\u0003\u0002;'\u0005)Q\u000f^5mg&\u0011Ah\u000e\u0002\u0010\u001b\u0016$\bn\u001c3Qe>4\u0017\u000e\\5oOB\u0011a(R\u0007\u0002\u007f)\u0011\u0001)Q\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003\u0005\u000e\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\t\u0006\u00191m\\7\n\u0005\u0019{$a\u0003'bufdunZ4j]\u001e\fa\u0001P5oSRtD#A%\u0011\u0005)\u0003Q\"A\b\u0002\t9\fW.Z\u000b\u0002\u001bB\u0011ADT\u0005\u0003\u001fv\u0011aa\u0015;sS:<\u0017!\u00028b[\u0016\u0004\u0013A\u00029be\u0006l7/F\u0001T!\t!FB\u0004\u0002V\u00119\u0011QEV\u0005\u0003!E\tabQ8om\u0016\u0014HoQ8n[\u0006tG\r\u0005\u0002K\u0013M\u0019\u0011BW\u001f\u0011\u0005msV\"\u0001/\u000b\u0003u\u000bQa]2bY\u0006L!a\u0018/\u0003\r\u0005s\u0017PU3g)\u0005A\u0016aD2p]Z,'\u000f\u001e$fCR,(/Z:\u0015\u0011\r\u001c\u0018QDA\u0017\u0003{\u00012\u0001Z4j\u001b\u0005)'B\u00014:\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Q\u0016\u0014\u0011c\u00117pg\u0016\f'\r\\3Ji\u0016\u0014\u0018\r^8s!\tQ\u0017/D\u0001l\u0015\taW.\u0001\u0004tS6\u0004H.\u001a\u0006\u0003]>\fqAZ3biV\u0014XM\u0003\u0002q/\u00059q\u000e]3oO&\u001c\u0018B\u0001:l\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\")Ao\u0003a\u0001k\u0006)a-\u001b7fgB\u0019aO_?\u000f\u0005]LhBA\u0015y\u0013\u0005i\u0016BA\u0019]\u0013\tYHP\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t\tD\fE\u0002\u007f\u0003/q1a`A\t\u001d\u0011\t\t!a\u0003\u000f\t\u0005\r\u0011q\u0001\b\u0004M\u0005\u0015\u0011B\u0001\u001e\u0014\u0013\r\tI!O\u0001\u0003S>LA!!\u0004\u0002\u0010\u0005\u0011am\u001d\u0006\u0004\u0003\u0013I\u0014\u0002BA\n\u0003+\t!CR5mKNK8\u000f^3n\t\u0016dWmZ1uK*!\u0011QBA\b\u0013\u0011\tI\"a\u0007\u0003\u0015\u0019KG.\u001a%b]\u0012dWM\u0003\u0003\u0002\u0014\u0005U\u0001bBA\u0010\u0017\u0001\u0007\u0011\u0011E\u0001\nG>tg/\u001a:uKJ\u0004B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O\u0019\u0012\u0001C2p]Z,'\u000f\u001e\u001a\n\t\u0005-\u0012Q\u0005\u0002\u0017'&l\u0007\u000f\\3GK\u0006$XO]3D_:4XM\u001d;fe\"9\u0011qF\u0006A\u0002\u0005E\u0012AA3d!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001c'\u000591m\u001c8wKJ$\u0018\u0002BA\u001e\u0003k\u0011\u0011#\u0012<bYV\fG/[8o\u0007>tG/\u001a=u\u0011\u001d\tyd\u0003a\u0001\u0003\u0003\nQ!];fef\u0004B!a\u0011\u0002N5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0003eCR\f'bAA&/\u0005Aq-Z8u_>d7/\u0003\u0003\u0002P\u0005\u0015#!B)vKJL(!E\"p]Z,'\u000f\u001e)be\u0006lW\r^3sgNqABWA+\u0003G\nY'!\u001d\u0002x\u0005u\u0004\u0003BA,\u0003;r1!VA-\u0013\r\tYfD\u0001\u000e\u000bb\u0004xN\u001d;D_6l\u0017M\u001c3\n\t\u0005}\u0013\u0011\r\u0002\r\u000bb\u0004xN\u001d;QCJ\fWn\u001d\u0006\u0004\u00037z\u0001\u0003BA3\u0003Oj\u0011!E\u0005\u0004\u0003S\n\"\u0001G(qi&|g.\u00197J]B,HOR8s[\u0006$\b+\u0019:b[B!\u0011QMA7\u0013\r\ty'\u0005\u0002\u0016\u001fB$\u0018n\u001c8bYRK\b/\u001a(b[\u0016\u0004\u0016M]1n!\u0011\t)'a\u001d\n\u0007\u0005U\u0014C\u0001\rPaRLwN\\1m\r\u0016\fG/\u001e:f'B,7\rU1sC6\u0004B!!\u001a\u0002z%\u0019\u00111P\t\u0003)\r{gN^3si\u0016\u00148i\u001c8gS\u001e\u0004\u0016M]1n!\u0011\t)'a \n\u0007\u0005\u0005\u0015C\u0001\nPaRLwN\\1m\r>\u00148-\u001a)be\u0006lGCAAC!\r\t9\tD\u0007\u0002\u0013!:A\"a#\u0002\u001c\u0006u\u0005\u0003BAG\u0003/k!!a$\u000b\t\u0005E\u00151S\u0001\u000bU\u000e|W.\\1oI\u0016\u0014(bAAK\u0007\u0006)!-Z;ti&!\u0011\u0011TAH\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0013G>lW.\u00198e\t\u0016\u001c8M]5qi&|g.\t\u0002\u0002 \u0006Q4i\u001c8wKJ$\bEZ5mKN\u0004So]5oO\u0002:Um\\'fg\u0006<3\u000fI5oi\u0016\u0014h.\u00197!G>tg/\u001a:uKJ\u0004cM]1nK^|'o[\u0001\ba\u0006\u0014\u0018-\\:!\u0003\u001d)\u00070Z2vi\u0016$\"!a*\u0011\u0007m\u000bI+C\u0002\u0002,r\u0013A!\u00168ji\u0006\u00012m\u001c8wKJ$\u0018I\u001c3FqB|'\u000f\u001e\u000b\u0003\u0003c\u0003RaWAZ\u0003oK1!!.]\u0005\u0019y\u0005\u000f^5p]B\u00191,!/\n\u0007\u0005mFL\u0001\u0003M_:<\u0007")
public class ConvertCommand
implements package.Command,
MethodProfiling {
    private final String name;
    private final ConvertParameters params;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static CloseableIterator<SimpleFeature> convertFeatures(Iterator<FileSystemDelegate.FileHandle> files, SimpleFeatureConverter converter, EvaluationContext ec, Query query) {
        return ConvertCommand$.MODULE$.convertFeatures(files, converter, ec, query);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, (String)message, code);
    }

    @Override
    public Seq<package.Command> subCommands() {
        return package.Command.subCommands$(this);
    }

    @Override
    public Option<ParameterException> validate() {
        return package.Command.validate$(this);
    }

    @Override
    public void run() {
        package.Command.run$(this);
    }

    private Logger logger$lzycompute() {
        ConvertCommand convertCommand = this;
        synchronized (convertCommand) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ConvertParameters params() {
        return this.params;
    }

    @Override
    public void execute() {
        this.profile((Function2 & Serializable)(count2, time) -> {
            this.complete$1(count2, BoxesRunTime.unboxToLong((Object)time));
            return BoxedUnit.UNIT;
        }, (Function0 & Serializable)() -> this.convertAndExport());
    }

    private Option<Object> convertAndExport() {
        if (this.params().files().isEmpty() && !LocalDelegate.StdInHandle$.MODULE$.isAvailable()) {
            throw new ParameterException("Missing option: <files>... is required");
        }
        Buffer inputs = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.params().files()).asScala();
        Option<String> format = IngestCommand$.MODULE$.getDataFormat(this.params(), (Seq<String>)inputs.toSeq());
        return ((Option)IngestCommand$.MODULE$.getSftAndConverter(this.params(), (Seq<String>)inputs.toSeq(), format, (Option<package.DataStoreCommand<? extends DataStore>>)None$.MODULE$).get()).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                SimpleFeatureType sft = (SimpleFeatureType)tuple2._1();
                Config config = (Config)tuple2._2();
                if (sft != null) {
                    SimpleFeatureType simpleFeatureType = sft;
                    if (config != null) {
                        Config config2 = config;
                        Iterator files = inputs.isEmpty() ? LocalDelegate.StdInHandle$.MODULE$.available().iterator() : inputs.iterator().flatMap((Function1 & Serializable)path -> PathUtils$.MODULE$.interpretPath(path));
                        return (Option)package.WithClose$.MODULE$.apply((Object)SimpleFeatureConverter$.MODULE$.apply(simpleFeatureType, config2), (Function1 & Serializable)converter -> {
                            Option option;
                            FeatureExporter featureExporter;
                            EvaluationContext ec = converter.createEvaluationContext(converter.createEvaluationContext$default$1());
                            Query query = ExportCommand$.MODULE$.createQuery(simpleFeatureType, this.params());
                            Option option2 = Option$.MODULE$.apply((Object)this.params().chunkSize());
                            if (None$.MODULE$.equals(option2)) {
                                featureExporter = new ExportCommand.Exporter(ExportCommand$ExportOptions$.MODULE$.apply(this.params()), query.getHints());
                            } else if (option2 instanceof Some) {
                                Some some = (Some)option2;
                                Long c = (Long)some.value();
                                featureExporter = new ExportCommand.ChunkedExporter(ExportCommand$ExportOptions$.MODULE$.apply(this.params()), query.getHints(), Predef$.MODULE$.Long2long(c));
                            } else {
                                throw new MatchError((Object)option2);
                            }
                            try (ExportCommand.Exporter exporter = featureExporter;){
                                Option count2 = (Option)package.WithClose$.MODULE$.apply(ConvertCommand$.MODULE$.convertFeatures((Iterator<FileSystemDelegate.FileHandle>)files, (SimpleFeatureConverter)converter, ec, query), (Function1 & Serializable)iter -> {
                                    if (!this.params().suppressEmpty() || iter.hasNext()) {
                                        exporter.start(QueryHints$.MODULE$.RichHints(query.getHints()).getReturnSft());
                                        return exporter.export((Iterator<SimpleFeature>)iter);
                                    }
                                    return new Some((Object)BoxesRunTime.boxToLong((long)0L));
                                }, IsCloseable$.MODULE$.closeableIsCloseable());
                                long records = ec.line() - (long)(this.params().noHeader() ? 0 : this.params().files().size());
                                package$Command$.MODULE$.user().info(new StringBuilder(21).append("Converted ").append(TextTools$.MODULE$.getPlural(records, "line")).append(" ").append("with ").append(TextTools$.MODULE$.getPlural(ec.success().getCount(), "success", "successes")).append(" ").append("and ").append(TextTools$.MODULE$.getPlural(ec.failure().getCount(), "failure")).toString());
                                option = count2;
                            }
                            return option;
                        }, IsCloseable$.MODULE$.closeableIsCloseable());
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ String $anonfun$execute$2(long c) {
        return new StringBuilder(14).append(" for ").append(c).append(" features").toString();
    }

    private final void complete$1(Option count2, long time) {
        package$Command$.MODULE$.user().info(new StringBuilder(29).append("Conversion complete to ").append(Option$.MODULE$.apply((Object)this.params().file()).getOrElse((Function0 & Serializable)() -> "standard out")).append(" ").append("in ").append(time).append("ms").append(count2.map((Function1 & Serializable)c -> ConvertCommand.$anonfun$execute$2(BoxesRunTime.unboxToLong((Object)c))).getOrElse((Function0 & Serializable)() -> "")).toString());
    }

    public ConvertCommand() {
        package.Command.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        MethodProfiling.$init$((MethodProfiling)this);
        this.name = "convert";
        this.params = new ConvertParameters();
    }

    @Parameters(commandDescription="Convert files using GeoMesa's internal converter framework")
    public static class ConvertParameters
    implements ExportCommand.ExportParams,
    OptionalInputFormatParam,
    OptionalTypeNameParam,
    OptionalFeatureSpecParam,
    ConverterConfigParam {
        @Parameter(names={"-C", "--converter"}, description="GeoMesa converter specification as a config string, file name, or name of an available converter")
        private String config;
        @Parameter(names={"--converter-error-mode"}, description="Override the converter error mode - 'skip-bad-records' or 'raise-errors'", converter=ParameterConverters.ErrorModeConverter.class)
        private Enumeration.Value errorMode;
        @Parameter(names={"-s", "--spec"}, description="SimpleFeatureType specification as a GeoTools spec string, SFT config, or file with either")
        private String spec;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate")
        private String featureName;
        @Parameter(names={"--input-format"}, description="File format of input files (shp, csv, tsv, avro, etc). Optional, auto-detection will be attempted")
        private String inputFormat;
        @Parameter(description="<file>...")
        private List<String> files;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header")
        private boolean noHeader;
        @Parameter(names={"--suppress-empty"}, description="Suppress all output (headers, etc) if there are no features exported")
        private boolean suppressEmpty;
        @Parameter(names={"-m", "--max-features"}, description="Restrict the maximum number of features returned")
        private Integer maxFeatures;
        @Parameter(names={"--attribute"}, description="Attributes or derived expressions to export, or 'id' to include the feature ID", splitter=NoopParameterSplitter.class)
        private List<String> transforms;
        @Parameter(names={"-a", "--attributes"}, description="Comma-separated attributes to export, or 'id' to include the feature ID")
        private List<String> attributes;
        @Parameter(names={"--sort-by"}, description="Sort by the specified attributes (comma-delimited)")
        private List<String> sortFields;
        @Parameter(names={"--sort-descending"}, description="Sort in descending order, instead of ascending", arity=0)
        private boolean sortDescending;
        @Parameter(names={"--chunk-size"}, description="Split the output into multiple files, by specifying the rough number of bytes to store per file", converter=ParameterConverters.BytesConverter.class)
        private Long chunkSize;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|avro-native|leaflet|orc|parquet|arrow)", converter=ParameterConverters.ExportFormatConverter.class)
        private ExportFormat explicitOutputFormat;
        private ExportFormat outputFormat;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"--num-reducers"}, description="Number of reducers to use when sorting or merging (for distributed jobs)", validateWith={PositiveInteger.class})
        private Integer reducers;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private Option<Enumeration.Value> mode;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        private volatile byte bitmap$0;

        @Override
        public String config() {
            return this.config;
        }

        @Override
        public void config_$eq(String x$1) {
            this.config = x$1;
        }

        @Override
        public Enumeration.Value errorMode() {
            return this.errorMode;
        }

        @Override
        public void errorMode_$eq(Enumeration.Value x$1) {
            this.errorMode = x$1;
        }

        @Override
        public String spec() {
            return this.spec;
        }

        @Override
        public void spec_$eq(String x$1) {
            this.spec = x$1;
        }

        @Override
        public String featureName() {
            return this.featureName;
        }

        @Override
        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String inputFormat() {
            return this.inputFormat;
        }

        @Override
        public void inputFormat_$eq(String x$1) {
            this.inputFormat = x$1;
        }

        @Override
        public List<String> files() {
            return this.files;
        }

        @Override
        public void files_$eq(List<String> x$1) {
            this.files = x$1;
        }

        @Override
        public String file() {
            return this.file;
        }

        @Override
        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        @Override
        public Integer gzip() {
            return this.gzip;
        }

        @Override
        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        @Override
        public boolean noHeader() {
            return this.noHeader;
        }

        @Override
        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        @Override
        public boolean suppressEmpty() {
            return this.suppressEmpty;
        }

        @Override
        public void suppressEmpty_$eq(boolean x$1) {
            this.suppressEmpty = x$1;
        }

        @Override
        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        @Override
        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        @Override
        public List<String> transforms() {
            return this.transforms;
        }

        @Override
        public void transforms_$eq(List<String> x$1) {
            this.transforms = x$1;
        }

        @Override
        public List<String> attributes() {
            return this.attributes;
        }

        @Override
        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        @Override
        public List<String> sortFields() {
            return this.sortFields;
        }

        @Override
        public void sortFields_$eq(List<String> x$1) {
            this.sortFields = x$1;
        }

        @Override
        public boolean sortDescending() {
            return this.sortDescending;
        }

        @Override
        public void sortDescending_$eq(boolean x$1) {
            this.sortDescending = x$1;
        }

        @Override
        public Long chunkSize() {
            return this.chunkSize;
        }

        @Override
        public void chunkSize_$eq(Long x$1) {
            this.chunkSize = x$1;
        }

        @Override
        public ExportFormat explicitOutputFormat() {
            return this.explicitOutputFormat;
        }

        @Override
        public void explicitOutputFormat_$eq(ExportFormat x$1) {
            this.explicitOutputFormat = x$1;
        }

        private ExportFormat outputFormat$lzycompute() {
            ConvertParameters convertParameters = this;
            synchronized (convertParameters) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.outputFormat = ExportCommand.ExportParams.outputFormat$(this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.outputFormat;
        }

        @Override
        public ExportFormat outputFormat() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.outputFormat$lzycompute();
            }
            return this.outputFormat;
        }

        @Override
        public boolean force() {
            return this.force;
        }

        @Override
        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        @Override
        public Integer reducers() {
            return this.reducers;
        }

        @Override
        public void reducers_$eq(Integer x$1) {
            this.reducers = x$1;
        }

        @Override
        public String runMode() {
            return this.runMode;
        }

        @Override
        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option<Enumeration.Value> mode$lzycompute() {
            ConvertParameters convertParameters = this;
            synchronized (convertParameters) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.mode = DistributedRunParam.mode$(this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.mode;
        }

        @Override
        public Option<Enumeration.Value> mode() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.mode$lzycompute();
            }
            return this.mode;
        }

        @Override
        public Map<String, String> hints() {
            return this.hints;
        }

        @Override
        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        @Override
        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        @Override
        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public ConvertParameters() {
            OptionalCqlFilterParam.$init$(this);
            QueryHintsParams.$init$(this);
            DistributedRunParam.$init$(this);
            NumReducersParam.$init$(this);
            OptionalForceParam.$init$(this);
            ExportCommand.ExportParams.$init$(this);
            InputFilesParam.$init$(this);
            OptionalInputFormatParam.$init$(this);
            OptionalTypeNameParam.$init$(this);
            OptionalFeatureSpecParam.$init$(this);
            ConverterConfigParam.$init$(this);
        }
    }
}

