/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.locationtech.geomesa.fs.storage.api.FileSystemStorage;
import org.locationtech.geomesa.fs.storage.common.jobs.StorageConfiguration$;
import org.locationtech.geomesa.fs.storage.orc.OrcFileSystemWriter;
import org.locationtech.geomesa.fs.storage.orc.OrcFileSystemWriter$;
import org.locationtech.geomesa.fs.storage.parquet.ParquetFileSystemStorage;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.export.formats.FileSystemExporter$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0005\u0005ud!B\f\u0019\u0003\u0003)\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u000bq\u0002A\u0011A\u001f\t\u0011\u0001\u0003\u0001R1A\u0005\n\u0005C\u0011b\u0017\u0001A\u0002\u0003\u0007I\u0011\u0002/\t\u0013=\u0004\u0001\u0019!a\u0001\n\u0013\u0001\b\"\u0003<\u0001\u0001\u0004\u0005\t\u0015)\u0003^\u0011\u00159\bA\"\u0005y\u0011\u001d\tY\u0001\u0001C!\u0003\u001bAaa\u0007\u0001\u0005B\u0005E\u0001bBA\u001e\u0001\u0011\u0005\u0013Q\b\u0005\b\u0003\u007f\u0001A\u0011IA!\u000f\u001d\t\u0019\u0005\u0007E\u0001\u0003\u000b2aa\u0006\r\t\u0002\u0005\u001d\u0003B\u0002\u001f\u000e\t\u0003\tiF\u0002\u0004\u0002`5\u0001\u0011\u0011\r\u0005\ta=\u0011\t\u0011)A\u0005c!1Ah\u0004C\u0001\u0003GBaa^\b\u0005R\u0005-dABA8\u001b\u0001\t\t\b\u0003\u00051'\t\u0005\t\u0015!\u00032\u0011\u0019a4\u0003\"\u0001\u0002t!1qo\u0005C)\u0003s\u0012!CR5mKNK8\u000f^3n\u000bb\u0004xN\u001d;fe*\u0011\u0011DG\u0001\bM>\u0014X.\u0019;t\u0015\tYB$\u0001\u0004fqB|'\u000f\u001e\u0006\u0003;y\tQ\u0001^8pYNT!a\b\u0011\u0002\u000f\u001d,w.\\3tC*\u0011\u0011EI\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002G\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g!\tic&D\u0001\u0019\u0013\ty\u0003DA\bGK\u0006$XO]3FqB|'\u000f^3s\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005IJdBA\u001a8!\t!\u0004&D\u00016\u0015\t1D%\u0001\u0004=e>|GOP\u0005\u0003q!\na\u0001\u0015:fI\u00164\u0017B\u0001\u001e<\u0005\u0019\u0019FO]5oO*\u0011\u0001\bK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005yz\u0004CA\u0017\u0001\u0011\u0015\u0001$\u00011\u00012\u0003\u0019A\u0017M\u001c3mKV\t!\t\u0005\u0002D1:\u0011A)\u0016\b\u0003\u000bJs!AR(\u000f\u0005\u001dkeB\u0001%M\u001d\tI5J\u0004\u00025\u0015&\t1%\u0003\u0002\"E%\u0011q\u0004I\u0005\u0003\u001dz\tQ!\u001e;jYNL!\u0001U)\u0002\u0005%|'B\u0001(\u001f\u0013\t\u0019F+\u0001\u0002gg*\u0011\u0001+U\u0005\u0003-^\u000b!CR5mKNK8\u000f^3n\t\u0016dWmZ1uK*\u00111\u000bV\u0005\u00033j\u0013!BR5mK\"\u000bg\u000e\u001a7f\u0015\t1v+\u0001\u0004xe&$XM]\u000b\u0002;B\u0011a\f\u001c\b\u0003?&t!\u0001\u00194\u000f\u0005\u0005\u001cgBA$c\u0013\t\u0019f$\u0003\u0002eK\u000691\u000f^8sC\u001e,'BA*\u001f\u0013\t9\u0007.A\u0002ba&T!\u0001Z3\n\u0005)\\\u0017!\u0005$jY\u0016\u001c\u0016p\u001d;f[N#xN]1hK*\u0011q\r[\u0005\u0003[:\u0014\u0001CR5mKNK8\u000f^3n/JLG/\u001a:\u000b\u0005)\\\u0017AC<sSR,'o\u0018\u0013fcR\u0011\u0011\u000f\u001e\t\u0003OIL!a\u001d\u0015\u0003\tUs\u0017\u000e\u001e\u0005\bk\u0016\t\t\u00111\u0001^\u0003\rAH%M\u0001\boJLG/\u001a:!\u00031\u0019'/Z1uK^\u0013\u0018\u000e^3s)\ti\u0016\u0010C\u0003{\u000f\u0001\u000710A\u0002tMR\u00042\u0001`A\u0004\u001b\u0005i(B\u0001@\u0000\u0003\u0019\u0019\u0018.\u001c9mK*!\u0011\u0011AA\u0002\u0003\u001d1W-\u0019;ve\u0016T1!!\u0002#\u0003\u001dy\u0007/\u001a8hSNL1!!\u0003~\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0001\u0006gR\f'\u000f\u001e\u000b\u0004c\u0006=\u0001\"\u0002>\t\u0001\u0004YH\u0003BA\n\u0003?\u0001RaJA\u000b\u00033I1!a\u0006)\u0005\u0019y\u0005\u000f^5p]B\u0019q%a\u0007\n\u0007\u0005u\u0001F\u0001\u0003M_:<\u0007bBA\u0011\u0013\u0001\u0007\u00111E\u0001\tM\u0016\fG/\u001e:fgB1\u0011QEA\u0018\u0003kqA!a\n\u0002,9\u0019A'!\u000b\n\u0003%J1!!\f)\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\r\u00024\tA\u0011\n^3sCR|'OC\u0002\u0002.!\u00022\u0001`A\u001c\u0013\r\tI$ \u0002\u000e'&l\u0007\u000f\\3GK\u0006$XO]3\u0002\u000b\tLH/Z:\u0016\u0005\u0005e\u0011!B2m_N,G#A9\u0002%\u0019KG.Z*zgR,W.\u0012=q_J$XM\u001d\t\u0003[5\u0019B!\u0004\u0014\u0002JA!\u00111JA-\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013\u0001D:dC2\fGn\\4hS:<'\u0002BA*\u0003+\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u0003/\n1aY8n\u0013\u0011\tY&!\u0014\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u000b\u0003\u0003\u000b\u0012\u0011\u0004U1scV,GOR5mKNK8\u000f^3n\u000bb\u0004xN\u001d;feN\u0011qB\u0010\u000b\u0005\u0003K\nI\u0007E\u0002\u0002h=i\u0011!\u0004\u0005\u0006aE\u0001\r!\r\u000b\u0004;\u00065\u0004\"\u0002>\u0013\u0001\u0004Y(!F(sG\u001aKG.Z*zgR,W.\u0012=q_J$XM]\n\u0003'y\"B!!\u001e\u0002xA\u0019\u0011qM\n\t\u000bA*\u0002\u0019A\u0019\u0015\u0007u\u000bY\bC\u0003{-\u0001\u00071\u0010")
public abstract class FileSystemExporter
implements FeatureExporter {
    private FileSystemDelegate.FileHandle handle;
    private String path;
    private FileSystemStorage.FileSystemWriter writer;
    private volatile boolean bitmap$0;

    private FileSystemDelegate.FileHandle handle$lzycompute() {
        FileSystemExporter fileSystemExporter = this;
        synchronized (fileSystemExporter) {
            if (!this.bitmap$0) {
                this.handle = PathUtils$.MODULE$.getHandle(this.path);
                this.bitmap$0 = true;
            }
        }
        this.path = null;
        return this.handle;
    }

    private FileSystemDelegate.FileHandle handle() {
        if (!this.bitmap$0) {
            return this.handle$lzycompute();
        }
        return this.handle;
    }

    private FileSystemStorage.FileSystemWriter writer() {
        return this.writer;
    }

    private void writer_$eq(FileSystemStorage.FileSystemWriter x$1) {
        this.writer = x$1;
    }

    public abstract FileSystemStorage.FileSystemWriter createWriter(SimpleFeatureType var1);

    @Override
    public void start(SimpleFeatureType sft) {
        if (this.writer() != null) {
            this.writer().close();
        }
        this.writer_$eq(this.createWriter(sft));
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        Predef$.MODULE$.require(this.writer() != null, (Function0 & Serializable)() -> "Must call 'start' before 'export'");
        LongRef i = LongRef.create((long)0L);
        features.foreach((Function1 & Serializable)f -> {
            FileSystemExporter.$anonfun$export$2(this, i, f);
            return BoxedUnit.UNIT;
        });
        return new Some((Object)BoxesRunTime.boxToLong((long)i.elem));
    }

    @Override
    public long bytes() {
        return this.handle().length();
    }

    @Override
    public void close() {
        if (this.writer() != null) {
            this.writer().close();
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$export$2(FileSystemExporter $this, LongRef i$1, SimpleFeature f) {
        $this.writer().write(f);
        ++i$1.elem;
    }

    public FileSystemExporter(String path) {
        this.path = path;
    }

    public static class OrcFileSystemExporter
    extends FileSystemExporter {
        private final String path;

        @Override
        public FileSystemStorage.FileSystemWriter createWriter(SimpleFeatureType sft) {
            return new OrcFileSystemWriter(sft, new Configuration(), new Path(PathUtils$.MODULE$.getUrl(this.path).toURI()), OrcFileSystemWriter$.MODULE$.$lessinit$greater$default$4());
        }

        public OrcFileSystemExporter(String path) {
            this.path = path;
            super(path);
        }
    }

    public static class ParquetFileSystemExporter
    extends FileSystemExporter {
        private final String path;

        @Override
        public FileSystemStorage.FileSystemWriter createWriter(SimpleFeatureType sft) {
            BoxedUnit boxedUnit;
            Configuration conf = new Configuration();
            StorageConfiguration$.MODULE$.setSft(conf, sft);
            try {
                boxedUnit = Class.forName("org.xerial.snappy.Snappy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                BoxedUnit boxedUnit2;
                if (FileSystemExporter$.MODULE$.logger().underlying().isWarnEnabled()) {
                    FileSystemExporter$.MODULE$.logger().underlying().warn("SNAPPY compression is not available on the classpath - falling back to GZIP");
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                conf.set("parquet.compression", "GZIP");
                boxedUnit = BoxedUnit.UNIT;
            }
            return new ParquetFileSystemStorage.ParquetFileSystemWriter(sft, new Path(PathUtils$.MODULE$.getUrl(this.path).toURI()), conf, ParquetFileSystemStorage.ParquetFileSystemWriter$.MODULE$.$lessinit$greater$default$4());
        }

        public ParquetFileSystemExporter(String path) {
            this.path = path;
            super(path);
        }
    }
}

