/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.ingest;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.geotools.data.DataUtilities;
import org.locationtech.geomesa.features.ScalaSimpleFeature;
import org.locationtech.geomesa.jobs.mapreduce.ConverterInputFormat;
import org.locationtech.geomesa.jobs.mapreduce.ConverterInputFormat$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat$;
import org.locationtech.geomesa.jobs.mapreduce.JobWithLibJars;
import org.locationtech.geomesa.jobs.package;
import org.locationtech.geomesa.tools.ingest.IngestCommand$IngestCounters$;
import org.locationtech.geomesa.tools.utils.JobRunner$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001B\r\u001b\u0001\u0015B\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"AQ\f\u0001B\u0001B\u0003%a\f\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003j\u0011!\t\bA!A!\u0002\u0013I\u0007\u0002\u0003:\u0001\u0005\u0003\u0005\u000b\u0011B:\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!I\u0011\u0011\u0004\u0001C\u0002\u0013%\u00111\u0004\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u0002\u001e!I\u0011Q\b\u0001C\u0002\u0013%\u0011q\b\u0005\t\u0003'\u0002\u0001\u0015!\u0003\u0002B!9\u0011Q\u000b\u0001\u0005\u0012\u0005]\u0003bBA3\u0001\u0011E\u0011q\r\u0005\b\u0003W\u0002A\u0011IA7\u0011\u001d\ty\b\u0001C\u0001\u0003\u0003;q!a#\u001b\u0011\u0003\tiI\u0002\u0004\u001a5!\u0005\u0011q\u0012\u0005\b\u0003\u000b\tB\u0011AAI\r\u0019\t\u0019*\u0005\u0001\u0002\u0016\"9\u0011QA\n\u0005\u0002\u0005}VABAc'\u0001\t9\rC\u0005\u0002LN\u0011\r\u0011\"\u0003\u0002N\"A\u0011qZ\n!\u0002\u0013\ti\u000bC\u0004\u0002RN!\t%a5\u0003%\r{gN^3si\u0016\u0014\u0018J\\4fgRTuN\u0019\u0006\u00037q\ta!\u001b8hKN$(BA\u000f\u001f\u0003\u0015!xn\u001c7t\u0015\ty\u0002%A\u0004hK>lWm]1\u000b\u0005\u0005\u0012\u0013\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u00011C\u0006\u0011\t\u0003O)j\u0011\u0001\u000b\u0006\u0002S\u0005)1oY1mC&\u00111\u0006\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u00055jdB\u0001\u0018;\u001d\ty\u0003H\u0004\u00021o9\u0011\u0011G\u000e\b\u0003eUj\u0011a\r\u0006\u0003i\u0011\na\u0001\u0010:p_Rt\u0014\"A\u0012\n\u0005\u0005\u0012\u0013BA\u0010!\u0013\tId$\u0001\u0003k_\n\u001c\u0018BA\u001e=\u0003\u001d\u0001\u0018mY6bO\u0016T!!\u000f\u0010\n\u0005yz$!C!xC&$\u0018M\u00197f\u0015\tYD\b\u0005\u0002B\t6\t!I\u0003\u0002Dy\u0005IQ.\u00199sK\u0012,8-Z\u0005\u0003\u000b\n\u0013aBS8c/&$\b\u000eT5c\u0015\u0006\u00148/\u0001\u0005egB\u000b'/Y7t!\u0011AEjT(\u000f\u0005%S\u0005C\u0001\u001a)\u0013\tY\u0005&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001b:\u00131!T1q\u0015\tY\u0005\u0006\u0005\u0002I!&\u0011\u0011K\u0014\u0002\u0007'R\u0014\u0018N\\4\u0002\u0007M4G\u000f\u0005\u0002U76\tQK\u0003\u0002W/\u000611/[7qY\u0016T!\u0001W-\u0002\u000f\u0019,\u0017\r^;sK*\u0011!LI\u0001\b_B,gnZ5t\u0013\taVKA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016\fqbY8om\u0016\u0014H/\u001a:D_:4\u0017n\u001a\t\u0003?\u001al\u0011\u0001\u0019\u0006\u0003C\n\faaY8oM&<'BA2e\u0003!!\u0018\u0010]3tC\u001a,'\"A3\u0002\u0007\r|W.\u0003\u0002hA\n11i\u001c8gS\u001e\fQ\u0001]1uQN\u00042A\u001b8P\u001d\tYWN\u0004\u00023Y&\t\u0011&\u0003\u0002<Q%\u0011q\u000e\u001d\u0002\u0004'\u0016\f(BA\u001e)\u00031a\u0017N\u00196beN4\u0015\u000e\\3t\u00031a\u0017N\u00196beN\u0004\u0016\r\u001e5t!\rQGO^\u0005\u0003kB\u0014\u0001\"\u0013;fe\u0006$xN\u001d\t\u0004O]L\u0018B\u0001=)\u0005%1UO\\2uS>t\u0007\u0007E\u0002k]j\u00042a_A\u0001\u001b\u0005a(BA?\u007f\u0003\tIwNC\u0001\u0000\u0003\u0011Q\u0017M^1\n\u0007\u0005\rAP\u0001\u0003GS2,\u0017A\u0002\u001fj]&$h\b\u0006\b\u0002\n\u00055\u0011qBA\t\u0003'\t)\"a\u0006\u0011\u0007\u0005-\u0001!D\u0001\u001b\u0011\u00151u\u00011\u0001H\u0011\u0015\u0011v\u00011\u0001T\u0011\u0015iv\u00011\u0001_\u0011\u0015Aw\u00011\u0001j\u0011\u0015\tx\u00011\u0001j\u0011\u0015\u0011x\u00011\u0001t\u000311\u0017-\u001b7D_VtG/\u001a:t+\t\ti\u0002\u0005\u0004\u0002 \u0005%\u00121F\u0007\u0003\u0003CQA!a\t\u0002&\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003OA\u0013AC2pY2,7\r^5p]&\u0019q.!\t\u0011\u000f\u001d\ni#!\r\u00022%\u0019\u0011q\u0006\u0015\u0003\rQ+\b\u000f\\33!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001c}\u0006!A.\u00198h\u0013\r\t\u0016QG\u0001\u000eM\u0006LGnQ8v]R,'o\u001d\u0011\u0002\u0007)|'-\u0006\u0002\u0002BA!\u00111IA(\u001b\t\t)EC\u0002D\u0003\u000fRA!!\u0013\u0002L\u00051\u0001.\u00193p_BT1!!\u0014#\u0003\u0019\t\u0007/Y2iK&!\u0011\u0011KA#\u0005\rQuNY\u0001\u0005U>\u0014\u0007%A\u0006nCB\u001cu.\u001e8uKJ\u001cH\u0003BA-\u0003G\u0002BA\u001b8\u0002\\A1q%!\fP\u0003;\u00022aJA0\u0013\r\t\t\u0007\u000b\u0002\u0005\u0019>tw\rC\u0004\u0002>1\u0001\r!!\u0011\u0002\u001dI,G-^2f\u0007>,h\u000e^3sgR!\u0011\u0011LA5\u0011\u001d\ti$\u0004a\u0001\u0003\u0003\nQ!Y<bSR$B!a\u001c\u0002vA\u0019Q&!\u001d\n\u0007\u0005MtHA\u0005K_\n\u0014Vm];mi\"9\u0011q\u000f\bA\u0002\u0005e\u0014\u0001\u0003:fa>\u0014H/\u001a:\u0011\u00075\nY(C\u0002\u0002~}\u0012ab\u0015;biV\u001c8)\u00197mE\u0006\u001c7.\u0001\u0007d_:4\u0017nZ;sK*{'\r\u0006\u0003\u0002\u0004\u0006%\u0005cA\u0014\u0002\u0006&\u0019\u0011q\u0011\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003{y\u0001\u0019AA!\u0003I\u0019uN\u001c<feR,'/\u00138hKN$(j\u001c2\u0011\u0007\u0005-\u0011c\u0005\u0002\u0012MQ\u0011\u0011Q\u0012\u0002\r\u0013:<Wm\u001d;NCB\u0004XM]\n\u0006'\u0005]\u00151\u0017\t\r\u0003\u0007\nI*!(\u0002(\u00065\u0016qU\u0005\u0005\u00037\u000b)E\u0001\u0004NCB\u0004XM\u001d\t\u0005\u0003?\u000b\u0019+\u0004\u0002\u0002\"*\u0019Q0a\u0012\n\t\u0005\u0015\u0016\u0011\u0015\u0002\r\u0019>twm\u0016:ji\u0006\u0014G.\u001a\t\u0004)\u0006%\u0016bAAV+\ni1+[7qY\u00164U-\u0019;ve\u0016\u0004B!a(\u00020&!\u0011\u0011WAQ\u0005\u0011!V\r\u001f;\u0011\t\u0005U\u00161X\u0007\u0003\u0003oS1!!/c\u00031\u00198-\u00197bY><w-\u001b8h\u0013\u0011\ti,a.\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u000b\u0003\u0003\u0003\u00042!a1\u0014\u001b\u0005\t\"aB\"p]R,\u0007\u0010\u001e\t\u0005\u0003/\u000bI-\u0003\u0003\u0002F\u0006e\u0015\u0001\u0002;fqR,\"!!,\u0002\u000bQ,\u0007\u0010\u001e\u0011\u0002\u00075\f\u0007\u000f\u0006\u0005\u0002\u0004\u0006U\u0017\u0011\\Ao\u0011\u001d\t9\u000e\u0007a\u0001\u0003;\u000b1a[3z\u0011\u001d\tY\u000e\u0007a\u0001\u0003O\u000b!a\u001d4\t\u000f\u0005}\u0007\u00041\u0001\u0002b\u000691m\u001c8uKb$\bcAAr+5\t1\u0003")
public class ConverterIngestJob
implements package.Awaitable,
JobWithLibJars {
    private final Map<String, String> dsParams;
    private final SimpleFeatureType sft;
    private final Config converterConfig;
    private final Seq<String> paths;
    private final Seq<Tuple2<String, String>> failCounters;
    private final Job job;

    public void setLibJars(Job job, Seq<String> fileNames, Iterator<Function0<Seq<File>>> searchPath) {
        JobWithLibJars.setLibJars$((JobWithLibJars)this, (Job)job, fileNames, searchPath);
    }

    private Seq<Tuple2<String, String>> failCounters() {
        return this.failCounters;
    }

    private Job job() {
        return this.job;
    }

    public Seq<Tuple2<String, Object>> mapCounters(Job job) {
        return new .colon.colon((Object)new Tuple2((Object)IngestCommand$IngestCounters$.MODULE$.Ingested(), (Object)BoxesRunTime.boxToLong((long)job.getCounters().findCounter(GeoMesaOutputFormat.OutputCounters$.MODULE$.Group(), GeoMesaOutputFormat.OutputCounters$.MODULE$.Written()).getValue())), (List)new .colon.colon((Object)new Tuple2((Object)IngestCommand$IngestCounters$.MODULE$.Failed(), ((IterableOnceOps)this.failCounters().map((Function1 & Serializable)c -> BoxesRunTime.boxToLong((long)ConverterIngestJob.$anonfun$mapCounters$1(job, c)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), (List)Nil$.MODULE$));
    }

    public Seq<Tuple2<String, Object>> reduceCounters(Job job) {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public package.JobResult await(package.StatusCallback reporter) {
        return JobRunner$.MODULE$.monitor(this.job(), reporter, (Function0<Seq<Tuple2<String, Object>>>)(Function0 & Serializable)() -> this.mapCounters(this.job()), (Function0<Seq<Tuple2<String, Object>>>)(Function0 & Serializable)() -> this.reduceCounters(this.job()));
    }

    public void configureJob(Job job) {
        job.setJarByClass(this.getClass());
        job.setMapperClass(IngestMapper.class);
        job.setInputFormatClass(ConverterInputFormat.class);
        job.setOutputFormatClass(GeoMesaOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setOutputValueClass(ScalaSimpleFeature.class);
        job.setNumReduceTasks(0);
        job.getConfiguration().set("mapred.map.tasks.speculative.execution", "false");
        job.getConfiguration().set("mapred.reduce.tasks.speculative.execution", "false");
        job.getConfiguration().set("mapreduce.job.user.classpath.first", "true");
        FileInputFormat.setInputPaths((Job)job, (String)this.paths.mkString(","));
        ConverterInputFormat$.MODULE$.setConverterConfig(job, this.converterConfig.root().render(ConfigRenderOptions.concise()));
        ConverterInputFormat$.MODULE$.setSft(job, this.sft);
        GeoMesaOutputFormat$.MODULE$.setOutput(job.getConfiguration(), this.dsParams, this.sft, GeoMesaOutputFormat$.MODULE$.setOutput$default$4());
    }

    public static final /* synthetic */ long $anonfun$mapCounters$1(Job job$1, Tuple2 c) {
        return job$1.getCounters().findCounter((String)c._1(), (String)c._2()).getValue();
    }

    public ConverterIngestJob(Map<String, String> dsParams, SimpleFeatureType sft, Config converterConfig, Seq<String> paths, Seq<String> libjarsFiles, Iterator<Function0<Seq<File>>> libjarsPaths) {
        this.dsParams = dsParams;
        this.sft = sft;
        this.converterConfig = converterConfig;
        this.paths = paths;
        JobWithLibJars.$init$((JobWithLibJars)this);
        this.failCounters = new .colon.colon((Object)new Tuple2((Object)ConverterInputFormat.ConverterCounters$.MODULE$.Group(), (Object)ConverterInputFormat.ConverterCounters$.MODULE$.Failed()), (List)new .colon.colon((Object)new Tuple2((Object)GeoMesaOutputFormat.OutputCounters$.MODULE$.Group(), (Object)GeoMesaOutputFormat.OutputCounters$.MODULE$.Failed()), (List)Nil$.MODULE$));
        Job job = Job.getInstance((Configuration)new Configuration(), (String)"GeoMesa Tools Ingest");
        this.setLibJars(job, libjarsFiles, libjarsPaths);
        this.configureJob(job);
        JobRunner$.MODULE$.submit(job);
        this.job = job;
    }

    public static class IngestMapper
    extends Mapper<LongWritable, SimpleFeature, Text, SimpleFeature>
    implements LazyLogging {
        private final Text text;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            IngestMapper ingestMapper = this;
            synchronized (ingestMapper) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        private Text text() {
            return this.text;
        }

        public void map(LongWritable key, SimpleFeature sf, Mapper.Context context) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("map key {}, map value {}", new Object[]{key.toString(), DataUtilities.encodeFeature((SimpleFeature)sf)});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            context.write((Object)this.text(), (Object)sf);
        }

        public IngestMapper() {
            LazyLogging.$init$((LazyLogging)this);
            this.text = new Text();
        }
    }
}

