/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.ingest;

import com.beust.jcommander.ParameterException;
import com.typesafe.config.Config;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.locationtech.geomesa.jobs.mapreduce.ConverterCombineInputFormat;
import org.locationtech.geomesa.jobs.package;
import org.locationtech.geomesa.tools.ConverterConfigParam;
import org.locationtech.geomesa.tools.DistributedCombineParam;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.DistributedRunParam$RunModes$;
import org.locationtech.geomesa.tools.OptionalFeatureSpecParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalInputFormatParam;
import org.locationtech.geomesa.tools.OptionalTypeNameParam;
import org.locationtech.geomesa.tools.TypeNameParam;
import org.locationtech.geomesa.tools.data.CreateSchemaCommand;
import org.locationtech.geomesa.tools.ingest.ConverterIngestJob;
import org.locationtech.geomesa.tools.ingest.IngestCommand$;
import org.locationtech.geomesa.tools.ingest.IngestCommand$IngestCounters$;
import org.locationtech.geomesa.tools.ingest.IngestCommand$Inputs$;
import org.locationtech.geomesa.tools.ingest.LocalConverterIngest;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.tools.utils.TerminalCallback$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.LocalDelegate;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0011Uba\u0002!B!\u0003\r\t\u0001\u0014\u0005\b\u0003/\u0001A\u0011AA\r\u0011%\t\t\u0003\u0001b\u0001\n\u0003\n\u0019\u0003C\u0004\u0002,\u00011\t%!\f\t\u000f\r=\b\u0001\"\u0011\u0004\n!91\u0011\u001f\u0001\u0005B\u0005e\u0001bBBz\u0001\u0011E1Q_\u0004\b\u0003o\t\u0005\u0012AA\u001d\r\u0019\u0001\u0015\t#\u0001\u0002>!9\u0011\u0011\f\u0005\u0005\u0002\u0005m\u0003\"CA/\u0011\t\u0007I\u0011AA0\u0011!\ty\b\u0003Q\u0001\n\u0005\u0005d!CAA\u0011A\u0005\u0019\u0011AAB\u0011\u001d\t9\u0002\u0004C\u0001\u00033A\u0011\"!-\r\u0001\u0004%\t!a-\t\u0013\u0005}G\u00021A\u0005\u0002\u0005\u0005\b\"CAt\u0019\u0001\u0007I\u0011AAu\u0011%\ti\u0010\u0004a\u0001\n\u0003\ty\u0010C\u0005\u0003\u00041\u0001\r\u0011\"\u0001\u0002j\"I!\u0011\u0003\u0007A\u0002\u0013\u0005!1\u0003\u0005\b\u0005/aA\u0011AAu\u0011\u001d\u0011I\u0002\u0003C\u0001\u00057AqAa\u0012\t\t\u0003\u0011I\u0005C\u0004\u0003,\"!\tA!,\t\u0013\t\u0015\u0007\"%A\u0005\u0002\t\u001d\u0007\"\u0003Bo\u0011E\u0005I\u0011\u0001Bd\u000f\u001d\u0011y\u000e\u0003E\u0001\u0005C4qA!:\t\u0011\u0003\u00119\u000fC\u0004\u0002Zm!\tA!;\t\u0013\t-8D1A\u0005\u0002\u0005\r\u0002\u0002\u0003Bw7\u0001\u0006I!!\n\t\u0013\t=8D1A\u0005\u0002\u0005\r\u0002\u0002\u0003By7\u0001\u0006I!!\n\t\u0013\tM8D1A\u0005\u0002\u0005\r\u0002\u0002\u0003B{7\u0001\u0006I!!\n\u0007\r\t]\b\u0002\u0011B}\u0011)\u00199a\tBK\u0002\u0013\u00051\u0011\u0002\u0005\u000b\u0007\u0017\u0019#\u0011#Q\u0001\n\t]\u0002bBA-G\u0011\u00051Q\u0002\u0005\n\u0007'\u0019#\u0019!C\u0001\u0003SD\u0001b!\u0006$A\u0003%\u00111\u001e\u0005\u000b\u0007/\u0019\u0003R1A\u0005\u0002\re\u0001bBB G\u0011\u00051\u0011\t\u0005\n\u0007\u0007\u001a\u0013\u0011!C\u0001\u0007\u000bB\u0011b!\u0013$#\u0003%\taa\u0013\t\u0013\r=3%!A\u0005B\u0005\r\u0002\"CB)G\u0005\u0005I\u0011AB*\u0011%\u0019YfIA\u0001\n\u0003\u0019i\u0006C\u0005\u0004h\r\n\t\u0011\"\u0011\u0004j!I1qO\u0012\u0002\u0002\u0013\u00051\u0011\u0010\u0005\n\u0007{\u001a\u0013\u0011!C!\u0007\u007fB\u0011ba!$\u0003\u0003%\te!\"\t\u0013\r\u001d5%!A\u0005B\r%\u0005\"CBFG\u0005\u0005I\u0011IBG\u000f\u001d\u0019\t\n\u0003E\u0001\u0007'3qAa>\t\u0011\u0003\u0019)\nC\u0004\u0002Z]\"\taa(\t\u0013\r\u0005vG1A\u0005\u0002\r\r\u0006\u0002CBXo\u0001\u0006Ia!*\t\u0013\rEv'!A\u0005\u0002\u000eM\u0006\"CB\\o\u0005\u0005I\u0011QB]\u0011%\u0019\tmNA\u0001\n\u0013\u0019\u0019\rC\u0004\u0004F\"!Iaa2\t\u000f\r}\u0007\u0002\"\u0003\u0004b\ni\u0011J\\4fgR\u001cu.\\7b]\u0012T!AQ\"\u0002\r%tw-Z:u\u0015\t!U)A\u0003u_>d7O\u0003\u0002G\u000f\u00069q-Z8nKN\f'B\u0001%J\u00031awnY1uS>tG/Z2i\u0015\u0005Q\u0015aA8sO\u000e\u0001QCA'k'\u001d\u0001aJV>\u007f\u0003\u0007\u0001\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\t1\fgn\u001a\u0006\u0002'\u0006!!.\u0019<b\u0013\t)\u0006K\u0001\u0004PE*,7\r\u001e\t\u0004/\u0016DgB\u0001-d\u001d\tI&M\u0004\u0002[C:\u00111\f\u0019\b\u00039~k\u0011!\u0018\u0006\u0003=.\u000ba\u0001\u0010:p_Rt\u0014\"\u0001&\n\u0005!K\u0015B\u0001$H\u0013\t!U)\u0003\u0002e\u0007\u00069\u0001/Y2lC\u001e,\u0017B\u00014h\u0005A!\u0015\r^1Ti>\u0014XmQ8n[\u0006tGM\u0003\u0002e\u0007B\u0011\u0011N\u001b\u0007\u0001\t\u0015Y\u0007A1\u0001m\u0005\t!5+\u0005\u0002ngB\u0011a.]\u0007\u0002_*\t\u0001/A\u0003tG\u0006d\u0017-\u0003\u0002s_\n9aj\u001c;iS:<\u0007C\u0001;z\u001b\u0005)(B\u0001<x\u0003\u0011!\u0017\r^1\u000b\u0005aL\u0015\u0001C4f_R|w\u000e\\:\n\u0005i,(!\u0003#bi\u0006\u001cFo\u001c:f!\t9F0\u0003\u0002~O\n\u0011B)[:ue&\u0014W\u000f^3e\u0007>lW.\u00198e!\t9v0C\u0002\u0002\u0002\u001d\u0014!#\u00138uKJ\f7\r^5wK\u000e{W.\\1oIB!\u0011QAA\t\u001d\u0011\t9!a\u0003\u000f\u0007a\u000bI!\u0003\u0002w\u0007&!\u0011QBA\b\u0003M\u0019%/Z1uKN\u001b\u0007.Z7b\u0007>lW.\u00198e\u0015\t18)\u0003\u0003\u0002\u0014\u0005U!\u0001F*dQ\u0016l\u0017m\u00149uS>t7oQ8n[\u0006tGM\u0003\u0003\u0002\u000e\u0005=\u0011A\u0002\u0013j]&$H\u0005\u0006\u0002\u0002\u001cA\u0019a.!\b\n\u0007\u0005}qN\u0001\u0003V]&$\u0018\u0001\u00028b[\u0016,\"!!\n\u0011\u0007=\u000b9#C\u0002\u0002*A\u0013aa\u0015;sS:<\u0017A\u00029be\u0006l7/\u0006\u0002\u00020A\u0019\u0011\u0011\u0007\u0007\u000f\u0007\u0005MrAD\u0002Y\u0003kI!AQ\"\u0002\u001b%sw-Z:u\u0007>lW.\u00198e!\r\tY\u0004C\u0007\u0002\u0003N)\u0001\"a\u0010\u0002FA\u0019a.!\u0011\n\u0007\u0005\rsN\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003\u000f\n)&\u0004\u0002\u0002J)!\u00111JA'\u00031\u00198-\u00197bY><w-\u001b8h\u0015\u0011\ty%!\u0015\u0002\u0011QL\b/Z:bM\u0016T!!a\u0015\u0002\u0007\r|W.\u0003\u0003\u0002X\u0005%#a\u0003'bufdunZ4j]\u001e\fa\u0001P5oSRtDCAA\u001d\u00039aunY1m\u0005\u0006$8\r[*ju\u0016,\"!!\u0019\u0011\t\u0005\r\u0014\u0011\u0010\b\u0005\u0003K\n\u0019H\u0004\u0003\u0002h\u00055dbA-\u0002j%\u0019\u00111N#\u0002\u000bU$\u0018\u000e\\:\n\t\u0005=\u0014\u0011O\u0001\u0005G>tgMC\u0002\u0002l\u0015KA!!\u001e\u0002x\u00059r)Z8NKN\f7+_:uK6\u0004&o\u001c9feRLWm\u001d\u0006\u0005\u0003_\n\t(\u0003\u0003\u0002|\u0005u$AD*zgR,W\u000e\u0015:pa\u0016\u0014H/\u001f\u0006\u0005\u0003k\n9(A\bM_\u000e\fGNQ1uG\"\u001c\u0016N_3!\u00051IenZ3tiB\u000b'/Y7t'Ea\u0011qHAC\u0003\u001b\u000b\u0019*!'\u0002 \u0006\u0015\u00161\u0016\t\u0005\u0003\u000f\u000bI)D\u0001D\u0013\r\tYi\u0011\u0002\u0016\u001fB$\u0018n\u001c8bYRK\b/\u001a(b[\u0016\u0004\u0016M]1n!\u0011\t9)a$\n\u0007\u0005E5I\u0001\rPaRLwN\\1m\r\u0016\fG/\u001e:f'B,7\rU1sC6\u0004B!a\"\u0002\u0016&\u0019\u0011qS\"\u0003%=\u0003H/[8oC24uN]2f!\u0006\u0014\u0018-\u001c\t\u0005\u0003\u000f\u000bY*C\u0002\u0002\u001e\u000e\u0013AcQ8om\u0016\u0014H/\u001a:D_:4\u0017n\u001a)be\u0006l\u0007\u0003BAD\u0003CK1!a)D\u0005ay\u0005\u000f^5p]\u0006d\u0017J\u001c9vi\u001a{'/\\1u!\u0006\u0014\u0018-\u001c\t\u0005\u0003\u000f\u000b9+C\u0002\u0002*\u000e\u00131\u0003R5tiJL'-\u001e;fIJ+h\u000eU1sC6\u0004B!a\"\u0002.&\u0019\u0011qV\"\u0003/\u0011K7\u000f\u001e:jEV$X\rZ\"p[\nLg.\u001a)be\u0006l\u0017a\u0002;ie\u0016\fGm]\u000b\u0003\u0003k\u00032aTA\\\u0013\r\tI\f\u0015\u0002\b\u0013:$XmZ3sQ-q\u0011QXAg\u0003\u001f\fI.a7\u0011\t\u0005}\u0016\u0011Z\u0007\u0003\u0003\u0003TA!a1\u0002F\u0006Q!nY8n[\u0006tG-\u001a:\u000b\t\u0005\u001d\u0017\u0011K\u0001\u0006E\u0016,8\u000f^\u0005\u0005\u0003\u0017\f\tMA\u0005QCJ\fW.\u001a;fe\u0006)a.Y7fg2\"\u0011\u0011[AkC\t\t\u0019.\u0001\u0002.i\u0006\u0012\u0011q[\u0001\n[5\"\bN]3bIN\f1\u0002Z3tGJL\u0007\u000f^5p]\u0006\u0012\u0011Q\\\u0001(\u001dVl'-\u001a:!_\u001a\u0004C\u000f\u001b:fC\u0012\u001c\b%\u001b4!kNLgn\u001a\u0011m_\u000e\fG\u000eI5oO\u0016\u001cH/A\u0006uQJ,\u0017\rZ:`I\u0015\fH\u0003BA\u000e\u0003GD\u0011\"!:\u0010\u0003\u0003\u0005\r!!.\u0002\u0007a$\u0013'A\u0004te\u000ed\u0015n\u001d;\u0016\u0005\u0005-\bc\u00018\u0002n&\u0019\u0011q^8\u0003\u000f\t{w\u000e\\3b]\"Z\u0001#!0\u0002N\u0006M\u0018\u0011\\A}Y\t\t)0\t\u0002\u0002x\u0006QQ&L:sG6b\u0017n\u001d;\"\u0005\u0005m\u0018\u0001S%oaV$\bEZ5mKN\u0004\u0013M]3!i\u0016DH\u000f\t4jY\u0016\u001c\be^5uQ\u0002b\u0017n\u001d;tA=4\u0007EZ5mKNd\u0003e\u001c8fAA,'\u000f\t7j]\u0016d\u0003\u0005^8!S:<Wm\u001d;/\u0003-\u0019(o\u0019'jgR|F%Z9\u0015\t\u0005m!\u0011\u0001\u0005\n\u0003K\f\u0012\u0011!a\u0001\u0003W\f1C\\8XC&$hi\u001c:D_6\u0004H.\u001a;j_:D3BEA_\u0003\u001b\u00149!!7\u0003\u000e1\u0012!\u0011B\u0011\u0003\u0005\u0017\tQ\"L\u0017o_6\"(/Y2lS:<\u0017E\u0001B\b\u0003\u0005\u0013V\r^;s]\u0002JW.\\3eS\u0006$X\r\\=!C\u001a$XM\u001d\u0011tk\nl\u0017\u000e\u001e;j]\u001e\u0004\u0013N\\4fgR\u0004#n\u001c2!Q\u0011L7\u000f\u001e:jEV$X\r\u001a\u0011k_\n\u001c\u0018&A\fo_^\u000b\u0017\u000e\u001e$pe\u000e{W\u000e\u001d7fi&|gn\u0018\u0013fcR!\u00111\u0004B\u000b\u0011%\t)oEA\u0001\u0002\u0004\tY/A\txC&$hi\u001c:D_6\u0004H.\u001a;j_:\fQbZ3u\t\u0006$\u0018MR8s[\u0006$HC\u0002B\u000f\u0005c\u0011\u0019\u0004E\u0003o\u0005?\u0011\u0019#C\u0002\u0003\"=\u0014aa\u00149uS>t\u0007\u0003\u0002B\u0013\u0005[qAAa\n\u0003*A\u0011Al\\\u0005\u0004\u0005Wy\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002*\t=\"b\u0001B\u0016_\"9\u00111F\u000bA\u0002\u0005}\u0005b\u0002B\u001b+\u0001\u0007!qG\u0001\u0006M&dWm\u001d\t\u0007\u0005s\u0011\tEa\t\u000f\t\tm\"q\b\b\u00049\nu\u0012\"\u00019\n\u0005\u0011|\u0017\u0002\u0002B\"\u0005\u000b\u00121aU3r\u0015\t!w.\u0001\nhKR\u001cf\r^!oI\u000e{gN^3si\u0016\u0014HC\u0003B&\u0005\u007f\u0012\u0019Ja&\u0003\u001cB1!Q\nB*\u0005/j!Aa\u0014\u000b\u0007\tEs.\u0001\u0003vi&d\u0017\u0002\u0002B+\u0005\u001f\u00121\u0001\u0016:z!\u0015q'q\u0004B-!\u001dq'1\fB0\u0005gJ1A!\u0018p\u0005\u0019!V\u000f\u001d7feA!!\u0011\rB8\u001b\t\u0011\u0019G\u0003\u0003\u0003f\t\u001d\u0014AB:j[BdWM\u0003\u0003\u0003j\t-\u0014a\u00024fCR,(/\u001a\u0006\u0004\u0005[J\u0015aB8qK:<\u0017n]\u0005\u0005\u0005c\u0012\u0019GA\tTS6\u0004H.\u001a$fCR,(/\u001a+za\u0016\u0004BA!\u001e\u0003|5\u0011!q\u000f\u0006\u0005\u0005s\ni%\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0005{\u00129H\u0001\u0004D_:4\u0017n\u001a\u0005\b\u0003W1\u0002\u0019\u0001BA%)\u0011\u0019Ia\"\u0003\u000e\u0006e\u00151\u0013\u0004\u0007\u0005\u000bC\u0001A!!\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\t\u0005\u001d%\u0011R\u0005\u0004\u0005\u0017\u001b%!\u0004+za\u0016t\u0015-\\3QCJ\fW\u000e\u0005\u0003\u0002\b\n=\u0015b\u0001BI\u0007\n\u0001b)Z1ukJ,7\u000b]3d!\u0006\u0014\u0018-\u001c\u0005\b\u0005+3\u0002\u0019\u0001B\u001c\u0003\u0019Ig\u000e];ug\"9!\u0011\u0014\fA\u0002\tu\u0011A\u00024pe6\fG\u000fC\u0004\u0003\u001eZ\u0001\rAa(\u0002\u000f\r|W.\\1oIB)aNa\b\u0003\"B\"!1\u0015BT!\u00119VM!*\u0011\u0007%\u00149\u000bB\u0006\u0003*\nm\u0015\u0011!A\u0001\u0006\u0003a'aA0%c\u0005Yq-\u001a;Ti\u0006$\u0018J\u001c4p))\u0011\u0019Ca,\u0003:\nu&\u0011\u0019\u0005\b\u0005c;\u0002\u0019\u0001BZ\u0003%\u0019XoY2fgN,7\u000fE\u0002o\u0005kK1Aa.p\u0005\u0011auN\\4\t\u000f\tmv\u00031\u0001\u00034\u0006Aa-Y5mkJ,7\u000fC\u0005\u0003@^\u0001\n\u00111\u0001\u0003$\u00051\u0011m\u0019;j_:D\u0011Ba1\u0018!\u0003\u0005\rAa\t\u0002\u000b%t\u0007/\u001e;\u0002+\u001d,Go\u0015;bi&sgm\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\u001a\u0016\u0005\u0005G\u0011Ym\u000b\u0002\u0003NB!!q\u001aBm\u001b\t\u0011\tN\u0003\u0003\u0003T\nU\u0017!C;oG\",7m[3e\u0015\r\u00119n\\\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bn\u0005#\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003U9W\r^*uCRLeNZ8%I\u00164\u0017-\u001e7uIQ\na\"\u00138hKN$8i\\;oi\u0016\u00148\u000fE\u0002\u0003dni\u0011\u0001\u0003\u0002\u000f\u0013:<Wm\u001d;D_VtG/\u001a:t'\rY\u0012q\b\u000b\u0003\u0005C\f\u0001\"\u00138hKN$X\rZ\u0001\n\u0013:<Wm\u001d;fI\u0002\naAR1jY\u0016$\u0017a\u0002$bS2,G\rI\u0001\n!\u0016\u00148/[:uK\u0012\f!\u0002U3sg&\u001cH/\u001a3!\u0005\u0019Ie\u000e];ugN91%a\u0010\u0003|\u000e\u0005\u0001c\u00018\u0003~&\u0019!q`8\u0003\u000fA\u0013x\u000eZ;diB!!\u0011HB\u0002\u0013\u0011\u0019)A!\u0012\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u000bA\fG\u000f[:\u0016\u0005\t]\u0012A\u00029bi\"\u001c\b\u0005\u0006\u0003\u0004\u0010\rE\u0001c\u0001BrG!91q\u0001\u0014A\u0002\t]\u0012!B:uI&t\u0017AB:uI&t\u0007%A\u0004iC:$G.Z:\u0016\u0005\rm\u0001C\u0002B\u001d\u0007;\u0019\t#\u0003\u0003\u0004 \t\u0015#\u0001\u0002'jgR\u0004Baa\t\u0004:9!1QEB\u001a\u001d\u0011\u00199c!\f\u000f\t\u0005\u001d4\u0011F\u0005\u0005\u0007W\t\t(\u0001\u0002j_&!1qFB\u0019\u0003\t17O\u0003\u0003\u0004,\u0005E\u0014\u0002BB\u001b\u0007o\t!CR5mKNK8\u000f^3n\t\u0016dWmZ1uK*!1qFB\u0019\u0013\u0011\u0019Yd!\u0010\u0003\u0015\u0019KG.\u001a%b]\u0012dWM\u0003\u0003\u00046\r]\u0012\u0001D1t'>,(oY3MSN$XCAB\b\u0003\u0011\u0019w\u000e]=\u0015\t\r=1q\t\u0005\n\u0007\u000fY\u0003\u0013!a\u0001\u0005o\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004N)\"!q\u0007Bf\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u00111Q\u000b\t\u0004]\u000e]\u0013bAB-_\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!1qLB3!\rq7\u0011M\u0005\u0004\u0007Gz'aA!os\"I\u0011Q]\u0018\u0002\u0002\u0003\u00071QK\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u001111\u000e\t\u0007\u0007[\u001a\u0019ha\u0018\u000e\u0005\r=$bAB9_\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\rU4q\u000e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002l\u000em\u0004\"CAsc\u0005\u0005\t\u0019AB0\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005\u00152\u0011\u0011\u0005\n\u0003K\u0014\u0014\u0011!a\u0001\u0007+\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0007+\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003K\ta!Z9vC2\u001cH\u0003BAv\u0007\u001fC\u0011\"!:6\u0003\u0003\u0005\raa\u0018\u0002\r%s\u0007/\u001e;t!\r\u0011\u0019oN\n\u0006o\u0005}2q\u0013\t\u0005\u00073\u001bi*\u0004\u0002\u0004\u001c*\u001911\u0006*\n\t\r\u001511\u0014\u000b\u0003\u0007'\u000b1b\u0015;e\u0013:Le\u000e];ugV\u00111Q\u0015\t\u0007\u0007O\u001bi+!\n\u000e\u0005\r%&\u0002BBV\u0007_\n\u0011\"[7nkR\f'\r\\3\n\t\t\r3\u0011V\u0001\r'R$\u0017J\\%oaV$8\u000fI\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0007\u001f\u0019)\fC\u0004\u0004\bm\u0002\rAa\u000e\u0002\u000fUt\u0017\r\u001d9msR!11XB_!\u0015q'q\u0004B\u001c\u0011%\u0019y\fPA\u0001\u0002\u0004\u0019y!A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\u0012AT\u0001\bY>\fGm\u00154u)\u0019\u0019Ima3\u0004RB)aNa\b\u0003`!9\u00111\u0006 A\u0002\r5'CBBh\u0005\u000f\u0013iI\u0002\u0004\u0003\u0006\"\u00011Q\u001a\u0005\b\u0005;s\u0004\u0019ABj!\u0015q'qDBka\u0011\u00199na7\u0011\t]+7\u0011\u001c\t\u0004S\u000emGaCBo\u0007#\f\t\u0011!A\u0003\u00021\u00141a\u0018\u00134\u0003Y9(/\u001b;f\u0013:4WM\u001d:fI\u000e{gN^3si\u0016\u0014H\u0003CA\u000e\u0007G\u001c9oa;\t\u000f\r\u0015x\b1\u0001\u0003$\u0005AA/\u001f9f\u001d\u0006lW\rC\u0004\u0004j~\u0002\rAa\t\u0002\u001f\r|gN^3si\u0016\u00148\u000b\u001e:j]\u001eDqa!<@\u0001\u0004\u0011i\"\u0001\u0007tG\",W.Y*ue&tw-\u0001\u0007mS\nT\u0017M]:GS2,7/A\u0004fq\u0016\u001cW\u000f^3\u0002\u0017M$\u0018M\u001d;J]\u001e,7\u000f\u001e\u000b\r\u0007o$Y\u0001\"\n\u0005*\u00115B\u0011\u0007\t\u0005\u0007s$)A\u0004\u0003\u0004|\u0012\u0005abA-\u0004~&\u00191q`#\u0002\t)|'m]\u0005\u0004I\u0012\r!bAB\u0000\u000b&!Aq\u0001C\u0005\u0005%\tu/Y5uC\ndWMC\u0002e\t\u0007Aq\u0001\"\u0004\u0007\u0001\u0004!y!\u0001\u0003n_\u0012,\u0007\u0003\u0002C\t\t?qA\u0001b\u0005\u0005\u001a9\u0019\u0001\f\"\u0006\n\u0007\u0011]1)A\nESN$(/\u001b2vi\u0016$'+\u001e8QCJ\fW.\u0003\u0003\u0005\u001c\u0011u\u0011\u0001\u0003*v]6{G-Z:\u000b\u0007\u0011]1)\u0003\u0003\u0005\"\u0011\r\"a\u0002*v]6{G-\u001a\u0006\u0005\t7!i\u0002\u0003\u0004\u0005(\u0019\u0001\r\u0001[\u0001\u0003INDq\u0001b\u000b\u0007\u0001\u0004\u0011y&A\u0002tMRDq\u0001b\f\u0007\u0001\u0004\u0011\u0019(A\u0005d_:4XM\u001d;fe\"9!Q\u0013\u0004A\u0002\u0011M\u0002cAA\u0019G\u0001")
public interface IngestCommand<DS extends DataStore>
extends package.DataStoreCommand<DS>,
package.DistributedCommand,
package.InteractiveCommand,
CreateSchemaCommand.SchemaOptionsCommand {
    public static String getStatInfo$default$4() {
        return IngestCommand$.MODULE$.getStatInfo$default$4();
    }

    public static String getStatInfo$default$3() {
        return IngestCommand$.MODULE$.getStatInfo$default$3();
    }

    public static String getStatInfo(long successes, long failures, String action, String input) {
        return IngestCommand$.MODULE$.getStatInfo(successes, failures, action, input);
    }

    public static Try<Option<Tuple2<SimpleFeatureType, Config>>> getSftAndConverter(TypeNameParam params, Seq<String> inputs, Option<String> format, Option<package.DataStoreCommand<? extends DataStore>> command) {
        return IngestCommand$.MODULE$.getSftAndConverter(params, inputs, format, command);
    }

    public static Option<String> getDataFormat(OptionalInputFormatParam params, Seq<String> files) {
        return IngestCommand$.MODULE$.getDataFormat(params, files);
    }

    public static GeoMesaSystemProperties.SystemProperty LocalBatchSize() {
        return IngestCommand$.MODULE$.LocalBatchSize();
    }

    public void org$locationtech$geomesa$tools$ingest$IngestCommand$_setter_$name_$eq(String var1);

    @Override
    public String name();

    @Override
    public IngestParams params();

    public static /* synthetic */ Seq libjarsFiles$(IngestCommand $this) {
        return $this.libjarsFiles();
    }

    @Override
    default public Seq<String> libjarsFiles() {
        return new .colon.colon((Object)"org/locationtech/geomesa/tools/ingest-libjars.list", (List)Nil$.MODULE$);
    }

    public static /* synthetic */ void execute$(IngestCommand $this) {
        $this.execute();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    default public void execute() {
        Enumeration.Value mode;
        Enumeration.Value value;
        void var2_1;
        if (this.params().files().isEmpty() && !LocalDelegate.StdInHandle$.MODULE$.isAvailable()) {
            throw new ParameterException("Missing option: <files>... is required, or use `-` to ingest from standard in");
        }
        Inputs files = new Inputs((Seq<String>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.params().files()).asScala()).toSeq());
        Inputs inputs = this.params().srcList() ? files.asSourceList() : var2_1;
        Option<String> format = IngestCommand$.MODULE$.getDataFormat(this.params(), inputs.paths());
        boolean remote = inputs.paths().exists((Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)PathUtils$.MODULE$.isRemote(path)));
        if (remote) {
            String prefix = ((String)inputs.paths().head()).split("/")[0].toLowerCase();
            if (!((IterableOnceOps)inputs.paths().drop(1)).forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)IngestCommand.$anonfun$execute$2(prefix, x$1)))) {
                throw new ParameterException(new StringBuilder(61).append("Files must all be on the same file system: (").append(prefix).append(") or all be local").toString());
            }
        }
        if (format.contains((Object)"shp")) {
            if (this.params().mode().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)IngestCommand.$anonfun$execute$3(x$2)))) {
                package$Command$.MODULE$.user().warn("Forcing run mode to local for shapefile ingestion");
            }
            value = DistributedRunParam$RunModes$.MODULE$.Local();
        } else if (remote) {
            value = (Enumeration.Value)this.params().mode().getOrElse((Function0 & Serializable)() -> DistributedRunParam$RunModes$.MODULE$.Distributed());
        } else {
            if (this.params().mode().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)IngestCommand.$anonfun$execute$5(x$3)))) {
                throw new ParameterException("Input files must be in a distributed file system to run in distributed mode");
            }
            value = DistributedRunParam$RunModes$.MODULE$.Local();
        }
        Enumeration.Value value2 = mode = value;
        Enumeration.Value value3 = DistributedRunParam$RunModes$.MODULE$.Local();
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            if (!this.params().waitForCompletion()) {
                throw new ParameterException("Tracking must be enabled when running in local mode");
            }
        } else if (!BoxesRunTime.equalsNumObject((Number)this.params().threads(), (Object)BoxesRunTime.boxToInteger((int)1))) {
            throw new ParameterException("Threads can only be specified in local mode");
        }
        if (this.params().maxSplitSize() != null && !this.params().combineInputs()) {
            throw new ParameterException("--split-max-size can only be used with --combine-inputs");
        }
        ((Option)IngestCommand$.MODULE$.getSftAndConverter(this.params(), inputs.paths(), format, (Option<package.DataStoreCommand<? extends DataStore>>)new Some((Object)this)).get()).foreach((Function1 & Serializable)x0$1 -> {
            IngestCommand.$anonfun$execute$6(this, mode, inputs, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ package.Awaitable startIngest$(IngestCommand $this, Enumeration.Value mode, DataStore ds, SimpleFeatureType sft, Config converter, Inputs inputs) {
        return $this.startIngest(mode, ds, sft, converter, inputs);
    }

    default public package.Awaitable startIngest(Enumeration.Value mode, DS ds, SimpleFeatureType sft, Config converter, Inputs inputs) {
        Enumeration.Value value = mode;
        Enumeration.Value value2 = DistributedRunParam$RunModes$.MODULE$.Local();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            package$Command$.MODULE$.user().info("Running ingestion in local mode");
            return new LocalConverterIngest((DataStore)ds, (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.connection()).asJava(), sft, converter, inputs, Predef$.MODULE$.Integer2int(this.params().threads()));
        }
        Enumeration.Value value4 = DistributedRunParam$RunModes$.MODULE$.Distributed();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            package$Command$.MODULE$.user().info(new StringBuilder(37).append("Running ingestion in distributed ").append((Object)(this.params().combineInputs() ? "combine " : "")).append("mode").toString());
            return new ConverterIngestJob(this, sft, converter, inputs){
                private final /* synthetic */ IngestCommand $outer;

                public void configureJob(Job job) {
                    super.configureJob(job);
                    if (this.$outer.params().combineInputs()) {
                        job.setInputFormatClass(ConverterCombineInputFormat.class);
                        Option$.MODULE$.apply((Object)this.$outer.params().maxSplitSize()).foreach((Function1 & Serializable)s -> {
                            $anon$1.$anonfun$configureJob$1(job, s);
                            return BoxedUnit.UNIT;
                        });
                        return;
                    }
                }

                public static final /* synthetic */ void $anonfun$configureJob$1(Job job$1, Integer s) {
                    FileInputFormat.setMaxInputSplitSize((Job)job$1, (long)Predef$.MODULE$.Integer2int(s));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    super($outer.connection(), sft$2, converter$1, inputs$2.paths(), $outer.libjarsFiles(), $outer.libjarsPaths());
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$configureJob$1$adapted(org.apache.hadoop.mapreduce.Job java.lang.Integer )}, serializedLambda);
                }
            };
        }
        throw new NotImplementedError(new StringBuilder(32).append("Missing implementation for mode ").append(mode).toString());
    }

    public static /* synthetic */ boolean $anonfun$execute$2(String prefix$1, String x$1) {
        return x$1.toLowerCase().startsWith(prefix$1);
    }

    public static /* synthetic */ boolean $anonfun$execute$3(Enumeration.Value x$2) {
        Enumeration.Value value = x$2;
        Enumeration.Value value2 = DistributedRunParam$RunModes$.MODULE$.Local();
        return value == null ? value2 != null : !value.equals(value2);
    }

    public static /* synthetic */ boolean $anonfun$execute$5(Enumeration.Value x$3) {
        Enumeration.Value value = x$3;
        Enumeration.Value value2 = DistributedRunParam$RunModes$.MODULE$.Local();
        return value == null ? value2 != null : !value.equals(value2);
    }

    public static /* synthetic */ void $anonfun$execute$6(IngestCommand $this, Enumeration.Value mode$1, Inputs inputs$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            SimpleFeatureType sft = (SimpleFeatureType)tuple2._1();
            Config converter = (Config)tuple2._2();
            long start = System.currentTimeMillis();
            DataStore ds = DataStoreFinder.getDataStore((Map)((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter($this.connection()).asJava()));
            if (ds == null) {
                throw new ParameterException("Could not create data store from parameters");
            }
            try {
                BoxedUnit boxedUnit;
                SimpleFeatureType existing = (SimpleFeatureType)Try$.MODULE$.apply((Function0 & Serializable)() -> ds.getSchema(sft.getTypeName())).getOrElse((Function0 & Serializable)() -> null);
                if (existing == null) {
                    package$Command$.MODULE$.user().info(new StringBuilder(18).append("Creating schema '").append(sft.getTypeName()).append("'").toString());
                    $this.setBackendSpecificOptions(sft);
                    ds.createSchema((FeatureType)sft);
                } else {
                    package$Command$.MODULE$.user().info(new StringBuilder(16).append("Schema '").append(sft.getTypeName()).append("' exists").toString());
                    if (DataUtilities.compare((SimpleFeatureType)sft, (SimpleFeatureType)existing) != 0) {
                        throw new ParameterException(new StringBuilder(87).append("Existing simple feature type does not match expected type").append("\n  existing: '").append(SimpleFeatureTypes$.MODULE$.encodeType(existing)).append("'").append("\n  expected: '").append(SimpleFeatureTypes$.MODULE$.encodeType(sft)).append("'").toString());
                    }
                }
                package.Awaitable result = $this.startIngest(mode$1, ds, sft, converter, inputs$1);
                if ($this.params().waitForCompletion()) {
                    package.JobResult jobResult = result.await(TerminalCallback$.MODULE$.apply(TerminalCallback$.MODULE$.apply$default$1()));
                    if (!(jobResult instanceof package.JobResult$.JobSuccess)) {
                        if (jobResult instanceof package.JobResult$.JobFailure) {
                            package.JobResult$.JobFailure jobFailure = (package.JobResult$.JobFailure)jobResult;
                            String message = jobFailure.message();
                            package$Command$.MODULE$.user().error(new StringBuilder(20).append("Ingestion failed in ").append(TextTools$.MODULE$.getTime(start)).toString());
                            throw new package.Command.CommandException(message);
                        }
                        throw new MatchError((Object)jobResult);
                    }
                    package.JobResult$.JobSuccess jobSuccess = (package.JobResult$.JobSuccess)jobResult;
                    String message = jobSuccess.message();
                    scala.collection.immutable.Map counts = jobSuccess.counts();
                    package$Command$.MODULE$.user().info(new StringBuilder(22).append("Ingestion complete in ").append(TextTools$.MODULE$.getTime(start)).toString());
                    long count2 = BoxesRunTime.unboxToLong((Object)counts.getOrElse((Object)IngestCommand$IngestCounters$.MODULE$.Persisted(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> BoxesRunTime.unboxToLong((Object)counts.getOrElse((Object)IngestCommand$IngestCounters$.MODULE$.Ingested(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))));
                    long failed = BoxesRunTime.unboxToLong((Object)counts.getOrElse((Object)IngestCommand$IngestCounters$.MODULE$.Failed(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                    long x$1 = count2;
                    long x$2 = failed;
                    String x$3 = message;
                    String x$4 = IngestCommand$.MODULE$.getStatInfo$default$3();
                    package$Command$.MODULE$.user().info(IngestCommand$.MODULE$.getStatInfo(x$1, x$2, x$4, x$3));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    package$Command$.MODULE$.user().info("Job submitted, check tracking for progress and result");
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                package.CloseWithLogging$.MODULE$.apply((Object)ds, (IsCloseable)IsCloseable$.MODULE$.dataStoreIsCloseable());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static void $init$(IngestCommand $this) {
        $this.org$locationtech$geomesa$tools$ingest$IngestCommand$_setter_$name_$eq("ingest");
    }

    public static interface IngestParams
    extends OptionalTypeNameParam,
    OptionalFeatureSpecParam,
    OptionalForceParam,
    ConverterConfigParam,
    OptionalInputFormatParam,
    DistributedRunParam,
    DistributedCombineParam {
        public Integer threads();

        public void threads_$eq(Integer var1);

        public boolean srcList();

        public void srcList_$eq(boolean var1);

        public boolean noWaitForCompletion();

        public void noWaitForCompletion_$eq(boolean var1);

        public static /* synthetic */ boolean waitForCompletion$(IngestParams $this) {
            return $this.waitForCompletion();
        }

        default public boolean waitForCompletion() {
            return !this.noWaitForCompletion();
        }

        public static void $init$(IngestParams $this) {
            $this.threads_$eq(Predef$.MODULE$.int2Integer(1));
            $this.srcList_$eq(false);
            $this.noWaitForCompletion_$eq(false);
        }
    }

    public static class Inputs
    implements Product,
    Serializable {
        private List<FileSystemDelegate.FileHandle> handles;
        private final Seq<String> paths;
        private final boolean stdin;
        private volatile boolean bitmap$0;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Seq<String> paths() {
            return this.paths;
        }

        public boolean stdin() {
            return this.stdin;
        }

        private List<FileSystemDelegate.FileHandle> handles$lzycompute() {
            Inputs inputs = this;
            synchronized (inputs) {
                if (!this.bitmap$0) {
                    Object object;
                    Seq<String> seq = this.paths();
                    if (Nil$.MODULE$.equals(seq)) {
                        object = LocalDelegate.StdInHandle$.MODULE$.available().toList();
                    } else {
                        Seq<String> seq2 = IngestCommand$Inputs$.MODULE$.StdInInputs();
                        Seq<String> seq3 = seq;
                        object = !(seq2 != null ? !seq2.equals(seq3) : seq3 != null) ? new .colon.colon((Object)new LocalDelegate.StdInHandle(), (List)Nil$.MODULE$) : ((IterableOnceOps)this.paths().flatMap((Function1 & Serializable)path -> PathUtils$.MODULE$.interpretPath(path))).toList();
                    }
                    this.handles = object;
                    this.bitmap$0 = true;
                }
            }
            return this.handles;
        }

        public List<FileSystemDelegate.FileHandle> handles() {
            if (!this.bitmap$0) {
                return this.handles$lzycompute();
            }
            return this.handles;
        }

        public Inputs asSourceList() {
            List paths = this.handles().flatMap((Function1 & Serializable)file -> (List)package.WithClose$.MODULE$.apply((Object)file.open(), (Function1 & Serializable)iter -> iter.flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    InputStream is = (InputStream)tuple2._2();
                    return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)IOUtils.lineIterator((InputStream)is, (Charset)StandardCharsets.UTF_8)).asScala();
                }
                throw new MatchError((Object)tuple2);
            }).toList(), IsCloseable$.MODULE$.closeableIsCloseable()));
            return new Inputs((Seq<String>)paths);
        }

        public Inputs copy(Seq<String> paths) {
            return new Inputs(paths);
        }

        public Seq<String> copy$default$1() {
            return this.paths();
        }

        public String productPrefix() {
            return "Inputs";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.paths();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Inputs;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "paths";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Inputs)) return false;
            boolean bl = true;
            if (!bl) return false;
            Inputs inputs = (Inputs)x$1;
            Seq<String> seq = this.paths();
            Seq<String> seq2 = inputs.paths();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!inputs.canEqual(this)) return false;
            return true;
        }

        /*
         * Unable to fully structure code
         */
        public Inputs(Seq<String> paths) {
            this.paths = paths;
            super();
            Product.$init$((Product)this);
            if (paths.isEmpty()) ** GOTO lbl-1000
            v0 = paths;
            var2_2 = IngestCommand$Inputs$.MODULE$.StdInInputs();
            if (!(v0 != null ? v0.equals(var2_2) == false : var2_2 != null)) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            this.stdin = v1;
        }
    }
}

