/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export.formats;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.util.URLs;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001B\b\u0011\u0001uA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\u0006c\u0001!\tA\r\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0011\u0019i\u0004\u0001)A\u0005o!Ia\b\u0001a\u0001\u0002\u0004%Ia\u0010\u0005\n\u0015\u0002\u0001\r\u00111A\u0005\n-C\u0011\"\u0015\u0001A\u0002\u0003\u0005\u000b\u0015\u0002!\t\u0013I\u0003\u0001\u0019!a\u0001\n\u0013\u0019\u0006\"\u00032\u0001\u0001\u0004\u0005\r\u0011\"\u0003d\u0011%)\u0007\u00011A\u0001B\u0003&A\u000bC\u0003g\u0001\u0011\u0005s\rC\u0003\u0014\u0001\u0011\u0005C\u000fC\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a\t\t2\u000b[1qK\u001aLG.Z#ya>\u0014H/\u001a:\u000b\u0005E\u0011\u0012a\u00024pe6\fGo\u001d\u0006\u0003'Q\ta!\u001a=q_J$(BA\u000b\u0017\u0003\u0015!xn\u001c7t\u0015\t9\u0002$A\u0004hK>lWm]1\u000b\u0005eQ\u0012\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u000e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qB\u0005\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VM\u001a\t\u0003K\u0019j\u0011\u0001E\u0005\u0003OA\u0011qBR3biV\u0014X-\u0012=q_J$XM]\u0001\u0005M&dW\r\u0005\u0002+_5\t1F\u0003\u0002-[\u0005\u0011\u0011n\u001c\u0006\u0002]\u0005!!.\u0019<b\u0013\t\u00014F\u0001\u0003GS2,\u0017A\u0002\u001fj]&$h\b\u0006\u00024iA\u0011Q\u0005\u0001\u0005\u0006Q\t\u0001\r!K\u0001\u0004kJdW#A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0005ij\u0013a\u00018fi&\u0011A(\u000f\u0002\u0004+Jc\u0015\u0001B;sY\u0002\n!\u0001Z:\u0016\u0003\u0001\u0003\"!\u0011%\u000e\u0003\tS!a\u0011#\u0002\u0013MD\u0017\r]3gS2,'BA#G\u0003\u0011!\u0017\r^1\u000b\u0005\u001dS\u0012\u0001C4f_R|w\u000e\\:\n\u0005%\u0013%AE*iCB,g-\u001b7f\t\u0006$\u0018m\u0015;pe\u0016\fa\u0001Z:`I\u0015\fHC\u0001'P!\tyR*\u0003\u0002OA\t!QK\\5u\u0011\u001d\u0001f!!AA\u0002\u0001\u000b1\u0001\u001f\u00132\u0003\r!7\u000fI\u0001\t[\u0006\u0004\b/\u001b8hgV\tA\u000b\u0005\u0003V9~{fB\u0001,[!\t9\u0006%D\u0001Y\u0015\tIF$\u0001\u0004=e>|GOP\u0005\u00037\u0002\na\u0001\u0015:fI\u00164\u0017BA/_\u0005\ri\u0015\r\u001d\u0006\u00037\u0002\u0002\"a\b1\n\u0005\u0005\u0004#aA%oi\u0006aQ.\u00199qS:<7o\u0018\u0013fcR\u0011A\n\u001a\u0005\b!&\t\t\u00111\u0001U\u0003%i\u0017\r\u001d9j]\u001e\u001c\b%A\u0003ti\u0006\u0014H\u000f\u0006\u0002MQ\")\u0011n\u0003a\u0001U\u0006\u00191O\u001a;\u0011\u0005-\u0014X\"\u00017\u000b\u00055t\u0017AB:j[BdWM\u0003\u0002pa\u00069a-Z1ukJ,'BA9\u001b\u0003\u001dy\u0007/\u001a8hSNL!a\u001d7\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X\r\u0006\u0002vwB\u0019qD\u001e=\n\u0005]\u0004#AB(qi&|g\u000e\u0005\u0002 s&\u0011!\u0010\t\u0002\u0005\u0019>tw\rC\u0003}\u0019\u0001\u0007Q0\u0001\u0005gK\u0006$XO]3t!\u0015q\u0018qAA\u0007\u001d\ry\u00181\u0001\b\u0004/\u0006\u0005\u0011\"A\u0011\n\u0007\u0005\u0015\u0001%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00111\u0002\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011Q\u0001\u0011\u0011\u0007-\fy!C\u0002\u0002\u00121\u0014QbU5na2,g)Z1ukJ,\u0017!\u00022zi\u0016\u001cX#\u0001=\u0002\u000b\rdwn]3\u0015\u00031\u0003")
public class ShapefileExporter
implements FeatureExporter {
    private final File file;
    private final URL url;
    private ShapefileDataStore ds;
    private Map<Object, Object> mappings;

    private URL url() {
        return this.url;
    }

    private ShapefileDataStore ds() {
        return this.ds;
    }

    private void ds_$eq(ShapefileDataStore x$1) {
        this.ds = x$1;
    }

    private Map<Object, Object> mappings() {
        return this.mappings;
    }

    private void mappings_$eq(Map<Object, Object> x$1) {
        this.mappings = x$1;
    }

    @Override
    public void start(SimpleFeatureType sft) {
        Option$.MODULE$.apply((Object)this.file.getParentFile()).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.exists())).foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.mkdirs()));
        this.ds_$eq((ShapefileDataStore)new ShapefileDataStoreFactory().createDataStore(this.url()));
        this.ds().createSchema(sft);
        IntRef i = IntRef.create((int)-1);
        IntRef j = IntRef.create((int)0);
        Buffer attributes = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(sft.getAttributeDescriptors()).asScala()).flatMap((Function1 & Serializable)d -> {
            block3: {
                block2: {
                    ++i$1.elem;
                    Class binding = d.getType().getBinding();
                    if (Geometry.class.isAssignableFrom(binding)) break block2;
                    Class clazz = binding;
                    Class<byte[]> clazz2 = byte[].class;
                    if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block3;
                }
                return None$.MODULE$;
            }
            ++j$1.elem;
            return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i$1.elem)), (Object)BoxesRunTime.boxToInteger((int)j$1.elem)));
        });
        this.mappings_$eq((Map<Object, Object>)((Map)attributes.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)sft.indexOf(sft.getGeometryDescriptor().getLocalName()))), (Object)BoxesRunTime.boxToInteger((int)0)))));
    }

    @Override
    public Option<Object> export(Iterator<SimpleFeature> features) {
        LongRef count2 = LongRef.create((long)0L);
        package.WithClose$.MODULE$.apply((Object)this.ds().getFeatureWriterAppend(Transaction.AUTO_COMMIT), (Function1 & Serializable)writer -> {
            features.foreach((Function1 & Serializable)feature -> {
                ShapefileExporter.$anonfun$export$2($this, writer, count$1, feature);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
        return new Some((Object)BoxesRunTime.boxToLong((long)count2.elem));
    }

    @Override
    public long bytes() {
        long l;
        ShpFiles files = new ShpFiles(this.url());
        try {
            LongRef sum = LongRef.create((long)0L);
            ((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(files.getFileNames()).asScala()).values().foreach((Function1 & Serializable)file -> {
                ShapefileExporter.$anonfun$bytes$1(sum, file);
                return BoxedUnit.UNIT;
            });
            l = sum.elem;
        }
        finally {
            files.dispose();
        }
        return l;
    }

    @Override
    public void close() {
        Option$.MODULE$.apply((Object)this.ds()).foreach((Function1 & Serializable)x$5 -> {
            x$5.dispose();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$export$3(SimpleFeature toWrite$1, SimpleFeature feature$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            int from = tuple2._1$mcI$sp();
            int to = tuple2._2$mcI$sp();
            toWrite$1.setAttribute(to, feature$1.getAttribute(from));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$export$2(ShapefileExporter $this, FeatureWriter writer$1, LongRef count$1, SimpleFeature feature) {
        SimpleFeature toWrite = (SimpleFeature)writer$1.next();
        $this.mappings().foreach((Function1 & Serializable)x0$1 -> {
            ShapefileExporter.$anonfun$export$3(toWrite, feature, x0$1);
            return BoxedUnit.UNIT;
        });
        toWrite.getUserData().putAll(feature.getUserData());
        writer$1.write();
        ++count$1.elem;
    }

    public static final /* synthetic */ void $anonfun$bytes$1(LongRef sum$1, String file) {
        sum$1.elem += URLs.urlToFile((URL)new URL(file)).length();
    }

    public ShapefileExporter(File file) {
        this.file = file;
        this.url = URLs.fileToUrl((File)file);
    }
}

