/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.ingest;

import com.beust.jcommander.ParameterException;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.locationtech.geomesa.convert.ConverterConfigLoader$;
import org.locationtech.geomesa.convert.all.TypeAwareInference$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter$;
import org.locationtech.geomesa.tools.ConverterConfigParam;
import org.locationtech.geomesa.tools.FeatureSpecParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalInputFormatParam;
import org.locationtech.geomesa.tools.TypeNameParam;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.tools.utils.CLArgResolver$;
import org.locationtech.geomesa.tools.utils.Prompt$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits;
import org.locationtech.geomesa.utils.conversions.ScalaImplicits$;
import org.locationtech.geomesa.utils.geotools.ConfigSftParsing$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class IngestCommand$
implements LazyLogging {
    public static final IngestCommand$ MODULE$ = new IngestCommand$();
    private static final GeoMesaSystemProperties.SystemProperty LocalBatchSize;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        LocalBatchSize = new GeoMesaSystemProperties.SystemProperty("geomesa.ingest.local.batch.size", "20000");
    }

    private Logger logger$lzycompute() {
        IngestCommand$ ingestCommand$ = this;
        synchronized (ingestCommand$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public GeoMesaSystemProperties.SystemProperty LocalBatchSize() {
        return LocalBatchSize;
    }

    public Option<String> getDataFormat(OptionalInputFormatParam params, Seq<String> files) {
        Iterator exts;
        Some raw = params.inputFormat() != null ? new Some((Object)params.inputFormat()) : ((exts = files.iterator().flatMap((Function1 & Serializable)path -> PathUtils$.MODULE$.interpretPath(path)).map((Function1 & Serializable)x$4 -> x$4.format()).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$5))))).hasNext() ? new Some(exts.next()) : None$.MODULE$);
        return raw.map((Function1 & Serializable)x0$1 -> {
            String string = x0$1;
            switch (string == null ? 0 : string.hashCode()) {
                default: 
            }
            if (string.equalsIgnoreCase("gml")) {
                return "xml";
            }
            if (string.equalsIgnoreCase("geojson")) {
                return "json";
            }
            return string.toLowerCase(Locale.US);
        });
    }

    public Try<Option<Tuple2<SimpleFeatureType, Config>>> getSftAndConverter(TypeNameParam params, Seq<String> inputs, Option<String> format, Option<package.DataStoreCommand<? extends DataStore>> command) {
        Try try_;
        Object object = new Object();
        try {
            try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                ObjectRef sft = ObjectRef.create((Object)((SimpleFeatureType)MODULE$.loadSft(params, command).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
                Config converter = (Config)Option$.MODULE$.apply((Object)((ConverterConfigParam)((Object)params)).config()).map((Function1 & Serializable)configArg -> CLArgResolver$.MODULE$.getConfig((String)configArg)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                if (converter == null && inputs.nonEmpty()) {
                    Tuple2 tuple2;
                    package$Command$.MODULE$.user().info("No converter defined - will attempt to detect schema from input files");
                    FileSystemDelegate.FileHandle file = (FileSystemDelegate.FileHandle)ScalaImplicits.RichIterator$.MODULE$.headOption$extension(ScalaImplicits$.MODULE$.RichIterator(inputs.iterator().flatMap((Function1 & Serializable)path -> PathUtils$.MODULE$.interpretPath(path)))).getOrElse((Function0 & Serializable)() -> {
                        throw new ParameterException("Parameter <files> did not evaluate to anything that could be read");
                    });
                    ListBuffer opened = ListBuffer$.MODULE$.empty();
                    try {
                        Option option;
                        Option option2 = format;
                        if (None$.MODULE$.equals(option2)) {
                            option = SimpleFeatureConverter$.MODULE$.infer((Function0 & Serializable)() -> IngestCommand$.open$1(file, opened), Option$.MODULE$.apply((Object)((SimpleFeatureType)sft.elem)), Option$.MODULE$.apply((Object)file.path()));
                        } else if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            String fmt = (String)some.value();
                            option = TypeAwareInference$.MODULE$.infer(fmt, (Function0 & Serializable)() -> IngestCommand$.open$1(file, opened), Option$.MODULE$.apply((Object)((SimpleFeatureType)sft.elem)), Option$.MODULE$.apply((Object)file.path()));
                        } else {
                            throw new MatchError((Object)option2);
                        }
                        Option opt = option;
                        tuple2 = (Tuple2)opt.getOrElse((Function0 & Serializable)() -> {
                            throw new ParameterException("Could not determine converter from inputs - please specify a converter");
                        });
                    }
                    finally {
                        package.CloseWithLogging$.MODULE$.apply((Object)opened, (IsCloseable)IsCloseable$.MODULE$.iterableIsCloseable());
                    }
                    Tuple2 tuple22 = tuple2;
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    SimpleFeatureType inferredSft = (SimpleFeatureType)tuple22._1();
                    Config inferredConverter = (Config)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)inferredSft, (Object)inferredConverter);
                    SimpleFeatureType inferredSft2 = (SimpleFeatureType)tuple23._1();
                    Config inferredConverter2 = (Config)tuple23._2();
                    ConfigRenderOptions renderOptions = ConfigRenderOptions.concise().setFormatted(true);
                    ObjectRef inferredSftString = ObjectRef.create((Object)None$.MODULE$);
                    if ((SimpleFeatureType)sft.elem == null) {
                        String typeName = (String)Option$.MODULE$.apply((Object)params.featureName()).getOrElse((Function0 & Serializable)() -> {
                            String base;
                            Set existing = (Set)Option$.MODULE$.option2Iterable(command).toSet().flatMap((Function1 & Serializable)x$8 -> Predef$.MODULE$.wrapRefArray((Object[])x$8.withDataStore((Function1 & Serializable)x$9 -> x$9.getTypeNames())));
                            Option fileName = Option$.MODULE$.apply((Object)FilenameUtils.getBaseName((String)file.path()));
                            String name = base = (String)fileName.map((Function1 & Serializable)x$10 -> x$10.trim().replaceAll("[^A-Za-z0-9]+", "_")).filterNot((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.isEmpty())).getOrElse((Function0 & Serializable)() -> "geomesa");
                            int i = 0;
                            while (existing.contains((Object)name)) {
                                name = new StringBuilder(1).append(base).append("_").append(i).toString();
                                ++i;
                            }
                            return name;
                        });
                        sft.elem = SimpleFeatureTypes$.MODULE$.renameSft(inferredSft2, typeName);
                        SimpleFeatureType x$1 = (SimpleFeatureType)sft.elem;
                        boolean x$2 = false;
                        boolean x$3 = SimpleFeatureTypes$.MODULE$.toConfig$default$2();
                        inferredSftString.elem = new Some((Object)SimpleFeatureTypes$.MODULE$.toConfig(x$1, x$3, false).root().render(renderOptions));
                        if (!((OptionalForceParam)((Object)params)).force()) {
                            package$Command$.MODULE$.user().info(new StringBuilder(29).append("Inferred schema: ").append(typeName).append(" identified ").append(SimpleFeatureTypes$.MODULE$.encodeType((SimpleFeatureType)sft.elem)).toString());
                        }
                    }
                    converter = inferredConverter2;
                    if (!((OptionalForceParam)((Object)params)).force()) {
                        String converterString = inferredConverter2.root().render(renderOptions);
                        package$Command$.MODULE$.user().info(new StringBuilder(20).append("Inferred converter:\n").append(converterString).toString());
                        String x$4 = "Use inferred converter (y/n)? ";
                        List<String> x$5 = Prompt$.MODULE$.confirm$default$2();
                        Object x$6 = Prompt$.MODULE$.confirm$default$3("Use inferred converter (y/n)? ", x$5);
                        if (Prompt$.MODULE$.confirm("Use inferred converter (y/n)? ", x$5, x$6)) {
                            IngestCommand$.persist$1(sft, converterString, inferredSftString);
                        } else {
                            package$Command$.MODULE$.user().info("Please re-run with a valid converter");
                            IngestCommand$.persist$1(sft, converterString, inferredSftString);
                            throw new NonLocalReturnControl(object, (Object)new Success((Object)None$.MODULE$));
                        }
                    }
                }
                if ((SimpleFeatureType)sft.elem == null) {
                    throw new ParameterException("SimpleFeatureType name and/or specification argument is required");
                }
                if (converter == null) {
                    throw new ParameterException("Converter config argument is required");
                }
                if (((ConverterConfigParam)((Object)params)).errorMode() != null) {
                    ConfigObject opts = ConfigValueFactory.fromMap(Collections.singletonMap("error-mode", ((ConverterConfigParam)((Object)params)).errorMode().toString()));
                    converter = ConfigFactory.empty().withValue("options", (ConfigValue)opts).withFallback((ConfigMergeable)converter);
                }
                return new Some((Object)new Tuple2((Object)((SimpleFeatureType)sft.elem), (Object)converter));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                try_ = (Try)ex.value();
            }
            throw ex;
        }
        return try_;
    }

    public String getStatInfo(long successes, long failures, String action, String input) {
        String failureString = failures == 0L ? "with no failures" : new StringBuilder(21).append("and failed to ingest ").append(TextTools$.MODULE$.getPlural(failures, "feature")).toString();
        return new StringBuilder(2).append(action).append(" ").append(TextTools$.MODULE$.getPlural(successes, "feature")).append(" ").append(failureString).append(TextTools$.MODULE$.prefixSpace(input)).toString();
    }

    public String getStatInfo$default$3() {
        return "Ingested";
    }

    public String getStatInfo$default$4() {
        return "";
    }

    private Option<SimpleFeatureType> loadSft(TypeNameParam params, Option<package.DataStoreCommand<? extends DataStore>> command) {
        Option fromStore;
        LazyRef fromEnv$lzy;
        block0: {
            fromEnv$lzy = new LazyRef();
            fromStore = command.flatMap((Function1 & Serializable)cmd -> Option$.MODULE$.apply((Object)params.featureName()).flatMap((Function1 & Serializable)name -> ((Option)cmd.withDataStore((Function1 & Serializable)ds -> Try$.MODULE$.apply((Function0 & Serializable)() -> ds.getSchema(name)).filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)IngestCommand$.$anonfun$loadSft$5(x$12))).toOption())).map((Function1 & Serializable)sft -> sft)));
            if (!this.logger().underlying().isWarnEnabled()) break block0;
            fromStore.foreach((Function1 & Serializable)fs -> {
                IngestCommand$.$anonfun$loadSft$11(fromEnv$lzy, params, fs);
                return BoxedUnit.UNIT;
            });
        }
        return fromStore.orElse((Function0 & Serializable)() -> IngestCommand$.fromEnv$1(fromEnv$lzy, params));
    }

    private void writeInferredConverter(String typeName, String converterString, Option<String> schemaString) {
        block9: {
            try {
                Option conf;
                Option option = conf = ((IterableOnceOps)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(this.getClass().getClassLoader().getResources("reference.conf")).asScala()).find((Function1 & Serializable)u -> BoxesRunTime.boxToBoolean((boolean)IngestCommand$.$anonfun$writeInferredConverter$1(u)));
                if (None$.MODULE$.equals(option)) {
                    package$Command$.MODULE$.user().error("Could not persist converter: could not find 'conf/reference.conf'");
                    break block9;
                }
                if (option instanceof Some) {
                    Tuple2 tuple2;
                    Some some = (Some)option;
                    URL r = (URL)some.value();
                    File reference = new File(r.toURI());
                    File folder = reference.getParentFile();
                    String baseName = typeName.replaceAll("[^A-Za-z0-9_]+", "_");
                    ObjectRef convert = ObjectRef.create((Object)new File(folder, new StringBuilder(5).append(baseName).append(".conf").toString()));
                    int i = 1;
                    while (((File)convert.elem).exists()) {
                        convert.elem = new File(folder, new StringBuilder(6).append(baseName).append("_").append(i).append(".conf").toString());
                        ++i;
                    }
                    package.WithClose$.MODULE$.apply((Object)new PrintWriter(new FileWriter((File)convert.elem)), (Function1 & Serializable)writer -> {
                        IngestCommand$.$anonfun$writeInferredConverter$2(baseName, converterString, schemaString, writer);
                        return BoxedUnit.UNIT;
                    }, IsCloseable$.MODULE$.closeableIsCloseable());
                    package.WithClose$.MODULE$.apply((Object)new PrintWriter(new FileWriter(reference, true)), (Function1 & Serializable)writer -> {
                        writer.println(new StringBuilder(10).append("include \"").append(((File)convert.elem).getName()).append("\"").toString());
                        return BoxedUnit.UNIT;
                    }, IsCloseable$.MODULE$.closeableIsCloseable());
                    Tuple2 tuple22 = tuple2 = schemaString.isDefined() ? new Tuple2((Object)"schema and converter", (Object)new StringBuilder(28).append("'--spec ").append(baseName).append("' and '--converter ").append(baseName).append("'").toString()) : new Tuple2((Object)"converter", (Object)new StringBuilder(14).append("'--converter ").append(baseName).append("'").toString());
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String names = (String)tuple2._1();
                    String refs = (String)tuple2._2();
                    Tuple2 tuple23 = new Tuple2((Object)names, (Object)refs);
                    String names2 = (String)tuple23._1();
                    String refs2 = (String)tuple23._2();
                    package$Command$.MODULE$.user().info(new StringBuilder(54).append("Added import in reference.conf and saved inferred ").append(names2).append(" to ").append(((File)convert.elem).getAbsolutePath()).toString());
                    package$Command$.MODULE$.user().info(new StringBuilder(45).append("In future commands, the ").append(names2).append(" may be invoked with ").append(refs2).toString());
                    break block9;
                }
                throw new MatchError((Object)option);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Error trying to persist inferred schema", e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    package$Command$.MODULE$.user().error(new StringBuilder(41).append("Error trying to persist inferred schema: ").append(e).toString());
                }
                throw throwable;
            }
        }
    }

    private static final InputStream open$1(FileSystemDelegate.FileHandle file$1, ListBuffer opened$1) {
        CloseableIterator streams = file$1.open().map((Function1 & Serializable)x$6 -> (InputStream)x$6._2());
        opened$1.$plus$eq((Object)streams);
        if (streams.hasNext()) {
            return (InputStream)streams.next();
        }
        throw new ParameterException("Parameter <files> did not evaluate to anything that could be read");
    }

    private static final void persist$1(ObjectRef sft$3, String converterString$1, ObjectRef inferredSftString$1) {
        Object x$3;
        String x$1 = "Persist this converter for future use (y/n)? ";
        List<String> x$2 = Prompt$.MODULE$.confirm$default$2();
        if (Prompt$.MODULE$.confirm("Persist this converter for future use (y/n)? ", x$2, x$3 = Prompt$.MODULE$.confirm$default$3("Persist this converter for future use (y/n)? ", x$2))) {
            MODULE$.writeInferredConverter(((SimpleFeatureType)sft$3.elem).getTypeName(), converterString$1, (Option<String>)((Option)inferredSftString$1.elem));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$loadSft$5(SimpleFeatureType x$12) {
        return x$12 != null;
    }

    private static final /* synthetic */ Option fromEnv$lzycompute$1(LazyRef fromEnv$lzy$1, TypeNameParam params$2) {
        Option option;
        LazyRef lazyRef = fromEnv$lzy$1;
        synchronized (lazyRef) {
            option = fromEnv$lzy$1.initialized() ? (Option)fromEnv$lzy$1.value() : (Option)fromEnv$lzy$1.initialize((Object)Option$.MODULE$.apply((Object)((FeatureSpecParam)((Object)params$2)).spec()).map((Function1 & Serializable)x$13 -> CLArgResolver$.MODULE$.getSft((String)x$13, params$2.featureName())).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)params$2.featureName()).flatMap((Function1 & Serializable)name -> Try$.MODULE$.apply((Function0 & Serializable)() -> CLArgResolver$.MODULE$.getSft((String)name, CLArgResolver$.MODULE$.getSft$default$2())).toOption())));
        }
        return option;
    }

    private static final Option fromEnv$1(LazyRef fromEnv$lzy$1, TypeNameParam params$2) {
        if (fromEnv$lzy$1.initialized()) {
            return (Option)fromEnv$lzy$1.value();
        }
        return IngestCommand$.fromEnv$lzycompute$1(fromEnv$lzy$1, params$2);
    }

    public static final /* synthetic */ void $anonfun$loadSft$12(SimpleFeatureType fs$1, SimpleFeatureType fe) {
        String string = fs$1.getTypeName();
        String string2 = fe.getTypeName();
        if ((string != null ? !string.equals(string2) : string2 != null) || SimpleFeatureTypes$.MODULE$.compare(fs$1, fe) != 0) {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn(new StringBuilder(128).append("Schema from data store does not match schema from environment.").append("\n  From data store:  ").append(fs$1.getTypeName()).append(" identified ").append(DataUtilities.encodeType((SimpleFeatureType)fs$1)).append("\n  From environment: ").append(fe.getTypeName()).append(" identified ").append(DataUtilities.encodeType((SimpleFeatureType)fe)).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$loadSft$11(LazyRef fromEnv$lzy$1, TypeNameParam params$2, SimpleFeatureType fs) {
        IngestCommand$.fromEnv$1(fromEnv$lzy$1, params$2).foreach((Function1 & Serializable)fe -> {
            IngestCommand$.$anonfun$loadSft$12(fs, fe);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$writeInferredConverter$1(URL u) {
        return "file".equalsIgnoreCase(u.getProtocol()) && u.getPath().endsWith("/conf/reference.conf");
    }

    public static final /* synthetic */ void $anonfun$writeInferredConverter$2(String baseName$1, String converterString$2, Option schemaString$1, PrintWriter writer) {
        writer.println(new StringBuilder(4).append(ConverterConfigLoader$.MODULE$.path()).append(".").append(baseName$1).append(" : ").append(converterString$2).toString());
        schemaString$1.foreach((Function1 & Serializable)s -> {
            writer.println(new StringBuilder(4).append(ConfigSftParsing$.MODULE$.path()).append(".").append(baseName$1).append(" : ").append(s).toString());
            return BoxedUnit.UNIT;
        });
    }

    private IngestCommand$() {
    }
}

