/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.status;

import com.beust.jcommander.ParameterException;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import java.io.Serializable;
import org.locationtech.geomesa.convert.ConverterConfigLoader$;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.tools.status.EnvironmentParameters;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeLoader$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005E4A!\u0004\b\u00013!)A\u0007\u0001C\u0001k!9\u0001\b\u0001b\u0001\n\u0003J\u0004BB\u001f\u0001A\u0003%!\bC\u0004?\u0001\t\u0007I\u0011I \t\r\r\u0003\u0001\u0015!\u0003A\u0011\u0015!\u0005\u0001\"\u0011F\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u001dy\u0006!%A\u0005\u0002\u0001DQa\u001b\u0001\u0005\u00021DqA\u001c\u0001\u0012\u0002\u0013\u0005\u0001\rC\u0003p\u0001\u0011\u0005Q\tC\u0003q\u0001\u0011\u0005QI\u0001\nF]ZL'o\u001c8nK:$8i\\7nC:$'BA\b\u0011\u0003\u0019\u0019H/\u0019;vg*\u0011\u0011CE\u0001\u0006i>|Gn\u001d\u0006\u0003'Q\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u0016-\u0005aAn\\2bi&|g\u000e^3dQ*\tq#A\u0002pe\u001e\u001c\u0001aE\u0002\u00015\t\u0002\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\t1\fgn\u001a\u0006\u0002?\u0005!!.\u0019<b\u0013\t\tCD\u0001\u0004PE*,7\r\u001e\t\u0003GEr!\u0001J\u0018\u000f\u0005\u0015rcB\u0001\u0014.\u001d\t9CF\u0004\u0002)W5\t\u0011F\u0003\u0002+1\u00051AH]8pizJ\u0011aF\u0005\u0003+YI!a\u0005\u000b\n\u0005E\u0011\u0012B\u0001\u0019\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!AM\u001a\u0003\u000f\r{W.\\1oI*\u0011\u0001\u0007E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"a\u000e\u0001\u000e\u00039\tAA\\1nKV\t!\b\u0005\u0002\u001cw%\u0011A\b\b\u0002\u0007'R\u0014\u0018N\\4\u0002\u000b9\fW.\u001a\u0011\u0002\rA\f'/Y7t+\u0005\u0001\u0005CA\u001cB\u0013\t\u0011eBA\u000bF]ZL'o\u001c8nK:$\b+\u0019:b[\u0016$XM]:\u0002\u000fA\f'/Y7tA\u00059Q\r_3dkR,G#\u0001$\u0011\u0005\u001dSU\"\u0001%\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0003\tUs\u0017\u000e^\u0001\tY&\u001cHo\u00154ugR\u0011aI\u0014\u0005\b\u001f\u001e\u0001\n\u00111\u0001Q\u0003\u0015q\u0017-\\3t!\r\tV\u000b\u0017\b\u0003%Rs!\u0001K*\n\u0003%K!\u0001\r%\n\u0005Y;&\u0001\u0002'jgRT!\u0001\r%\u0011\u0005ekfB\u0001.\\!\tA\u0003*\u0003\u0002]\u0011\u00061\u0001K]3eK\u001aL!\u0001\u00100\u000b\u0005qC\u0015A\u00057jgR\u001cf\r^:%I\u00164\u0017-\u001e7uIE*\u0012!\u0019\u0016\u0003!\n\\\u0013a\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005!D\u0015AC1o]>$\u0018\r^5p]&\u0011!.\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u00047jgR\u001cuN\u001c<feR,'o\u001d\u000b\u0003\r6DqaT\u0005\u0011\u0002\u0003\u0007\u0001+\u0001\rmSN$8i\u001c8wKJ$XM]:%I\u00164\u0017-\u001e7uIE\nQ\u0002\\5tiN3Go\u001d(b[\u0016\u001c\u0018A\u00057jgR\u001cuN\u001c<feR,'OT1nKN\u0004")
public class EnvironmentCommand
implements package.Command {
    private final String name;
    private final EnvironmentParameters params;

    @Override
    public Seq<package.Command> subCommands() {
        return package.Command.subCommands$(this);
    }

    @Override
    public Option<ParameterException> validate() {
        return package.Command.validate$(this);
    }

    @Override
    public void run() {
        package.Command.run$(this);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public EnvironmentParameters params() {
        return this.params;
    }

    @Override
    public void execute() {
        if (!(this.params().sfts() != null || this.params().converters() != null || this.params().listSfts() || this.params().listConverters() || this.params().describeSfts() || this.params().describeConverters())) {
            package$Command$.MODULE$.output().info("No flags given; displaying list of SFTs and Converters.");
            package$Command$.MODULE$.output().info(new StringBuilder(44).append("Use 'help ").append(this.name()).append("' to see complete command options.").toString());
            this.listSftsNames();
            this.listConverterNames();
            return;
        }
        if (this.params().listSfts()) {
            this.listSftsNames();
        }
        if (this.params().listConverters()) {
            this.listConverterNames();
        }
        if (this.params().describeSfts()) {
            this.listSfts(this.listSfts$default$1());
        }
        if (this.params().describeConverters()) {
            this.listConverters(this.listConverters$default$1());
        }
        if (this.params().sfts() != null) {
            this.listSfts((List<String>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.params().sfts()).asScala()).toList());
        }
        if (this.params().converters() != null) {
            this.listConverters((List<String>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.params().converters()).asScala()).toList());
            return;
        }
    }

    public void listSfts(List<String> names) {
        block6: {
            Function1 & Serializable intersect;
            List filtered;
            block7: {
                String string;
                String paramsLower;
                block5: {
                    List all = SimpleFeatureTypeLoader$.MODULE$.sfts();
                    filtered = names.isEmpty() ? all : names.flatMap((Function1 & Serializable)n -> all.find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)EnvironmentCommand.$anonfun$listSfts$2(n, x$1))));
                    package$Command$.MODULE$.output().info("Simple Feature Types:");
                    if (filtered.isEmpty()) {
                        package$Command$.MODULE$.output().info("None available");
                        return;
                    }
                    String string2 = paramsLower = this.params().format().toLowerCase();
                    String string3 = "typesafe";
                    if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block5;
                    String string4 = paramsLower;
                    String string5 = "spec";
                    if (string4 != null ? !string4.equals(string5) : string5 != null) break block6;
                }
                switch ((string = paramsLower) == null ? 0 : string.hashCode()) {
                    case -675405369: {
                        if (!"typesafe".equals(string)) break;
                        intersect = (Function1 & Serializable)sft -> String.valueOf(SimpleFeatureTypes$.MODULE$.toConfigString(sft, !this.params().excludeUserData(), this.params().concise(), SimpleFeatureTypes$.MODULE$.toConfigString$default$4(), SimpleFeatureTypes$.MODULE$.toConfigString$default$5()));
                        break block7;
                    }
                    case 3536827: {
                        if (!"spec".equals(string)) break;
                        intersect = (Function1 & Serializable)sft -> String.valueOf(SimpleFeatureTypes$.MODULE$.encodeType(sft, !this.params().excludeUserData()));
                        break block7;
                    }
                }
                throw new MatchError((Object)string);
            }
            Function1 & Serializable formatFn = intersect;
            ((List)filtered.sortBy((Function1 & Serializable)x$2 -> x$2.getTypeName(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)s -> new StringBuilder(3).append(s.getTypeName()).append(" = ").append(formatFn.apply(s)).toString()).foreach((Function1 & Serializable)x$1 -> {
                EnvironmentCommand.$anonfun$listSfts$7(x$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new ParameterException(new StringBuilder(56).append("Unknown format '").append(this.params().format()).append("'. Valid values are 'typesafe' or 'spec'").toString());
    }

    public List<String> listSfts$default$1() {
        return package$.MODULE$.List().empty();
    }

    public void listConverters(List<String> names) {
        Map all = ConverterConfigLoader$.MODULE$.confs();
        Map filtered = names.isEmpty() ? all : names.flatMap((Function1 & Serializable)n -> all.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)EnvironmentCommand.$anonfun$listConverters$2(n, x$3))));
        package$Command$.MODULE$.output().info("Simple Feature Type Converters:");
        if (filtered.isEmpty()) {
            package$Command$.MODULE$.output().info("None available");
            return;
        }
        ConfigRenderOptions options = ConfigRenderOptions.defaults().setJson(false).setOriginComments(false);
        Iterable strings = (Iterable)filtered.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String cname = (String)tuple2._1();
                Config conf = (Config)tuple2._2();
                return new StringBuilder(17).append("converter-name=").append(cname).append("\n").append(EnvironmentCommand.render$1(conf, options)).append("\n").toString();
            }
            throw new MatchError((Object)tuple2);
        });
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])strings.toArray(ClassTag$.MODULE$.apply(String.class))), (Ordering)Ordering.String$.MODULE$)), (Function1 & Serializable)x$1 -> {
            EnvironmentCommand.$anonfun$listConverters$4(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public List<String> listConverters$default$1() {
        return package$.MODULE$.List().empty();
    }

    public void listSftsNames() {
        package$Command$.MODULE$.output().info("Simple Feature Types:");
        List all = SimpleFeatureTypeLoader$.MODULE$.sfts();
        ((List)all.sortBy((Function1 & Serializable)x$4 -> x$4.getTypeName(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)s -> String.valueOf(s.getTypeName())).foreach((Function1 & Serializable)x$1 -> {
            EnvironmentCommand.$anonfun$listSftsNames$3(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void listConverterNames() {
        package$Command$.MODULE$.output().info("Simple Feature Type Converters:");
        Map all = ConverterConfigLoader$.MODULE$.confs();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])((IterableOnceOps)all.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String cname = (String)tuple2._1();
                return String.valueOf(cname);
            }
            throw new MatchError((Object)tuple2);
        })).toArray(ClassTag$.MODULE$.apply(String.class))), (Ordering)Ordering.String$.MODULE$)), (Function1 & Serializable)x$1 -> {
            EnvironmentCommand.$anonfun$listConverterNames$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$listSfts$2(String n$1, SimpleFeatureType x$1) {
        String string = x$1.getTypeName();
        String string2 = n$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$listSfts$7(String x$1) {
        package$Command$.MODULE$.output().info(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$listConverters$2(String n$2, Tuple2 x$3) {
        Object object = x$3._1();
        String string = n$2;
        return !(object != null ? !object.equals(string) : string != null);
    }

    private static final String render$1(Config c, ConfigRenderOptions options$1) {
        return c.root().render(options$1);
    }

    public static final /* synthetic */ void $anonfun$listConverters$4(String x$1) {
        package$Command$.MODULE$.output().info(x$1);
    }

    public static final /* synthetic */ void $anonfun$listSftsNames$3(String x$1) {
        package$Command$.MODULE$.output().info(x$1);
    }

    public static final /* synthetic */ void $anonfun$listConverterNames$2(String x$1) {
        package$Command$.MODULE$.output().info(x$1);
    }

    public EnvironmentCommand() {
        package.Command.$init$(this);
        this.name = "env";
        this.params = new EnvironmentParameters();
    }
}

