/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.utils;

import java.io.Serializable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.locationtech.geomesa.jobs.package;
import org.locationtech.geomesa.tools.package$Command$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class JobRunner$ {
    public static final JobRunner$ MODULE$ = new JobRunner$();

    public package.JobResult run(Job job, package.StatusCallback reporter, Function0<Seq<Tuple2<String, Object>>> mapCounters, Function0<Seq<Tuple2<String, Object>>> reduceCounters) {
        this.submit(job);
        return this.monitor(job, reporter, mapCounters, reduceCounters);
    }

    public void submit(Job job) {
        package$Command$.MODULE$.user().info(new StringBuilder(34).append("Submitting job '").append(job.getJobName()).append("' - please wait...").toString());
        job.submit();
        package$Command$.MODULE$.user().info(new StringBuilder(22).append("Tracking available at ").append(job.getStatus().getTrackingUrl()).toString());
    }

    public package.JobResult monitor(Job job, package.StatusCallback reporter, Function0<Seq<Tuple2<String, Object>>> mapCounters, Function0<Seq<Tuple2<String, Object>>> reduceCounters) {
        Function1 & Serializable status;
        Function1 & Serializable intersect;
        if (job.getNumReduceTasks() != 0) {
            BooleanRef mapping = BooleanRef.create((boolean)true);
            intersect = (Function1 & Serializable)done -> {
                JobRunner$.$anonfun$monitor$1(mapping, job, reporter, mapCounters, reduceCounters, BoxesRunTime.unboxToBoolean((Object)done));
                return BoxedUnit.UNIT;
            };
        } else {
            intersect = status = (Function1 & Serializable)done -> {
                reporter.apply("", job.mapProgress(), (Seq)((IterableOps)mapCounters.apply()).$plus$plus((IterableOnce)reduceCounters.apply()), BoxesRunTime.unboxToBoolean((Object)done));
                return BoxedUnit.UNIT;
            };
        }
        while (!job.isComplete()) {
            JobStatus.State state = job.getStatus().getState();
            JobStatus.State state2 = JobStatus.State.PREP;
            Object object = (state == null ? state2 != null : !state.equals(state2)) ? status.apply((Object)BoxesRunTime.boxToBoolean((boolean)false)) : BoxedUnit.UNIT;
            Thread.sleep(500L);
        }
        status.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
        if (job.isSuccessful()) {
            return new package.JobResult$.JobSuccess("", ((IterableOnceOps)((IterableOps)mapCounters.apply()).$plus$plus((IterableOnce)reduceCounters.apply())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
        return new package.JobResult$.JobFailure(new StringBuilder(31).append("Job failed with state ").append(job.getStatus().getState()).append(" due to: ").append(job.getStatus().getFailureInfo()).toString());
    }

    public static final /* synthetic */ void $anonfun$monitor$1(BooleanRef mapping$1, Job job$1, package.StatusCallback reporter$1, Function0 mapCounters$1, Function0 reduceCounters$1, boolean done) {
        if (mapping$1.elem) {
            float mapProgress = job$1.mapProgress();
            if (mapProgress < 1.0f) {
                reporter$1.apply("Map:    ", mapProgress, (Seq)mapCounters$1.apply(), false);
                return;
            }
            reporter$1.apply("Map:    ", mapProgress, (Seq)mapCounters$1.apply(), true);
            reporter$1.reset();
            mapping$1.elem = false;
            return;
        }
        reporter$1.apply("Reduce: ", job$1.reduceProgress(), (Seq)reduceCounters$1.apply(), done);
    }

    private JobRunner$() {
    }
}

