/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.utils;

import com.beust.jcommander.IValueValidator;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.BaseConverter;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.geotools.api.filter.Filter;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.convert.Modes;
import org.locationtech.geomesa.tools.export.ExportFormat;
import org.locationtech.geomesa.tools.export.ExportFormat$;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.geomesa.utils.text.DurationParsing$;
import org.locationtech.geomesa.utils.text.Suffixes;
import scala.Array;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005=w!\u0002\u0014(\u0011\u0003\u0011d!\u0002\u001b(\u0011\u0003)\u0004\"\u0002\u001f\u0002\t\u0003id\u0001\u0002 \u0002\u0001}B\u0001bX\u0002\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\u0006y\r!\t\u0001\u0019\u0005\u0006I\u000e!\t%\u001a\u0004\u0005Q\u0006\u0001\u0011\u000e\u0003\u0005`\u000f\t\u0005\t\u0015!\u0003U\u0011\u0015at\u0001\"\u0001t\u0011\u0015!w\u0001\"\u0011w\r\u0011A\u0018\u0001A=\t\u0011}[!\u0011!Q\u0001\nQCa\u0001P\u0006\u0005\u0002\u0005-\u0001B\u00023\f\t\u0003\n\tB\u0002\u0004\u0002\u0016\u0005\u0001\u0011q\u0003\u0005\t?>\u0011\t\u0011)A\u0005)\"1Ah\u0004C\u0001\u0003OAa\u0001Z\b\u0005B\u00055bABA\u0019\u0003\u0001\t\u0019\u0004\u0003\u0005`'\t\u0005\t\u0015!\u0003U\u0011\u0019a4\u0003\"\u0001\u0002>!1Am\u0005C!\u0003\u00072a!a\u0012\u0002\u0001\u0005%\u0003\u0002C0\u0018\u0005\u0003\u0005\u000b\u0011\u0002+\t\rq:B\u0011AA+\u0011\u0019!w\u0003\"\u0011\u0002\\\u00191\u0011qL\u0001\u0001\u0003CB\u0001bX\u000e\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\u0007ym!\t!!\"\t\r\u0011\\B\u0011IAF\r\u0019\ty)\u0001\u0001\u0002\u0012\"Aql\bB\u0001B\u0003%A\u000b\u0003\u0004=?\u0011\u0005\u0011\u0011\u0015\u0005\u0007I~!\t%a*\u0007\r\u0005-\u0016\u0001AAW\u0011\u0019a4\u0005\"\u0001\u0002>\"9\u0011\u0011Y\u0012\u0005B\u0005\r\u0017a\u0005)be\u0006lW\r^3s\u0007>tg/\u001a:uKJ\u001c(B\u0001\u0015*\u0003\u0015)H/\u001b7t\u0015\tQ3&A\u0003u_>d7O\u0003\u0002-[\u00059q-Z8nKN\f'B\u0001\u00180\u00031awnY1uS>tG/Z2i\u0015\u0005\u0001\u0014aA8sO\u000e\u0001\u0001CA\u001a\u0002\u001b\u00059#a\u0005)be\u0006lW\r^3s\u0007>tg/\u001a:uKJ\u001c8CA\u00017!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\r\u0002\u000e\u0011&tGoQ8om\u0016\u0014H/\u001a:\u0014\u0005\r\u0001\u0005cA!K\u00196\t!I\u0003\u0002D\t\u0006Q1m\u001c8wKJ$XM]:\u000b\u0005\u00153\u0015A\u00036d_6l\u0017M\u001c3fe*\u0011q\tS\u0001\u0006E\u0016,8\u000f\u001e\u0006\u0002\u0013\u0006\u00191m\\7\n\u0005-\u0013%!\u0004\"bg\u0016\u001cuN\u001c<feR,'\u000f\u0005\u0003N%R#V\"\u0001(\u000b\u0005=\u0003\u0016\u0001B;uS2T\u0011!U\u0001\u0005U\u00064\u0018-\u0003\u0002T\u001d\n\u0019Q*\u00199\u0011\u0005UcfB\u0001,[!\t9\u0006(D\u0001Y\u0015\tI\u0016'\u0001\u0004=e>|GOP\u0005\u00037b\na\u0001\u0015:fI\u00164\u0017BA/_\u0005\u0019\u0019FO]5oO*\u00111\fO\u0001\u0005]\u0006lW\r\u0006\u0002bGB\u0011!mA\u0007\u0002\u0003!)q,\u0002a\u0001)\u000691m\u001c8wKJ$HC\u0001'g\u0011\u00159g\u00011\u0001U\u0003\u00151\u0018\r\\;f\u0005E!UO]1uS>t7i\u001c8wKJ$XM]\n\u0003\u000f)\u00042!\u0011&l!\ta\u0017/D\u0001n\u0015\tqw.\u0001\u0005ekJ\fG/[8o\u0015\t\u0001\b(\u0001\u0006d_:\u001cWO\u001d:f]RL!A]7\u0003\u0011\u0011+(/\u0019;j_:$\"\u0001^;\u0011\u0005\t<\u0001\"B0\n\u0001\u0004!FCA6x\u0011\u00159'\u00021\u0001U\u0005=1\u0015\u000e\u001c;fe\u000e{gN^3si\u0016\u00148CA\u0006{!\r\t%j\u001f\t\u0004y\u0006\u001dQ\"A?\u000b\u0005y|\u0018A\u00024jYR,'O\u0003\u0003\u0002\u0002\u0005\r\u0011aA1qS*\u0019\u0011QA\u0018\u0002\u0011\u001d,w\u000e^8pYNL1!!\u0003~\u0005\u00191\u0015\u000e\u001c;feR!\u0011QBA\b!\t\u00117\u0002C\u0003`\u001b\u0001\u0007A\u000bF\u0002|\u0003'AQa\u001a\bA\u0002Q\u0013Q#\u0012=q_J$hi\u001c:nCR\u001cuN\u001c<feR,'oE\u0002\u0010\u00033\u0001B!\u0011&\u0002\u001cA!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"%\na!\u001a=q_J$\u0018\u0002BA\u0013\u0003?\u0011A\"\u0012=q_J$hi\u001c:nCR$B!!\u000b\u0002,A\u0011!m\u0004\u0005\u0006?F\u0001\r\u0001\u0016\u000b\u0005\u00037\ty\u0003C\u0003h%\u0001\u0007AKA\tLKf4\u0016\r\\;f\u0007>tg/\u001a:uKJ\u001c2aEA\u001b!\u0011\t%*a\u000e\u0011\u000b]\nI\u0004\u0016+\n\u0007\u0005m\u0002H\u0001\u0004UkBdWM\r\u000b\u0005\u0003\u007f\t\t\u0005\u0005\u0002c'!)q,\u0006a\u0001)R!\u0011qGA#\u0011\u00159g\u00031\u0001U\u0005EIe\u000e^3sm\u0006d7i\u001c8wKJ$XM]\n\u0004/\u0005-\u0003\u0003B!K\u0003\u001b\u0002raNA\u001d\u0003\u001f\ny\u0005E\u0002N\u0003#J1!a\u0015O\u0005\u0011!\u0015\r^3\u0015\t\u0005]\u0013\u0011\f\t\u0003E^AQaX\rA\u0002Q#B!!\u0014\u0002^!)qM\u0007a\u0001)\n\u0011RI\u001d:pe6{G-Z\"p]Z,'\u000f^3s'\rY\u00121\r\t\u0005\u0003*\u000b)\u0007\u0005\u0003\u0002h\u0005}d\u0002BA5\u0003srA!a\u001b\u0002x9!\u0011QNA;\u001d\u0011\ty'a\u001d\u000f\u0007]\u000b\t(C\u00011\u0013\tqs&\u0003\u0002-[%\u0011AmK\u0005\u0005\u0003w\ni(A\u0003N_\u0012,7O\u0003\u0002eW%!\u0011\u0011QAB\u0005%)%O]8s\u001b>$WM\u0003\u0003\u0002|\u0005uD\u0003BAD\u0003\u0013\u0003\"AY\u000e\t\u000b}k\u0002\u0019\u0001+\u0015\t\u0005\u0015\u0014Q\u0012\u0005\u0006Oz\u0001\r\u0001\u0016\u0002\u000f\u0005f$Xm]\"p]Z,'\u000f^3s'\ry\u00121\u0013\t\u0005\u0003*\u000b)\n\u0005\u0003\u0002\u0018\u0006uUBAAM\u0015\r\tY\nU\u0001\u0005Y\u0006tw-\u0003\u0003\u0002 \u0006e%\u0001\u0002'p]\u001e$B!a)\u0002&B\u0011!m\b\u0005\u0006?\u0006\u0002\r\u0001\u0016\u000b\u0005\u0003+\u000bI\u000bC\u0003hE\u0001\u0007AK\u0001\bCsR,7OV1mS\u0012\fGo\u001c:\u0014\u000b\r\ny+!.\u0011\t\u0005]\u0015\u0011W\u0005\u0005\u0003g\u000bIJ\u0001\u0004PE*,7\r\u001e\t\u0006\u0003o\u000bI\fV\u0007\u0002\t&\u0019\u00111\u0018#\u0003\u001f%3\u0016\r\\;f-\u0006d\u0017\u000eZ1u_J$\"!a0\u0011\u0005\t\u001c\u0013\u0001\u0003<bY&$\u0017\r^3\u0015\r\u0005\u0015\u00171ZAg!\r9\u0014qY\u0005\u0004\u0003\u0013D$\u0001B+oSRDQaX\u0013A\u0002QCQaZ\u0013A\u0002Q\u0003")
public final class ParameterConverters {

    public static class BytesConverter
    extends BaseConverter<Long> {
        public Long convert(String value) {
            Try try_ = Suffixes.Memory$.MODULE$.bytes(value);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                long b = BoxesRunTime.unboxToLong((Object)success.value());
                return Predef$.MODULE$.long2Long(b);
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new ParameterException(new StringBuilder(22).append("Invalid byte string '").append(value).append("'").toString(), e);
            }
            throw new MatchError((Object)try_);
        }

        public BytesConverter(String name) {
            super(name);
        }
    }

    public static class BytesValidator
    implements IValueValidator<String> {
        public void validate(String name, String value) {
            Suffixes.Memory$.MODULE$.bytes(value).failed().foreach((Function1 & Serializable)e -> {
                throw new ParameterException(new StringBuilder(22).append("Invalid byte string '").append(value).append("'").toString(), e);
            });
        }
    }

    public static class DurationConverter
    extends BaseConverter<Duration> {
        public Duration convert(String value) {
            Duration duration;
            try {
                duration = DurationParsing$.MODULE$.caseInsensitive(value);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(10).append("duration: ").append(e).toString()));
                }
                throw throwable;
            }
            return duration;
        }

        public DurationConverter(String name) {
            super(name);
        }
    }

    public static class ErrorModeConverter
    extends BaseConverter<Enumeration.Value> {
        public Enumeration.Value convert(String value) {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Modes.ErrorMode$.MODULE$.apply(value));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Enumeration.Value m = (Enumeration.Value)success.value();
                return m;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new ParameterException(e.getMessage());
            }
            throw new MatchError((Object)try_);
        }

        public ErrorModeConverter(String name) {
            super(name);
        }
    }

    public static class ExportFormatConverter
    extends BaseConverter<ExportFormat> {
        public ExportFormat convert(String value) {
            ExportFormat exportFormat;
            try {
                exportFormat = (ExportFormat)ExportFormat$.MODULE$.apply(value).getOrElse((Function0 & Serializable)() -> {
                    throw new ParameterException(new StringBuilder(36).append("Invalid format '").append(value).append("'. Valid values are ").append(((IterableOnceOps)((SeqOps)ExportFormat$.MODULE$.Formats().flatMap((Function1 & Serializable)f -> {
                        Seq<String> seq = f.extensions();
                        return StringOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.augmentString(f.name()), seq);
                    })).distinct()).mkString("'", "', '", "'")).toString());
                });
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("format: ").append(e).toString()));
                }
                throw throwable;
            }
            return exportFormat;
        }

        public ExportFormatConverter(String name) {
            super(name);
        }
    }

    public static class FilterConverter
    extends BaseConverter<Filter> {
        public Filter convert(String value) {
            Filter filter;
            try {
                filter = ECQL.toFilter((String)value);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("filter: ").append(e).toString()));
                }
                throw throwable;
            }
            return filter;
        }

        public FilterConverter(String name) {
            super(name);
        }
    }

    public static class HintConverter
    extends BaseConverter<Map<String, String>> {
        /*
         * WARNING - void declaration
         */
        public Map<String, String> convert(String value) {
            void v0;
            try {
                void var3_2;
                HashMap map = new HashMap();
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])value.split(";")), (Function1 & Serializable)part -> {
                    Object object;
                    String[] stringArray = part.split("=");
                    if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
                        throw new MatchError((Object)stringArray);
                    }
                    String k = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                    String v = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                    Tuple2 tuple2 = new Tuple2((Object)k, (Object)v);
                    String k2 = (String)tuple2._1();
                    String v2 = (String)tuple2._2();
                    return map.put(k2.trim(), v2.trim());
                });
                v0 = var3_2;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(10).append("hint map: ").append(e).toString()));
                }
                throw throwable;
            }
            return v0;
        }

        public HintConverter(String name) {
            super(name);
        }
    }

    public static class IntervalConverter
    extends BaseConverter<Tuple2<Date, Date>> {
        public Tuple2<Date, Date> convert(String value) {
            Tuple2 tuple2;
            try {
                int i = value.indexOf(47);
                if (i == -1 || value.indexOf(47, i + 1) != -1) {
                    throw new IllegalArgumentException("Interval from/to must be separated by a single '/'");
                }
                Date start = (Date)FastConverter$.MODULE$.convert((Object)value.substring(0, i), Date.class);
                Date end = (Date)FastConverter$.MODULE$.convert((Object)value.substring(i + 1), Date.class);
                if (start == null || end == null) {
                    throw new IllegalArgumentException(new StringBuilder(35).append("Could not convert ").append(value).append(" to date interval").toString());
                }
                tuple2 = new Tuple2((Object)start, (Object)end);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("format: ").append(e).toString()));
                }
                throw throwable;
            }
            return tuple2;
        }

        public IntervalConverter(String name) {
            super(name);
        }
    }

    public static class KeyValueConverter
    extends BaseConverter<Tuple2<String, String>> {
        public Tuple2<String, String> convert(String value) {
            Tuple2 tuple2;
            try {
                int i = value.indexOf(61);
                if (i == -1 || value.indexOf(61, i + 1) != -1) {
                    throw new IllegalArgumentException("key-value pairs must be separated by a single '='");
                }
                tuple2 = new Tuple2((Object)value.substring(0, i), (Object)value.substring(i + 1));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("format: ").append(e).toString()));
                }
                throw throwable;
            }
            return tuple2;
        }

        public KeyValueConverter(String name) {
            super(name);
        }
    }
}

