/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.utils;

import com.beust.jcommander.IValueValidator;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.converters.BaseConverter;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.geotools.api.filter.Filter;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.convert.Modes;
import org.locationtech.geomesa.tools.export.ExportFormat;
import org.locationtech.geomesa.tools.export.ExportFormat$;
import org.locationtech.geomesa.utils.geotools.converters.FastConverter$;
import org.locationtech.geomesa.utils.text.DurationParsing$;
import org.locationtech.geomesa.utils.text.Suffixes;
import scala.Array;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dx!\u0002\u0016,\u0011\u00031d!\u0002\u001d,\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\te\u0001\u0002\"\u0002\u0001\rC\u0001bY\u0002\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\u0006\u0001\u000e!\t\u0001\u001a\u0005\u0006Q\u000e!\t%\u001b\u0004\u0005Y\u0006\u0001Q\u000e\u0003\u0005d\u000f\t\u0005\t\u0015!\u0003Y\u0011\u0015\u0001u\u0001\"\u0001x\u0011\u0015Aw\u0001\"\u0011{\r\u0011a\u0018\u0001A?\t\u0011\r\\!\u0011!Q\u0001\naCa\u0001Q\u0006\u0005\u0002\u0005M\u0001B\u00025\f\t\u0003\nIB\u0002\u0004\u0002\u001e\u0005\u0001\u0011q\u0004\u0005\tG>\u0011\t\u0011)A\u00051\"1\u0001i\u0004C\u0001\u0003_Aa\u0001[\b\u0005B\u0005UbABA\u001d\u0003\u0001\tY\u0004\u0003\u0005d'\t\u0005\t\u0015!\u0003Y\u0011\u0019\u00015\u0003\"\u0001\u0002F!1\u0001n\u0005C!\u0003\u00172a!a\u0014\u0002\u0001\u0005E\u0003\u0002C2\u0018\u0005\u0003\u0005\u000b\u0011\u0002-\t\r\u0001;B\u0011AA.\u0011\u0019Aw\u0003\"\u0011\u0002b\u00191\u0011QM\u0001\u0001\u0003OB\u0001bY\u000e\u0003\u0002\u0003\u0006I\u0001\u0017\u0005\u0007\u0001n!\t!!\u001c\t\r!\\B\u0011IA:\r\u0019\t9(\u0001\u0001\u0002z!A1m\bB\u0001B\u0003%\u0001\f\u0003\u0004A?\u0011\u0005\u0011Q\u0014\u0005\u0007Q~!\t%a)\u0007\r\u0005\u001d\u0016\u0001AAU\u0011!\u00197E!A!\u0002\u0013A\u0006B\u0002!$\t\u0003\tI\f\u0003\u0004iG\u0011\u0005\u0013q\u0018\u0004\u0007\u0003\u0007\f\u0001!!2\t\r\u0001;C\u0011AAk\u0011\u001d\tIn\nC!\u00037\f1\u0003U1sC6,G/\u001a:D_:4XM\u001d;feNT!\u0001L\u0017\u0002\u000bU$\u0018\u000e\\:\u000b\u00059z\u0013!\u0002;p_2\u001c(B\u0001\u00192\u0003\u001d9Wm\\7fg\u0006T!AM\u001a\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003Q\n1a\u001c:h\u0007\u0001\u0001\"aN\u0001\u000e\u0003-\u00121\u0003U1sC6,G/\u001a:D_:4XM\u001d;feN\u001c\"!\u0001\u001e\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\taGA\u0007IS:$8i\u001c8wKJ$XM]\n\u0003\u0007\u0011\u00032!\u0012(Q\u001b\u00051%BA$I\u0003)\u0019wN\u001c<feR,'o\u001d\u0006\u0003\u0013*\u000b!B[2p[6\fg\u000eZ3s\u0015\tYE*A\u0003cKV\u001cHOC\u0001N\u0003\r\u0019w.\\\u0005\u0003\u001f\u001a\u0013QBQ1tK\u000e{gN^3si\u0016\u0014\b\u0003B)W1bk\u0011A\u0015\u0006\u0003'R\u000bA!\u001e;jY*\tQ+\u0001\u0003kCZ\f\u0017BA,S\u0005\ri\u0015\r\u001d\t\u00033\u0002t!A\u00170\u0011\u0005mcT\"\u0001/\u000b\u0005u+\u0014A\u0002\u001fs_>$h(\u0003\u0002`y\u00051\u0001K]3eK\u001aL!!\u00192\u0003\rM#(/\u001b8h\u0015\tyF(\u0001\u0003oC6,GCA3h!\t17!D\u0001\u0002\u0011\u0015\u0019W\u00011\u0001Y\u0003\u001d\u0019wN\u001c<feR$\"\u0001\u00156\t\u000b-4\u0001\u0019\u0001-\u0002\u000bY\fG.^3\u0003#\u0011+(/\u0019;j_:\u001cuN\u001c<feR,'o\u0005\u0002\b]B\u0019QIT8\u0011\u0005A,X\"A9\u000b\u0005I\u001c\u0018\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005Qd\u0014AC2p]\u000e,(O]3oi&\u0011a/\u001d\u0002\t\tV\u0014\u0018\r^5p]R\u0011\u00010\u001f\t\u0003M\u001eAQaY\u0005A\u0002a#\"a\\>\t\u000b-T\u0001\u0019\u0001-\u0003\u001f\u0019KG\u000e^3s\u0007>tg/\u001a:uKJ\u001c\"a\u0003@\u0011\u0007\u0015su\u0010\u0005\u0003\u0002\u0002\u0005=QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\r\u0019LG\u000e^3s\u0015\u0011\tI!a\u0003\u0002\u0007\u0005\u0004\u0018NC\u0002\u0002\u000eM\n\u0001bZ3pi>|Gn]\u0005\u0005\u0003#\t\u0019A\u0001\u0004GS2$XM\u001d\u000b\u0005\u0003+\t9\u0002\u0005\u0002g\u0017!)1-\u0004a\u00011R\u0019q0a\u0007\t\u000b-t\u0001\u0019\u0001-\u0003+\u0015C\bo\u001c:u\r>\u0014X.\u0019;D_:4XM\u001d;feN\u0019q\"!\t\u0011\t\u0015s\u00151\u0005\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011F\u0017\u0002\r\u0015D\bo\u001c:u\u0013\u0011\ti#a\n\u0003\u0019\u0015C\bo\u001c:u\r>\u0014X.\u0019;\u0015\t\u0005E\u00121\u0007\t\u0003M>AQaY\tA\u0002a#B!a\t\u00028!)1N\u0005a\u00011\n\t2*Z=WC2,XmQ8om\u0016\u0014H/\u001a:\u0014\u0007M\ti\u0004\u0005\u0003F\u001d\u0006}\u0002#B\u001e\u0002BaC\u0016bAA\"y\t1A+\u001e9mKJ\"B!a\u0012\u0002JA\u0011am\u0005\u0005\u0006GV\u0001\r\u0001\u0017\u000b\u0005\u0003\u007f\ti\u0005C\u0003l-\u0001\u0007\u0001LA\u0007ECR,7i\u001c8wKJ$XM]\n\u0004/\u0005M\u0003\u0003B#O\u0003+\u00022!UA,\u0013\r\tIF\u0015\u0002\u0005\t\u0006$X\r\u0006\u0003\u0002^\u0005}\u0003C\u00014\u0018\u0011\u0015\u0019\u0017\u00041\u0001Y)\u0011\t)&a\u0019\t\u000b-T\u0002\u0019\u0001-\u0003#%sG/\u001a:wC2\u001cuN\u001c<feR,'oE\u0002\u001c\u0003S\u0002B!\u0012(\u0002lA91(!\u0011\u0002V\u0005UC\u0003BA8\u0003c\u0002\"AZ\u000e\t\u000b\rl\u0002\u0019\u0001-\u0015\t\u0005-\u0014Q\u000f\u0005\u0006Wz\u0001\r\u0001\u0017\u0002\u0013\u000bJ\u0014xN]'pI\u0016\u001cuN\u001c<feR,'oE\u0002 \u0003w\u0002B!\u0012(\u0002~A!\u0011qPAL\u001d\u0011\t\t)!%\u000f\t\u0005\r\u0015q\u0012\b\u0005\u0003\u000b\u000biI\u0004\u0003\u0002\b\u0006-ebA.\u0002\n&\tA'\u0003\u00023g%\u0011\u0001'M\u0005\u0003Q>JA!a%\u0002\u0016\u0006)Qj\u001c3fg*\u0011\u0001nL\u0005\u0005\u00033\u000bYJA\u0005FeJ|'/T8eK*!\u00111SAK)\u0011\ty*!)\u0011\u0005\u0019|\u0002\"B2\"\u0001\u0004AF\u0003BA?\u0003KCQa\u001b\u0012A\u0002a\u0013aBQ=uKN\u001cuN\u001c<feR,'oE\u0002$\u0003W\u0003B!\u0012(\u0002.B!\u0011qVA[\u001b\t\t\tLC\u0002\u00024R\u000bA\u0001\\1oO&!\u0011qWAY\u0005\u0011auN\\4\u0015\t\u0005m\u0016Q\u0018\t\u0003M\u000eBQaY\u0013A\u0002a#B!!,\u0002B\")1N\na\u00011\nq!)\u001f;fgZ\u000bG.\u001b3bi>\u00148#B\u0014\u0002H\u00065\u0007\u0003BAX\u0003\u0013LA!a3\u00022\n1qJ\u00196fGR\u0004R!a4\u0002Rbk\u0011\u0001S\u0005\u0004\u0003'D%aD%WC2,XMV1mS\u0012\fGo\u001c:\u0015\u0005\u0005]\u0007C\u00014(\u0003!1\u0018\r\\5eCR,GCBAo\u0003G\f)\u000fE\u0002<\u0003?L1!!9=\u0005\u0011)f.\u001b;\t\u000b\rL\u0003\u0019\u0001-\t\u000b-L\u0003\u0019\u0001-")
public final class ParameterConverters {

    public static class BytesConverter
    extends BaseConverter<Long> {
        public Long convert(String value) {
            Try try_ = Suffixes.Memory$.MODULE$.bytes(value);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                long b = BoxesRunTime.unboxToLong((Object)success.value());
                return Predef$.MODULE$.long2Long(b);
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new ParameterException(new StringBuilder(22).append("Invalid byte string '").append(value).append("'").toString(), e);
            }
            throw new MatchError((Object)try_);
        }

        public BytesConverter(String name) {
            super(name);
        }
    }

    public static class BytesValidator
    implements IValueValidator<String> {
        public void validate(String name, String value) {
            Suffixes.Memory$.MODULE$.bytes(value).failed().foreach((Function1 & Serializable)e -> {
                throw new ParameterException(new StringBuilder(22).append("Invalid byte string '").append(value).append("'").toString(), e);
            });
        }
    }

    public static class DateConverter
    extends BaseConverter<Date> {
        /*
         * WARNING - void declaration
         */
        public Date convert(String value) {
            void v0;
            try {
                void var3_2;
                Date date = (Date)FastConverter$.MODULE$.convert((Object)value, Date.class);
                if (date == null) {
                    throw new IllegalArgumentException(new StringBuilder(26).append("Could not convert ").append(value).append(" to date").toString());
                }
                v0 = var3_2;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("format: ").append(e).toString()));
                }
                throw throwable;
            }
            return v0;
        }

        public DateConverter(String name) {
            super(name);
        }
    }

    public static class DurationConverter
    extends BaseConverter<Duration> {
        public Duration convert(String value) {
            Duration duration;
            try {
                duration = DurationParsing$.MODULE$.caseInsensitive(value);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(10).append("duration: ").append(e).toString()));
                }
                throw throwable;
            }
            return duration;
        }

        public DurationConverter(String name) {
            super(name);
        }
    }

    public static class ErrorModeConverter
    extends BaseConverter<Enumeration.Value> {
        public Enumeration.Value convert(String value) {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Modes.ErrorMode$.MODULE$.apply(value));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Enumeration.Value m = (Enumeration.Value)success.value();
                return m;
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new ParameterException(e.getMessage());
            }
            throw new MatchError((Object)try_);
        }

        public ErrorModeConverter(String name) {
            super(name);
        }
    }

    public static class ExportFormatConverter
    extends BaseConverter<ExportFormat> {
        public ExportFormat convert(String value) {
            ExportFormat exportFormat;
            try {
                exportFormat = (ExportFormat)ExportFormat$.MODULE$.apply(value).getOrElse((Function0 & Serializable)() -> {
                    throw new ParameterException(new StringBuilder(36).append("Invalid format '").append(value).append("'. Valid values are ").append(((IterableOnceOps)((SeqOps)ExportFormat$.MODULE$.Formats().flatMap((Function1 & Serializable)f -> {
                        Seq<String> seq = f.extensions();
                        return StringOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.augmentString(f.name()), seq);
                    })).distinct()).mkString("'", "', '", "'")).toString());
                });
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("format: ").append(e).toString()));
                }
                throw throwable;
            }
            return exportFormat;
        }

        public ExportFormatConverter(String name) {
            super(name);
        }
    }

    public static class FilterConverter
    extends BaseConverter<Filter> {
        public Filter convert(String value) {
            Filter filter;
            try {
                filter = ECQL.toFilter((String)value);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("filter: ").append(e).toString()));
                }
                throw throwable;
            }
            return filter;
        }

        public FilterConverter(String name) {
            super(name);
        }
    }

    public static class HintConverter
    extends BaseConverter<Map<String, String>> {
        /*
         * WARNING - void declaration
         */
        public Map<String, String> convert(String value) {
            void v0;
            try {
                void var3_2;
                HashMap map = new HashMap();
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])value.split(";")), (Function1 & Serializable)part -> {
                    Object object;
                    String[] stringArray = part.split("=");
                    if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
                        throw new MatchError((Object)stringArray);
                    }
                    String k = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                    String v = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                    Tuple2 tuple2 = new Tuple2((Object)k, (Object)v);
                    String k2 = (String)tuple2._1();
                    String v2 = (String)tuple2._2();
                    return map.put(k2.trim(), v2.trim());
                });
                v0 = var3_2;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(10).append("hint map: ").append(e).toString()));
                }
                throw throwable;
            }
            return v0;
        }

        public HintConverter(String name) {
            super(name);
        }
    }

    public static class IntervalConverter
    extends BaseConverter<Tuple2<Date, Date>> {
        public Tuple2<Date, Date> convert(String value) {
            Tuple2 tuple2;
            try {
                int i = value.indexOf(47);
                if (i == -1 || value.indexOf(47, i + 1) != -1) {
                    throw new IllegalArgumentException("Interval from/to must be separated by a single '/'");
                }
                Date start = (Date)FastConverter$.MODULE$.convert((Object)value.substring(0, i), Date.class);
                Date end = (Date)FastConverter$.MODULE$.convert((Object)value.substring(i + 1), Date.class);
                if (start == null || end == null) {
                    throw new IllegalArgumentException(new StringBuilder(35).append("Could not convert ").append(value).append(" to date interval").toString());
                }
                tuple2 = new Tuple2((Object)start, (Object)end);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("format: ").append(e).toString()));
                }
                throw throwable;
            }
            return tuple2;
        }

        public IntervalConverter(String name) {
            super(name);
        }
    }

    public static class KeyValueConverter
    extends BaseConverter<Tuple2<String, String>> {
        public Tuple2<String, String> convert(String value) {
            Tuple2 tuple2;
            try {
                int i = value.indexOf(61);
                if (i == -1 || value.indexOf(61, i + 1) != -1) {
                    throw new IllegalArgumentException("key-value pairs must be separated by a single '='");
                }
                tuple2 = new Tuple2((Object)value.substring(0, i), (Object)value.substring(i + 1));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new ParameterException(this.getErrorString(value, new StringBuilder(8).append("format: ").append(e).toString()));
                }
                throw throwable;
            }
            return tuple2;
        }

        public KeyValueConverter(String name) {
            super(name);
        }
    }
}

