/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.tools.ConverterConfigParam;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.InputFilesParam;
import org.locationtech.geomesa.tools.NumReducersParam;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalFeatureSpecParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalInputFormatParam;
import org.locationtech.geomesa.tools.OptionalTypeNameParam;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.export.ConvertCommand$;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.ExportCommand$;
import org.locationtech.geomesa.tools.export.ExportCommand$ExportOptions$;
import org.locationtech.geomesa.tools.export.ExportFormat;
import org.locationtech.geomesa.tools.ingest.IngestCommand;
import org.locationtech.geomesa.tools.ingest.IngestCommand$;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.tools.utils.NoopParameterSplitter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.tools.utils.ParameterValidators;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.fs.LocalDelegate;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.locationtech.geomesa.utils.text.TextTools$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00055h\u0001B\t\u0013\u0001uAQA\u0013\u0001\u0005\u0002-CqA\u0014\u0001C\u0002\u0013\u0005s\n\u0003\u0004T\u0001\u0001\u0006I\u0001\u0015\u0005\b)\u0002\u0011\r\u0011\"\u0011V\u0011\u001d\t9\u000e\u0001Q\u0001\nYCq!!7\u0001\t\u0003\nY\u000eC\u0004\u0002^\u0002!I!a8\b\u000bi\u0013\u0002\u0012A.\u0007\u000bE\u0011\u0002\u0012\u0001/\t\u000b)KA\u0011A2\t\u000b\u0011LA\u0011A3\u0007\r\u0005]\u0013\u0002AA-\u0011\u0019QE\u0002\"\u0001\u0002\n\"I\u0011q\u0012\u0007A\u0002\u0013\u0005\u0011\u0011\u0013\u0005\n\u00033c\u0001\u0019!C\u0001\u00037C\u0001\"a*\rA\u0003&\u00111\u0013\u0002\u000f\u0007>tg/\u001a:u\u0007>lW.\u00198e\u0015\t\u0019B#\u0001\u0004fqB|'\u000f\u001e\u0006\u0003+Y\tQ\u0001^8pYNT!a\u0006\r\u0002\u000f\u001d,w.\\3tC*\u0011\u0011DG\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u00027\u0005\u0019qN]4\u0004\u0001M)\u0001A\b\u00149\u0001B\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0005Y\u0006twMC\u0001$\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0002#AB(cU\u0016\u001cG\u000f\u0005\u0002(k9\u0011\u0001f\r\b\u0003SIr!AK\u0019\u000f\u0005-\u0002dB\u0001\u00170\u001b\u0005i#B\u0001\u0018\u001d\u0003\u0019a$o\\8u}%\t1$\u0003\u0002\u001a5%\u0011q\u0003G\u0005\u0003+YI!\u0001\u000e\u000b\u0002\u000fA\f7m[1hK&\u0011ag\u000e\u0002\b\u0007>lW.\u00198e\u0015\t!D\u0003\u0005\u0002:}5\t!H\u0003\u0002<y\u0005)1\u000f^1ug*\u0011QHF\u0001\u0006kRLGn]\u0005\u0003\u007fi\u0012q\"T3uQ>$\u0007K]8gS2Lgn\u001a\t\u0003\u0003\"k\u0011A\u0011\u0006\u0003\u0007\u0012\u000bAb]2bY\u0006dwnZ4j]\u001eT!!\u0012$\u0002\u0011QL\b/Z:bM\u0016T\u0011aR\u0001\u0004G>l\u0017BA%C\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005a\u0005CA'\u0001\u001b\u0005\u0011\u0012\u0001\u00028b[\u0016,\u0012\u0001\u0015\t\u0003?EK!A\u0015\u0011\u0003\rM#(/\u001b8h\u0003\u0015q\u0017-\\3!\u0003\u0019\u0001\u0018M]1ngV\ta\u000b\u0005\u0002X\u00199\u0011\u0001\f\u0003\b\u0003QeK!a\u0005\u000b\u0002\u001d\r{gN^3si\u000e{W.\\1oIB\u0011Q*C\n\u0004\u0013u\u0003\u0005C\u00010b\u001b\u0005y&\"\u00011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t|&AB!osJ+g\rF\u0001\\\u0003=\u0019wN\u001c<feR4U-\u0019;ve\u0016\u001cH\u0003\u00034y\u0003O\t9$a\u0012\u0011\u0007\u001dTG.D\u0001i\u0015\tIG(\u0001\u0006d_2dWm\u0019;j_:L!a\u001b5\u0003#\rcwn]3bE2,\u0017\n^3sCR|'\u000f\u0005\u0002nm6\taN\u0003\u0002pa\u000611/[7qY\u0016T!!\u001d:\u0002\u000f\u0019,\u0017\r^;sK*\u00111\u000f^\u0001\u0004CBL'BA;\u001b\u0003!9Wm\u001c;p_2\u001c\u0018BA<o\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sK\")\u0011p\u0003a\u0001u\u0006)a-\u001b7fgB!1p`A\u0003\u001d\tahP\u0004\u0002-{&\t\u0001-\u0003\u00025?&!\u0011\u0011AA\u0002\u0005!IE/\u001a:bi>\u0014(B\u0001\u001b`!\u0011\t9!!\t\u000f\t\u0005%\u00111\u0004\b\u0005\u0003\u0017\t)B\u0004\u0003\u0002\u000e\u0005EabA\u0015\u0002\u0010%\u0011QHF\u0005\u0004\u0003'a\u0014AA5p\u0013\u0011\t9\"!\u0007\u0002\u0005\u0019\u001c(bAA\ny%!\u0011QDA\u0010\u0003I1\u0015\u000e\\3TsN$X-\u001c#fY\u0016<\u0017\r^3\u000b\t\u0005]\u0011\u0011D\u0005\u0005\u0003G\t)C\u0001\u0006GS2,\u0007*\u00198eY\u0016TA!!\b\u0002 !9\u0011\u0011F\u0006A\u0002\u0005-\u0012!C2p]Z,'\u000f^3s!\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019-\u0005A1m\u001c8wKJ$('\u0003\u0003\u00026\u0005=\"AF*j[BdWMR3biV\u0014XmQ8om\u0016\u0014H/\u001a:\t\u000f\u0005e2\u00021\u0001\u0002<\u0005\u0011Qm\u0019\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011\t\f\u0002\u000f\r|gN^3si&!\u0011QIA \u0005E)e/\u00197vCRLwN\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u0013Z\u0001\u0019AA&\u0003\u0015\tX/\u001a:z!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)e\u0006!A-\u0019;b\u0013\u0011\t)&a\u0014\u0003\u000bE+XM]=\u0003#\r{gN^3siB\u000b'/Y7fi\u0016\u00148o\u0005\b\r;\u0006m\u0013\u0011NA9\u0003o\ni(a!\u0011\t\u0005u\u00131\r\b\u00041\u0006}\u0013bAA1%\u0005iQ\t\u001f9peR\u001cu.\\7b]\u0012LA!!\u001a\u0002h\taQ\t\u001f9peR\u0004\u0016M]1ng*\u0019\u0011\u0011\r\n\u0011\t\u0005-\u0014QN\u0007\u0002)%\u0019\u0011q\u000e\u000b\u00031=\u0003H/[8oC2Le\u000e];u\r>\u0014X.\u0019;QCJ\fW\u000e\u0005\u0003\u0002l\u0005M\u0014bAA;)\t)r\n\u001d;j_:\fG\u000eV=qK:\u000bW.\u001a)be\u0006l\u0007\u0003BA6\u0003sJ1!a\u001f\u0015\u0005ay\u0005\u000f^5p]\u0006dg)Z1ukJ,7\u000b]3d!\u0006\u0014\u0018-\u001c\t\u0005\u0003W\ny(C\u0002\u0002\u0002R\u0011AcQ8om\u0016\u0014H/\u001a:D_:4\u0017n\u001a)be\u0006l\u0007\u0003BA6\u0003\u000bK1!a\"\u0015\u0005Iy\u0005\u000f^5p]\u0006dgi\u001c:dKB\u000b'/Y7\u0015\u0005\u0005-\u0005cAAG\u00195\t\u0011\"A\u0004te\u000ed\u0015n\u001d;\u0016\u0005\u0005M\u0005c\u00010\u0002\u0016&\u0019\u0011qS0\u0003\u000f\t{w\u000e\\3b]\u0006Y1O]2MSN$x\fJ3r)\u0011\ti*a)\u0011\u0007y\u000by*C\u0002\u0002\"~\u0013A!\u00168ji\"I\u0011QU\b\u0002\u0002\u0003\u0007\u00111S\u0001\u0004q\u0012\n\u0014\u0001C:sG2K7\u000f\u001e\u0011)\u0017A\tY+a/\u0002>\u0006\r\u0017Q\u0019\t\u0005\u0003[\u000b9,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003)Q7m\\7nC:$WM\u001d\u0006\u0004\u0003k3\u0015!\u00022fkN$\u0018\u0002BA]\u0003_\u0013\u0011\u0002U1sC6,G/\u001a:\u0002\u000b9\fW.Z:-\u0005\u0005}\u0016EAAa\u0003)iSf\u001d:d[1L7\u000f^\u0001\fI\u0016\u001c8M]5qi&|g.\t\u0002\u0002H\u0006A\u0015J\u001c9vi\u00022\u0017\u000e\\3tA\u0005\u0014X\r\t;fqR\u0004c-\u001b7fg\u0002:\u0018\u000e\u001e5!Y&\u001cHo\u001d\u0011pM\u00022\u0017\u000e\\3tY\u0001zg.\u001a\u0011qKJ\u0004C.\u001b8fY\u0001\"x\u000eI5oO\u0016\u001cHO\f\u0015\b\u0019\u0005-\u0017\u0011[Aj!\u0011\ti+!4\n\t\u0005=\u0017q\u0016\u0002\u000b!\u0006\u0014\u0018-\\3uKJ\u001c\u0018AE2p[6\fg\u000e\u001a#fg\u000e\u0014\u0018\u000e\u001d;j_:\f#!!6\u0002u\r{gN^3si\u00022\u0017\u000e\\3tAU\u001c\u0018N\\4!\u000f\u0016|W*Z:bOM\u0004\u0013N\u001c;fe:\fG\u000eI2p]Z,'\u000f^3sA\u0019\u0014\u0018-\\3x_J\\\u0017a\u00029be\u0006l7\u000fI\u0001\bKb,7-\u001e;f)\t\ti*\u0001\td_:4XM\u001d;B]\u0012,\u0005\u0010]8siR\u0011\u0011\u0011\u001d\t\u0006=\u0006\r\u0018q]\u0005\u0004\u0003K|&AB(qi&|g\u000eE\u0002_\u0003SL1!a;`\u0005\u0011auN\\4")
public class ConvertCommand
implements package.Command,
MethodProfiling {
    private final String name;
    private final ConvertParameters params;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static CloseableIterator<SimpleFeature> convertFeatures(Iterator<FileSystemDelegate.FileHandle> files, SimpleFeatureConverter converter, EvaluationContext ec, Query query) {
        return ConvertCommand$.MODULE$.convertFeatures(files, converter, ec, query);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.profile$((MethodProfiling)this, (String)message, code);
    }

    @Override
    public Seq<package.Command> subCommands() {
        return package.Command.subCommands$(this);
    }

    @Override
    public Option<ParameterException> validate() {
        return package.Command.validate$(this);
    }

    @Override
    public void run() {
        package.Command.run$(this);
    }

    private Logger logger$lzycompute() {
        ConvertCommand convertCommand = this;
        synchronized (convertCommand) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ConvertParameters params() {
        return this.params;
    }

    @Override
    public void execute() {
        this.profile((Function2 & Serializable)(count2, time) -> {
            this.complete$1(count2, BoxesRunTime.unboxToLong((Object)time));
            return BoxedUnit.UNIT;
        }, (Function0 & Serializable)() -> this.convertAndExport());
    }

    /*
     * WARNING - void declaration
     */
    private Option<Object> convertAndExport() {
        void var2_1;
        IngestCommand.Inputs files = new IngestCommand.Inputs((Seq<String>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.params().files()).asScala()).toSeq());
        if (files.stdin() && !LocalDelegate.StdInHandle$.MODULE$.isAvailable()) {
            BoxedUnit boxedUnit;
            if (files.paths().isEmpty()) {
                throw new ParameterException("Missing option: <files>... is required, or use `-` to ingest from standard in");
            }
            if (package$Command$.MODULE$.user().underlying().isInfoEnabled()) {
                package$Command$.MODULE$.user().underlying().info("Waiting for input...");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            while (!LocalDelegate.StdInHandle$.MODULE$.isAvailable()) {
                Thread.sleep(10L);
            }
        }
        IngestCommand.Inputs inputs = this.params().srcList() ? files.asSourceList() : var2_1;
        Option<String> format = IngestCommand$.MODULE$.getDataFormat(this.params(), inputs.paths());
        return ((Option)IngestCommand$.MODULE$.getSftAndConverter(this.params(), inputs, format, (Option<? extends DataStore>)None$.MODULE$).get()).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                SimpleFeatureType sft = (SimpleFeatureType)tuple2._1();
                Config config = (Config)tuple2._2();
                if (sft != null) {
                    SimpleFeatureType simpleFeatureType = sft;
                    if (config != null) {
                        Config config2 = config;
                        Iterator files = inputs.handles().iterator();
                        return (Option)package.WithClose$.MODULE$.apply((Object)SimpleFeatureConverter$.MODULE$.apply(simpleFeatureType, config2), (Function1 & Serializable)converter -> {
                            Option option;
                            Object object;
                            EvaluationContext ec = converter.createEvaluationContext(converter.createEvaluationContext$default$1());
                            Query query = ExportCommand$.MODULE$.createQuery(simpleFeatureType, this.params());
                            Option option2 = Option$.MODULE$.apply((Object)this.params().chunkSize());
                            if (None$.MODULE$.equals(option2)) {
                                object = new ExportCommand.Exporter(ExportCommand$ExportOptions$.MODULE$.apply(this.params()), query.getHints());
                            } else if (option2 instanceof Some) {
                                Some some = (Some)option2;
                                Long c = (Long)some.value();
                                object = new ExportCommand.ChunkedExporter(ExportCommand$ExportOptions$.MODULE$.apply(this.params()), query.getHints(), Predef$.MODULE$.Long2long(c));
                            } else {
                                throw new MatchError((Object)option2);
                            }
                            try (ExportCommand.Exporter exporter = object;){
                                BoxedUnit boxedUnit;
                                Option count2 = (Option)package.WithClose$.MODULE$.apply(ConvertCommand$.MODULE$.convertFeatures((Iterator<FileSystemDelegate.FileHandle>)files, (SimpleFeatureConverter)converter, ec, query), (Function1 & Serializable)iter -> {
                                    if (!this.params().suppressEmpty() || iter.hasNext()) {
                                        exporter.start(QueryHints$.MODULE$.RichHints(query.getHints()).getReturnSft());
                                        return exporter.export((Iterator)iter);
                                    }
                                    return new Some((Object)BoxesRunTime.boxToLong((long)0L));
                                }, IsCloseable$.MODULE$.closeableIsCloseable());
                                long records = ec.line() - (long)(this.params().noHeader() ? 0 : this.params().files().size());
                                if (package$Command$.MODULE$.user().underlying().isInfoEnabled()) {
                                    package$Command$.MODULE$.user().underlying().info(new StringBuilder(21).append("Converted ").append(TextTools$.MODULE$.getPlural(records, "line")).append(" ").append("with ").append(TextTools$.MODULE$.getPlural(ec.success().getCount(), "success", "successes")).append(" ").append("and ").append(TextTools$.MODULE$.getPlural(ec.failure().getCount(), "failure")).toString());
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                option = count2;
                            }
                            return option;
                        }, IsCloseable$.MODULE$.closeableIsCloseable());
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ String $anonfun$execute$2(long c) {
        return new StringBuilder(14).append(" for ").append(c).append(" features").toString();
    }

    private final void complete$1(Option count2, long time) {
        BoxedUnit boxedUnit;
        if (package$Command$.MODULE$.user().underlying().isInfoEnabled()) {
            package$Command$.MODULE$.user().underlying().info(new StringBuilder(29).append("Conversion complete to ").append(Option$.MODULE$.apply((Object)this.params().file()).getOrElse((Function0 & Serializable)() -> "standard out")).append(" ").append("in ").append(time).append("ms").append(count2.map((Function1 & Serializable)c -> ConvertCommand.$anonfun$execute$2(BoxesRunTime.unboxToLong((Object)c))).getOrElse((Function0 & Serializable)() -> "")).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public ConvertCommand() {
        package.Command.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        MethodProfiling.$init$((MethodProfiling)this);
        this.name = "convert";
        this.params = new ConvertParameters();
    }

    @Parameters(commandDescription="Convert files using GeoMesa's internal converter framework")
    public static class ConvertParameters
    implements ExportCommand.ExportParams,
    OptionalInputFormatParam,
    OptionalTypeNameParam,
    OptionalFeatureSpecParam,
    ConverterConfigParam {
        @Parameter(names={"--src-list"}, description="Input files are text files with lists of files, one per line, to ingest.")
        private boolean srcList;
        @Parameter(names={"-C", "--converter"}, description="GeoMesa converter specification as a config string, file name, or name of an available converter")
        private String config;
        @Parameter(names={"--converter-error-mode"}, description="Override the converter error mode - 'log-errors' or 'raise-errors'", converter=ParameterConverters.ErrorModeConverter.class)
        private Enumeration.Value errorMode;
        @Parameter(names={"-s", "--spec"}, description="SimpleFeatureType specification as a GeoTools spec string, SFT config, or file with either")
        private String spec;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate")
        private String featureName;
        @Parameter(names={"--input-format"}, description="File format of input files (shp, csv, tsv, avro, etc). Optional, auto-detection will be attempted")
        private String inputFormat;
        @Parameter(description="<file>...")
        private List<String> files;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header")
        private boolean noHeader;
        @Parameter(names={"--suppress-empty"}, description="Suppress all output (headers, etc) if there are no features exported")
        private boolean suppressEmpty;
        @Parameter(names={"-m", "--max-features"}, description="Restrict the maximum number of features returned")
        private Integer maxFeatures;
        @Parameter(names={"--attribute"}, description="Attributes or derived expressions to export, or 'id' to include the feature ID", splitter=NoopParameterSplitter.class)
        private List<String> transforms;
        @Parameter(names={"-a", "--attributes"}, description="Comma-separated attributes to export, or 'id' to include the feature ID")
        private List<String> attributes;
        @Parameter(names={"--sort-by"}, description="Sort by the specified attributes (comma-delimited)")
        private List<String> sortFields;
        @Parameter(names={"--sort-descending"}, description="Sort in descending order, instead of ascending", arity=0)
        private boolean sortDescending;
        @Parameter(names={"--chunk-size"}, description="Split the output into multiple files, by specifying the rough number of bytes to store per file", converter=ParameterConverters.BytesConverter.class)
        private Long chunkSize;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|avro-native|leaflet|orc|parquet|arrow)", converter=ParameterConverters.ExportFormatConverter.class)
        private ExportFormat explicitOutputFormat;
        private ExportFormat outputFormat;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"--num-reducers"}, description="Number of reducers to use when sorting or merging (for distributed jobs)", validateWith={ParameterValidators.PositiveInteger.class})
        private Integer reducers;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private Option<Enumeration.Value> mode;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        private volatile byte bitmap$0;

        @Override
        public String config() {
            return this.config;
        }

        @Override
        public void config_$eq(String x$1) {
            this.config = x$1;
        }

        @Override
        public Enumeration.Value errorMode() {
            return this.errorMode;
        }

        @Override
        public void errorMode_$eq(Enumeration.Value x$1) {
            this.errorMode = x$1;
        }

        @Override
        public String spec() {
            return this.spec;
        }

        @Override
        public void spec_$eq(String x$1) {
            this.spec = x$1;
        }

        @Override
        public String featureName() {
            return this.featureName;
        }

        @Override
        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public String inputFormat() {
            return this.inputFormat;
        }

        @Override
        public void inputFormat_$eq(String x$1) {
            this.inputFormat = x$1;
        }

        @Override
        public List<String> files() {
            return this.files;
        }

        @Override
        public void files_$eq(List<String> x$1) {
            this.files = x$1;
        }

        @Override
        public String file() {
            return this.file;
        }

        @Override
        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        @Override
        public Integer gzip() {
            return this.gzip;
        }

        @Override
        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        @Override
        public boolean noHeader() {
            return this.noHeader;
        }

        @Override
        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        @Override
        public boolean suppressEmpty() {
            return this.suppressEmpty;
        }

        @Override
        public void suppressEmpty_$eq(boolean x$1) {
            this.suppressEmpty = x$1;
        }

        @Override
        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        @Override
        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        @Override
        public List<String> transforms() {
            return this.transforms;
        }

        @Override
        public void transforms_$eq(List<String> x$1) {
            this.transforms = x$1;
        }

        @Override
        public List<String> attributes() {
            return this.attributes;
        }

        @Override
        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        @Override
        public List<String> sortFields() {
            return this.sortFields;
        }

        @Override
        public void sortFields_$eq(List<String> x$1) {
            this.sortFields = x$1;
        }

        @Override
        public boolean sortDescending() {
            return this.sortDescending;
        }

        @Override
        public void sortDescending_$eq(boolean x$1) {
            this.sortDescending = x$1;
        }

        @Override
        public Long chunkSize() {
            return this.chunkSize;
        }

        @Override
        public void chunkSize_$eq(Long x$1) {
            this.chunkSize = x$1;
        }

        @Override
        public ExportFormat explicitOutputFormat() {
            return this.explicitOutputFormat;
        }

        @Override
        public void explicitOutputFormat_$eq(ExportFormat x$1) {
            this.explicitOutputFormat = x$1;
        }

        private ExportFormat outputFormat$lzycompute() {
            ConvertParameters convertParameters = this;
            synchronized (convertParameters) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.outputFormat = ExportCommand.ExportParams.outputFormat$(this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.outputFormat;
        }

        @Override
        public ExportFormat outputFormat() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.outputFormat$lzycompute();
            }
            return this.outputFormat;
        }

        @Override
        public boolean force() {
            return this.force;
        }

        @Override
        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        @Override
        public Integer reducers() {
            return this.reducers;
        }

        @Override
        public void reducers_$eq(Integer x$1) {
            this.reducers = x$1;
        }

        @Override
        public String runMode() {
            return this.runMode;
        }

        @Override
        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option<Enumeration.Value> mode$lzycompute() {
            ConvertParameters convertParameters = this;
            synchronized (convertParameters) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.mode = DistributedRunParam.mode$(this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.mode;
        }

        @Override
        public Option<Enumeration.Value> mode() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.mode$lzycompute();
            }
            return this.mode;
        }

        @Override
        public Map<String, String> hints() {
            return this.hints;
        }

        @Override
        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        @Override
        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        @Override
        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public boolean srcList() {
            return this.srcList;
        }

        public void srcList_$eq(boolean x$1) {
            this.srcList = x$1;
        }

        public ConvertParameters() {
            OptionalCqlFilterParam.$init$(this);
            QueryHintsParams.$init$(this);
            DistributedRunParam.$init$(this);
            NumReducersParam.$init$(this);
            OptionalForceParam.$init$(this);
            ExportCommand.ExportParams.$init$(this);
            InputFilesParam.$init$(this);
            OptionalInputFormatParam.$init$(this);
            OptionalTypeNameParam.$init$(this);
            OptionalFeatureSpecParam.$init$(this);
            ConverterConfigParam.$init$(this);
            this.srcList = false;
        }
    }
}

