/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.export;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert.EvaluationContext$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter;
import org.locationtech.geomesa.filter.package$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.planning.LocalQueryRunner$;
import org.locationtech.geomesa.index.stats.RunnableStats;
import org.locationtech.geomesa.tools.export.ConvertCommand$;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.locationtech.geomesa.utils.io.package;
import org.locationtech.geomesa.utils.stats.Stat;
import org.locationtech.geomesa.utils.stats.Stat$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class ConvertCommand$
implements LazyLogging {
    public static final ConvertCommand$ MODULE$ = new ConvertCommand$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        ConvertCommand$ convertCommand$ = this;
        synchronized (convertCommand$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public CloseableIterator<SimpleFeature> convertFeatures(Iterator<FileSystemDelegate.FileHandle> files, SimpleFeatureConverter converter, EvaluationContext ec, Query query) {
        return ConvertCommand$.transform$1(ConvertCommand$.org$locationtech$geomesa$tools$export$ConvertCommand$$limit$1(ConvertCommand$.org$locationtech$geomesa$tools$export$ConvertCommand$$filter$1(ConvertCommand$.org$locationtech$geomesa$tools$export$ConvertCommand$$convert$1(files, converter, ec), query), query), converter, query, files, ec);
    }

    public static final CloseableIterator org$locationtech$geomesa$tools$export$ConvertCommand$$convert$1(Iterator files$2, SimpleFeatureConverter converter$1, EvaluationContext ec$1) {
        return CloseableIterator$.MODULE$.apply(files$2, (Function0)(JFunction0.mcV.sp & Serializable)() -> CloseableIterator$.MODULE$.apply$default$2()).flatMap((Function1 & Serializable)file -> file.open().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option name = (Option)tuple2._1();
                InputStream is = (InputStream)tuple2._2();
                Map params = EvaluationContext$.MODULE$.inputFileParam((String)name.getOrElse((Function0 & Serializable)() -> file.path()));
                EvaluationContext context = converter$1.createEvaluationContext(params, ec$1.success(), ec$1.failure());
                CloseableIterator features = converter$1.process(is, context);
                return CloseableIterator$.MODULE$.apply((Iterator)features, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    features.close();
                    ec$1.line_$eq(ec$1.line() + context.line());
                });
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    public static final CloseableIterator org$locationtech$geomesa$tools$export$ConvertCommand$$filter$1(CloseableIterator iter, Query query$2) {
        Filter filter = query$2.getFilter();
        IncludeFilter includeFilter = Filter.INCLUDE;
        if (!(filter != null ? !filter.equals(includeFilter) : includeFilter != null)) {
            return iter;
        }
        Filter filter2 = query$2.getFilter();
        return iter.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter2.evaluate(x$1)));
    }

    public static final CloseableIterator org$locationtech$geomesa$tools$export$ConvertCommand$$limit$1(CloseableIterator iter, Query query$2) {
        Option option = QueryHints$.MODULE$.RichHints(query$2.getHints()).getMaxFeatures();
        if (None$.MODULE$.equals(option)) {
            return iter;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            int m = BoxesRunTime.unboxToInt((Object)some.value());
            return iter.take(m);
        }
        throw new MatchError((Object)option);
    }

    private static final CloseableIterator transform$1(CloseableIterator iter, SimpleFeatureConverter converter$1, Query query$2, Iterator files$2, EvaluationContext ec$1) {
        RunnableStats stats = new RunnableStats(query$2, files$2, converter$1, ec$1){
            private final Query query$2;
            private final Iterator files$2;
            private final SimpleFeatureConverter converter$1;
            private final EvaluationContext ec$1;

            public <T extends Stat> Option<T> query(SimpleFeatureType sft, Filter ignored, String stats, Hints queryHints) {
                None$ none$;
                Stat stat = Stat$.MODULE$.apply(sft, stats);
                try {
                    package.WithClose$.MODULE$.apply((Object)ConvertCommand$.org$locationtech$geomesa$tools$export$ConvertCommand$$limit$1(ConvertCommand$.org$locationtech$geomesa$tools$export$ConvertCommand$$filter$1(ConvertCommand$.org$locationtech$geomesa$tools$export$ConvertCommand$$convert$1(this.files$2, this.converter$1, this.ec$1), this.query$2), this.query$2), (Function1 & Serializable)x$1 -> {
                        anon.1.$anonfun$query$1(stat, x$1);
                        return BoxedUnit.UNIT;
                    }, IsCloseable$.MODULE$.closeableIsCloseable());
                    none$ = new Some((Object)stat);
                }
                catch (Exception e) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error(new StringBuilder(53).append("Error running stats query with stats '").append(stats).append("' and filter '").append(package$.MODULE$.filterToString(ignored)).append("'").toString(), (Throwable)e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    none$ = None$.MODULE$;
                }
                return none$;
            }

            public static final /* synthetic */ void $anonfun$query$2(Stat stat$1, SimpleFeature sf) {
                stat$1.observe(sf);
            }

            public static final /* synthetic */ void $anonfun$query$1(Stat stat$1, CloseableIterator x$1) {
                x$1.foreach((Function1 & Serializable)sf -> {
                    anon.1.$anonfun$query$2(stat$1, sf);
                    return BoxedUnit.UNIT;
                });
            }
            {
                this.query$2 = query$2;
                this.files$2 = files$2;
                this.converter$1 = converter$1;
                this.ec$1 = ec$1;
                super(null);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$query$1$adapted(org.locationtech.geomesa.utils.stats.Stat org.locationtech.geomesa.utils.collection.CloseableIterator ), $anonfun$query$2$adapted(org.locationtech.geomesa.utils.stats.Stat org.geotools.api.feature.simple.SimpleFeature )}, serializedLambda);
            }
        };
        return LocalQueryRunner$.MODULE$.transform(converter$1.targetSft(), iter, QueryHints$.MODULE$.RichHints(query$2.getHints()).getTransform(), query$2.getHints());
    }

    private ConvertCommand$() {
    }
}

