/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.tools.stats;

import java.io.Serializable;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.tools.package$Command$;
import org.locationtech.geomesa.utils.stats.Histogram;
import org.locationtech.geomesa.utils.stats.Stat$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class StatsHistogramCommand$ {
    public static final StatsHistogramCommand$ MODULE$ = new StatsHistogramCommand$();
    private static final Tuple2<String, Object> Threshold1 = new Tuple2((Object)"\u001b[1m\u001b[36m", (Object)BoxesRunTime.boxToCharacter((char)'\u26ab'));
    private static final Tuple2<String, Object> Threshold2 = new Tuple2((Object)"\u001b[1m\u001b[32m", (Object)BoxesRunTime.boxToCharacter((char)'\u25cf'));
    private static final Tuple2<String, Object> Threshold3 = new Tuple2((Object)"\u001b[1m\u001b[33m", (Object)BoxesRunTime.boxToCharacter((char)'\u25cf'));
    private static final Tuple2<String, Object> Threshold4 = new Tuple2((Object)"\u001b[1m\u001b[31m", (Object)BoxesRunTime.boxToCharacter((char)'\u2b24'));
    private static final int AsciiWorldMapLength = 140;
    private static final int AsciiWorldMapHeight = 42;
    private static final char[][] AsciiWorldMap = (char[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"                                                                                                                                            ", "                                                                                                                                            ", "                                          .      .   ,:,,:                                                                                  ", "                                    . :,.:,,,::,.,,,.,__,__,,.,;                                    :.                                      ", "                              ,. ;:,__:,.,,,,.,,____________,,          :,,:                          __                                    ", "                           ,.,::::,  .::;    .  ,,____________.                         ,,.        ;.,.,,__        ,;.                      ", "                          .,,:::;:,:: .,, .      ,__________,                         ,    .,. ,,________.,.,,__    ::                      ", "             ______,: :,,,/; ,.,,; ,;  ,. ,,,.    :______,,.,             ,____;   __    , __.,__________________________.:;;;.,,           ", "            ,,____________; ________.,,    .,,,.  __.,./.               ,.,,;__. ;,,,______.;__________________________________,,:,.,       ", "            ,,__.,.,________.:,__,.,,   .,,, ,     :.,.               ,,,__:__.,:______________________________________.,,.,.,__;           ", "             .:,,    .,,______;,,__.:     ____,                       ,,.,  ;,__.,________________________________.,      :,                ", "            ;          ,__________,,__,,.:,____,,                   .  ,.,,,______.,:__________________.,:________\\__    ,,                 ", "                         ,,,________,.:__.,.,,:: ,                 .:,________________________________,,,__________,,                       ", "                          __________.,.: .,__,/:                    __.,,,____,:;__.:,.,;__.,:,__________________,, :                       ", "                          .,__________,__.,                      ,,.:  : , .::;.,:.,__:,.,__________________,:__   __                       ", "                           ,,,__________.,,                       :,,__.      :,;__________________________,,  ,.:,,                        ", "                             :,____.,.,,:                        ______.,.:____,,__,,,____________________.,,,                              ", "                              ,,,.,                            ,,________________.,__:.: ,,,______,________.,;                              ", "                                 ,,, :,    ;:.                 ________________,. ,__,,,     ,.,,.  ,,__ :                                  ", "                                     ,:.                      ,________.,,______.,,,,        ,.,     ,,__.   :,                             ", "                                        , .,,,,,,               ,________________.,,,         ,:      ,       ,                             ", "                                         ,,____.,,.,                   ,__________.:                 .,; :,,. ,:                            ", "                                         __________.,__:                ,,____,,.,                     .   __: . :,__,                      ", "                                          ,,____________                 ________,                          . :     . :.                    ", "                                           ,,,________.                 __________ ,,.                        :__., ,,                      ", "                                            :________,:                  ,____.,.  .:                      ,__________,     ,.              ", "                                            ,,____.,                     ,____,,                           ,__________,,                    ", "                                            ____.,:                       :__,                             ;.,.:__,____,                    ", "                                           ,____.                                                                  .,,.        :;.          ", "                                           ;__/                                                                      ,,       .             ", "                                           ,__                                                                                              ", "                                           ,,                                                                                               ", "                                                                                                                                            ", "                                                                                                                                            ", "                                          /                                                                                                 ", "                                       ____                 _ _/:\\_____/________________ ____________________________________.              ", "          :.,.________________________.              ______________________________________________________________________                 ", "          .________________________________ .___/____________________________________________________________________________,              ", "  ________________________________________________________________________________________________________________________________          ", "                                                                                                                                            ", "                                                                                                                                            ", "                                                                                                                                            ", "                                                                                                                                            "}), (Function1 & Serializable)x$11 -> x$11.toCharArray(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Character.TYPE)));

    public void printHist(Histogram<Object> stat, SimpleFeatureType sft, String attribute) {
        BoxedUnit boxedUnit;
        if (package$Command$.MODULE$.output().underlying().isInfoEnabled()) {
            package$Command$.MODULE$.output().underlying().info("Binned histogram for '{}':", (Object)attribute);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (stat.isEmpty()) {
            BoxedUnit boxedUnit2;
            if (package$Command$.MODULE$.output().underlying().isInfoEnabled()) {
                package$Command$.MODULE$.output().underlying().info("  No values");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return;
        }
        Function1 stringify = Stat$.MODULE$.stringifier(sft.getDescriptor(attribute).getType().getBinding(), Stat$.MODULE$.stringifier$default$2());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), stat.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = stat.bounds(i);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object min = tuple2._1();
            Object max = tuple2._2();
            Tuple2 tuple22 = new Tuple2(min, max);
            Object min2 = tuple22._1();
            Object max2 = tuple22._2();
            if (package$Command$.MODULE$.output().underlying().isInfoEnabled()) {
                package$Command$.MODULE$.output().underlying().info("  [ {} to {} ] {}", new Object[]{stringify.apply(min2), stringify.apply(max2), BoxesRunTime.boxToLong((long)stat.count(i))});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        });
    }

    public String geomHistToString(String attribute, Histogram<Geometry> stat) {
        long[][] counts = (long[][])Array$.MODULE$.fill(this.AsciiWorldMapHeight(), (Function0 & Serializable)() -> (long[])Array$.MODULE$.fill(MODULE$.AsciiWorldMapLength(), (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L, (ClassTag)ClassTag$.MODULE$.Long()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
        this.putCountsInGrid$1(stat, counts);
        long min = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])counts), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)StatsHistogramCommand$.$anonfun$geomHistToString$3(x$8)), (ClassTag)ClassTag$.MODULE$.Long())).min((Ordering)Ordering.Long$.MODULE$));
        long max = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])counts), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)StatsHistogramCommand$.$anonfun$geomHistToString$4(x$9)), (ClassTag)ClassTag$.MODULE$.Long())).max((Ordering)Ordering.Long$.MODULE$));
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        String currentColor = null;
        for (int i = 0; i < this.AsciiWorldMapHeight(); ++i) {
            long[] row = counts[i];
            for (int j = 0; j < this.AsciiWorldMapLength(); ++j) {
                Tuple2<String, Object> tuple2;
                float normalized = StatsHistogramCommand$.normalize$1(row[j], min, max);
                Tuple2<String, Object> tuple22 = normalized < 0.1f ? new Tuple2<String, Object>((Object)"\u001b[0m", (Object)BoxesRunTime.boxToCharacter((char)this.AsciiWorldMap()[i][j])) : (normalized < 0.3f ? this.Threshold1() : (normalized < 0.5f ? this.Threshold2() : (tuple2 = normalized < 0.8f ? this.Threshold3() : this.Threshold4())));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String color = (String)tuple2._1();
                char c = tuple2._2$mcC$sp();
                Tuple2 tuple23 = new Tuple2((Object)color, (Object)BoxesRunTime.boxToCharacter((char)c));
                String color2 = (String)tuple23._1();
                char = tuple23._2$mcC$sp();
                String string = color2;
                String string2 = currentColor;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    sb.append(color2);
                    currentColor = color2;
                }
                sb.append(char);
            }
            sb.append('\n');
        }
        sb.append("\u001b[0m\nKey: ");
        sb.append(new StringBuilder(12).append("[").append(this.Threshold1()._1()).append(this.Threshold1()._2$mcC$sp()).append("\u001b[0m").append(" ").append(StatsHistogramCommand$.denormalize$1(0.1f, max, min)).append(" to ").append(StatsHistogramCommand$.denormalize$1(0.3f, max, min)).append("] ").toString());
        sb.append(new StringBuilder(12).append("[").append(this.Threshold2()._1()).append(this.Threshold2()._2$mcC$sp()).append("\u001b[0m").append(" ").append(StatsHistogramCommand$.denormalize$1(0.3f, max, min)).append(" to ").append(StatsHistogramCommand$.denormalize$1(0.5f, max, min)).append("] ").toString());
        sb.append(new StringBuilder(12).append("[").append(this.Threshold3()._1()).append(this.Threshold3()._2$mcC$sp()).append("\u001b[0m").append(" ").append(StatsHistogramCommand$.denormalize$1(0.5f, max, min)).append(" to ").append(StatsHistogramCommand$.denormalize$1(0.8f, max, min)).append("] ").toString());
        sb.append(new StringBuilder(12).append("[").append(this.Threshold4()._1()).append(this.Threshold4()._2$mcC$sp()).append("\u001b[0m").append("  ").append(StatsHistogramCommand$.denormalize$1(0.8f, max, min)).append(" to ").append(max).append("]").toString());
        return sb.toString();
    }

    private Tuple2<String, Object> Threshold1() {
        return Threshold1;
    }

    private Tuple2<String, Object> Threshold2() {
        return Threshold2;
    }

    private Tuple2<String, Object> Threshold3() {
        return Threshold3;
    }

    private Tuple2<String, Object> Threshold4() {
        return Threshold4;
    }

    private int AsciiWorldMapLength() {
        return AsciiWorldMapLength;
    }

    private int AsciiWorldMapHeight() {
        return AsciiWorldMapHeight;
    }

    private char[][] AsciiWorldMap() {
        return AsciiWorldMap;
    }

    private final void putCountsInGrid$1(Histogram stat$2, long[][] counts$1) {
        for (int i = 0; i < stat$2.length(); ++i) {
            long count2 = stat$2.count(i);
            if (count2 <= 0L) continue;
            Point point = (Point)stat$2.medianValue(i);
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(point.getX(), point.getY());
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            double x = sp2._1$mcD$sp();
            double y = sp2._2$mcD$sp();
            Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(x, y);
            double x2 = sp3._1$mcD$sp();
            double y2 = sp3._2$mcD$sp();
            double xOffset = (x2 + (double)180) / (double)360;
            double yOffset = 1.0 - (y2 + (double)90) / (double)180;
            int j = (int)package$.MODULE$.floor(yOffset * (double)this.AsciiWorldMapHeight());
            int k = (int)package$.MODULE$.floor(xOffset * (double)this.AsciiWorldMapLength());
            long[] lArray = counts$1[j];
            lArray[k] = lArray[k] + count2;
        }
    }

    public static final /* synthetic */ long $anonfun$geomHistToString$3(long[] x$8) {
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray(x$8).min((Ordering)Ordering.Long$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$geomHistToString$4(long[] x$9) {
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray(x$9).max((Ordering)Ordering.Long$.MODULE$));
    }

    private static final float normalize$1(long count2, long min$1, long max$1) {
        return (float)(count2 - min$1) / (float)(max$1 - min$1);
    }

    private static final long denormalize$1(float percent, long max$1, long min$1) {
        return (long)(percent * (float)(max$1 - min$1)) + min$1;
    }

    private StatsHistogramCommand$() {
    }
}

